/*
 * Decompiled with CFR 0.152.
 */
package mustachejava.benchmarks;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.util.HtmlEscaper;
import com.github.mustachejavabenchmarks.NullWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Benchmark)
public class Main {
    private final NullWriter nw = new NullWriter();
    private final Mustache normal = new DefaultMustacheFactory().compile((Reader)new StringReader("({{#loop}}({{value}}){{/loop}})"), "test");
    private final List<Object> scope = new ArrayList<1>(Collections.singletonList(new Object(){
        List loop = new ArrayList();
        {
            int i = 0;
            while (i < 10) {
                final int finalI = i++;
                this.loop.add(new Object(){
                    String value;
                    {
                        this.value = String.valueOf(finalI);
                    }
                });
            }
        }
    }));

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void benchMustache() throws IOException {
        this.normal.execute((Writer)this.nw, this.scope).close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void benchJustEscapeClean() {
        HtmlEscaper.escape((String)"variable", (Writer)this.nw);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void benchJustEscapeTwo() {
        HtmlEscaper.escape((String)"va&ri\"ble", (Writer)this.nw);
    }

    public static void main(String[] args) throws IOException {
        Main main = new Main();
        while (true) {
            main.benchMustache();
        }
    }
}

