/*
 * Decompiled with CFR 0.152.
 */
package mustachejava.benchmarks;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.util.HtmlEscaper;
import com.github.mustachejavabenchmarks.NullWriter;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Benchmark)
public class Main {
    private final NullWriter nw = new NullWriter();
    private final Mustache normal = new DefaultMustacheFactory().compile((Reader)new StringReader("({{#loop}}({{value}}){{/loop}})"), "test");
    private final List<Object> scope = new ArrayList<1>(Collections.singletonList(new Object(){
        List loop = new ArrayList();
        {
            int i = 0;
            while (i < 10) {
                final int finalI = i++;
                this.loop.add(new Object(){
                    String value;
                    {
                        this.value = String.valueOf(finalI);
                    }
                });
            }
        }
    }));
    private static String html = Main.readStringFromURL(ClassLoader.getSystemResourceAsStream("Yahoo.html"));

    private static String readStringFromURL(InputStream source) {
        try (Scanner scanner = new Scanner(source, StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void benchEscapeHTML() {
        HtmlEscaper.escape((String)html, (Writer)this.nw);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void benchEscapeHTMLwithSW() {
        HtmlEscaper.escape((String)html, (Writer)new StringWriter());
    }
}

