/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.h2;

import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.NonNull;
import org.h2.tools.Server;
import org.springframework.boot.autoconfigure.AbstractDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.h2.H2ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactoryBean;

@Configuration
@ConditionalOnClass(value={Server.class})
@ConditionalOnProperty(prefix="spring.h2.server", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={H2ServerProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class H2ServerAutoConfiguration {
    @NonNull
    private H2ServerProperties properties;

    @Bean(initMethod="start", destroyMethod="stop")
    public Server h2Server() throws IllegalStateException {
        try {
            return Server.createTcpServer((String[])this.properties.createArguments());
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to build server", e);
        }
    }

    public H2ServerAutoConfiguration(@NonNull H2ServerProperties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked @NonNull but is null");
        }
        this.properties = properties;
    }

    @Configuration
    @ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseFactoryBean.class})
    public static class DataSourceDependsOnBeanFactoryPostProcessor
    extends AbstractDependsOnBeanFactoryPostProcessor {
        public DataSourceDependsOnBeanFactoryPostProcessor() {
            super(DataSource.class, EmbeddedDatabaseFactoryBean.class, new String[]{"h2Server"});
        }
    }
}

