/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit;

import com.github.springtestdbunit.DataSetModifiers;
import com.github.springtestdbunit.DatabaseConnections;
import com.github.springtestdbunit.DbUnitTestContext;
import com.github.springtestdbunit.DbUnitTestExecutionListener;
import com.github.springtestdbunit.annotation.DatabaseOperation;
import com.github.springtestdbunit.annotation.DatabaseSetup;
import com.github.springtestdbunit.annotation.DatabaseSetups;
import com.github.springtestdbunit.annotation.DatabaseTearDown;
import com.github.springtestdbunit.annotation.DatabaseTearDowns;
import com.github.springtestdbunit.annotation.ExpectedDatabase;
import com.github.springtestdbunit.annotation.ExpectedDatabases;
import com.github.springtestdbunit.assertion.DatabaseAssertion;
import com.github.springtestdbunit.dataset.DataSetLoader;
import com.github.springtestdbunit.dataset.DataSetModifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbUnitRunner {
    private static final Log logger = LogFactory.getLog(DbUnitTestExecutionListener.class);

    DbUnitRunner() {
    }

    public void beforeTestMethod(DbUnitTestContext testContext) throws Exception {
        List<DatabaseSetup> annotations = this.getAnnotations(testContext, DatabaseSetups.class, DatabaseSetup.class);
        this.setupOrTeardown(testContext, true, AnnotationAttributes.get(annotations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestMethod(DbUnitTestContext testContext) throws Exception {
        try {
            try {
                this.verifyExpected(testContext, this.getAnnotations(testContext, ExpectedDatabases.class, ExpectedDatabase.class));
            }
            finally {
                block12: {
                    List<DatabaseTearDown> annotations = this.getAnnotations(testContext, DatabaseTearDowns.class, DatabaseTearDown.class);
                    try {
                        this.setupOrTeardown(testContext, false, AnnotationAttributes.get(annotations));
                    }
                    catch (RuntimeException ex) {
                        if (testContext.getTestException() == null) {
                            throw ex;
                        }
                        if (!logger.isWarnEnabled()) break block12;
                        logger.warn((Object)"Unable to throw database cleanup exception due to existing test error", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            testContext.getConnections().closeAll();
        }
    }

    private <T extends Annotation> List<T> getAnnotations(DbUnitTestContext testContext, Class<? extends Annotation> containerType, Class<T> type) {
        ArrayList annotations = new ArrayList();
        this.addAnnotationToList(annotations, AnnotationUtils.findAnnotation(testContext.getTestClass(), type));
        this.addRepeatableAnnotationsToList(annotations, AnnotationUtils.findAnnotation(testContext.getTestClass(), containerType));
        this.addAnnotationToList(annotations, AnnotationUtils.findAnnotation((Method)testContext.getTestMethod(), type));
        this.addRepeatableAnnotationsToList(annotations, AnnotationUtils.findAnnotation((Method)testContext.getTestMethod(), containerType));
        return annotations;
    }

    private <T extends Annotation> void addAnnotationToList(List<T> annotations, T annotation) {
        if (annotation != null) {
            annotations.add(annotation);
        }
    }

    private <T extends Annotation> void addRepeatableAnnotationsToList(List<T> annotations, Annotation annotationContainer) {
        if (annotationContainer != null) {
            Annotation[] value;
            for (Annotation annotation : value = (Annotation[])AnnotationUtils.getValue((Annotation)annotationContainer)) {
                annotations.add(annotation);
            }
        }
    }

    private void verifyExpected(DbUnitTestContext testContext, List<ExpectedDatabase> annotations) throws Exception {
        if (testContext.getTestException() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping @DatabaseTest expectation due to test exception " + testContext.getTestException().getClass()));
            }
            return;
        }
        DatabaseConnections connections = testContext.getConnections();
        DataSetModifier modifier = this.getModifier(testContext, annotations);
        for (int i = annotations.size() - 1; i >= 0; --i) {
            ExpectedDatabase annotation = annotations.get(i);
            String query = annotation.query();
            String table = annotation.table();
            IDataSet expectedDataSet = this.loadDataset(testContext, annotation.value(), modifier);
            IDatabaseConnection connection = connections.get(annotation.connection());
            if (expectedDataSet != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Veriftying @DatabaseTest expectation using " + annotation.value()));
                }
                DatabaseAssertion assertion = annotation.assertionMode().getDatabaseAssertion();
                if (StringUtils.hasLength((String)query)) {
                    Assert.hasLength((String)table, (String)"The table name must be specified when using a SQL query");
                    ITable expectedTable = expectedDataSet.getTable(table);
                    ITable actualTable = connection.createQueryTable(table, query);
                    assertion.assertEquals(expectedTable, actualTable);
                } else if (StringUtils.hasLength((String)table)) {
                    ITable actualTable = connection.createTable(table);
                    ITable expectedTable = expectedDataSet.getTable(table);
                    assertion.assertEquals(expectedTable, actualTable);
                } else {
                    IDataSet actualDataSet = connection.createDataSet();
                    assertion.assertEquals(expectedDataSet, actualDataSet);
                }
            }
            if (!annotation.override()) continue;
            return;
        }
    }

    private DataSetModifier getModifier(DbUnitTestContext testContext, List<ExpectedDatabase> annotations) {
        DataSetModifiers modifiers = new DataSetModifiers();
        for (ExpectedDatabase annotation : annotations) {
            for (Class<? extends DataSetModifier> modifierClass : annotation.modifiers()) {
                modifiers.add(testContext.getTestInstance(), modifierClass);
            }
        }
        return modifiers;
    }

    private void setupOrTeardown(DbUnitTestContext testContext, boolean isSetup, Collection<AnnotationAttributes> annotations) throws Exception {
        DatabaseConnections connections = testContext.getConnections();
        for (AnnotationAttributes annotation : annotations) {
            List<IDataSet> datasets = this.loadDataSets(testContext, annotation);
            DatabaseOperation operation = annotation.getType();
            org.dbunit.operation.DatabaseOperation dbUnitOperation = this.getDbUnitDatabaseOperation(testContext, operation);
            if (datasets.isEmpty()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing " + (isSetup ? "Setup" : "Teardown") + " of @DatabaseTest using " + (Object)((Object)operation) + " on " + datasets.toString()));
            }
            IDatabaseConnection connection = connections.get(annotation.getConnection());
            CompositeDataSet dataSet = new CompositeDataSet(datasets.toArray(new IDataSet[datasets.size()]));
            dbUnitOperation.execute(connection, (IDataSet)dataSet);
        }
    }

    private List<IDataSet> loadDataSets(DbUnitTestContext testContext, AnnotationAttributes annotation) throws Exception {
        ArrayList<IDataSet> datasets = new ArrayList<IDataSet>();
        for (String dataSetLocation : annotation.getValue()) {
            datasets.add(this.loadDataset(testContext, dataSetLocation, DataSetModifier.NONE));
        }
        return datasets;
    }

    private IDataSet loadDataset(DbUnitTestContext testContext, String dataSetLocation, DataSetModifier modifier) throws Exception {
        DataSetLoader dataSetLoader = testContext.getDataSetLoader();
        if (StringUtils.hasLength((String)dataSetLocation)) {
            IDataSet dataSet = dataSetLoader.loadDataSet(testContext.getTestClass(), dataSetLocation);
            dataSet = modifier.modify(dataSet);
            Assert.notNull((Object)dataSet, (String)("Unable to load dataset from \"" + dataSetLocation + "\" using " + dataSetLoader.getClass()));
            return dataSet;
        }
        return null;
    }

    private org.dbunit.operation.DatabaseOperation getDbUnitDatabaseOperation(DbUnitTestContext testContext, DatabaseOperation operation) {
        org.dbunit.operation.DatabaseOperation databaseOperation = testContext.getDatbaseOperationLookup().get(operation);
        Assert.state((databaseOperation != null ? 1 : 0) != 0, (String)("The database operation " + (Object)((Object)operation) + " is not supported"));
        return databaseOperation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationAttributes {
        private final DatabaseOperation type;
        private final String[] value;
        private final String connection;

        public AnnotationAttributes(Annotation annotation) {
            Assert.state((annotation instanceof DatabaseSetup || annotation instanceof DatabaseTearDown ? 1 : 0) != 0, (String)"Only DatabaseSetup and DatabaseTearDown annotations are supported");
            Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
            this.type = (DatabaseOperation)((Object)attributes.get("type"));
            this.value = (String[])attributes.get("value");
            this.connection = (String)attributes.get("connection");
        }

        public DatabaseOperation getType() {
            return this.type;
        }

        public String[] getValue() {
            return this.value;
        }

        public String getConnection() {
            return this.connection;
        }

        public static <T extends Annotation> Collection<AnnotationAttributes> get(Collection<T> annotations) {
            ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>();
            for (Annotation annotation : annotations) {
                annotationAttributes.add(new AnnotationAttributes(annotation));
            }
            return annotationAttributes;
        }
    }
}

