/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.test.service;

import java.net.URISyntaxException;
import java.net.URL;
import org.junit.Assert;

public class ClassFileLocator {
    private static final String PREFIX = "file:";

    public String getClassFilePath(String path) {
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = cl.getResource(path + ".class");
        if (url != null) {
            return this.getFilenameFromUrl(url);
        }
        url = cl.getResource(path);
        Assert.assertNotNull((String)("No class found for the path = " + path), (Object)url);
        return this.getFilenameFromUrl(url);
    }

    public String getJspFilePath(String path) {
        ClassLoader cl = this.getClass().getClassLoader();
        String generatedClassName = path.replaceAll("_", "_005f").replace(".jsp", "_jsp");
        URL url = cl.getResource("jsp/" + generatedClassName + ".class");
        if (url == null) {
            url = cl.getResource("org/apache/jsp/" + generatedClassName + ".class");
        }
        Assert.assertNotNull((String)("No jsp file found for the path = " + path), (Object)url);
        return this.getFilenameFromUrl(url);
    }

    public String getJarFilePath(String path) {
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = cl.getResource(path);
        Assert.assertNotNull((String)("No jar found for the path = " + path), (Object)url);
        return this.getFilenameFromUrl(url);
    }

    private String getFilenameFromUrl(URL url) {
        String filename;
        try {
            filename = url.toURI().getPath();
        }
        catch (URISyntaxException e) {
            Assert.fail((String)("Failed to get file path = " + url));
            return null;
        }
        if (filename.startsWith(PREFIX)) {
            filename = filename.substring(PREFIX.length());
        }
        return filename;
    }
}

