/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import edu.umd.cs.findbugs.anttask.AbstractFindBugsTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class FindBugsTask
extends AbstractFindBugsTask {
    private String effort;
    private boolean conserveSpace;
    private boolean sorted = true;
    private boolean timestampNow = true;
    private boolean quietErrors;
    private String warningsProperty;
    private int maxRank;
    private String projectName;
    private boolean workHard;
    private boolean relaxed;
    private boolean adjustExperimental;
    private String adjustPriority;
    private File projectFile;
    private File userPreferencesFile;
    private File baselineBugs;
    private boolean applySuppression;
    private File excludeFile;
    private Path excludePath;
    private File includeFile;
    private Path includePath;
    private Path auxClasspath;
    private Path auxAnalyzepath;
    private Path sourcePath;
    private String outputFormat = "xml";
    private String reportLevel;
    private String visitors;
    private String chooseVisitors;
    private String omitVisitors;
    private String outputFileName;
    private String stylesheet;
    private final List<ClassLocation> classLocations = new ArrayList<ClassLocation>();
    private String onlyAnalyze;
    private boolean noClassOk;
    private boolean nested = true;
    private boolean setExitCode = true;
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private final List<DirSet> dirsets = new ArrayList<DirSet>();

    public FindBugsTask() {
        super("edu.umd.cs.findbugs.FindBugs2");
    }

    public void setWorkHard(boolean workHard) {
        this.workHard = workHard;
    }

    public void setSetExitCode(boolean setExitCode) {
        this.setExitCode = setExitCode;
    }

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public void setNoClassOk(boolean noClassOk) {
        this.noClassOk = noClassOk;
    }

    public void setRelaxed(boolean relaxed) {
        this.relaxed = relaxed;
    }

    public void setAdjustExperimental(boolean adjustExperimental) {
        this.adjustExperimental = adjustExperimental;
    }

    public void setAdjustPriority(String adjustPriorityString) {
        this.adjustPriority = adjustPriorityString;
    }

    public void setVisitors(String commaSeperatedString) {
        this.visitors = commaSeperatedString;
    }

    public void setChooseVisitors(String commaSeperatedString) {
        this.chooseVisitors = commaSeperatedString;
    }

    public void setOmitVisitors(String commaSeperatedString) {
        this.omitVisitors = commaSeperatedString;
    }

    public void setOutput(String format) {
        this.outputFormat = format;
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public void setReportLevel(String level) {
        this.reportLevel = level;
    }

    public void setSort(boolean flag) {
        this.sorted = flag;
    }

    public void setTimestampNow(boolean flag) {
        this.timestampNow = flag;
    }

    public void setQuietErrors(boolean flag) {
        this.quietErrors = flag;
    }

    public void setApplySuppression(boolean flag) {
        this.applySuppression = flag;
    }

    public void setWarningsProperty(String name) {
        this.warningsProperty = name;
    }

    public void setEffort(String effort) {
        this.effort = effort;
    }

    public void setMaxRank(int maxRank) {
        this.maxRank = maxRank;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setConserveSpace(boolean flag) {
        this.conserveSpace = flag;
    }

    public void setExcludeFilter(File filterFile) {
        if (filterFile != null && filterFile.length() > 0L) {
            this.excludeFile = filterFile;
        } else {
            if (filterFile != null) {
                this.log("Warning: exclude filter file " + filterFile + (filterFile.exists() ? " is empty" : " does not exist"));
            }
            this.excludeFile = null;
        }
    }

    public void setIncludeFilter(File filterFile) {
        if (filterFile != null && filterFile.length() > 0L) {
            this.includeFile = filterFile;
        } else {
            if (filterFile != null) {
                this.log("Warning: include filter file " + filterFile + (filterFile.exists() ? " is empty" : " does not exist"));
            }
            this.includeFile = null;
        }
    }

    public void setBaselineBugs(File baselineBugs) {
        if (baselineBugs != null && baselineBugs.length() > 0L) {
            this.baselineBugs = baselineBugs;
        } else {
            if (baselineBugs != null) {
                this.log("Warning: baseline bugs file " + baselineBugs + (baselineBugs.exists() ? " is empty" : " does not exist"));
            }
            this.baselineBugs = null;
        }
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setUserPreferencesFile(File userPreferencesFile) {
        this.userPreferencesFile = userPreferencesFile;
    }

    public void setAuxClasspath(Path src) {
        String[] elementList;
        boolean nonEmpty = false;
        for (String anElementList : elementList = src.list()) {
            if ("".equals(anElementList)) continue;
            nonEmpty = true;
            break;
        }
        if (nonEmpty) {
            if (this.auxClasspath == null) {
                this.auxClasspath = src;
            } else {
                this.auxClasspath.append(src);
            }
        }
    }

    public Path createAuxClasspath() {
        if (this.auxClasspath == null) {
            this.auxClasspath = new Path(this.getProject());
        }
        return this.auxClasspath.createPath();
    }

    public void setAuxClasspathRef(Reference r) {
        Path path = this.createAuxClasspath();
        path.setRefid(r);
        path.toString();
    }

    public void setAuxAnalyzepath(Path src) {
        String[] elementList;
        boolean nonEmpty = false;
        for (String anElementList : elementList = src.list()) {
            if ("".equals(anElementList)) continue;
            nonEmpty = true;
            break;
        }
        if (nonEmpty) {
            if (this.auxAnalyzepath == null) {
                this.auxAnalyzepath = src;
            } else {
                this.auxAnalyzepath.append(src);
            }
        }
    }

    public Path createAuxAnalyzepath() {
        if (this.auxAnalyzepath == null) {
            this.auxAnalyzepath = new Path(this.getProject());
        }
        return this.auxAnalyzepath.createPath();
    }

    public void setAuxAnalyzepathRef(Reference r) {
        this.createAuxAnalyzepath().setRefid(r);
    }

    public void setSourcePath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
    }

    public Path createSourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.getProject());
        }
        return this.sourcePath.createPath();
    }

    public void setSourcePathRef(Reference r) {
        this.createSourcePath().setRefid(r);
    }

    public void setExcludePath(Path src) {
        if (this.excludePath == null) {
            this.excludePath = src;
        } else {
            this.excludePath.append(src);
        }
    }

    public Path createExcludePath() {
        if (this.excludePath == null) {
            this.excludePath = new Path(this.getProject());
        }
        return this.excludePath.createPath();
    }

    public void setExcludePathRef(Reference r) {
        this.createExcludePath().setRefid(r);
    }

    public void setIncludePath(Path src) {
        if (this.includePath == null) {
            this.includePath = src;
        } else {
            this.includePath.append(src);
        }
    }

    public Path createIncludePath() {
        if (this.includePath == null) {
            this.includePath = new Path(this.getProject());
        }
        return this.includePath.createPath();
    }

    public void setIncludePathRef(Reference r) {
        this.createIncludePath().setRefid(r);
    }

    public ClassLocation createClass() {
        ClassLocation cl = new ClassLocation();
        this.classLocations.add(cl);
        return cl;
    }

    public void setOutputFile(String outputFileName) {
        if (outputFileName != null && outputFileName.length() > 0) {
            this.outputFileName = outputFileName;
        }
    }

    public void setOnlyAnalyze(String filter) {
        this.onlyAnalyze = filter;
    }

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void addDirset(DirSet fs) {
        this.dirsets.add(fs);
    }

    @Override
    protected void checkParameters() {
        super.checkParameters();
        if (this.projectFile == null && this.classLocations.size() == 0 && this.filesets.size() == 0 && this.dirsets.size() == 0 && this.auxAnalyzepath == null) {
            throw new BuildException("either projectfile, <class/>, <fileset/> or <auxAnalyzepath/> child elements must be defined for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (!(this.outputFormat == null || "xml".equalsIgnoreCase(this.outputFormat.trim()) || "xml:withMessages".equalsIgnoreCase(this.outputFormat.trim()) || "html".equalsIgnoreCase(this.outputFormat.trim()) || "text".equalsIgnoreCase(this.outputFormat.trim()) || "xdocs".equalsIgnoreCase(this.outputFormat.trim()) || "emacs".equalsIgnoreCase(this.outputFormat.trim()))) {
            throw new BuildException("output attribute must be either 'text', 'xml', 'html', 'xdocs' or 'emacs' for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (!(this.reportLevel == null || "experimental".equalsIgnoreCase(this.reportLevel.trim()) || "low".equalsIgnoreCase(this.reportLevel.trim()) || "medium".equalsIgnoreCase(this.reportLevel.trim()) || "high".equalsIgnoreCase(this.reportLevel.trim()))) {
            throw new BuildException("reportlevel attribute must be either 'experimental' or 'low' or 'medium' or 'high' for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        List<String> efforts = Arrays.asList("min", "less", "default", "more", "max");
        if (this.effort != null && !efforts.contains(this.effort)) {
            throw new BuildException("effort attribute must be one of " + efforts);
        }
    }

    @Override
    protected void beforeExecuteJavaProcess() {
        this.log("Running SpotBugs...");
    }

    @Override
    protected void afterExecuteJavaProcess(int rc) {
        if ((rc & 4) != 0) {
            throw new BuildException("Execution of SpotBugs failed.");
        }
        if ((rc & 2) != 0) {
            this.log("Classes needed for analysis were missing");
        }
        if (this.warningsProperty != null && (rc & 1) != 0) {
            this.getProject().setProperty(this.warningsProperty, "true");
        }
        if (this.outputFileName != null) {
            this.log("Output saved to " + this.outputFileName);
        }
    }

    @Override
    protected void configureFindbugsEngine() {
        File file;
        DirectoryScanner ds;
        int x;
        String[] result;
        if (this.projectName != null) {
            this.addArg("-projectName");
            this.addArg(this.projectName);
        }
        if (this.adjustExperimental) {
            this.addArg("-adjustExperimental");
        }
        if (this.conserveSpace) {
            this.addArg("-conserveSpace");
        }
        if (this.workHard) {
            this.addArg("-workHard");
        }
        if (this.effort != null) {
            this.addArg("-effort:" + this.effort);
        }
        if (this.maxRank >= 1 && this.maxRank <= 20) {
            this.addArg("-maxRank ");
            this.addArg(Integer.toString(this.maxRank));
        }
        if (this.adjustPriority != null) {
            this.addArg("-adjustPriority");
            this.addArg(this.adjustPriority);
        }
        if (this.sorted) {
            this.addArg("-sortByClass");
        }
        if (this.timestampNow) {
            this.addArg("-timestampNow");
        }
        if (this.outputFormat != null && !"text".equalsIgnoreCase(this.outputFormat.trim())) {
            this.outputFormat = this.outputFormat.trim();
            String outputArg = "-";
            int colon = this.outputFormat.indexOf(58);
            if (colon >= 0) {
                outputArg = outputArg + this.outputFormat.substring(0, colon).toLowerCase();
                outputArg = outputArg + ":";
                outputArg = outputArg + this.outputFormat.substring(colon + 1);
            } else {
                outputArg = outputArg + this.outputFormat.toLowerCase();
                if (this.stylesheet != null) {
                    outputArg = outputArg + ":";
                    outputArg = outputArg + this.stylesheet.trim();
                }
            }
            this.addArg(outputArg);
        }
        if (this.quietErrors) {
            this.addArg("-quiet");
        }
        if (this.reportLevel != null) {
            this.addArg("-" + this.reportLevel.trim().toLowerCase());
        }
        if (this.projectFile != null) {
            this.addArg("-project");
            this.addArg(this.projectFile.getPath());
        }
        if (this.userPreferencesFile != null) {
            this.addArg("-userPrefs");
            this.addArg(this.userPreferencesFile.getPath());
        }
        if (this.applySuppression) {
            this.addArg("-applySuppression");
        }
        if (this.baselineBugs != null) {
            this.addArg("-excludeBugs");
            this.addArg(this.baselineBugs.getPath());
        }
        if (this.excludeFile != null) {
            this.addArg("-exclude");
            this.addArg(this.excludeFile.getPath());
        }
        if (this.excludePath != null) {
            result = this.excludePath.toString().split(File.pathSeparator);
            for (x = 0; x < result.length; ++x) {
                this.addArg("-exclude");
                this.addArg(result[x]);
            }
        }
        if (this.includeFile != null) {
            this.addArg("-include");
            this.addArg(this.includeFile.getPath());
        }
        if (this.includePath != null) {
            result = this.includePath.toString().split(File.pathSeparator);
            for (x = 0; x < result.length; ++x) {
                this.addArg("-include");
                this.addArg(result[x]);
            }
        }
        if (this.visitors != null) {
            this.addArg("-visitors");
            this.addArg(this.visitors);
        }
        if (this.omitVisitors != null) {
            this.addArg("-omitVisitors");
            this.addArg(this.omitVisitors);
        }
        if (this.chooseVisitors != null) {
            this.addArg("-chooseVisitors");
            this.addArg(this.chooseVisitors);
        }
        if (this.auxClasspath != null) {
            try {
                String unreadReference = this.auxClasspath.toString();
                String auxClasspathString = this.auxClasspath.toString();
                if (!auxClasspathString.isEmpty()) {
                    if (auxClasspathString.length() > 100) {
                        this.addArg("-auxclasspathFromInput");
                        this.setInputString(auxClasspathString);
                    } else {
                        this.addArg("-auxclasspath");
                        this.addArg(auxClasspathString);
                    }
                }
            }
            catch (Throwable t) {
                this.log("Warning: auxClasspath " + t + " not found.");
            }
        }
        if (this.sourcePath != null) {
            this.addArg("-sourcepath");
            this.addArg(this.sourcePath.toString());
        }
        if (this.outputFileName != null) {
            this.addArg("-outputFile");
            this.addArg(this.outputFileName);
        }
        if (this.relaxed) {
            this.addArg("-relaxed");
        }
        if (!this.nested) {
            this.addArg("-nested:false");
        }
        if (this.noClassOk) {
            this.addArg("-noClassOk");
        }
        if (this.onlyAnalyze != null) {
            this.addArg("-onlyAnalyze");
            this.addArg(this.onlyAnalyze);
        }
        if (this.setExitCode) {
            this.addArg("-exitcode");
        }
        for (ClassLocation classLocation : this.classLocations) {
            this.addArg(classLocation.toString());
        }
        for (FileSet fs : this.filesets) {
            ds = fs.getDirectoryScanner();
            for (String fileName : ds.getIncludedFiles()) {
                file = new File(ds.getBasedir(), fileName);
                this.addArg(file.toString());
            }
        }
        for (DirSet fs : this.dirsets) {
            ds = fs.getDirectoryScanner();
            for (String fileName : ds.getIncludedDirectories()) {
                file = new File(ds.getBasedir(), fileName);
                this.addArg(file.toString());
            }
        }
        if (this.auxAnalyzepath != null) {
            result = this.auxAnalyzepath.toString().split(File.pathSeparator);
            for (int x2 = 0; x2 < result.length; ++x2) {
                this.addArg(result[x2]);
            }
        }
    }

    public static class ClassLocation {
        File classLocation = null;

        public void setLocation(File location) {
            this.classLocation = location;
        }

        public File getLocation() {
            return this.classLocation;
        }

        public String toString() {
            return this.classLocation != null ? this.classLocation.toString() : "";
        }
    }
}

