/*
 * Decompiled with CFR 0.152.
 */
package com.jackandphantom.carouselrecyclerview.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jackandphantom/carouselrecyclerview/view/ReflectionImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "performReflection", "", "originalImage", "Landroid/graphics/Bitmap;", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setImageResource", "resId", "", "carouselrecyclerview_release"})
public final class ReflectionImageView
extends AppCompatImageView {
    public void setImageDrawable(@Nullable Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable == null) {
            return;
        }
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            this.performReflection(bitmapDrawable.getBitmap());
        }
        Bitmap bitmap = null;
        bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        this.performReflection(bitmap);
    }

    public void setImageResource(int resId) {
        this.performReflection(BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId));
    }

    private final void performReflection(Bitmap originalImage) {
        if (originalImage == null) {
            return;
        }
        int reflectionGap = 4;
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        Matrix matrix = new Matrix();
        matrix.preScale(1.0f, -1.0f);
        Bitmap reflectionImage = Bitmap.createBitmap((Bitmap)originalImage, (int)0, (int)(height / 2), (int)width, (int)(height / 2), (Matrix)matrix, (boolean)false);
        Bitmap bitmapWithReflection = Bitmap.createBitmap((int)width, (int)(height + height / 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmapWithReflection);
        Paint paint = new Paint();
        float f = originalImage.getHeight();
        Bitmap bitmap = bitmapWithReflection;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmapWithReflection");
        LinearGradient shader = new LinearGradient(0.0f, f, 0.0f, (float)bitmap.getHeight() + (float)reflectionGap, 0x70FFFFFF, 0, Shader.TileMode.MIRROR);
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawBitmap(originalImage, 0.0f, 0.0f, null);
        Paint defaultPaint = new Paint();
        canvas.drawRect(0.0f, (float)height, (float)width, (float)(bitmapWithReflection.getHeight() + reflectionGap), defaultPaint);
        canvas.drawBitmap(reflectionImage, 0.0f, (float)(height + reflectionGap), null);
        canvas.drawRect(0.0f, (float)height, (float)width, (float)(bitmapWithReflection.getHeight() + reflectionGap), paint);
        super.setImageDrawable((Drawable)new BitmapDrawable(this.getResources(), bitmapWithReflection));
    }

    public ReflectionImageView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
    }
}

