/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReusableStructureName
extends ASTCssNode {
    private List<ElementSubsequent> nameParts = new ArrayList<ElementSubsequent>();

    public ReusableStructureName(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public ReusableStructureName(HiddenTokenAwareTree underlyingStructure, List<ElementSubsequent> nameParts) {
        this(underlyingStructure);
        this.nameParts = nameParts;
    }

    public boolean isInterpolated() {
        for (ElementSubsequent namePart : this.nameParts) {
            if (!namePart.isInterpolated()) continue;
            return true;
        }
        return false;
    }

    public String asString() {
        String result = "";
        for (ElementSubsequent namePart : this.nameParts) {
            result = result + namePart.getFullName();
        }
        return result;
    }

    public List<ElementSubsequent> getNameParts() {
        return this.nameParts;
    }

    public void addNamePart(ElementSubsequent namePart) {
        this.nameParts.add(namePart);
    }

    public boolean hasMultipleParts() {
        return this.nameParts.size() > 1;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return Collections.emptyList();
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.REUSABLE_STRUCTURE_NAME;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (ElementSubsequent namePart : this.nameParts) {
            result.append(namePart);
        }
        return result.toString();
    }

    @Override
    public ReusableStructureName clone() {
        ReusableStructureName result = (ReusableStructureName)super.clone();
        result.nameParts = new ArrayList<ElementSubsequent>(this.nameParts);
        return result;
    }
}

