/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.Collections;
import java.util.List;

public class MediaExpressionFeature
extends ASTCssNode {
    private String feature;

    public MediaExpressionFeature(HiddenTokenAwareTree underlyingStructure, String feature) {
        super(underlyingStructure);
        this.feature = feature;
    }

    public boolean isRatioFeature() {
        if (this.getFeature() == null) {
            return false;
        }
        String feature = this.getFeature().toLowerCase();
        return feature.endsWith("aspect-ratio") || feature.endsWith("pixel-ratio");
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return Collections.emptyList();
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.MEDIUM_EX_FEATURE;
    }

    @Override
    public MediaExpressionFeature clone() {
        return (MediaExpressionFeature)super.clone();
    }
}

