/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JILocalMethodDescriptor;

public final class JILocalInterfaceDefinition
implements Serializable {
    private static final long serialVersionUID = 7683984211902254797L;
    private String interfaceIdentifier = null;
    private final Map<Integer, JILocalMethodDescriptor> opnumVsMethodInfo = new HashMap<Integer, JILocalMethodDescriptor>();
    private final Map<Integer, JILocalMethodDescriptor> dispIdVsMethodInfo = new HashMap<Integer, JILocalMethodDescriptor>();
    private final Map<String, JILocalMethodDescriptor> nameVsMethodInfo = new HashMap<String, JILocalMethodDescriptor>();
    private boolean dispInterface = true;
    private int nextNum = 0;
    Object instance = null;
    Class<?> clazz = null;

    public JILocalInterfaceDefinition(String interfaceIdentifier) {
        this.interfaceIdentifier = interfaceIdentifier;
    }

    public JILocalInterfaceDefinition(String interfaceIdentifier, boolean isDispInterface) {
        this.interfaceIdentifier = interfaceIdentifier;
        this.dispInterface = isDispInterface;
    }

    public void addMethodDescriptor(JILocalMethodDescriptor methodDescriptor) {
        if (this.nameVsMethodInfo.containsKey(methodDescriptor.getMethodName())) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4131));
        }
        methodDescriptor.setMethodNum(this.nextNum);
        ++this.nextNum;
        this.opnumVsMethodInfo.put(methodDescriptor.getMethodNum(), methodDescriptor);
        if (this.dispInterface) {
            if (methodDescriptor.getMethodDispID() == -1) {
                throw new IllegalArgumentException(JISystem.getLocalizedMessage(4151));
            }
            this.dispIdVsMethodInfo.put(methodDescriptor.getMethodDispID(), methodDescriptor);
        }
        this.nameVsMethodInfo.put(methodDescriptor.getMethodName(), methodDescriptor);
    }

    public JILocalMethodDescriptor getMethodDescriptor(int opnum) {
        return this.opnumVsMethodInfo.get(opnum);
    }

    public JILocalMethodDescriptor getMethodDescriptorForDispId(int dispId) {
        return this.dispIdVsMethodInfo.get(dispId);
    }

    public JILocalMethodDescriptor getMethodDescriptor(String name) {
        return this.nameVsMethodInfo.get(name);
    }

    public JILocalMethodDescriptor[] getMethodDescriptors() {
        return this.opnumVsMethodInfo.values().toArray(new JILocalMethodDescriptor[this.opnumVsMethodInfo.values().size()]);
    }

    public String getInterfaceIdentifier() {
        return this.interfaceIdentifier;
    }

    public void removeMethodDescriptor(int opnum) {
        JILocalMethodDescriptor methodDescriptor = this.opnumVsMethodInfo.remove(opnum);
        if (methodDescriptor != null) {
            this.nameVsMethodInfo.remove(methodDescriptor.getMethodName());
        }
    }

    public void removeMethodDescriptor(String methodName) {
        JILocalMethodDescriptor methodDescriptor = this.nameVsMethodInfo.remove(methodName);
        if (methodDescriptor != null) {
            this.opnumVsMethodInfo.remove(methodDescriptor.getMethodNum());
            this.dispIdVsMethodInfo.remove(methodDescriptor.getMethodNum());
        }
    }

    public boolean isDispInterface() {
        return this.dispInterface;
    }
}

