/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JILocalInterfaceDefinition;
import org.jinterop.dcom.core.JILocalMethodDescriptor;
import org.jinterop.dcom.core.JILocalParamsDescriptor;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIVariant;
import rpc.core.UUID;

public final class JILocalCoClass
implements Serializable {
    private static final long serialVersionUID = 5542223845228327383L;
    private static final String IID_IDISPATCH = "00020400-0000-0000-c000-000000000046";
    private static Random randomGen = new Random(Double.doubleToRawLongBits(Math.random()));
    private final int identifier;
    private WeakReference<JIInterfacePointer> interfacePointer = null;
    private boolean isAlreadyExported = false;
    private byte[] objectID = null;
    private JILocalInterfaceDefinition interfaceDefinition = null;
    private final List<String> listOfSupportedInterfaces = new ArrayList<String>();
    private final Map<String, JILocalInterfaceDefinition> mapOfIIDsToInterfaceDefinitions = new HashMap<String, JILocalInterfaceDefinition>();
    private JISession session = null;
    private boolean realIID = false;
    private final Map<String, String> ipidVsIID = new HashMap<String, String>();
    private final Map<String, String> IIDvsIpid = new HashMap<String, String>();

    private void init(JILocalInterfaceDefinition interfaceDefinition, Class clazz, Object instance, boolean realIID) {
        this.listOfSupportedInterfaces.add(IID_IDISPATCH.toUpperCase());
        this.listOfSupportedInterfaces.add("00000131-0000-0000-C000-000000000046");
        this.interfaceDefinition = interfaceDefinition;
        interfaceDefinition.clazz = clazz;
        interfaceDefinition.instance = instance;
        this.listOfSupportedInterfaces.add(interfaceDefinition.getInterfaceIdentifier().toUpperCase());
        this.mapOfIIDsToInterfaceDefinitions.put(interfaceDefinition.getInterfaceIdentifier().toUpperCase(), interfaceDefinition);
        this.realIID = realIID;
    }

    public JILocalCoClass(JILocalInterfaceDefinition interfaceDefinition, Class clazz) {
        if (interfaceDefinition == null || clazz == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4122));
        }
        this.identifier = clazz.hashCode() ^ new Object().hashCode() ^ randomGen.nextInt();
        this.init(interfaceDefinition, clazz, null, false);
    }

    public JILocalCoClass(JILocalInterfaceDefinition interfaceDefinition, Class clazz, boolean useInterfaceDefinitionIID) {
        if (interfaceDefinition == null || clazz == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4122));
        }
        this.identifier = clazz.hashCode() ^ new Object().hashCode() ^ randomGen.nextInt();
        this.init(interfaceDefinition, clazz, null, useInterfaceDefinitionIID);
    }

    public JILocalCoClass(JILocalInterfaceDefinition interfaceDefinition, Object instance) {
        if (interfaceDefinition == null || instance == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4122));
        }
        this.identifier = instance.hashCode() ^ new Object().hashCode() ^ randomGen.nextInt();
        this.init(interfaceDefinition, null, instance, false);
    }

    public JILocalCoClass(JILocalInterfaceDefinition interfaceDefinition, Object instance, boolean useInterfaceDefinitionIID) {
        if (interfaceDefinition == null || instance == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4122));
        }
        this.identifier = instance.hashCode() ^ new Object().hashCode() ^ randomGen.nextInt();
        this.init(interfaceDefinition, null, instance, useInterfaceDefinitionIID);
    }

    public void setSupportedEventInterfaces(List<String> listOfIIDs) {
        if (listOfIIDs != null) {
            for (int i = 0; i < listOfIIDs.size(); ++i) {
                String s = listOfIIDs.get(i).toUpperCase();
                this.listOfSupportedInterfaces.add(s);
                this.mapOfIIDsToInterfaceDefinitions.put(s, this.interfaceDefinition);
            }
        }
    }

    public void addInterfaceDefinition(JILocalInterfaceDefinition interfaceDefinition, Object instance) {
        if (interfaceDefinition == null || instance == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4122));
        }
        interfaceDefinition.instance = instance;
        String s = interfaceDefinition.getInterfaceIdentifier().toUpperCase();
        this.listOfSupportedInterfaces.add(s);
        this.mapOfIIDsToInterfaceDefinitions.put(s, interfaceDefinition);
    }

    public void addInterfaceDefinition(JILocalInterfaceDefinition interfaceDefinition, Class clazz) {
        if (interfaceDefinition == null || clazz == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4122));
        }
        interfaceDefinition.clazz = clazz;
        String s = interfaceDefinition.getInterfaceIdentifier().toUpperCase();
        this.listOfSupportedInterfaces.add(s);
        this.mapOfIIDsToInterfaceDefinitions.put(s, interfaceDefinition);
    }

    public Object getServerInstance() {
        return this.interfaceDefinition.instance;
    }

    public Class getServerClass() {
        return this.interfaceDefinition.clazz;
    }

    void setObjectId(byte[] objectId) {
        this.objectID = objectId;
    }

    void setAssociatedInterfacePointer(JIInterfacePointer interfacePointer) {
        this.isAlreadyExported = true;
        this.interfacePointer = new WeakReference<JIInterfacePointer>(interfacePointer);
        String ipid = interfacePointer.getIPID().toUpperCase();
        String iid = interfacePointer.getIID().toUpperCase();
        this.IIDvsIpid.put(iid, ipid);
        this.ipidVsIID.put(ipid, iid);
    }

    boolean isAssociatedReferenceAlive() {
        return this.interfacePointer == null ? false : this.interfacePointer.get() != null;
    }

    boolean isAlreadyExported() {
        return this.isAlreadyExported;
    }

    byte[] getObjectId() {
        return this.objectID;
    }

    boolean isPresent(String iid) {
        return this.listOfSupportedInterfaces.contains(iid.toUpperCase());
    }

    synchronized boolean exportInstance(String uniqueIID, String IPID) throws InstantiationException, IllegalAccessException {
        IPID = IPID.toUpperCase();
        if (!this.isPresent(uniqueIID)) {
            return false;
        }
        this.IIDvsIpid.put(uniqueIID.toUpperCase(), IPID);
        this.ipidVsIID.put(IPID, uniqueIID.toUpperCase());
        return true;
    }

    public String getCoClassIID() {
        return this.interfaceDefinition.getInterfaceIdentifier();
    }

    Object[] invokeMethod(String IPID, int Opnum, NetworkDataRepresentation ndr) throws JIException {
        IPID = IPID.toUpperCase();
        Object retVal = null;
        String iid = this.ipidVsIID.get(IPID);
        if (iid == null) {
            throw new JIException(-2147417836);
        }
        JILocalInterfaceDefinition interfaceDefinitionOfClass = this.mapOfIIDsToInterfaceDefinitions.get(iid);
        interfaceDefinitionOfClass = interfaceDefinitionOfClass == null ? this.interfaceDefinition : interfaceDefinitionOfClass;
        JILocalMethodDescriptor methodDescriptor = null;
        boolean execute = false;
        Object[] params = null;
        boolean isStandardCall = true;
        if (this.interfaceDefinition.isDispInterface()) {
            isStandardCall = false;
            switch (Opnum) {
                case 3: {
                    retVal = new Object[]{0};
                    break;
                }
                case 4: {
                    throw new JIException(-2147467263);
                }
                case 5: {
                    JILocalParamsDescriptor paramObject = new JILocalParamsDescriptor();
                    paramObject.addInParamAsType(UUID.class, 0);
                    paramObject.addInParamAsObject(new JIArray(new JIString(4), null, 1, true), 0);
                    paramObject.addInParamAsType(Integer.class, 0);
                    paramObject.addInParamAsType(Integer.class, 0);
                    JIArray array = (JIArray)paramObject.read(ndr)[1];
                    Object[] arrayObj = (Object[])array.getArrayInstance();
                    Integer[] dispIds = new Integer[arrayObj.length];
                    JIString apiName = (JIString)arrayObj[0];
                    JILocalMethodDescriptor info = interfaceDefinitionOfClass.getMethodDescriptor(apiName.getString());
                    dispIds[0] = info == null ? Integer.valueOf(-2147352570) : Integer.valueOf(info.getMethodNum());
                    for (int i = 1; i < arrayObj.length; ++i) {
                        dispIds[i] = i - 1;
                    }
                    JIArray results = new JIArray(dispIds);
                    retVal = new Object[]{results};
                    break;
                }
                case 6: {
                    int i;
                    JIArray array;
                    JILocalParamsDescriptor paramObject = new JILocalParamsDescriptor();
                    paramObject.setSession(this.session);
                    paramObject.addInParamAsType(Integer.class, 0);
                    paramObject.addInParamAsType(UUID.class, 0);
                    paramObject.addInParamAsType(Integer.class, 0);
                    paramObject.addInParamAsType(Integer.class, 0);
                    JIStruct dispParams = new JIStruct();
                    dispParams.addMember(new JIPointer(new JIArray(JIVariant.class, null, 1, true)));
                    dispParams.addMember(new JIPointer(new JIArray(Integer.class, null, 1, true)));
                    dispParams.addMember(Integer.class);
                    dispParams.addMember(Integer.class);
                    paramObject.addInParamAsObject(dispParams, 64);
                    paramObject.addInParamAsType(Integer.class, 0);
                    paramObject.addInParamAsObject(new JIArray(Integer.class, null, 1, true), 0);
                    paramObject.addInParamAsObject(new JIArray(JIVariant.class, null, 1, true), 0);
                    Object[] retresults = paramObject.read(ndr);
                    int dispId = ((Number)retresults[0]).intValue();
                    JILocalMethodDescriptor info = interfaceDefinitionOfClass.getMethodDescriptorForDispId(dispId);
                    if (info == null) {
                        if (JISystem.getLogger().isLoggable(Level.SEVERE)) {
                            JISystem.getLogger().log(Level.SEVERE, "MethodDescriptor not found for DispId :- {0}", dispId);
                        }
                        throw new JIException(-2147352573);
                    }
                    dispParams = (JIStruct)retresults[4];
                    JIPointer ptrToParamsArray = (JIPointer)dispParams.getMember(0);
                    params = new Object[]{};
                    if (!ptrToParamsArray.isNull()) {
                        array = (JIArray)ptrToParamsArray.getReferent();
                        Object[] variants = (Object[])array.getArrayInstance();
                        params = new Object[variants.length];
                        for (i = 0; i < variants.length; ++i) {
                            params[i] = ((JIVariant)variants[i]).getObject();
                        }
                    }
                    if (((Number)retresults[5]).intValue() != 0) {
                        array = (JIArray)retresults[6];
                        Integer[] indexs = (Integer[])array.getArrayInstance();
                        array = (JIArray)retresults[7];
                        JIVariant[] variants = (JIVariant[])array.getArrayInstance();
                        for (int i2 = 0; i2 < indexs.length; ++i2) {
                            params[indexs[i2].intValue()] = variants[i2];
                        }
                    }
                    int halflength = params.length / 2;
                    for (i = 0; i < halflength; ++i) {
                        Object t = params[i];
                        params[i] = params[params.length - 1 - i];
                        params[params.length - 1 - i] = t;
                    }
                    methodDescriptor = info;
                    execute = true;
                    break;
                }
                default: {
                    isStandardCall = true;
                    Opnum -= 4;
                    if (!JISystem.getLogger().isLoggable(Level.INFO)) break;
                    JISystem.getLogger().log(Level.INFO, "Standard call came: Opnum is {0}", Opnum);
                }
            }
        }
        if (isStandardCall) {
            methodDescriptor = interfaceDefinitionOfClass.getMethodDescriptor(Opnum - 3);
            if (methodDescriptor == null) {
                throw new JIException(-1073610706);
            }
            methodDescriptor.getParameterObject().setSession(this.session);
            params = methodDescriptor.getParameterObject().read(ndr);
            execute = true;
        }
        if (execute) {
            Class<?> calleeClazz = interfaceDefinitionOfClass.instance == null ? interfaceDefinitionOfClass.clazz : interfaceDefinitionOfClass.instance.getClass();
            Method method = null;
            try {
                Object result;
                Object calleeInstance;
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "methodDescriptor: {0}", methodDescriptor.getMethodName());
                }
                method = calleeClazz.getDeclaredMethod(methodDescriptor.getMethodName(), methodDescriptor.getInparametersAsClass());
                Object object = calleeInstance = interfaceDefinitionOfClass.instance == null ? calleeClazz.newInstance() : interfaceDefinitionOfClass.instance;
                if (JISystem.getLogger().isLoggable(Level.INFO)) {
                    JISystem.getLogger().log(Level.INFO, "Call Back Method to be executed: {0} , to be executed on {1}", new Object[]{method, calleeInstance});
                }
                retVal = (result = method.invoke(calleeInstance, params)) == null ? null : (!(result instanceof Object[]) ? new Object[]{result} : result);
            }
            catch (IllegalArgumentException e) {
                JISystem.getLogger().throwing("JILocalCoClass", "invokeMethod", e);
                throw new JIException(-2147024809, (Throwable)e);
            }
            catch (IllegalAccessException | SecurityException e) {
                JISystem.getLogger().throwing("JILocalCoClass", "invokeMethod", e);
                throw new JIException(5, (Throwable)e);
            }
            catch (InstantiationException | InvocationTargetException e) {
                JISystem.getLogger().throwing("JILocalCoClass", "invokeMethod", e);
                throw new JIException(-2147418113, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                JISystem.getLogger().throwing("JILocalCoClass", "invokeMethod", e);
                throw new JIException(-1073610706, (Throwable)e);
            }
        }
        return retVal;
    }

    public JILocalInterfaceDefinition getInterfaceDefinition() {
        return this.interfaceDefinition;
    }

    public boolean equals(Object target) {
        if (target == null || !(target instanceof JILocalCoClass)) {
            return false;
        }
        return this.identifier == ((JILocalCoClass)target).identifier;
    }

    public int hashCode() {
        return this.identifier;
    }

    public JILocalInterfaceDefinition getInterfaceDefinition(String IID) {
        return this.mapOfIIDsToInterfaceDefinitions.get(IID.toUpperCase());
    }

    JILocalInterfaceDefinition getInterfaceDefinitionFromIPID(String IPID) {
        return this.mapOfIIDsToInterfaceDefinitions.get(this.ipidVsIID.get(IPID.toUpperCase()));
    }

    String getIpidFromIID(String uniqueIID) {
        return this.IIDvsIpid.get(uniqueIID.toUpperCase());
    }

    String getIIDFromIpid(String ipid) {
        return this.ipidVsIID.get(ipid.toUpperCase());
    }

    public boolean isCoClassUnderRealIID() {
        return this.realIID;
    }

    void setSession(JISession session) {
        this.session = session;
    }

    JISession getSession() {
        return this.session;
    }

    List<String> getSupportedInterfaces() {
        return this.listOfSupportedInterfaces;
    }
}

