/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.IJIUnreferenced;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIComOxidRuntime;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIObjectId;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JIRemUnknownServer;
import org.jinterop.dcom.core.JIStdObjRef;
import org.jinterop.dcom.core.JIStruct;
import rpc.core.UUID;

public final class JISession {
    private static Random randomGen = new Random(Double.doubleToRawLongBits(Math.random()));
    private int sessionIdentifier = -1;
    private String username = null;
    private String password = null;
    private String domain = null;
    private String targetServer = null;
    private static Map mapOfObjects = Collections.synchronizedMap(new HashMap());
    private static Object mutex = new Object();
    private IJIAuthInfo authInfo = null;
    private JIComServer stub = null;
    private JIRemUnknownServer stub2 = null;
    private static int oxidResolverPort = -1;
    private static byte[] localhost = new byte[]{127, 0, 0, 1};
    private static String localhostStr = "127.0.0.1";
    private static String localhostStr2 = "LOCALHOST";
    private static Map mapOfSessionIdsVsSessions = new HashMap();
    private static ArrayList listOfSessions = new ArrayList();
    private List listOfDeferencedIpids = new ArrayList();
    private static Timer releaseRefsTimer = new Timer(true);
    private Map mapOfUnreferencedHandlers = new HashMap();
    private int timeout = 0;
    private boolean useSessionSecurity = false;
    private boolean useNTLMv2 = false;
    private boolean isSSO = false;
    private ArrayList links = new ArrayList();
    private static final Map mapOfOxidsVsJISessions = new HashMap();
    private boolean sessionInDestroy = false;
    static ReferenceQueue referenceQueueOfCOMObjects = new ReferenceQueue();
    static Thread cleanUpThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                try {
                    while (true) {
                        Reference r;
                        if ((r = referenceQueueOfCOMObjects.remove()) == null) {
                            continue;
                        }
                        IPID_SessionID_Holder holder = null;
                        Map map = mapOfObjects;
                        synchronized (map) {
                            holder = (IPID_SessionID_Holder)mapOfObjects.remove(r);
                            if (holder == null) {
                                continue;
                            }
                        }
                        JISession session = null;
                        Object object = mutex;
                        synchronized (object) {
                            session = (JISession)mapOfSessionIdsVsSessions.get(holder.sessionID);
                        }
                        if (holder.isOnlySessionIDPresent) {
                            try {
                                JISession.destroySession(session);
                                continue block12;
                            }
                            catch (Exception e) {
                                if (!JISystem.getLogger().isLoggable(Level.FINEST)) continue;
                                JISystem.getLogger().log(Level.FINEST, "exception from destroy session in clean up thread: {0}", e.getMessage());
                                continue;
                            }
                        }
                        if (session == null) continue;
                        try {
                            String IPID = holder.IPID;
                            session.addDereferencedIpids(IPID, holder.oid);
                            holder = null;
                            IJIUnreferenced unreferenced = session.getUnreferencedHandler(IPID);
                            if (unreferenced != null) {
                                unreferenced.unReferenced();
                            }
                            session.unregisterUnreferencedHandler(IPID);
                            continue block12;
                        }
                        catch (Exception e) {
                            if (!JISystem.getLogger().isLoggable(Level.INFO)) continue;
                            JISystem.getLogger().log(Level.INFO, "exception from removing a IPID from session in clean up thread: {0}", e.getMessage());
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    JISystem.getLogger().throwing("JISession", "CleanupThread:run()", e);
                    return;
                }
            }
        }
    }, "jI_GarbageCollector");
    private static Map mapOfIPIDSvsCount;

    private static String getLocalHost(String destination) {
        InetAddress intendedDestination;
        DatagramSocket sock;
        try {
            sock = new DatagramSocket();
            intendedDestination = InetAddress.getByName(destination);
        }
        catch (Exception e) {
            return "127.0.0.1";
        }
        sock.connect(intendedDestination, sock.getLocalPort());
        return sock.getLocalAddress().getHostAddress();
    }

    void setTargetServer(String targetServer) {
        if (targetServer.equalsIgnoreCase("127.0.0.1")) {
            this.targetServer = JISession.getLocalhostAddressAsIPString();
        } else {
            this.targetServer = targetServer;
            if (localhostStr.equalsIgnoreCase("127.0.0.1")) {
                localhostStr = JISession.getLocalHost(targetServer);
            }
        }
    }

    static byte[] getLocalhostAddressAsIPbytes() {
        return localhost;
    }

    static String getLocalhostAddressAsIPString() {
        return localhostStr;
    }

    static String getLocalhostCanonicalAddressAsString() {
        return localhostStr2;
    }

    String getTargetServer() {
        return this.targetServer;
    }

    private JISession() {
    }

    static int getOxidResolverPort() {
        return oxidResolverPort;
    }

    public IJIAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JISession createSession(IJIAuthInfo authInfo) {
        if (authInfo == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4112));
        }
        JISession session = new JISession();
        session.authInfo = authInfo;
        session.sessionIdentifier = authInfo.getUserName().hashCode() ^ authInfo.getPassword().hashCode() ^ authInfo.getDomain().hashCode() ^ new Object().hashCode() ^ (int)Runtime.getRuntime().freeMemory() ^ randomGen.nextInt();
        Object object = mutex;
        synchronized (object) {
            mapOfSessionIdsVsSessions.put(new Integer(session.sessionIdentifier), session);
            listOfSessions.add(session);
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "Created Session: {0}", session.sessionIdentifier);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JISession createSession(String domain, String username, String password) {
        if (username == null || password == null || domain == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4112));
        }
        JISession session = new JISession();
        session.username = username;
        session.password = password;
        session.domain = domain;
        session.sessionIdentifier = username.hashCode() ^ password.hashCode() ^ domain.hashCode() ^ new Object().hashCode() ^ (int)Runtime.getRuntime().freeMemory() ^ randomGen.nextInt();
        Object object = mutex;
        synchronized (object) {
            mapOfSessionIdsVsSessions.put(new Integer(session.sessionIdentifier), session);
            listOfSessions.add(session);
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "Created Session: {0}", session.sessionIdentifier);
        }
        return session;
    }

    public static JISession createSession(JISession session) {
        JISession newSession = JISession.createSession(session.getDomain(), session.getUserName(), session.getPassword());
        newSession.authInfo = session.authInfo;
        return newSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JISession createSession() {
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4178));
        }
        JISession session = new JISession();
        session.sessionIdentifier = new Object().hashCode() ^ (int)Runtime.getRuntime().freeMemory() ^ randomGen.nextInt();
        session.isSSO = true;
        Object object = mutex;
        synchronized (object) {
            mapOfSessionIdsVsSessions.put(new Integer(session.sessionIdentifier), session);
            listOfSessions.add(session);
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "Created Session for SSO: {0}", session.sessionIdentifier);
        }
        return session;
    }

    public boolean isSSOEnabled() {
        return this.isSSO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroySession(JISession session) throws JIException {
        if (session == null) {
            return;
        }
        if (session.stub == null) {
            Object object = mutex;
            synchronized (object) {
                mapOfSessionIdsVsSessions.remove(new Integer(session.getSessionIdentifier()));
                listOfSessions.remove(session);
            }
            JISession.postDestroy(session);
            return;
        }
        try {
            ArrayList<JIStruct> list = new ArrayList<JIStruct>();
            ArrayList<String> listOfFreeIPIDs = new ArrayList<String>();
            Object object = mutex;
            synchronized (object) {
                block33: {
                    if (!session.sessionInDestroy) break block33;
                    return;
                }
                session.sessionInDestroy = true;
                for (int j = 0; j < session.listOfDeferencedIpids.size(); ++j) {
                    list.add(session.prepareForReleaseRef((String)session.listOfDeferencedIpids.get(j)));
                }
                listOfFreeIPIDs.addAll(session.listOfDeferencedIpids);
                session.listOfDeferencedIpids.clear();
            }
            object = mapOfObjects;
            synchronized (object) {
                Iterator iterator = mapOfObjects.entrySet().iterator();
                while (iterator.hasNext()) {
                    String ipid;
                    Map.Entry entry = iterator.next();
                    IPID_SessionID_Holder holder = (IPID_SessionID_Holder)entry.getValue();
                    if (session.getSessionIdentifier() != holder.sessionID.intValue() || (ipid = holder.IPID) == null) continue;
                    list.add(session.prepareForReleaseRef(ipid));
                    listOfFreeIPIDs.add(ipid);
                    iterator.remove();
                }
            }
            if (session.stub.getServerInterfacePointer() != null && !listOfFreeIPIDs.contains(session.stub.getServerInterfacePointer().getIPID())) {
                list.add(session.prepareForReleaseRef(session.stub.getServerInterfacePointer().getIPID(), ((JIStdObjRef)session.stub.getServerInterfacePointer().getObjectReference(1)).getPublicRefs()));
                listOfFreeIPIDs.add(session.stub.getServerInterfacePointer().getIPID());
            }
            listOfFreeIPIDs.clear();
            if (list.size() > 0) {
                JIArray array = new JIArray(list.toArray(new JIStruct[list.size()]), true);
                try {
                    session.stub.closeStub();
                    session.releaseRefs(array, true);
                }
                catch (JIException e) {
                    JISystem.getLogger().throwing("JISession", "destroySession", e);
                }
            }
            JIComOxidRuntime.clearIPIDsforSession(session);
            if (JISystem.getLogger().isLoggable(Level.INFO)) {
                JISystem.getLogger().log(Level.INFO, "Destroyed Session: {0}", session.sessionIdentifier);
            }
        }
        finally {
            Object object = mutex;
            synchronized (object) {
                mapOfSessionIdsVsSessions.remove(new Integer(session.getSessionIdentifier()));
                listOfSessions.remove(session);
                if (session.stub.getServerInterfacePointer() != null) {
                    mapOfOxidsVsJISessions.remove(new JIOxid(session.stub.getServerInterfacePointer().getOXID()));
                }
            }
            session.stub.closeStub();
            session.stub2.closeStub();
        }
        JISession.postDestroy(session);
        session.stub = null;
        session.stub2 = null;
    }

    private static void postDestroy(JISession session) throws JIException {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "About to destroy links for Session: {0} , size of which is {1}", new Object[]{session.getSessionIdentifier(), session.links.size()});
        }
        for (int i = 0; i < session.links.size(); ++i) {
            JISession.destroySession((JISession)session.links.get(i));
        }
        session.links.clear();
        JIComOxidRuntime.destroySessionOIDs(session.getSessionIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStub(JIComServer stub) {
        this.stub = stub;
        Object object = mutex;
        synchronized (object) {
            mapOfOxidsVsJISessions.put(new JIOxid(stub.getServerInterfacePointer().getOXID()), this);
        }
    }

    void setStub2(JIRemUnknownServer stub) {
        this.stub2 = stub;
    }

    JIComServer getStub() {
        return this.stub;
    }

    JIRemUnknownServer getStub2() {
        return this.stub2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToSession(IJIComObject comObject, byte[] oid) {
        if (this.sessionInDestroy) {
            return;
        }
        IPID_SessionID_Holder holder = new IPID_SessionID_Holder(comObject.getIpid(), this.getSessionIdentifier(), false, oid);
        Map map = mapOfObjects;
        synchronized (map) {
            mapOfObjects.put(new WeakReference<IJIComObject>(comObject, referenceQueueOfCOMObjects), holder);
        }
        this.addToSession(comObject.getIpid(), oid, ((JIStdObjRef)comObject.internal_getInterfacePointer().getObjectReference(1)).getFlags() == 4096);
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, " for IID: {0}", comObject.getInterfaceIdentifier());
        }
    }

    static void debug_addIpids(String ipid, int num) {
    }

    static void debug_delIpids(String ipid, int num) {
    }

    private void addToSession(String IPID, byte[] oid, boolean dontping) {
        JIObjectId joid = new JIObjectId(oid, dontping);
        JIComOxidRuntime.addUpdateOXIDs(this, IPID, joid);
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "[addToSession] Adding IPID: {0} to session: {1}", new Object[]{IPID, this.getSessionIdentifier()});
        }
    }

    void releaseRef(String IPID) throws JIException {
        this.releaseRef(IPID, 5);
    }

    void releaseRef(String IPID, int numinstances) throws JIException {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "releaseRef:Reclaiming from Session: {0} , the IPID: {1}, numinstances is {2}", new Object[]{this.getSessionIdentifier(), IPID, numinstances});
        }
        JICallBuilder obj = new JICallBuilder(true);
        obj.setParentIpid(IPID);
        obj.setOpnum(2);
        obj.addInParamAsShort((short)1, 0);
        JIArray array = new JIArray(new UUID[]{new UUID(IPID)}, true);
        obj.addInParamAsArray(array, 0);
        obj.addInParamAsInt(numinstances, 0);
        obj.addInParamAsInt(0, 0);
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.WARNING, "releaseRef: Releasing numinstances {0} references of IPID: {1} session: {2}", new Object[]{numinstances, IPID, this.getSessionIdentifier()});
            JISession.debug_delIpids(IPID, numinstances);
        }
        this.stub2.addRef_ReleaseRef(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDereferencedIpids(String IPID, byte[] oid) {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "addDereferencedIpids for session : {0} , IPID is: {1}", new Object[]{this.getSessionIdentifier(), IPID});
        }
        Object object = mutex;
        synchronized (object) {
            if (!this.listOfDeferencedIpids.contains(IPID)) {
                this.listOfDeferencedIpids.add(IPID);
            }
        }
        JIComOxidRuntime.delIPIDReference(IPID, new JIObjectId(oid, false), this);
    }

    private void releaseRefs(JIArray arrayOfStructs, boolean fromDestroy) throws JIException {
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "In releaseRefs for session : {0} , array length is: {1}", new Object[]{this.getSessionIdentifier(), (short)((Object[])arrayOfStructs.getArrayInstance()).length});
        }
        JICallBuilder obj = new JICallBuilder(true);
        obj.setOpnum(2);
        obj.addInParamAsShort((short)((Object[])arrayOfStructs.getArrayInstance()).length, 0);
        obj.addInParamAsArray(arrayOfStructs, 0);
        obj.fromDestroySession = fromDestroy;
        this.stub2.addRef_ReleaseRef(obj);
    }

    private JIStruct prepareForReleaseRef(String IPID, int numInstancesfirsttime) throws JIException {
        JIStruct remInterface = new JIStruct();
        remInterface.addMember(new UUID(IPID));
        remInterface.addMember(new Integer(numInstancesfirsttime + 5));
        remInterface.addMember(new Integer(0));
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().log(Level.INFO, "prepareForReleaseRef: Releasing numInstancesfirsttime + 5 references of IPID: {0} session: {1} , numInstancesfirsttime is {2}", new Object[]{IPID, this.getSessionIdentifier(), numInstancesfirsttime});
        }
        JISession.debug_delIpids(IPID, numInstancesfirsttime + 5);
        return remInterface;
    }

    private JIStruct prepareForReleaseRef(String IPID) throws JIException {
        return this.prepareForReleaseRef(IPID, 5);
    }

    public String getUserName() {
        return this.authInfo == null ? this.username : this.authInfo.getUserName();
    }

    String getPassword() {
        return this.authInfo == null ? this.password : this.authInfo.getPassword();
    }

    public String getDomain() {
        return this.authInfo == null ? this.domain : this.authInfo.getDomain();
    }

    public int getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JISession)) {
            return false;
        }
        JISession temp = (JISession)obj;
        return temp.sessionIdentifier == this.sessionIdentifier;
    }

    public int hashCode() {
        return this.sessionIdentifier;
    }

    protected void finalize() throws Throwable {
        try {
            JISession.destroySession(this);
        }
        catch (JIException e) {
            if (JISystem.getLogger().isLoggable(Level.FINEST)) {
                JISystem.getLogger().log(Level.FINEST, "Exception in finalize when destroying session {0}", e.getMessage());
            }
        }
        finally {
            super.finalize();
        }
    }

    synchronized IJIUnreferenced getUnreferencedHandler(String ipid) {
        return (IJIUnreferenced)this.mapOfUnreferencedHandlers.get(ipid);
    }

    synchronized void registerUnreferencedHandler(String ipid, IJIUnreferenced unreferenced) {
        this.mapOfUnreferencedHandlers.put(ipid, unreferenced);
    }

    synchronized void unregisterUnreferencedHandler(String ipid) {
        this.mapOfUnreferencedHandlers.remove(ipid);
    }

    public void setGlobalSocketTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getGlobalSocketTimeout() {
        return this.timeout;
    }

    public void useSessionSecurity(boolean enable) {
        this.useSessionSecurity = enable;
    }

    public void useNTLMv2(boolean enable) {
        this.useNTLMv2 = enable;
    }

    public boolean isSessionSecurityEnabled() {
        return !this.isSSO & this.useSessionSecurity;
    }

    public boolean isNTLMv2Enabled() {
        return !this.isSSO & this.useNTLMv2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void linkTwoSessions(JISession src, JISession target) {
        if (src.sessionInDestroy || target.sessionInDestroy) {
            return;
        }
        if (src.equals(target)) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            if (!src.links.contains(target)) {
                src.links.add(target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unLinkSession(JISession src, JISession tobeunlinked) {
        if (src.sessionInDestroy) {
            return;
        }
        if (src.equals(tobeunlinked)) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            src.links.remove(tobeunlinked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JISession resolveSessionForOxid(JIOxid oxid) {
        Object object = mutex;
        synchronized (object) {
            return (JISession)mapOfOxidsVsJISessions.get(oxid);
        }
    }

    boolean isSessionInDestroy() {
        return this.sessionInDestroy;
    }

    static {
        JISystem.internal_initLogger();
        try {
            InetAddress localhostAddr = InetAddress.getLocalHost();
            localhost = localhostAddr.getAddress();
            localhostStr = localhostAddr.getHostAddress();
            localhostStr2 = localhostAddr.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        System.setProperty("jcifs.smb.client.domain", "JIDomain");
        cleanUpThread.setDaemon(true);
        cleanUpThread.start();
        JIComOxidRuntime.startResolver();
        JIComOxidRuntime.startResolverTimer();
        oxidResolverPort = JIComOxidRuntime.getOxidResolverPort();
        releaseRefsTimer.scheduleAtFixedRate((TimerTask)new Release_References_TimerTask(), 0L, 180000L);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < listOfSessions.size(); ++i) {
                    JISession session = (JISession)listOfSessions.get(i);
                    try {
                        JISession.destroySession(session);
                        continue;
                    }
                    catch (JIException e) {
                        JISystem.getLogger().throwing("JISession", "addShutDownHook Thread:run()", e);
                    }
                }
                JISystem.internal_writeProgIdsToFile();
                JIComOxidRuntime.stopResolver();
                releaseRefsTimer.cancel();
                mapOfSessionIdsVsSessions.clear();
                mapOfObjects.clear();
                listOfSessions.clear();
            }
        }, "jI_ShutdownHook"));
        mapOfIPIDSvsCount = Collections.synchronizedMap(new HashMap());
    }

    private static class IPID_SessionID_Holder {
        public final String IPID;
        public final Integer sessionID;
        public final boolean isOnlySessionIDPresent;
        public final byte[] oid;

        private IPID_SessionID_Holder(String IPID, int sessionID, boolean isOnlySessionId, byte[] oid) {
            this.IPID = IPID;
            this.isOnlySessionIDPresent = isOnlySessionId;
            this.sessionID = new Integer(sessionID);
            this.oid = oid;
        }
    }

    private static class Release_References_TimerTask
    extends TimerTask {
        private Release_References_TimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                List listOfSessionsClone = null;
                Object object = mutex;
                synchronized (object) {
                    listOfSessionsClone = (List)listOfSessions.clone();
                }
                for (int i = 0; i < listOfSessionsClone.size(); ++i) {
                    JISession session = (JISession)listOfSessionsClone.get(i);
                    ArrayList<JIStruct> listToKill = new ArrayList<JIStruct>();
                    Object object2 = mutex;
                    synchronized (object2) {
                        if (JISystem.getLogger().isLoggable(Level.INFO)) {
                            JISystem.getLogger().log(Level.INFO, "Release_References_TimerTask:[RUN] Session:  {0} , listOfDeferencedIpids.size(): {1}", new Object[]{session.getSessionIdentifier(), session.listOfDeferencedIpids.size()});
                        }
                        for (int j = 0; j < session.listOfDeferencedIpids.size(); ++j) {
                            try {
                                listToKill.add(session.prepareForReleaseRef((String)session.listOfDeferencedIpids.get(j)));
                                continue;
                            }
                            catch (JIException jIException) {
                                // empty catch block
                            }
                        }
                        session.listOfDeferencedIpids.clear();
                    }
                    if (listToKill.size() <= 0) continue;
                    JIArray array = new JIArray(listToKill.toArray(new JIStruct[listToKill.size()]), true);
                    try {
                        session.releaseRefs(array, false);
                        continue;
                    }
                    catch (JIException e) {
                        JISystem.getLogger().logp(Level.SEVERE, "JISession", "Release_References_TimerTask:run()", "Exception in internal GC", e);
                    }
                }
            }
            catch (Exception e) {
                JISystem.getLogger().logp(Level.SEVERE, "JISession", "Release_References_TimerTask:run()", "Exception in internal GC", e);
            }
        }
    }
}

