/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.progressview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import com.skydoves.progressview.AnimatorExtensionKt;
import com.skydoves.progressview.HighlightView;
import com.skydoves.progressview.OnProgressChangeListener;
import com.skydoves.progressview.OnProgressClickListener;
import com.skydoves.progressview.ProgressLabelConstraints;
import com.skydoves.progressview.ProgressView;
import com.skydoves.progressview.ProgressView$progressAnimate$;
import com.skydoves.progressview.ProgressViewAnimation;
import com.skydoves.progressview.ProgressViewDSL;
import com.skydoves.progressview.ProgressViewOrientation;
import com.skydoves.progressview.R;
import com.skydoves.progressview.TextForm;
import com.skydoves.progressview.TextViewExtensionKt;
import com.skydoves.progressview.ViewExtensionKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u00b5\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0085\u0001\u001a\u00030\u0086\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001J\t\u0010\u000b\u001a\u00030\u0086\u0001H\u0002J\u0014\u0010\u0089\u0001\u001a\u00030\u0086\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0014J\u001b\u0010\u008c\u0001\u001a\u00030\u0086\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0007\u0010\u008d\u0001\u001a\u00020\tH\u0002J\u0014\u0010\u008e\u0001\u001a\u00020A2\t\b\u0002\u0010\u008f\u0001\u001a\u00020AH\u0002J\u0014\u0010\u0090\u0001\u001a\u00020A2\t\b\u0001\u0010\u0091\u0001\u001a\u00020AH\u0002J\u0014\u0010\u0092\u0001\u001a\u00020A2\t\b\u0001\u0010\u0091\u0001\u001a\u00020AH\u0002J\u0014\u0010\u0093\u0001\u001a\u00020A2\t\b\u0002\u0010\u008f\u0001\u001a\u00020AH\u0002J\u0013\u0010\u0094\u0001\u001a\u00020\t2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0002J\u0007\u0010\u0097\u0001\u001a\u00020\fJ\u0007\u0010\u0098\u0001\u001a\u00020\fJ\n\u0010\u0099\u0001\u001a\u00030\u0086\u0001H\u0014J7\u0010\u009a\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u009b\u0001\u001a\u00020\f2\u0007\u0010\u009c\u0001\u001a\u00020\t2\u0007\u0010\u009d\u0001\u001a\u00020\t2\u0007\u0010\u009e\u0001\u001a\u00020\t2\u0007\u0010\u009f\u0001\u001a\u00020\tH\u0014J.\u0010\u00a0\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u00a1\u0001\u001a\u00020\t2\u0007\u0010\u00a2\u0001\u001a\u00020\t2\u0007\u0010\u00a3\u0001\u001a\u00020\t2\u0007\u0010\u00a4\u0001\u001a\u00020\tH\u0014J\b\u0010\u00a5\u0001\u001a\u00030\u0086\u0001J'\u0010\u00a6\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u00a7\u0001\u001a\u00020A2\u0011\b\u0006\u0010\u00a8\u0001\u001a\n\u0012\u0005\u0012\u00030\u0086\u00010\u00a9\u0001H\u0082\bJ\u001f\u0010\u00aa\u0001\u001a\u00030\u0086\u00012\u0015\u0010\u00ab\u0001\u001a\u0010\u0012\u0004\u0012\u00020A\u0012\u0005\u0012\u00030\u0086\u00010\u00ac\u0001J\u0010\u0010\u00aa\u0001\u001a\u00030\u0086\u00012\u0006\u0010c\u001a\u00020dJ\u001f\u0010\u00ad\u0001\u001a\u00030\u0086\u00012\u0015\u0010\u00ab\u0001\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0005\u0012\u00030\u0086\u00010\u00ac\u0001J\u0010\u0010\u00ad\u0001\u001a\u00030\u0086\u00012\u0006\u0010e\u001a\u00020fJ\u0014\u0010\u00ae\u0001\u001a\u00030\u0086\u00012\b\u0010\u00af\u0001\u001a\u00030\u00b0\u0001H\u0002J\n\u0010\u00b1\u0001\u001a\u00030\u0086\u0001H\u0002J\n\u0010\u00b2\u0001\u001a\u00030\u0086\u0001H\u0002J\n\u0010\u00b3\u0001\u001a\u00030\u0086\u0001H\u0002J\n\u0010\u00b4\u0001\u001a\u00030\u0086\u0001H\u0002R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R&\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R&\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R&\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u000e\"\u0004\b.\u0010\u0010R&\u0010/\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0014\"\u0004\b1\u0010\u0016R&\u00102\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0014\"\u0004\b4\u0010\u0016R$\u00106\u001a\u0002052\u0006\u0010\u0011\u001a\u000205@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R*\u0010;\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\t@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010@\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R&\u0010B\u001a\u00020A2\u0006\u0010\u0011\u001a\u00020A8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR&\u0010G\u001a\u00020A2\u0006\u0010\u0011\u001a\u00020A8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010D\"\u0004\bI\u0010FR(\u0010K\u001a\u0004\u0018\u00010J2\b\u0010\u0011\u001a\u0004\u0018\u00010J@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR$\u0010P\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\u0014\"\u0004\bR\u0010\u0016R(\u0010T\u001a\u0004\u0018\u00010S2\b\u0010\u0011\u001a\u0004\u0018\u00010S@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u0011\u0010Y\u001a\u00020Z\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\R$\u0010]\u001a\u00020A2\u0006\u0010\u0011\u001a\u00020A@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010D\"\u0004\b_\u0010FR\u001a\u0010`\u001a\u00020AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010D\"\u0004\bb\u0010FR\u0010\u0010c\u001a\u0004\u0018\u00010dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010e\u001a\u0004\u0018\u00010fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010h\u001a\u00020g2\u0006\u0010\u0011\u001a\u00020g@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u000e\u0010m\u001a\u00020nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010o\u001a\u00020AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010p\u001a\u00020A2\u0006\u0010\u0011\u001a\u00020A@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010D\"\u0004\br\u0010FR\u001a\u0010s\u001a\u00020tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bu\u0010v\"\u0004\bw\u0010xR$\u0010y\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010\u000e\"\u0004\b{\u0010\u0010R&\u0010|\u001a\u00020A2\u0006\u0010\u0011\u001a\u00020A8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b}\u0010D\"\u0004\b~\u0010FR-\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u007f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u007f@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001\"\u0006\b\u0083\u0001\u0010\u0084\u0001\u00a8\u0006\u00b6\u0001"}, d2={"Lcom/skydoves/progressview/ProgressView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "autoAnimate", "", "getAutoAnimate", "()Z", "setAutoAnimate", "(Z)V", "value", "borderColor", "getBorderColor", "()I", "setBorderColor", "(I)V", "borderWidth", "getBorderWidth", "setBorderWidth", "colorBackground", "getColorBackground", "setColorBackground", "duration", "", "getDuration", "()J", "setDuration", "(J)V", "highlightView", "Lcom/skydoves/progressview/HighlightView;", "getHighlightView", "()Lcom/skydoves/progressview/HighlightView;", "interpolator", "Landroid/view/animation/Interpolator;", "getInterpolator", "()Landroid/view/animation/Interpolator;", "setInterpolator", "(Landroid/view/animation/Interpolator;)V", "isAnimating", "setAnimating", "labelColorInner", "getLabelColorInner", "setLabelColorInner", "labelColorOuter", "getLabelColorOuter", "setLabelColorOuter", "Lcom/skydoves/progressview/ProgressLabelConstraints;", "labelConstraints", "getLabelConstraints", "()Lcom/skydoves/progressview/ProgressLabelConstraints;", "setLabelConstraints", "(Lcom/skydoves/progressview/ProgressLabelConstraints;)V", "labelGravity", "getLabelGravity", "()Ljava/lang/Integer;", "setLabelGravity", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "", "labelSize", "getLabelSize", "()F", "setLabelSize", "(F)V", "labelSpace", "getLabelSpace", "setLabelSpace", "", "labelText", "getLabelText", "()Ljava/lang/CharSequence;", "setLabelText", "(Ljava/lang/CharSequence;)V", "labelTypeface", "getLabelTypeface", "setLabelTypeface", "Landroid/graphics/Typeface;", "labelTypefaceObject", "getLabelTypefaceObject", "()Landroid/graphics/Typeface;", "setLabelTypefaceObject", "(Landroid/graphics/Typeface;)V", "labelView", "Landroid/widget/TextView;", "getLabelView", "()Landroid/widget/TextView;", "max", "getMax", "setMax", "min", "getMin", "setMin", "onProgressChangeListener", "Lcom/skydoves/progressview/OnProgressChangeListener;", "onProgressClickListener", "Lcom/skydoves/progressview/OnProgressClickListener;", "Lcom/skydoves/progressview/ProgressViewOrientation;", "orientation", "getOrientation", "()Lcom/skydoves/progressview/ProgressViewOrientation;", "setOrientation", "(Lcom/skydoves/progressview/ProgressViewOrientation;)V", "path", "Landroid/graphics/Path;", "previousProgress", "progress", "getProgress", "setProgress", "progressAnimation", "Lcom/skydoves/progressview/ProgressViewAnimation;", "getProgressAnimation", "()Lcom/skydoves/progressview/ProgressViewAnimation;", "setProgressAnimation", "(Lcom/skydoves/progressview/ProgressViewAnimation;)V", "progressFromPrevious", "getProgressFromPrevious", "setProgressFromPrevious", "radius", "getRadius", "setRadius", "", "radiusArray", "getRadiusArray", "()[F", "setRadiusArray", "([F)V", "applyTextForm", "", "textForm", "Lcom/skydoves/progressview/TextForm;", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "getAttrs", "defStyleAttr", "getLabelPosition", "progressValue", "getPreviousMergedLabelPosition", "progressRange", "getPreviousMergedProgressSize", "getProgressSize", "getViewSize", "view", "Landroid/view/View;", "isProgressedMax", "isVertical", "onFinishInflate", "onLayout", "changed", "left", "top", "right", "bottom", "onSizeChanged", "w", "h", "oldw", "oldh", "progressAnimate", "setLabelViewPosition", "position", "action", "Lkotlin/Function0;", "setOnProgressChangeListener", "block", "Lkotlin/Function1;", "setOnProgressClickListener", "setTypeArray", "a", "Landroid/content/res/TypedArray;", "updateBackground", "updateHighlightView", "updateLabel", "updateProgressView", "Builder", "progressview_release"})
public final class ProgressView
extends FrameLayout {
    @NotNull
    private final TextView labelView;
    @NotNull
    private final HighlightView highlightView;
    private long duration;
    private boolean isAnimating;
    private boolean autoAnimate;
    private float min;
    private float max;
    private float previousProgress;
    private boolean progressFromPrevious;
    private float progress;
    @NotNull
    private ProgressViewAnimation progressAnimation;
    @Nullable
    private Interpolator interpolator;
    @NotNull
    private ProgressViewOrientation orientation;
    @ColorInt
    private int colorBackground;
    @Px
    private float radius;
    @Nullable
    private float[] radiusArray;
    @ColorInt
    private int borderColor;
    @Px
    private int borderWidth;
    @Nullable
    private CharSequence labelText;
    @Px
    private float labelSize;
    @ColorInt
    private int labelColorInner;
    @ColorInt
    private int labelColorOuter;
    private int labelTypeface;
    @Nullable
    private Typeface labelTypefaceObject;
    @NotNull
    private ProgressLabelConstraints labelConstraints;
    @Nullable
    private Integer labelGravity;
    @Px
    private float labelSpace;
    private OnProgressChangeListener onProgressChangeListener;
    private OnProgressClickListener onProgressClickListener;
    private final Path path;

    @NotNull
    public final TextView getLabelView() {
        return this.labelView;
    }

    @NotNull
    public final HighlightView getHighlightView() {
        return this.highlightView;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final void setDuration(long l) {
        this.duration = l;
    }

    public final boolean isAnimating() {
        return this.isAnimating;
    }

    public final void setAnimating(boolean bl) {
        this.isAnimating = bl;
    }

    public final boolean getAutoAnimate() {
        return this.autoAnimate;
    }

    public final void setAutoAnimate(boolean bl) {
        this.autoAnimate = bl;
    }

    public final float getMin() {
        return this.min;
    }

    public final void setMin(float f) {
        this.min = f;
    }

    public final float getMax() {
        return this.max;
    }

    public final void setMax(float value) {
        this.max = value;
        this.updateProgressView();
    }

    public final boolean getProgressFromPrevious() {
        return this.progressFromPrevious;
    }

    public final void setProgressFromPrevious(boolean value) {
        this.progressFromPrevious = value;
        this.previousProgress = 0.0f;
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float value) {
        block1: {
            if (this.progressFromPrevious) {
                this.previousProgress = this.progress;
            }
            this.progress = value >= this.max ? this.max : (value <= this.min ? this.min : value);
            this.updateProgressView();
            OnProgressChangeListener onProgressChangeListener = this.onProgressChangeListener;
            if (onProgressChangeListener == null) break block1;
            onProgressChangeListener.onChange(this.progress);
        }
    }

    @NotNull
    public final ProgressViewAnimation getProgressAnimation() {
        return this.progressAnimation;
    }

    public final void setProgressAnimation(@NotNull ProgressViewAnimation progressViewAnimation) {
        Intrinsics.checkNotNullParameter((Object)((Object)progressViewAnimation), (String)"<set-?>");
        this.progressAnimation = progressViewAnimation;
    }

    @Nullable
    public final Interpolator getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(@Nullable Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @NotNull
    public final ProgressViewOrientation getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(@NotNull ProgressViewOrientation value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.orientation = value;
        this.highlightView.setOrientation(value);
        this.updateProgressView();
    }

    public final int getColorBackground() {
        return this.colorBackground;
    }

    public final void setColorBackground(int value) {
        this.colorBackground = value;
        this.updateBackground();
    }

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float value) {
        this.radius = value;
        this.highlightView.setRadius(value);
        this.updateBackground();
    }

    @Nullable
    public final float[] getRadiusArray() {
        return this.radiusArray;
    }

    public final void setRadiusArray(@Nullable float[] value) {
        this.radiusArray = value;
        this.highlightView.setRadiusArray(value);
        this.updateBackground();
    }

    public final int getBorderColor() {
        return this.borderColor;
    }

    public final void setBorderColor(int value) {
        this.borderColor = value;
        this.updateBackground();
    }

    public final int getBorderWidth() {
        return this.borderWidth;
    }

    public final void setBorderWidth(int value) {
        this.borderWidth = value;
        this.updateBackground();
    }

    @Nullable
    public final CharSequence getLabelText() {
        return this.labelText;
    }

    public final void setLabelText(@Nullable CharSequence value) {
        this.labelText = value;
        this.updateProgressView();
    }

    public final float getLabelSize() {
        return this.labelSize;
    }

    public final void setLabelSize(float value) {
        this.labelSize = value;
        this.updateProgressView();
    }

    public final int getLabelColorInner() {
        return this.labelColorInner;
    }

    public final void setLabelColorInner(int value) {
        this.labelColorInner = value;
        this.updateProgressView();
    }

    public final int getLabelColorOuter() {
        return this.labelColorOuter;
    }

    public final void setLabelColorOuter(int value) {
        this.labelColorOuter = value;
        this.updateProgressView();
    }

    public final int getLabelTypeface() {
        return this.labelTypeface;
    }

    public final void setLabelTypeface(int value) {
        this.labelTypeface = value;
        this.updateProgressView();
    }

    @Nullable
    public final Typeface getLabelTypefaceObject() {
        return this.labelTypefaceObject;
    }

    public final void setLabelTypefaceObject(@Nullable Typeface value) {
        this.labelTypefaceObject = value;
        this.updateProgressView();
    }

    @NotNull
    public final ProgressLabelConstraints getLabelConstraints() {
        return this.labelConstraints;
    }

    public final void setLabelConstraints(@NotNull ProgressLabelConstraints value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.labelConstraints = value;
        this.updateProgressView();
    }

    @Nullable
    public final Integer getLabelGravity() {
        return this.labelGravity;
    }

    public final void setLabelGravity(@Nullable Integer value) {
        this.labelGravity = value;
        this.updateProgressView();
    }

    public final float getLabelSpace() {
        return this.labelSpace;
    }

    public final void setLabelSpace(float value) {
        this.labelSpace = value;
        this.updateProgressView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getAttrs(AttributeSet attributeSet, int defStyleAttr) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ProgressView, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026essView, defStyleAttr, 0)");
        TypedArray typedArray2 = typedArray;
        try {
            this.setTypeArray(typedArray2);
        }
        finally {
            typedArray2.recycle();
        }
    }

    private final void setTypeArray(TypedArray a) {
        ProgressLabelConstraints progressLabelConstraints;
        int n;
        this.setLabelText(a.getString(R.styleable.ProgressView_progressView_labelText));
        this.setLabelSize(ViewExtensionKt.px2Sp((View)this, a.getDimension(R.styleable.ProgressView_progressView_labelSize, this.labelSize)));
        this.setLabelSpace(a.getDimension(R.styleable.ProgressView_progressView_labelSpace, this.labelSpace));
        this.setLabelColorInner(a.getColor(R.styleable.ProgressView_progressView_labelColorInner, this.labelColorInner));
        this.setLabelColorOuter(a.getColor(R.styleable.ProgressView_progressView_labelColorOuter, this.labelColorOuter));
        switch (a.getInt(R.styleable.ProgressView_progressView_labelTypeface, 0)) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.setLabelTypeface(n);
        switch (a.getInt(R.styleable.ProgressView_progressView_labelConstraints, ProgressLabelConstraints.ALIGN_PROGRESS.ordinal())) {
            case 1: {
                progressLabelConstraints = ProgressLabelConstraints.ALIGN_CONTAINER;
                break;
            }
            default: {
                progressLabelConstraints = ProgressLabelConstraints.ALIGN_PROGRESS;
            }
        }
        this.setLabelConstraints(progressLabelConstraints);
        switch (a.getInt(R.styleable.ProgressView_progressView_orientation, ProgressViewOrientation.HORIZONTAL.getValue())) {
            case 0: {
                this.setOrientation(ProgressViewOrientation.HORIZONTAL);
                break;
            }
            case 1: {
                this.setOrientation(ProgressViewOrientation.VERTICAL);
                break;
            }
        }
        int n2 = a.getInt(R.styleable.ProgressView_progressView_animation, this.progressAnimation.getValue());
        if (n2 == ProgressViewAnimation.NORMAL.getValue()) {
            this.progressAnimation = ProgressViewAnimation.NORMAL;
        } else if (n2 == ProgressViewAnimation.BOUNCE.getValue()) {
            this.progressAnimation = ProgressViewAnimation.BOUNCE;
        } else if (n2 == ProgressViewAnimation.DECELERATE.getValue()) {
            this.progressAnimation = ProgressViewAnimation.DECELERATE;
        } else if (n2 == ProgressViewAnimation.ACCELERATEDECELERATE.getValue()) {
            this.progressAnimation = ProgressViewAnimation.ACCELERATEDECELERATE;
        }
        this.min = a.getFloat(R.styleable.ProgressView_progressView_min, this.min);
        this.setMax(a.getFloat(R.styleable.ProgressView_progressView_max, this.max));
        this.setProgress(a.getFloat(R.styleable.ProgressView_progressView_progress, this.progress));
        this.setRadius(a.getDimension(R.styleable.ProgressView_progressView_radius, this.radius));
        this.duration = a.getInteger(R.styleable.ProgressView_progressView_duration, (int)this.duration);
        this.setColorBackground(a.getColor(R.styleable.ProgressView_progressView_colorBackground, this.colorBackground));
        this.setBorderColor(a.getColor(R.styleable.ProgressView_progressView_borderColor, this.borderColor));
        this.setBorderWidth(a.getDimensionPixelSize(R.styleable.ProgressView_progressView_borderWidth, this.borderWidth));
        this.autoAnimate = a.getBoolean(R.styleable.ProgressView_progressView_autoAnimate, this.autoAnimate);
        this.setProgressFromPrevious(a.getBoolean(R.styleable.ProgressView_progressView_progressFromPrevious, this.progressFromPrevious));
        HighlightView highlightView = this.highlightView;
        boolean bl = false;
        boolean bl2 = false;
        HighlightView $this$with = highlightView;
        boolean bl3 = false;
        $this$with.setAlpha(a.getFloat(R.styleable.ProgressView_progressView_highlightAlpha, $this$with.getHighlightAlpha()));
        $this$with.setColor(a.getColor(R.styleable.ProgressView_progressView_colorProgress, $this$with.getColor()));
        $this$with.setColorGradientStart(a.getColor(R.styleable.ProgressView_progressView_colorGradientStart, 65555));
        $this$with.setColorGradientEnd(a.getColor(R.styleable.ProgressView_progressView_colorGradientEnd, 65555));
        $this$with.setRadius(this.radius);
        $this$with.setRadiusArray(this.radiusArray);
        $this$with.setPadding((int)a.getDimension(R.styleable.ProgressView_progressView_padding, (float)this.borderWidth));
        $this$with.setHighlightColor(a.getColor(R.styleable.ProgressView_progressView_highlightColor, $this$with.getHighlightColor()));
        $this$with.setHighlightThickness((int)a.getDimension(R.styleable.ProgressView_progressView_highlightWidth, (float)$this$with.getHighlightThickness()));
        if (!a.getBoolean(R.styleable.ProgressView_progressView_highlighting, !$this$with.getHighlighting())) {
            $this$with.setHighlightThickness(0);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.updateProgressView();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed && this.orientation == ProgressViewOrientation.VERTICAL) {
            this.setRotation(180.0f);
            this.labelView.setRotation(180.0f);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Path path = this.path;
        boolean bl = false;
        boolean bl2 = false;
        Path $this$apply = path;
        boolean bl3 = false;
        $this$apply.reset();
        float[] fArray = this.radiusArray;
        if (this.radiusArray == null) {
            float[] fArray2 = new float[8];
            fArray2[0] = this.radius;
            fArray2[1] = this.radius;
            fArray2[2] = this.radius;
            fArray2[3] = this.radius;
            fArray2[4] = this.radius;
            fArray2[5] = this.radius;
            fArray2[6] = this.radius;
            fArray = fArray2;
            fArray2[7] = this.radius;
        }
        float[] radiusArray = fArray;
        $this$apply.addRoundRect(new RectF(0.0f, 0.0f, (float)w, (float)h), radiusArray, Path.Direction.CCW);
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.clipPath(this.path);
        super.dispatchDraw(canvas);
    }

    private final void updateProgressView() {
        this.post(new Runnable(this){
            final /* synthetic */ ProgressView this$0;

            public final void run() {
                ProgressView.access$updateHighlightView(this.this$0);
                ProgressView.access$updateLabel(this.this$0);
                ProgressView.access$autoAnimate(this.this$0);
            }
            {
                this.this$0 = progressView;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void updateBackground() {
        void $this$apply;
        GradientDrawable gradientDrawable = new GradientDrawable();
        boolean bl = false;
        boolean bl2 = false;
        GradientDrawable gradientDrawable2 = gradientDrawable;
        ProgressView progressView = this;
        boolean bl3 = false;
        if (this.radiusArray != null) {
            $this$apply.setCornerRadii(this.radiusArray);
        } else {
            $this$apply.setCornerRadius(this.radius);
        }
        $this$apply.setColor(this.colorBackground);
        $this$apply.setStroke(this.borderWidth, this.borderColor);
        Unit unit = Unit.INSTANCE;
        progressView.setBackground((Drawable)gradientDrawable);
    }

    private final void updateHighlightView() {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        if (this.max <= this.progress) {
            if (this.isVertical()) {
                params.height = this.getViewSize((View)this);
            } else {
                params.width = this.getViewSize((View)this);
            }
        } else if (this.isVertical()) {
            params.height = (int)ProgressView.getProgressSize$default(this, 0.0f, 1, null);
        } else {
            params.width = (int)ProgressView.getProgressSize$default(this, 0.0f, 1, null);
        }
        this.highlightView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.highlightView.updateHighlightView();
        this.removeView((View)this.highlightView);
        this.addView((View)this.highlightView);
    }

    private final void updateLabel() {
        boolean bl;
        if (this.labelGravity != null) {
            this.labelView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            Integer n = this.labelGravity;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            bl = false;
            if (n == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.labelView.setGravity(((Number)n).intValue());
        } else if (!this.isVertical()) {
            this.labelView.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
            this.labelView.setGravity(16);
        } else {
            this.labelView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            this.labelView.setGravity(81);
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Context context$iv = context;
        boolean $i$f$textForm = false;
        TextForm.Builder builder = new TextForm.Builder(context$iv);
        bl = false;
        boolean bl5 = false;
        TextForm.Builder builder2 = builder;
        ProgressView progressView = this;
        boolean bl6 = false;
        $this$textForm.text = this.getLabelText();
        $this$textForm.textSize = this.getLabelSize();
        $this$textForm.textTypeface = this.getLabelTypeface();
        $this$textForm.textTypefaceObject = this.getLabelTypefaceObject();
        Unit unit = Unit.INSTANCE;
        progressView.applyTextForm(builder.build());
        this.removeView((View)this.labelView);
        this.addView((View)this.labelView);
        this.post(new Runnable(this){
            final /* synthetic */ ProgressView this$0;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                if ((float)this.this$0.getLabelView().getWidth() + this.this$0.getLabelSpace() < ProgressView.getProgressSize$default(this.this$0, 0.0f, 1, null)) {
                    void this_$iv;
                    ProgressView progressView = this.this$0;
                    float position$iv = ProgressView.getProgressSize$default(this.this$0, 0.0f, 1, null) - (float)this.this$0.getLabelView().getWidth() - this.this$0.getLabelSpace();
                    boolean $i$f$setLabelViewPosition = false;
                    if (this_$iv.getLabelConstraints() == ProgressLabelConstraints.ALIGN_PROGRESS) {
                        boolean bl = false;
                        this.this$0.getLabelView().setTextColor(this.this$0.getLabelColorInner());
                        if (this_$iv.isVertical()) {
                            this_$iv.getLabelView().setY(position$iv);
                        } else {
                            this_$iv.getLabelView().setX(position$iv);
                        }
                    }
                } else {
                    ProgressView this_$iv = this.this$0;
                    float position$iv = ProgressView.getProgressSize$default(this.this$0, 0.0f, 1, null) + this.this$0.getLabelSpace();
                    boolean $i$f$setLabelViewPosition = false;
                    if (this_$iv.getLabelConstraints() == ProgressLabelConstraints.ALIGN_PROGRESS) {
                        boolean bl = false;
                        this.this$0.getLabelView().setTextColor(this.this$0.getLabelColorOuter());
                        if (this_$iv.isVertical()) {
                            this_$iv.getLabelView().setY(position$iv);
                        } else {
                            this_$iv.getLabelView().setX(position$iv);
                        }
                    }
                }
            }
            {
                this.this$0 = progressView;
            }
        });
    }

    private final void setLabelViewPosition(float position, Function0<Unit> action) {
        int $i$f$setLabelViewPosition = 0;
        if (this.getLabelConstraints() == ProgressLabelConstraints.ALIGN_PROGRESS) {
            action.invoke();
            if (this.isVertical()) {
                this.getLabelView().setY(position);
            } else {
                this.getLabelView().setX(position);
            }
        }
    }

    static /* synthetic */ void setLabelViewPosition$default(ProgressView this_, float position, Function0 action, int n, Object object) {
        if ((n & 2) != 0) {
            action = setLabelViewPosition.1.INSTANCE;
        }
        boolean $i$f$setLabelViewPosition = false;
        if (this_.getLabelConstraints() == ProgressLabelConstraints.ALIGN_PROGRESS) {
            action.invoke();
            if (this_.isVertical()) {
                this_.getLabelView().setY(position);
            } else {
                this_.getLabelView().setX(position);
            }
        }
    }

    private final float getProgressSize(float progressValue) {
        return (float)this.getViewSize((View)this) / this.max * progressValue;
    }

    static /* synthetic */ float getProgressSize$default(ProgressView progressView, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = progressView.progress;
        }
        return progressView.getProgressSize(f);
    }

    private final float getPreviousMergedProgressSize(@FloatRange(from=0.0, to=1.0) float progressRange) {
        return this.getProgressSize(this.previousProgress) + ProgressView.getProgressSize$default(this, 0.0f, 1, null) * progressRange <= ProgressView.getProgressSize$default(this, 0.0f, 1, null) ? this.getProgressSize(this.previousProgress) + ProgressView.getProgressSize$default(this, 0.0f, 1, null) * progressRange : ProgressView.getProgressSize$default(this, 0.0f, 1, null);
    }

    private final float getLabelPosition(float progressValue) {
        return (float)this.labelView.getWidth() + this.labelSpace < this.getProgressSize(progressValue) ? this.getProgressSize(progressValue) - (float)this.labelView.getWidth() - this.labelSpace : this.getProgressSize(progressValue) + this.labelSpace;
    }

    static /* synthetic */ float getLabelPosition$default(ProgressView progressView, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = progressView.progress;
        }
        return progressView.getLabelPosition(f);
    }

    private final float getPreviousMergedLabelPosition(@FloatRange(from=0.0, to=1.0) float progressRange) {
        return this.getLabelPosition(this.previousProgress) + ProgressView.getLabelPosition$default(this, 0.0f, 1, null) * progressRange <= ProgressView.getLabelPosition$default(this, 0.0f, 1, null) ? this.getLabelPosition(this.previousProgress) + ProgressView.getLabelPosition$default(this, 0.0f, 1, null) * progressRange : ProgressView.getLabelPosition$default(this, 0.0f, 1, null);
    }

    private final void autoAnimate() {
        if (this.autoAnimate) {
            this.progressAnimate();
        }
    }

    private final int getViewSize(View view) {
        return this.isVertical() ? view.getHeight() : view.getWidth();
    }

    public final void progressAnimate() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        boolean bl = false;
        boolean bl2 = false;
        ValueAnimator $this$apply = valueAnimator;
        boolean bl3 = false;
        $this$apply.setInterpolator(this.interpolator != null ? (TimeInterpolator)this.interpolator : (TimeInterpolator)this.progressAnimation.getInterpolator());
        $this$apply.setDuration(this.duration);
        $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ ProgressView this$0;
            {
                this.this$0 = progressView;
            }

            /*
             * WARNING - void declaration
             */
            public final void onAnimationUpdate(ValueAnimator it) {
                void this_$iv;
                ValueAnimator valueAnimator = it;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"it");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                float value = ((Float)object).floatValue();
                ProgressView progressView = this.this$0;
                float position$iv = ProgressView.access$getPreviousMergedLabelPosition(this.this$0, value);
                boolean $i$f$setLabelViewPosition = false;
                if (this_$iv.getLabelConstraints() == ProgressLabelConstraints.ALIGN_PROGRESS) {
                    if (this_$iv.isVertical()) {
                        this_$iv.getLabelView().setY(position$iv);
                    } else {
                        this_$iv.getLabelView().setX(position$iv);
                    }
                }
                ViewExtensionKt.updateLayoutParams((ViewGroup)this.this$0.getHighlightView(), (Function1<? super ViewGroup.LayoutParams, Unit>)((Function1)new Function1<ViewGroup.LayoutParams, Unit>(this, value){
                    final /* synthetic */ progressAnimate$$inlined$apply$lambda$1 this$0;
                    final /* synthetic */ float $value;
                    {
                        this.this$0 = var1_1;
                        this.$value = f;
                        super(1);
                    }

                    public final void invoke(@NotNull ViewGroup.LayoutParams $this$updateLayoutParams) {
                        Intrinsics.checkNotNullParameter((Object)$this$updateLayoutParams, (String)"$receiver");
                        if (this.this$0.this$0.isVertical()) {
                            $this$updateLayoutParams.height = (int)ProgressView.access$getPreviousMergedProgressSize(this.this$0.this$0, this.$value);
                        } else {
                            $this$updateLayoutParams.width = (int)ProgressView.access$getPreviousMergedProgressSize(this.this$0.this$0, this.$value);
                        }
                    }
                }));
            }
        });
        AnimatorExtensionKt.doStartAndFinish((Animator)$this$apply, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ProgressView this$0;
            {
                this.this$0 = progressView;
                super(0);
            }

            public final void invoke() {
                this.this$0.setAnimating(true);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ProgressView this$0;
            {
                this.this$0 = progressView;
                super(0);
            }

            public final void invoke() {
                this.this$0.setAnimating(false);
            }
        }));
        bl = false;
        bl2 = false;
        ValueAnimator it = valueAnimator;
        boolean bl4 = false;
        it.start();
    }

    public final boolean isVertical() {
        return this.orientation == ProgressViewOrientation.VERTICAL;
    }

    public final boolean isProgressedMax() {
        return this.progress == this.max;
    }

    public final void setOnProgressChangeListener(@NotNull OnProgressChangeListener onProgressChangeListener) {
        Intrinsics.checkNotNullParameter((Object)onProgressChangeListener, (String)"onProgressChangeListener");
        this.onProgressChangeListener = onProgressChangeListener;
    }

    public final /* synthetic */ void setOnProgressChangeListener(Function1<? super Float, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.onProgressChangeListener = new OnProgressChangeListener(block){
            final /* synthetic */ Function1 $block;

            public final void onChange(float progress) {
                this.$block.invoke((Object)Float.valueOf(progress));
            }
            {
                this.$block = function1;
            }
        };
    }

    public final void setOnProgressClickListener(@NotNull OnProgressClickListener onProgressClickListener) {
        Intrinsics.checkNotNullParameter((Object)onProgressClickListener, (String)"onProgressClickListener");
        this.onProgressClickListener = onProgressClickListener;
        this.highlightView.setOnProgressClickListener(this.onProgressClickListener);
    }

    public final /* synthetic */ void setOnProgressClickListener(Function1<? super Boolean, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.onProgressClickListener = new OnProgressClickListener(block){
            final /* synthetic */ Function1 $block;

            public final void onClickProgress(boolean highlighting) {
                this.$block.invoke((Object)highlighting);
            }
            {
                this.$block = function1;
            }
        };
        this.highlightView.setOnProgressClickListener(this.onProgressClickListener);
    }

    public final void applyTextForm(@NotNull TextForm textForm) {
        Intrinsics.checkNotNullParameter((Object)textForm, (String)"textForm");
        TextViewExtensionKt.applyTextForm(this.labelView, textForm);
    }

    public ProgressView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.labelView = new TextView(this.getContext());
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.highlightView = new HighlightView(context2, null, 2, null);
        this.duration = 1000L;
        this.autoAnimate = true;
        this.max = 100.0f;
        this.progressAnimation = ProgressViewAnimation.NORMAL;
        this.orientation = ProgressViewOrientation.HORIZONTAL;
        this.colorBackground = -1;
        this.radius = ViewExtensionKt.dp2Px((View)this, 5);
        this.borderColor = this.colorBackground;
        this.labelText = "";
        this.labelSize = 12.0f;
        this.labelColorInner = -1;
        this.labelColorOuter = -16777216;
        this.labelConstraints = ProgressLabelConstraints.ALIGN_PROGRESS;
        this.labelSpace = ViewExtensionKt.dp2Px((View)this, 8);
        this.path = new Path();
    }

    public ProgressView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        this(context, attributeSet, 0);
    }

    public ProgressView(@NotNull Context context, @NotNull AttributeSet attributeSet, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet, defStyle);
        this.labelView = new TextView(this.getContext());
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.highlightView = new HighlightView(context2, null, 2, null);
        this.duration = 1000L;
        this.autoAnimate = true;
        this.max = 100.0f;
        this.progressAnimation = ProgressViewAnimation.NORMAL;
        this.orientation = ProgressViewOrientation.HORIZONTAL;
        this.colorBackground = -1;
        this.radius = ViewExtensionKt.dp2Px((View)this, 5);
        this.borderColor = this.colorBackground;
        this.labelText = "";
        this.labelSize = 12.0f;
        this.labelColorInner = -1;
        this.labelColorOuter = -16777216;
        this.labelConstraints = ProgressLabelConstraints.ALIGN_PROGRESS;
        this.labelSpace = ViewExtensionKt.dp2Px((View)this, 8);
        this.path = new Path();
        this.getAttrs(attributeSet, defStyle);
    }

    public static final /* synthetic */ OnProgressChangeListener access$getOnProgressChangeListener$p(ProgressView $this) {
        return $this.onProgressChangeListener;
    }

    public static final /* synthetic */ OnProgressClickListener access$getOnProgressClickListener$p(ProgressView $this) {
        return $this.onProgressClickListener;
    }

    public static final /* synthetic */ void access$updateHighlightView(ProgressView $this) {
        $this.updateHighlightView();
    }

    public static final /* synthetic */ void access$updateLabel(ProgressView $this) {
        $this.updateLabel();
    }

    public static final /* synthetic */ void access$autoAnimate(ProgressView $this) {
        $this.autoAnimate();
    }

    public static final /* synthetic */ void access$setLabelViewPosition(ProgressView $this, float position, Function0 action) {
        $this.setLabelViewPosition(position, (Function0<Unit>)action);
    }

    public static final /* synthetic */ float access$getPreviousMergedLabelPosition(ProgressView $this, float progressRange) {
        return $this.getPreviousMergedLabelPosition(progressRange);
    }

    public static final /* synthetic */ float access$getPreviousMergedProgressSize(ProgressView $this, float progressRange) {
        return $this.getPreviousMergedProgressSize(progressRange);
    }

    @ProgressViewDSL
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u0010\u0010\u0010\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u0010\u0010\u0011\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u0010\u0010\u0016\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\t\u001a\u00020!J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u001bJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u001bJ\u001a\u0010$\u001a\u00020\u00002\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020'0&J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020(J\u001a\u0010)\u001a\u00020\u00002\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0&J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020,J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u001bJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020/J\u0010\u00100\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\u001bJ\u0010\u00101\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u0010\u00102\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u0010\u00103\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\fJ\u000e\u00104\u001a\u00020\u00002\u0006\u0010\t\u001a\u000205J\u0010\u00106\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\u001bJ\u000e\u00107\u001a\u00020\u00002\u0006\u0010\t\u001a\u000205J\u0010\u00108\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\u001bJ\u001a\u00109\u001a\u00020\u00002\b\b\u0001\u0010:\u001a\u00020\f2\b\b\u0001\u0010;\u001a\u00020\fJ\u000e\u0010<\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020=R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/skydoves/progressview/ProgressView$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "progressView", "Lcom/skydoves/progressview/ProgressView;", "build", "setAutoAnimate", "value", "", "setColorBackground", "", "setDuration", "", "setHeight", "setHighlightColor", "setHighlightThickness", "setHighlighting", "setInterpolator", "Landroid/view/animation/Interpolator;", "setLabelColorInner", "setLabelColorOuter", "setLabelConstraints", "Lcom/skydoves/progressview/ProgressLabelConstraints;", "setLabelGravity", "setLabelSize", "", "setLabelSpace", "setLabelText", "", "setLabelTextResource", "setLabelTypeface", "Landroid/graphics/Typeface;", "setMax", "setMin", "setOnProgressChangeListener", "block", "Lkotlin/Function1;", "", "Lcom/skydoves/progressview/OnProgressChangeListener;", "setOnProgressClickListener", "Lcom/skydoves/progressview/OnProgressClickListener;", "setOrientation", "Lcom/skydoves/progressview/ProgressViewOrientation;", "setProgress", "setProgressViewAnimation", "Lcom/skydoves/progressview/ProgressViewAnimation;", "setProgressbarAlpha", "setProgressbarColor", "setProgressbarColorGradientEnd", "setProgressbarColorGradientStart", "setProgressbarRadii", "", "setProgressbarRadius", "setRadii", "setRadius", "setSize", "width", "height", "setTextForm", "Lcom/skydoves/progressview/TextForm;", "progressview_release"})
    public static final class Builder {
        private final ProgressView progressView;

        @NotNull
        public final Builder setSize(@Px int width, @Px int height) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(ViewExtensionKt.dp2Px((View)$this$apply.progressView, width), ViewExtensionKt.dp2Px((View)$this$apply.progressView, height)));
            return builder;
        }

        @NotNull
        public final Builder setHeight(@Px int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getLayoutParams().height = value;
            return builder;
        }

        @NotNull
        public final Builder setDuration(long value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setDuration(value);
            return builder;
        }

        @NotNull
        public final Builder setAutoAnimate(boolean value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setAutoAnimate(value);
            return builder;
        }

        @NotNull
        public final Builder setMin(float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setMin(value);
            return builder;
        }

        @NotNull
        public final Builder setMax(float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setMax(value);
            return builder;
        }

        @NotNull
        public final Builder setProgress(float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setProgress(value);
            return builder;
        }

        @NotNull
        public final Builder setOrientation(@NotNull ProgressViewOrientation value) {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setOrientation(value);
            return builder;
        }

        @NotNull
        public final Builder setColorBackground(@ColorInt int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setColorBackground(value);
            return builder;
        }

        @NotNull
        public final Builder setRadius(@Px float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setRadius(value);
            return builder;
        }

        @NotNull
        public final Builder setRadii(@NotNull float[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setRadiusArray(value);
            return builder;
        }

        @NotNull
        public final Builder setLabelText(@NotNull CharSequence value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLabelText(value);
            return builder;
        }

        @NotNull
        public final Builder setLabelTextResource(@StringRes int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            String string = $this$apply.progressView.getContext().getString(value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"progressView.context.getString(value)");
            $this$apply.setLabelText(string);
            return builder;
        }

        @NotNull
        public final Builder setLabelSize(float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLabelSize(ViewExtensionKt.sp2Px((View)$this$apply.progressView, value));
            return builder;
        }

        @NotNull
        public final Builder setLabelSpace(@Px float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLabelSpace(value);
            return builder;
        }

        @NotNull
        public final Builder setLabelColorInner(@ColorInt int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLabelColorInner(value);
            return builder;
        }

        @NotNull
        public final Builder setLabelColorOuter(@ColorInt int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLabelColorOuter(value);
            return builder;
        }

        @NotNull
        public final Builder setLabelTypeface(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLabelTypeface(value);
            return builder;
        }

        @NotNull
        public final Builder setLabelTypeface(@NotNull Typeface value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLabelTypefaceObject(value);
            return builder;
        }

        @NotNull
        public final Builder setLabelGravity(int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLabelGravity(value);
            return builder;
        }

        @NotNull
        public final Builder setLabelConstraints(@NotNull ProgressLabelConstraints value) {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setLabelConstraints(value);
            return builder;
        }

        @NotNull
        public final Builder setProgressbarAlpha(@FloatRange(from=0.0, to=1.0) float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getHighlightView().setAlpha(value);
            return builder;
        }

        @NotNull
        public final Builder setProgressbarColor(@ColorInt int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getHighlightView().setColor(value);
            return builder;
        }

        @NotNull
        public final Builder setProgressbarColorGradientStart(@ColorInt int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getHighlightView().setColorGradientStart(value);
            return builder;
        }

        @NotNull
        public final Builder setProgressbarColorGradientEnd(@ColorInt int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getHighlightView().setColorGradientEnd(value);
            return builder;
        }

        @NotNull
        public final Builder setProgressbarRadius(@Px float value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getHighlightView().setRadius(value);
            return builder;
        }

        @NotNull
        public final Builder setProgressbarRadii(@NotNull float[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getHighlightView().setRadiusArray(value);
            return builder;
        }

        @NotNull
        public final Builder setHighlightColor(@ColorInt int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getHighlightView().setHighlightColor(value);
            return builder;
        }

        @NotNull
        public final Builder setHighlighting(boolean value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getHighlightView().setHighlighting(value);
            return builder;
        }

        @NotNull
        public final Builder setHighlightThickness(@Px int value) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.getHighlightView().setHighlightThickness(value);
            return builder;
        }

        @NotNull
        public final Builder setOnProgressChangeListener(@NotNull OnProgressChangeListener value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.onProgressChangeListener = value;
            return builder;
        }

        @NotNull
        public final Builder setProgressViewAnimation(@NotNull ProgressViewAnimation value) {
            Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setProgressAnimation(value);
            return builder;
        }

        @NotNull
        public final Builder setInterpolator(@NotNull Interpolator value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.setInterpolator(value);
            return builder;
        }

        @NotNull
        public final Builder setOnProgressClickListener(@NotNull OnProgressClickListener value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.onProgressClickListener = value;
            return builder;
        }

        @NotNull
        public final Builder setTextForm(@NotNull TextForm value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            TextViewExtensionKt.applyTextForm($this$apply.progressView.getLabelView(), value);
            return builder;
        }

        public final /* synthetic */ Builder setOnProgressChangeListener(Function1<? super Float, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.onProgressChangeListener = new OnProgressChangeListener(block){
                final /* synthetic */ Function1 $block$inlined;
                {
                    this.$block$inlined = function1;
                }

                public final void onChange(float progress) {
                    this.$block$inlined.invoke((Object)Float.valueOf(progress));
                }
            };
            return builder;
        }

        public final /* synthetic */ Builder setOnProgressClickListener(Function1<? super Boolean, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.progressView.onProgressClickListener = new OnProgressClickListener(block){
                final /* synthetic */ Function1 $block$inlined;
                {
                    this.$block$inlined = function1;
                }

                public final void onClickProgress(boolean highlighting) {
                    this.$block$inlined.invoke((Object)highlighting);
                }
            };
            return builder;
        }

        @NotNull
        public final ProgressView build() {
            return this.progressView;
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.progressView = new ProgressView(context);
        }
    }
}

