/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.powermenu;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.core.widget.ImageViewCompat;
import com.skydoves.powermenu.ConvertUtil;
import com.skydoves.powermenu.IPowerMenuAdapter;
import com.skydoves.powermenu.MenuBaseAdapter;
import com.skydoves.powermenu.PowerMenuItem;
import com.skydoves.powermenu.R;
import com.skydoves.powermenu.ResourceUtil;
import com.skydoves.powermenu.annotations.Dp;
import com.skydoves.powermenu.annotations.Sp;
import com.skydoves.powermenu.databinding.ItemPowerMenuLibrarySkydovesBinding;

public class MenuListAdapter
extends MenuBaseAdapter<PowerMenuItem>
implements IPowerMenuAdapter {
    @ColorInt
    private int textColor = -2;
    @ColorInt
    private int menuColor = -2;
    @ColorInt
    private int selectedTextColor = -2;
    @ColorInt
    private int selectedMenuColor = -2;
    @ColorInt
    private int iconColor = -2;
    @Sp
    private int textSize = 12;
    @Dp
    private int iconSize = 35;
    @Dp
    private int iconPadding = 7;
    private int textGravity = 0x800003;
    private Typeface textTypeface = null;
    private boolean selectedEffect = true;

    public MenuListAdapter(ListView listView) {
        super(listView);
    }

    @Override
    public View getView(int index, View view, ViewGroup viewGroup) {
        Context context = viewGroup.getContext();
        if (view == null) {
            LayoutInflater inflater = LayoutInflater.from((Context)context);
            view = ItemPowerMenuLibrarySkydovesBinding.inflate(inflater, viewGroup, false).getRoot();
        }
        PowerMenuItem powerMenuItem = (PowerMenuItem)this.getItem(index);
        View background = view.findViewById(R.id.item_power_menu_layout);
        TextView title = (TextView)view.findViewById(R.id.item_power_menu_title);
        ImageView icon = (ImageView)view.findViewById(R.id.item_power_menu_icon);
        title.setText(powerMenuItem.title);
        title.setTextSize((float)this.textSize);
        title.setGravity(this.textGravity);
        if (this.textTypeface != null) {
            title.setTypeface(this.textTypeface);
        }
        if (powerMenuItem.iconRes != 0 || powerMenuItem.icon != null) {
            icon.getLayoutParams().width = ConvertUtil.convertDpToPixel(this.iconSize, context);
            icon.getLayoutParams().height = ConvertUtil.convertDpToPixel(this.iconSize, context);
            if (powerMenuItem.iconRes != 0) {
                icon.setImageResource(powerMenuItem.iconRes);
            } else if (powerMenuItem.icon != null) {
                icon.setImageDrawable(powerMenuItem.icon);
            }
            if (this.iconColor != -2) {
                ImageViewCompat.setImageTintList((ImageView)icon, (ColorStateList)ColorStateList.valueOf((int)this.iconColor));
            }
            if (icon.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams)icon.getLayoutParams()).rightMargin = ConvertUtil.convertDpToPixel(this.iconPadding, context);
            }
            icon.setVisibility(0);
        } else if (powerMenuItem.iconContentDescription != null) {
            icon.setContentDescription(powerMenuItem.iconContentDescription);
        } else {
            icon.setVisibility(8);
        }
        if (powerMenuItem.isSelected) {
            this.setSelectedPosition(index);
            if (this.selectedMenuColor == -2) {
                background.setBackgroundColor(-1);
            } else {
                background.setBackgroundColor(this.selectedMenuColor);
            }
            if (this.selectedTextColor == -2) {
                title.setTextColor(ResourceUtil.getAccentColor(context));
            } else {
                title.setTextColor(this.selectedTextColor);
            }
        } else {
            if (this.menuColor == -2) {
                background.setBackgroundColor(-1);
            } else {
                background.setBackgroundColor(this.menuColor);
            }
            if (this.textColor == -2) {
                title.setTextColor(-16777216);
            } else {
                title.setTextColor(this.textColor);
            }
        }
        return super.getView(index, view, viewGroup);
    }

    @Override
    public void setSelectedPosition(int position) {
        super.setSelectedPosition(position);
        if (this.selectedEffect) {
            for (int i = 0; i < this.getItemList().size(); ++i) {
                PowerMenuItem item = (PowerMenuItem)this.getItem(i);
                item.isSelected = i == position;
            }
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setTextColor(@ColorInt int color) {
        this.textColor = color;
    }

    @Override
    public void setMenuColor(@ColorInt int color) {
        this.menuColor = color;
    }

    @Override
    public void setSelectedTextColor(@ColorInt int color) {
        this.selectedTextColor = color;
    }

    @Override
    public void setSelectedMenuColor(@ColorInt int color) {
        this.selectedMenuColor = color;
    }

    @Override
    public void setSelectedEffect(boolean selectedEffect) {
        this.selectedEffect = selectedEffect;
    }

    @Override
    public void setTextSize(@Sp int size) {
        this.textSize = size;
    }

    @Override
    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    @Override
    public void setIconColor(int iconColor) {
        this.iconColor = iconColor;
    }

    @Override
    public void setIconPadding(int iconPadding) {
        this.iconPadding = iconPadding;
    }

    @Override
    public void setTextGravity(int gravity) {
        this.textGravity = gravity;
    }

    @Override
    public void setTextTypeface(Typeface typeface) {
        this.textTypeface = typeface;
    }
}

