/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.powermenu;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.ColorRes;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import com.skydoves.powermenu.AbstractMenuBuilder;
import com.skydoves.powermenu.AbstractPowerMenu;
import com.skydoves.powermenu.CircularEffect;
import com.skydoves.powermenu.MenuAnimation;
import com.skydoves.powermenu.MenuBaseAdapter;
import com.skydoves.powermenu.OnDismissedListener;
import com.skydoves.powermenu.OnMenuItemClickListener;
import com.skydoves.powermenu.databinding.LayoutMaterialPowerMenuLibrarySkydovesBinding;
import com.skydoves.powermenu.databinding.LayoutPowerMenuLibrarySkydovesBinding;
import java.util.ArrayList;
import java.util.List;

public class CustomPowerMenu<T, E extends MenuBaseAdapter<T>>
extends AbstractPowerMenu<T, E> {
    private LayoutPowerMenuLibrarySkydovesBinding binding;
    private LayoutMaterialPowerMenuLibrarySkydovesBinding materialBinding;

    protected CustomPowerMenu(@NonNull Context context, @NonNull AbstractMenuBuilder abstractMenuBuilder) {
        super(context, abstractMenuBuilder);
        Builder builder = (Builder)abstractMenuBuilder;
        if (builder.menuItemClickListener != null) {
            this.setOnMenuItemClickListener(builder.menuItemClickListener);
        }
        if (builder.selected != -1) {
            this.setSelectedPosition(builder.selected);
        }
        this.adapter = builder.adapter;
        this.adapter.setListView(this.getMenuListView());
        this.menuListView.setAdapter((ListAdapter)this.adapter);
        this.addItemList(builder.Ts);
    }

    @Override
    protected void initialize(@NonNull Context context, Boolean isMaterial) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        if (isMaterial.booleanValue()) {
            this.materialBinding = LayoutMaterialPowerMenuLibrarySkydovesBinding.inflate(layoutInflater, null, false);
        } else {
            this.binding = LayoutPowerMenuLibrarySkydovesBinding.inflate(layoutInflater, null, false);
        }
        this.adapter = new MenuBaseAdapter(this.menuListView);
        super.initialize(context, isMaterial);
    }

    @Override
    View getMenuRoot(Boolean isMaterial) {
        if (isMaterial.booleanValue()) {
            return this.materialBinding.getRoot();
        }
        return this.binding.getRoot();
    }

    @Override
    ListView getMenuList(Boolean isMaterial) {
        if (isMaterial.booleanValue()) {
            return this.materialBinding.powerMenuListView;
        }
        return this.binding.powerMenuListView;
    }

    @Override
    CardView getMenuCard(Boolean isMaterial) {
        if (isMaterial.booleanValue()) {
            return this.materialBinding.powerMenuCard;
        }
        return this.binding.powerMenuCard;
    }

    public static abstract class Factory<T, E extends MenuBaseAdapter<T>> {
        @NonNull
        public abstract CustomPowerMenu<T, E> create(@NonNull Context var1, @NonNull LifecycleOwner var2);
    }

    public static class Builder<T, E extends MenuBaseAdapter<T>>
    extends AbstractMenuBuilder {
        private OnMenuItemClickListener<T> menuItemClickListener = null;
        private final E adapter;
        private final List<T> Ts;

        public Builder(@NonNull Context context, @NonNull E adapter) {
            this.context = context;
            this.Ts = new ArrayList<T>();
            this.adapter = adapter;
            this.layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        public Builder<T, E> setLifecycleOwner(@NonNull LifecycleOwner lifecycleOwner) {
            this.lifecycleOwner = lifecycleOwner;
            return this;
        }

        public Builder<T, E> setShowBackground(boolean show) {
            this.showBackground = show;
            return this;
        }

        public Builder<T, E> setOnMenuItemClickListener(Object menuItemClickListener) {
            this.menuItemClickListener = (OnMenuItemClickListener)menuItemClickListener;
            return this;
        }

        public Builder<T, E> setOnBackgroundClickListener(View.OnClickListener onBackgroundClickListener) {
            this.backgroundClickListener = onBackgroundClickListener;
            return this;
        }

        public Builder<T, E> setOnDismissListener(OnDismissedListener onDismissListener) {
            this.onDismissedListener = onDismissListener;
            return this;
        }

        public Builder<T, E> setHeaderView(@LayoutRes int headerView) {
            this.headerView = this.layoutInflater.inflate(headerView, null);
            return this;
        }

        public Builder<T, E> setHeaderView(View headerView) {
            this.headerView = headerView;
            return this;
        }

        public Builder<T, E> setFooterView(@LayoutRes int footerView) {
            this.footerView = this.layoutInflater.inflate(footerView, null);
            return this;
        }

        public Builder<T, E> setFooterView(View footerView) {
            this.footerView = footerView;
            return this;
        }

        public Builder<T, E> setAnimation(@NonNull MenuAnimation menuAnimation) {
            this.menuAnimation = menuAnimation;
            return this;
        }

        public Builder<T, E> setAnimationStyle(@StyleRes int style2) {
            this.animationStyle = style2;
            return this;
        }

        public Builder<T, E> setMenuRadius(@Px float radius) {
            this.menuRadius = radius;
            return this;
        }

        public Builder<T, E> setMenuShadow(@Px float shadow) {
            this.menuShadow = shadow;
            return this;
        }

        public Builder<T, E> setWidth(@Px int width) {
            this.width = width;
            return this;
        }

        public Builder<T, E> setHeight(@Px int height) {
            this.height = height;
            return this;
        }

        public Builder<T, E> setPadding(@Px int padding) {
            this.padding = padding;
            return this;
        }

        public Builder<T, E> setSize(@Px int width, @Px int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder<T, E> setDividerHeight(@Px int height) {
            this.dividerHeight = height;
            return this;
        }

        public Builder<T, E> setDivider(Drawable divider) {
            this.divider = divider;
            return this;
        }

        public Builder<T, E> setBackgroundColor(@Px int color) {
            this.backgroundColor = color;
            return this;
        }

        public Builder<T, E> setBackgroundColorResource(@ColorRes int color) {
            this.backgroundColor = ContextCompat.getColor((Context)this.context, (int)color);
            return this;
        }

        public Builder<T, E> setBackgroundAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
            this.backgroundAlpha = alpha;
            return this;
        }

        public Builder<T, E> setBackgroundSystemUiVisibility(int visibility) {
            this.backgroundSystemUiVisibility = visibility;
            return this;
        }

        public Builder<T, E> setFocusable(boolean focusable) {
            this.focusable = focusable;
            return this;
        }

        public Builder<T, E> setSelected(int position) {
            this.selected = position;
            return this;
        }

        public Builder<T, E> setIsClipping(boolean isClipping) {
            this.isClipping = isClipping;
            return this;
        }

        public Builder<T, E> setDismissIfShowAgain(boolean dismissIfShowAgain) {
            this.dismissIfShowAgain = dismissIfShowAgain;
            return this;
        }

        public Builder<T, E> setAutoDismiss(boolean autoDismiss) {
            this.autoDismiss = autoDismiss;
            return this;
        }

        public Builder<T, E> addItem(Object item) {
            this.Ts.add(item);
            return this;
        }

        public Builder<T, E> addItem(int position, Object item) {
            this.Ts.add(position, item);
            return this;
        }

        public Builder<T, E> addItemList(List<T> itemList) {
            this.Ts.addAll(itemList);
            return this;
        }

        public Builder<T, E> setPreferenceName(@NonNull String preferenceName) {
            this.preferenceName = preferenceName;
            return this;
        }

        public Builder<T, E> setInitializeRule(@NonNull Lifecycle.Event event, int defaultPosition) {
            this.initializeRule = event;
            this.defaultPosition = defaultPosition;
            return this;
        }

        public Builder<T, E> setCircularEffect(@NonNull CircularEffect circularEffect) {
            this.circularEffect = circularEffect;
            return this;
        }

        public Builder<T, E> setIsMaterial(Boolean isMaterial) {
            this.isMaterial = isMaterial;
            return this;
        }

        public CustomPowerMenu<T, E> build() {
            return new CustomPowerMenu(this.context, this);
        }
    }
}

