/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import com.skydoves.balloon.extensions.ContextExtensionKt;
import com.skydoves.balloon.internals.ViewPropertyDelegate;
import com.skydoves.balloon.internals.ViewPropertyKt;
import com.skydoves.balloon.overlay.BalloonOverlayCircle;
import com.skydoves.balloon.overlay.BalloonOverlayEmpty;
import com.skydoves.balloon.overlay.BalloonOverlayOval;
import com.skydoves.balloon.overlay.BalloonOverlayRect;
import com.skydoves.balloon.overlay.BalloonOverlayRoundRect;
import com.skydoves.balloon.overlay.BalloonOverlayShape;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010\u00012\u0006\u0010A\u001a\u00020BH\u0002J\u0012\u0010C\u001a\u00020?2\b\u0010A\u001a\u0004\u0018\u00010BH\u0014J\u0006\u0010D\u001a\u00020?J\b\u0010E\u001a\u00020\u0007H\u0002J0\u0010F\u001a\u00020?2\u0006\u0010G\u001a\u00020\"2\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007H\u0014J\b\u0010L\u001a\u00020?H\u0002R/\u0010\n\u001a\u0004\u0018\u00010\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR;\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00118F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R+\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0010\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010#\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\u0010\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R+\u0010*\u001a\u00020)2\u0006\u0010\t\u001a\u00020)8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010\u0010\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R+\u00100\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b3\u0010\u0010\u001a\u0004\b1\u0010%\"\u0004\b2\u0010'R/\u00105\u001a\u0004\u0018\u0001042\b\u0010\t\u001a\u0004\u0018\u0001048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b:\u0010\u0010\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/skydoves/balloon/overlay/BalloonAnchorOverlayView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "anchorView", "getAnchorView", "()Landroid/view/View;", "setAnchorView", "(Landroid/view/View;)V", "anchorView$delegate", "Lcom/skydoves/balloon/internals/ViewPropertyDelegate;", "", "anchorViewList", "getAnchorViewList", "()Ljava/util/List;", "setAnchorViewList", "(Ljava/util/List;)V", "anchorViewList$delegate", "Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "balloonOverlayShape", "getBalloonOverlayShape", "()Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "setBalloonOverlayShape", "(Lcom/skydoves/balloon/overlay/BalloonOverlayShape;)V", "balloonOverlayShape$delegate", "bitmap", "Landroid/graphics/Bitmap;", "invalidated", "", "overlayColor", "getOverlayColor", "()I", "setOverlayColor", "(I)V", "overlayColor$delegate", "", "overlayPadding", "getOverlayPadding", "()F", "setOverlayPadding", "(F)V", "overlayPadding$delegate", "overlayPaddingColor", "getOverlayPaddingColor", "setOverlayPaddingColor", "overlayPaddingColor$delegate", "Landroid/graphics/Point;", "overlayPosition", "getOverlayPosition", "()Landroid/graphics/Point;", "setOverlayPosition", "(Landroid/graphics/Point;)V", "overlayPosition$delegate", "paddingColorPaint", "Landroid/graphics/Paint;", "paint", "addFocusViewInOverlay", "", "view", "canvas", "Landroid/graphics/Canvas;", "dispatchDraw", "forceInvalidate", "getStatusBarHeight", "onLayout", "changed", "left", "top", "right", "bottom", "prepareBitmap", "balloon_release"})
@SourceDebugExtension(value={"SMAP\nBalloonAnchorOverlayView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalloonAnchorOverlayView.kt\ncom/skydoves/balloon/overlay/BalloonAnchorOverlayView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1855#2,2:248\n*S KotlinDebug\n*F\n+ 1 BalloonAnchorOverlayView.kt\ncom/skydoves/balloon/overlay/BalloonAnchorOverlayView\n*L\n138#1:248,2\n*E\n"})
public final class BalloonAnchorOverlayView
extends View {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ViewPropertyDelegate anchorView$delegate;
    @NotNull
    private final ViewPropertyDelegate anchorViewList$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayColor$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayPaddingColor$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayPadding$delegate;
    @NotNull
    private final ViewPropertyDelegate overlayPosition$delegate;
    @NotNull
    private final ViewPropertyDelegate balloonOverlayShape$delegate;
    @Nullable
    private Bitmap bitmap;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Paint paddingColorPaint;
    private boolean invalidated;

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context, @Nullable AttributeSet attr, int defStyle) {
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attr, defStyle);
        this.anchorView$delegate = ViewPropertyKt.viewProperty(this, null);
        this.anchorViewList$delegate = ViewPropertyKt.viewProperty(this, null);
        this.overlayColor$delegate = ViewPropertyKt.viewProperty(this, 0);
        this.overlayPaddingColor$delegate = ViewPropertyKt.viewProperty(this, 0);
        this.overlayPadding$delegate = ViewPropertyKt.viewProperty(this, Float.valueOf(0.0f));
        this.overlayPosition$delegate = ViewPropertyKt.viewProperty(this, null);
        this.balloonOverlayShape$delegate = ViewPropertyKt.viewProperty(this, BalloonOverlayOval.INSTANCE);
        this.paint = new Paint(1);
        this.paddingColorPaint = new Paint(1);
        Paint $this$_init__u24lambda_u240 = paint = this.paint;
        boolean bl = false;
        $this$_init__u24lambda_u240.setAntiAlias(true);
        $this$_init__u24lambda_u240.setFilterBitmap(true);
        $this$_init__u24lambda_u240.setDither(true);
        Paint $this$_init__u24lambda_u241 = paint = this.paddingColorPaint;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setAntiAlias(true);
        $this$_init__u24lambda_u241.setFilterBitmap(true);
        $this$_init__u24lambda_u241.setDither(true);
    }

    public /* synthetic */ BalloonAnchorOverlayView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final View getAnchorView() {
        return (View)this.anchorView$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setAnchorView(@Nullable View view) {
        this.anchorView$delegate.setValue((Object)this, $$delegatedProperties[0], view);
    }

    @Nullable
    public final List<View> getAnchorViewList() {
        return (List)this.anchorViewList$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setAnchorViewList(@Nullable List<? extends View> list) {
        this.anchorViewList$delegate.setValue((Object)this, $$delegatedProperties[1], list);
    }

    @ColorInt
    public final int getOverlayColor() {
        return ((Number)this.overlayColor$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    public final void setOverlayColor(int n) {
        this.overlayColor$delegate.setValue((Object)this, $$delegatedProperties[2], n);
    }

    @ColorInt
    public final int getOverlayPaddingColor() {
        return ((Number)this.overlayPaddingColor$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
    }

    public final void setOverlayPaddingColor(int n) {
        this.overlayPaddingColor$delegate.setValue((Object)this, $$delegatedProperties[3], n);
    }

    @Px
    public final float getOverlayPadding() {
        return ((Number)this.overlayPadding$delegate.getValue((Object)this, $$delegatedProperties[4])).floatValue();
    }

    public final void setOverlayPadding(float f) {
        this.overlayPadding$delegate.setValue((Object)this, $$delegatedProperties[4], Float.valueOf(f));
    }

    @Nullable
    public final Point getOverlayPosition() {
        return (Point)this.overlayPosition$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    public final void setOverlayPosition(@Nullable Point point) {
        this.overlayPosition$delegate.setValue((Object)this, $$delegatedProperties[5], point);
    }

    @NotNull
    public final BalloonOverlayShape getBalloonOverlayShape() {
        return (BalloonOverlayShape)this.balloonOverlayShape$delegate.getValue((Object)this, $$delegatedProperties[6]);
    }

    public final void setBalloonOverlayShape(@NotNull BalloonOverlayShape balloonOverlayShape) {
        Intrinsics.checkNotNullParameter((Object)balloonOverlayShape, (String)"<set-?>");
        this.balloonOverlayShape$delegate.setValue((Object)this, $$delegatedProperties[6], balloonOverlayShape);
    }

    public final void forceInvalidate() {
        this.invalidated = true;
        this.invalidate();
    }

    protected void dispatchDraw(@Nullable Canvas canvas) {
        block7: {
            Bitmap bitmap;
            block6: {
                block5: {
                    if (this.invalidated || this.bitmap == null) break block5;
                    Bitmap bitmap2 = this.bitmap;
                    boolean bl = bitmap2 != null ? bitmap2.isRecycled() : false;
                    if (!bl) break block6;
                }
                this.prepareBitmap();
            }
            if ((bitmap = this.bitmap) == null || bitmap.isRecycled()) break block7;
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawBitmap(bitmap, 0.0f, 0.0f, null);
            }
        }
    }

    private final void prepareBitmap() {
        block10: {
            block9: {
                if (this.getWidth() == 0 || this.getHeight() == 0) break block9;
                View view = this.getAnchorView();
                if (view != null ? view.getWidth() == 0 : false) break block9;
                View view2 = this.getAnchorView();
                boolean bl = view2 != null ? view2.getHeight() == 0 : false;
                if (!bl) break block10;
            }
            return;
        }
        Bitmap localBitmap = this.bitmap;
        if (localBitmap != null && !localBitmap.isRecycled()) {
            localBitmap.recycle();
        }
        this.bitmap = localBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(localBitmap);
        Object object = this.paint;
        Paint $this$prepareBitmap_u24lambda_u242 = object;
        boolean bl = false;
        $this$prepareBitmap_u24lambda_u242.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        $this$prepareBitmap_u24lambda_u242.setColor(this.getOverlayColor());
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint);
        object = this.paint;
        Paint $this$prepareBitmap_u24lambda_u243 = object;
        boolean bl2 = false;
        $this$prepareBitmap_u24lambda_u243.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        $this$prepareBitmap_u24lambda_u243.setColor(0);
        object = this.paddingColorPaint;
        Paint $this$prepareBitmap_u24lambda_u244 = object;
        boolean bl3 = false;
        $this$prepareBitmap_u24lambda_u244.setColor(this.getOverlayPaddingColor());
        $this$prepareBitmap_u24lambda_u244.setStyle(Paint.Style.STROKE);
        $this$prepareBitmap_u24lambda_u244.setStrokeWidth(this.getOverlayPadding());
        object = this.getAnchorViewList();
        if (object == null || object.isEmpty()) {
            this.addFocusViewInOverlay(this.getAnchorView(), canvas);
        } else {
            List<View> list = this.getAnchorViewList();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    View view = (View)element$iv;
                    boolean bl4 = false;
                    this.addFocusViewInOverlay(view, canvas);
                }
            }
        }
        this.invalidated = false;
    }

    private final void addFocusViewInOverlay(View view, Canvas canvas) {
        View view2 = view;
        if (view2 != null) {
            RectF rectF;
            RectF rectF2;
            View anchor = view2;
            boolean bl = false;
            Rect rect = new Rect();
            anchor.getGlobalVisibleRect(rect);
            Point point = this.getOverlayPosition();
            if (point != null) {
                Point position = point;
                boolean bl2 = false;
                rectF2 = new RectF((float)position.x - this.getOverlayPadding(), (float)position.y - this.getOverlayPadding() + (float)this.getStatusBarHeight(), (float)(position.x + anchor.getWidth()) + this.getOverlayPadding(), (float)(position.y + anchor.getHeight()) + this.getOverlayPadding() + (float)this.getStatusBarHeight());
            } else {
                rectF2 = new RectF((float)rect.left - this.getOverlayPadding(), (float)rect.top - this.getOverlayPadding(), (float)rect.right + this.getOverlayPadding(), (float)rect.bottom + this.getOverlayPadding());
            }
            RectF anchorRect = rectF2;
            float halfOfOverlayPadding = this.getOverlayPadding() / (float)2;
            RectF $this$addFocusViewInOverlay_u24lambda_u2412_u24lambda_u247 = rectF = new RectF(anchorRect);
            boolean bl3 = false;
            $this$addFocusViewInOverlay_u24lambda_u2412_u24lambda_u247.inset(halfOfOverlayPadding, halfOfOverlayPadding);
            RectF anchorPaddingRect = rectF;
            BalloonOverlayShape overlay = this.getBalloonOverlayShape();
            if (!(overlay instanceof BalloonOverlayEmpty)) {
                if (overlay instanceof BalloonOverlayRect) {
                    canvas.drawRect(anchorRect, this.paint);
                    canvas.drawRect(anchorPaddingRect, this.paddingColorPaint);
                } else if (overlay instanceof BalloonOverlayOval) {
                    canvas.drawOval(anchorRect, this.paint);
                    canvas.drawOval(anchorPaddingRect, this.paddingColorPaint);
                } else if (overlay instanceof BalloonOverlayCircle) {
                    Float f = ((BalloonOverlayCircle)overlay).getRadius();
                    if (f != null) {
                        float radius = ((Number)f).floatValue();
                        boolean bl4 = false;
                        canvas.drawCircle(anchorRect.centerX(), anchorRect.centerY(), radius, this.paint);
                        canvas.drawCircle(anchorPaddingRect.centerX(), anchorPaddingRect.centerY(), radius - halfOfOverlayPadding, this.paddingColorPaint);
                    }
                    Integer n = ((BalloonOverlayCircle)overlay).getRadiusRes();
                    if (n != null) {
                        int radiusRes = ((Number)n).intValue();
                        boolean bl5 = false;
                        float f2 = anchorRect.centerX();
                        float f3 = anchorRect.centerY();
                        Context context = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                        canvas.drawCircle(f2, f3, ContextExtensionKt.dimen(context, radiusRes), this.paint);
                        float f4 = anchorPaddingRect.centerX();
                        float f5 = anchorPaddingRect.centerY();
                        Context context2 = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                        canvas.drawCircle(f4, f5, ContextExtensionKt.dimen(context2, radiusRes) - halfOfOverlayPadding, this.paddingColorPaint);
                    }
                } else if (overlay instanceof BalloonOverlayRoundRect) {
                    Pair<Float, Float> pair = ((BalloonOverlayRoundRect)overlay).getRadiusPair();
                    if (pair != null) {
                        Pair<Float, Float> radiusPair = pair;
                        boolean bl6 = false;
                        canvas.drawRoundRect(anchorRect, ((Number)radiusPair.getFirst()).floatValue(), ((Number)radiusPair.getSecond()).floatValue(), this.paint);
                        canvas.drawRoundRect(anchorPaddingRect, ((Number)radiusPair.getFirst()).floatValue() - halfOfOverlayPadding, ((Number)radiusPair.getSecond()).floatValue() - halfOfOverlayPadding, this.paddingColorPaint);
                    }
                    Pair<Integer, Integer> pair2 = ((BalloonOverlayRoundRect)overlay).getRadiusResPair();
                    if (pair2 != null) {
                        Pair<Integer, Integer> radiusResPair = pair2;
                        boolean bl7 = false;
                        Context context = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                        float f = ContextExtensionKt.dimen(context, ((Number)radiusResPair.getFirst()).intValue());
                        Context context3 = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
                        canvas.drawRoundRect(anchorRect, f, ContextExtensionKt.dimen(context3, ((Number)radiusResPair.getSecond()).intValue()), this.paint);
                        Context context4 = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"context");
                        float f6 = ContextExtensionKt.dimen(context4, ((Number)radiusResPair.getFirst()).intValue()) - halfOfOverlayPadding;
                        Context context5 = this.getContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context5, (String)"context");
                        canvas.drawRoundRect(anchorPaddingRect, f6, ContextExtensionKt.dimen(context5, ((Number)radiusResPair.getSecond()).intValue()) - halfOfOverlayPadding, this.paddingColorPaint);
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final int getStatusBarHeight() {
        int n;
        Rect rectangle = new Rect();
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).getWindow().getDecorView().getWindowVisibleDisplayFrame(rectangle);
            n = rectangle.top;
        } else {
            n = 0;
        }
        return n;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.invalidated = true;
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attr, 0, 4, null);
    }

    @JvmOverloads
    public BalloonAnchorOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "anchorView", "getAnchorView()Landroid/view/View;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "anchorViewList", "getAnchorViewList()Ljava/util/List;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayColor", "getOverlayColor()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPaddingColor", "getOverlayPaddingColor()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPadding", "getOverlayPadding()F", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "overlayPosition", "getOverlayPosition()Landroid/graphics/Point;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(BalloonAnchorOverlayView.class, "balloonOverlayShape", "getBalloonOverlayShape()Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

