/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.balloon;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.method.MovementMethod;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.AnimRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.MainThread;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.view.ViewCompat;
import androidx.core.widget.ImageViewCompat;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.viewbinding.ViewBinding;
import com.skydoves.balloon.ArrowOrientation;
import com.skydoves.balloon.ArrowOrientationRules;
import com.skydoves.balloon.ArrowPositionRules;
import com.skydoves.balloon.AutoDismissRunnable;
import com.skydoves.balloon.Balloon;
import com.skydoves.balloon.BalloonAnimation;
import com.skydoves.balloon.BalloonCenterAlign;
import com.skydoves.balloon.BalloonHighlightAnimation;
import com.skydoves.balloon.BalloonInlineDsl;
import com.skydoves.balloon.BalloonPersistence;
import com.skydoves.balloon.DefinitionKt;
import com.skydoves.balloon.IconForm;
import com.skydoves.balloon.IconGravity;
import com.skydoves.balloon.OnBalloonClickListener;
import com.skydoves.balloon.OnBalloonDismissListener;
import com.skydoves.balloon.OnBalloonInitializedListener;
import com.skydoves.balloon.OnBalloonOutsideTouchListener;
import com.skydoves.balloon.OnBalloonOverlayClickListener;
import com.skydoves.balloon.R;
import com.skydoves.balloon.TextForm;
import com.skydoves.balloon.animations.BalloonRotateAnimation;
import com.skydoves.balloon.annotations.Dp;
import com.skydoves.balloon.annotations.Sp;
import com.skydoves.balloon.databinding.BalloonLayoutBodyBinding;
import com.skydoves.balloon.databinding.BalloonLayoutOverlayBinding;
import com.skydoves.balloon.extensions.ContextExtensionKt;
import com.skydoves.balloon.extensions.DrawableExtensionKt;
import com.skydoves.balloon.extensions.TextViewExtensionKt;
import com.skydoves.balloon.extensions.ViewExtensionKt;
import com.skydoves.balloon.overlay.BalloonAnchorOverlayView;
import com.skydoves.balloon.overlay.BalloonOverlayAnimation;
import com.skydoves.balloon.overlay.BalloonOverlayOval;
import com.skydoves.balloon.overlay.BalloonOverlayShape;
import com.skydoves.balloon.radius.RadiusLayout;
import com.skydoves.balloon.vectortext.VectorTextView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u0004\u009b\u0001\u009c\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000200H\u0002J\b\u00107\u001a\u000200H\u0002J\u0010\u00108\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0002J\u0006\u00109\u001a\u000200J\b\u0010:\u001a\u000200H\u0002J\u0006\u0010;\u001a\u000200J\u000e\u0010<\u001a\u00020\u00192\u0006\u0010=\u001a\u00020>J \u0010?\u001a\u00020)2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020CH\u0002J\u0010\u0010E\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0002J\u0010\u0010F\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0002J\u0006\u0010G\u001a\u000202J\n\u0010H\u001a\u0004\u0018\u00010IH\u0002J$\u0010J\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020C0K2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u0006\u0010L\u001a\u000205J\b\u0010M\u001a\u00020CH\u0002J\u0006\u0010N\u001a\u00020CJ\u0018\u0010O\u001a\u00020C2\u0006\u0010P\u001a\u00020C2\u0006\u0010Q\u001a\u000202H\u0002J\u0006\u0010R\u001a\u00020CJ\b\u0010S\u001a\u00020-H\u0002J\b\u0010T\u001a\u00020\u0019H\u0002J\u0010\u0010U\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\b\u0010V\u001a\u000200H\u0002J\b\u0010W\u001a\u000200H\u0002J\b\u0010X\u001a\u000200H\u0002J\b\u0010Y\u001a\u000200H\u0002J\b\u0010Z\u001a\u000200H\u0002J\b\u0010[\u001a\u000200H\u0002J\b\u0010\\\u001a\u000200H\u0002J\b\u0010]\u001a\u000200H\u0002J\b\u0010^\u001a\u000200H\u0002J\b\u0010_\u001a\u000200H\u0002J\u0018\u0010`\u001a\u0002002\u0006\u0010a\u001a\u00020b2\u0006\u0010Q\u001a\u000202H\u0002J\u0010\u0010c\u001a\u0002002\u0006\u0010d\u001a\u00020eH\u0016J\u0010\u0010f\u001a\u0002002\u0006\u0010d\u001a\u00020eH\u0016J\u0010\u0010g\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J6\u0010h\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u00002#\b\u0004\u0010j\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\bl\u0012\b\bm\u0012\u0004\b\b(i\u0012\u0004\u0012\u0002000kH\u0083\bJ,\u0010n\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J,\u0010q\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J,\u0010r\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J,\u0010s\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J,\u0010t\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J6\u0010u\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020C2\b\b\u0002\u0010v\u001a\u00020wH\u0007J\u000e\u0010x\u001a\u00020\u00002\u0006\u0010y\u001a\u00020\u0019J\u001a\u0010z\u001a\u0002002\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002000kJ\u0010\u0010z\u001a\u0002002\b\u0010{\u001a\u0004\u0018\u00010|J\u0014\u0010}\u001a\u0002002\f\u0010j\u001a\b\u0012\u0004\u0012\u0002000~J\u0011\u0010}\u001a\u0002002\t\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u0001J\u001b\u0010\u0081\u0001\u001a\u0002002\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002000kJ\u0011\u0010\u0081\u0001\u001a\u0002002\b\u0010#\u001a\u0004\u0018\u00010\"J#\u0010\u0082\u0001\u001a\u0002002\u001a\u0010j\u001a\u0016\u0012\u0004\u0012\u000202\u0012\u0005\u0012\u00030\u0084\u0001\u0012\u0004\u0012\u0002000\u0083\u0001J\u0013\u0010\u0082\u0001\u001a\u0002002\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001J\u0015\u0010\u0087\u0001\u001a\u0002002\f\u0010j\u001a\b\u0012\u0004\u0012\u0002000~J\u0013\u0010\u0087\u0001\u001a\u0002002\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u0001J#\u0010\u008a\u0001\u001a\u0002002\u001a\u0010j\u001a\u0016\u0012\u0004\u0012\u000202\u0012\u0005\u0012\u00030\u0084\u0001\u0012\u0004\u0012\u00020\u00190\u0083\u0001J\u0013\u0010\u008a\u0001\u001a\u0002002\n\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u0001J\u0013\u0010\u008d\u0001\u001a\u0002002\n\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u0001J\u0007\u0010\u008e\u0001\u001a\u00020\u0019J\"\u0010\u008f\u0001\u001a\u0002002\u0006\u00101\u001a\u0002022\u000e\b\u0004\u0010j\u001a\b\u0012\u0004\u0012\u0002000~H\u0083\bJ%\u0010\u0090\u0001\u001a\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J%\u0010\u0091\u0001\u001a\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J%\u0010\u0092\u0001\u001a\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J%\u0010\u0093\u0001\u001a\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J%\u0010\u0094\u0001\u001a\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007J/\u0010\u0095\u0001\u001a\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020C2\b\b\u0002\u0010v\u001a\u00020wH\u0007J\u0011\u0010\u0096\u0001\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\t\u0010\u0097\u0001\u001a\u000200H\u0002J\t\u0010\u0098\u0001\u001a\u000200H\u0002J\u0011\u0010\u0099\u0001\u001a\u0002002\u0006\u00104\u001a\u000205H\u0002J\"\u0010\u009a\u0001\u001a\u0002002\u0006\u00101\u001a\u0002022\u000e\b\u0004\u0010j\u001a\b\u0012\u0004\u0012\u0002000~H\u0083\bJ%\u0010\u009a\u0001\u001a\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010o\u001a\u00020C2\b\b\u0002\u0010p\u001a\u00020CH\u0007R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\f\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010 \u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001e\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010\u001f\u001a\u0004\u0018\u00010\"8\u0006@FX\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0017\u00a8\u0006\u009d\u0001"}, d2={"Lcom/skydoves/balloon/Balloon;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "context", "Landroid/content/Context;", "builder", "Lcom/skydoves/balloon/Balloon$Builder;", "(Landroid/content/Context;Lcom/skydoves/balloon/Balloon$Builder;)V", "autoDismissRunnable", "Lcom/skydoves/balloon/AutoDismissRunnable;", "getAutoDismissRunnable", "()Lcom/skydoves/balloon/AutoDismissRunnable;", "autoDismissRunnable$delegate", "Lkotlin/Lazy;", "balloonPersistence", "Lcom/skydoves/balloon/BalloonPersistence;", "getBalloonPersistence", "()Lcom/skydoves/balloon/BalloonPersistence;", "balloonPersistence$delegate", "binding", "Lcom/skydoves/balloon/databinding/BalloonLayoutBodyBinding;", "bodyWindow", "Landroid/widget/PopupWindow;", "getBodyWindow", "()Landroid/widget/PopupWindow;", "destroyed", "", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "handler$delegate", "<set-?>", "isShowing", "()Z", "Lcom/skydoves/balloon/OnBalloonInitializedListener;", "onBalloonInitializedListener", "overlayBinding", "Lcom/skydoves/balloon/databinding/BalloonLayoutOverlayBinding;", "overlayWindow", "getOverlayWindow", "adjustArrowColorByMatchingCardBackground", "Landroid/graphics/Bitmap;", "imageView", "Landroid/widget/ImageView;", "x", "", "y", "adjustArrowOrientationByRules", "", "anchor", "Landroid/view/View;", "adjustFitsSystemWindows", "parent", "Landroid/view/ViewGroup;", "applyBalloonAnimation", "applyBalloonOverlayAnimation", "canShowBalloonWindow", "clearAllPreferences", "createByBuilder", "dismiss", "dismissWithDelay", "delay", "", "drawableToBitmap", "drawable", "Landroid/graphics/drawable/Drawable;", "width", "", "height", "getArrowConstraintPositionX", "getArrowConstraintPositionY", "getBalloonArrowView", "getBalloonHighlightAnimation", "Landroid/view/animation/Animation;", "getColorsFromBalloonCard", "Lkotlin/Pair;", "getContentView", "getDoubleArrowSize", "getMeasuredHeight", "getMeasuredTextWidth", "measuredWidth", "rootView", "getMeasuredWidth", "getMinArrowPosition", "hasCustomLayout", "initializeArrow", "initializeBackground", "initializeBalloonContent", "initializeBalloonLayout", "initializeBalloonListeners", "initializeBalloonOverlay", "initializeBalloonRoot", "initializeBalloonWindow", "initializeCustomLayout", "initializeIcon", "initializeText", "measureTextWidth", "textView", "Landroid/widget/TextView;", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onPause", "passTouchEventToAnchor", "relay", "balloon", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "relayShowAlignBottom", "xOff", "yOff", "relayShowAlignLeft", "relayShowAlignRight", "relayShowAlignTop", "relayShowAsDropDown", "relayShowAtCenter", "centerAlign", "Lcom/skydoves/balloon/BalloonCenterAlign;", "setIsAttachedInDecor", "value", "setOnBalloonClickListener", "onBalloonClickListener", "Lcom/skydoves/balloon/OnBalloonClickListener;", "setOnBalloonDismissListener", "Lkotlin/Function0;", "onBalloonDismissListener", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "setOnBalloonInitializedListener", "setOnBalloonOutsideTouchListener", "Lkotlin/Function2;", "Landroid/view/MotionEvent;", "onBalloonOutsideTouchListener", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "setOnBalloonOverlayClickListener", "onBalloonOverlayClickListener", "Lcom/skydoves/balloon/OnBalloonOverlayClickListener;", "setOnBalloonOverlayTouchListener", "onTouchListener", "Landroid/view/View$OnTouchListener;", "setOnBalloonTouchListener", "shouldShowUp", "show", "showAlignBottom", "showAlignLeft", "showAlignRight", "showAlignTop", "showAsDropDown", "showAtCenter", "showOverlayWindow", "startBalloonHighlightAnimation", "stopBalloonHighlightAnimation", "traverseAndMeasureTextWidth", "update", "Builder", "Factory", "balloon_release"})
public final class Balloon
implements DefaultLifecycleObserver {
    @NotNull
    private final Context context;
    @NotNull
    private final Builder builder;
    @NotNull
    private final BalloonLayoutBodyBinding binding;
    @NotNull
    private final BalloonLayoutOverlayBinding overlayBinding;
    @NotNull
    private final PopupWindow bodyWindow;
    @NotNull
    private final PopupWindow overlayWindow;
    private boolean isShowing;
    private boolean destroyed;
    @JvmField
    @Nullable
    public OnBalloonInitializedListener onBalloonInitializedListener;
    @NotNull
    private final Lazy handler$delegate;
    @NotNull
    private final Lazy autoDismissRunnable$delegate;
    @NotNull
    private final Lazy balloonPersistence$delegate;

    private Balloon(Context context, Builder builder) {
        this.context = context;
        this.builder = builder;
        Object object = BalloonLayoutBodyBinding.inflate(LayoutInflater.from((Context)this.context), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.from(context), null, false)");
        this.binding = object;
        object = BalloonLayoutOverlayBinding.inflate(LayoutInflater.from((Context)this.context), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(LayoutInflater.from(context), null, false)");
        this.overlayBinding = object;
        this.bodyWindow = new PopupWindow((View)this.binding.getRoot(), -2, -2);
        this.overlayWindow = new PopupWindow((View)this.overlayBinding.getRoot(), -1, -1);
        this.onBalloonInitializedListener = this.builder.getOnBalloonInitializedListener();
        this.handler$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)handler.2.INSTANCE);
        this.autoDismissRunnable$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<AutoDismissRunnable>(this){
            final /* synthetic */ Balloon this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AutoDismissRunnable invoke() {
                return new AutoDismissRunnable(this.this$0);
            }
        }));
        this.balloonPersistence$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<BalloonPersistence>(this){
            final /* synthetic */ Balloon this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BalloonPersistence invoke() {
                return BalloonPersistence.Companion.getInstance(Balloon.access$getContext$p(this.this$0));
            }
        }));
        this.createByBuilder();
    }

    @NotNull
    public final PopupWindow getBodyWindow() {
        return this.bodyWindow;
    }

    @NotNull
    public final PopupWindow getOverlayWindow() {
        return this.overlayWindow;
    }

    public final boolean isShowing() {
        return this.isShowing;
    }

    private final Handler getHandler() {
        Lazy lazy = this.handler$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    private final AutoDismissRunnable getAutoDismissRunnable() {
        Lazy lazy = this.autoDismissRunnable$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (AutoDismissRunnable)lazy.getValue();
    }

    private final BalloonPersistence getBalloonPersistence() {
        Lazy lazy = this.balloonPersistence$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (BalloonPersistence)lazy.getValue();
    }

    private final void createByBuilder() {
        this.initializeBackground();
        this.initializeBalloonRoot();
        this.initializeBalloonWindow();
        this.initializeBalloonLayout();
        this.initializeBalloonContent();
        this.initializeBalloonOverlay();
        this.initializeBalloonListeners();
        FrameLayout frameLayout = this.binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.root");
        this.adjustFitsSystemWindows((ViewGroup)frameLayout);
        if (this.builder.getLifecycleOwner() == null && this.context instanceof LifecycleOwner) {
            this.builder.setLifecycleOwner((LifecycleOwner)this.context);
            frameLayout = this.builder.getLifecycleObserver();
            ((LifecycleOwner)this.context).getLifecycle().addObserver((LifecycleObserver)(frameLayout == null ? (LifecycleObserver)this : frameLayout));
        } else {
            Lifecycle lifecycle;
            frameLayout = this.builder.getLifecycleOwner();
            if (frameLayout != null && (lifecycle = frameLayout.getLifecycle()) != null) {
                LifecycleObserver lifecycleObserver = this.builder.getLifecycleObserver();
                lifecycle.addObserver(lifecycleObserver == null ? (LifecycleObserver)this : lifecycleObserver);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustFitsSystemWindows(ViewGroup parent) {
        void $this$mapTo$iv$iv;
        parent.setFitsSystemWindows(false);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)parent.getChildCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            View view = parent.getChildAt((int)it);
            collection.add(view);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            View child = (View)element$iv;
            boolean bl = false;
            child.setFitsSystemWindows(false);
            if (!(child instanceof ViewGroup)) continue;
            this.adjustFitsSystemWindows((ViewGroup)child);
        }
    }

    private final float getMinArrowPosition() {
        return (float)this.builder.getArrowSize() * this.builder.getArrowAlignAnchorPaddingRatio() + (float)this.builder.getArrowAlignAnchorPadding();
    }

    private final int getDoubleArrowSize() {
        return this.builder.getArrowSize() * 2;
    }

    private final void initializeArrow(View anchor) {
        AppCompatImageView appCompatImageView = this.binding.balloonArrow;
        boolean bl = false;
        boolean bl2 = false;
        AppCompatImageView $this$initializeArrow_u24lambda_u2d5 = appCompatImageView;
        boolean bl3 = false;
        $this$initializeArrow_u24lambda_u2d5.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.builder.getArrowSize(), this.builder.getArrowSize()));
        $this$initializeArrow_u24lambda_u2d5.setAlpha(this.builder.getAlpha());
        Drawable drawable = this.builder.getArrowDrawable();
        if (drawable != null) {
            Drawable drawable2 = drawable;
            boolean bl4 = false;
            boolean bl5 = false;
            Drawable it = drawable2;
            boolean bl6 = false;
            $this$initializeArrow_u24lambda_u2d5.setImageDrawable(it);
        }
        $this$initializeArrow_u24lambda_u2d5.setPadding(this.builder.getArrowLeftPadding(), this.builder.getArrowTopPadding(), this.builder.getArrowRightPadding(), this.builder.getArrowBottomPadding());
        if (this.builder.getArrowColor() != Integer.MIN_VALUE) {
            ImageViewCompat.setImageTintList((ImageView)((ImageView)$this$initializeArrow_u24lambda_u2d5), (ColorStateList)ColorStateList.valueOf((int)this.builder.getArrowColor()));
        } else {
            ImageViewCompat.setImageTintList((ImageView)((ImageView)$this$initializeArrow_u24lambda_u2d5), (ColorStateList)ColorStateList.valueOf((int)this.builder.getBackgroundColor()));
        }
        boolean $i$f$runOnAfterSDK21 = false;
        if (Build.VERSION.SDK_INT >= 21) {
            boolean bl7 = false;
            $this$initializeArrow_u24lambda_u2d5.setOutlineProvider(ViewOutlineProvider.BOUNDS);
        }
        this.binding.balloonCard.post(() -> Balloon.initializeArrow$lambda-5$lambda-4(this, anchor, $this$initializeArrow_u24lambda_u2d5));
    }

    private final Bitmap adjustArrowColorByMatchingCardBackground(ImageView imageView, float x, float y) {
        LinearGradient linearGradient;
        imageView.setColorFilter(this.builder.getBackgroundColor(), PorterDuff.Mode.SRC_IN);
        Drawable drawable = imageView.getDrawable();
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"imageView.drawable");
        Bitmap oldBitmap = this.drawableToBitmap(drawable, imageView.getDrawable().getIntrinsicWidth(), imageView.getDrawable().getIntrinsicHeight());
        Pair<Integer, Integer> colors = null;
        try {
            colors = this.getColorsFromBalloonCard(x, y);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Arrow attached outside balloon. Could not get a matching color.");
        }
        int startColor = ((Number)colors.getFirst()).intValue();
        int endColor = ((Number)colors.getSecond()).intValue();
        Bitmap updatedBitmap = Bitmap.createBitmap((int)oldBitmap.getWidth(), (int)oldBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(updatedBitmap);
        canvas.drawBitmap(oldBitmap, 0.0f, 0.0f, null);
        Paint paint = new Paint();
        ArrowOrientation arrowOrientation = this.builder.getArrowOrientation();
        int n = WhenMappings.$EnumSwitchMapping$0[arrowOrientation.ordinal()];
        switch (n) {
            case 1: 
            case 3: {
                Builder this_$iv = this.builder;
                boolean $i$f$getArrowHalfSize = false;
                LinearGradient linearGradient2 = new LinearGradient((float)oldBitmap.getWidth() / (float)2 - (float)this_$iv.getArrowSize() * 0.5f, 0.0f, (float)oldBitmap.getWidth(), 0.0f, startColor, endColor, Shader.TileMode.CLAMP);
                linearGradient = linearGradient2;
                break;
            }
            case 2: 
            case 4: {
                Builder this_$iv = this.builder;
                boolean $i$f$getArrowHalfSize = false;
                LinearGradient linearGradient3 = new LinearGradient((float)oldBitmap.getWidth() / (float)2 + (float)this_$iv.getArrowSize() * 0.5f, 0.0f, 0.0f, 0.0f, startColor, endColor, Shader.TileMode.CLAMP);
                linearGradient = linearGradient3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        LinearGradient shader = linearGradient;
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawRect(0.0f, 0.0f, (float)oldBitmap.getWidth(), (float)oldBitmap.getHeight(), paint);
        imageView.setColorFilter(0, PorterDuff.Mode.SRC_IN);
        Intrinsics.checkNotNullExpressionValue((Object)updatedBitmap, (String)"updatedBitmap");
        return updatedBitmap;
    }

    private final Pair<Integer, Integer> getColorsFromBalloonCard(float x, float y) {
        Drawable drawable = this.binding.balloonCard.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"binding.balloonCard.background");
        Bitmap bitmap = this.drawableToBitmap(drawable, this.binding.balloonCard.getWidth() + 1, this.binding.balloonCard.getHeight() + 1);
        int startColor = 0;
        int endColor = 0;
        ArrowOrientation arrowOrientation = this.builder.getArrowOrientation();
        int n = WhenMappings.$EnumSwitchMapping$0[arrowOrientation.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                Builder this_$iv = this.builder;
                boolean $i$f$getArrowHalfSize = false;
                startColor = bitmap.getPixel((int)(x + (float)this_$iv.getArrowSize() * 0.5f), (int)y);
                this_$iv = this.builder;
                $i$f$getArrowHalfSize = false;
                endColor = bitmap.getPixel((int)(x - (float)this_$iv.getArrowSize() * 0.5f), (int)y);
                break;
            }
            case 3: 
            case 4: {
                Builder this_$iv = this.builder;
                boolean $i$f$getArrowHalfSize = false;
                startColor = bitmap.getPixel((int)x, (int)(y + (float)this_$iv.getArrowSize() * 0.5f));
                this_$iv = this.builder;
                $i$f$getArrowHalfSize = false;
                endColor = bitmap.getPixel((int)x, (int)(y - (float)this_$iv.getArrowSize() * 0.5f));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new Pair((Object)startColor, (Object)endColor);
    }

    private final Bitmap drawableToBitmap(Drawable drawable, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    private final void adjustArrowOrientationByRules(View anchor) {
        if (this.builder.getArrowOrientationRules() == ArrowOrientationRules.ALIGN_FIXED) {
            return;
        }
        Rect anchorRect = new Rect();
        anchor.getGlobalVisibleRect(anchorRect);
        int[] nArray = new int[]{0, 0};
        int[] location = nArray;
        this.bodyWindow.getContentView().getLocationOnScreen(location);
        if (this.builder.getArrowOrientation() == ArrowOrientation.TOP && location[1] < anchorRect.bottom) {
            this.builder.setArrowOrientation(ArrowOrientation.BOTTOM);
        } else if (this.builder.getArrowOrientation() == ArrowOrientation.BOTTOM && location[1] > anchorRect.top) {
            this.builder.setArrowOrientation(ArrowOrientation.TOP);
        }
        this.initializeBalloonContent();
    }

    private final float getArrowConstraintPositionX(View anchor) {
        float f;
        FrameLayout frameLayout = this.binding.balloonContent;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.balloonContent");
        int balloonX = ViewExtensionKt.getViewPointOnScreen((View)((View)frameLayout)).x;
        int anchorX = ViewExtensionKt.getViewPointOnScreen((View)anchor).x;
        float minPosition = this.getMinArrowPosition();
        float maxPosition = (float)this.getMeasuredWidth() - minPosition - (float)this.builder.getMarginRight() - (float)this.builder.getMarginLeft();
        ArrowPositionRules arrowPositionRules = this.builder.getArrowPositionRules();
        int n = WhenMappings.$EnumSwitchMapping$1[arrowPositionRules.ordinal()];
        switch (n) {
            case 1: {
                Builder this_$iv = this.builder;
                boolean $i$f$getArrowHalfSize = false;
                f = (float)this.binding.balloonWrapper.getWidth() * this.builder.getArrowPosition() - (float)this_$iv.getArrowSize() * 0.5f;
                break;
            }
            case 2: {
                if (anchorX + anchor.getWidth() < balloonX) {
                    f = minPosition;
                    break;
                }
                if (balloonX + this.getMeasuredWidth() < anchorX) {
                    f = maxPosition;
                    break;
                }
                Builder this_$iv = this.builder;
                boolean $i$f$getArrowHalfSize = false;
                float position = (float)anchor.getWidth() * this.builder.getArrowPosition() + (float)anchorX - (float)balloonX - (float)this_$iv.getArrowSize() * 0.5f;
                if (position <= (float)this.getDoubleArrowSize()) {
                    f = minPosition;
                    break;
                }
                if (position > (float)(this.getMeasuredWidth() - this.getDoubleArrowSize())) {
                    f = maxPosition;
                    break;
                }
                f = position;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    private final float getArrowConstraintPositionY(View anchor) {
        float f;
        int statusBarHeight = ViewExtensionKt.getStatusBarHeight(anchor, this.builder.isStatusBarVisible());
        FrameLayout frameLayout = this.binding.balloonContent;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.balloonContent");
        int balloonY = ViewExtensionKt.getViewPointOnScreen((View)((View)frameLayout)).y - statusBarHeight;
        int anchorY = ViewExtensionKt.getViewPointOnScreen((View)anchor).y - statusBarHeight;
        float minPosition = this.getMinArrowPosition();
        float maxPosition = (float)this.getMeasuredHeight() - minPosition - (float)this.builder.getMarginTop() - (float)this.builder.getMarginBottom();
        int arrowHalfSize = this.builder.getArrowSize() / 2;
        ArrowPositionRules arrowPositionRules = this.builder.getArrowPositionRules();
        int n = WhenMappings.$EnumSwitchMapping$1[arrowPositionRules.ordinal()];
        switch (n) {
            case 1: {
                f = (float)this.binding.balloonWrapper.getHeight() * this.builder.getArrowPosition() - (float)arrowHalfSize;
                break;
            }
            case 2: {
                if (anchorY + anchor.getHeight() < balloonY) {
                    f = minPosition;
                    break;
                }
                if (balloonY + this.getMeasuredHeight() < anchorY) {
                    f = maxPosition;
                    break;
                }
                float position = (float)anchor.getHeight() * this.builder.getArrowPosition() + (float)anchorY - (float)balloonY - (float)arrowHalfSize;
                if (position <= (float)this.getDoubleArrowSize()) {
                    f = minPosition;
                    break;
                }
                if (position > (float)(this.getMeasuredHeight() - this.getDoubleArrowSize())) {
                    f = maxPosition;
                    break;
                }
                f = position;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeBackground() {
        Drawable drawable;
        RadiusLayout radiusLayout = this.binding.balloonCard;
        boolean bl = false;
        boolean bl2 = false;
        RadiusLayout $this$initializeBackground_u24lambda_u2d7 = radiusLayout;
        boolean bl3 = false;
        $this$initializeBackground_u24lambda_u2d7.setAlpha(this.builder.getAlpha());
        $this$initializeBackground_u24lambda_u2d7.setRadius(this.builder.getCornerRadius());
        ViewCompat.setElevation((View)((View)$this$initializeBackground_u24lambda_u2d7), (float)this.builder.getElevation());
        RadiusLayout radiusLayout2 = $this$initializeBackground_u24lambda_u2d7;
        Drawable drawable2 = this.builder.getBackgroundDrawable();
        if (drawable2 == null) {
            void $this$initializeBackground_u24lambda_u2d7_u24lambda_u2d6;
            GradientDrawable gradientDrawable = new GradientDrawable();
            boolean bl4 = false;
            boolean bl5 = false;
            GradientDrawable gradientDrawable2 = gradientDrawable;
            RadiusLayout radiusLayout3 = radiusLayout2;
            boolean bl6 = false;
            $this$initializeBackground_u24lambda_u2d7_u24lambda_u2d6.setColor(this.builder.getBackgroundColor());
            $this$initializeBackground_u24lambda_u2d7_u24lambda_u2d6.setCornerRadius(this.builder.getCornerRadius());
            Unit unit = Unit.INSTANCE;
            radiusLayout2 = radiusLayout3;
            drawable = (Drawable)gradientDrawable;
        } else {
            drawable = drawable2;
        }
        radiusLayout2.setBackground(drawable);
        $this$initializeBackground_u24lambda_u2d7.setPadding(this.builder.getPaddingLeft(), this.builder.getPaddingTop(), this.builder.getPaddingRight(), this.builder.getPaddingBottom());
    }

    private final void initializeBalloonWindow() {
        PopupWindow popupWindow = this.bodyWindow;
        boolean bl = false;
        boolean bl2 = false;
        PopupWindow $this$initializeBalloonWindow_u24lambda_u2d9 = popupWindow;
        boolean bl3 = false;
        $this$initializeBalloonWindow_u24lambda_u2d9.setOutsideTouchable(true);
        $this$initializeBalloonWindow_u24lambda_u2d9.setFocusable(this.builder.isFocusable());
        $this$initializeBalloonWindow_u24lambda_u2d9.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        boolean $i$f$runOnAfterSDK21 = false;
        if (Build.VERSION.SDK_INT >= 21) {
            boolean bl4 = false;
            $this$initializeBalloonWindow_u24lambda_u2d9.setElevation(this.builder.getElevation());
        }
        this.setIsAttachedInDecor(this.builder.isAttachedInDecor());
    }

    private final void initializeBalloonListeners() {
        this.setOnBalloonClickListener(this.builder.getOnBalloonClickListener());
        this.setOnBalloonDismissListener(this.builder.getOnBalloonDismissListener());
        this.setOnBalloonOutsideTouchListener(this.builder.getOnBalloonOutsideTouchListener());
        this.setOnBalloonTouchListener(this.builder.getOnBalloonTouchListener());
        this.setOnBalloonOverlayClickListener(this.builder.getOnBalloonOverlayClickListener());
        this.setOnBalloonOverlayTouchListener(this.builder.getOnBalloonOverlayTouchListener());
    }

    private final void initializeBalloonRoot() {
        FrameLayout frameLayout = this.binding.balloonWrapper;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout $this$initializeBalloonRoot_u24lambda_u2d10 = frameLayout;
        boolean bl3 = false;
        ViewGroup.LayoutParams layoutParams = $this$initializeBalloonRoot_u24lambda_u2d10.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(this.builder.getMarginLeft(), this.builder.getMarginTop(), this.builder.getMarginRight(), this.builder.getMarginBottom());
    }

    private final void initializeBalloonContent() {
        int paddingSize = this.builder.getArrowSize() - 1;
        int elevation = (int)this.builder.getElevation();
        FrameLayout frameLayout = this.binding.balloonContent;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout $this$initializeBalloonContent_u24lambda_u2d11 = frameLayout;
        boolean bl3 = false;
        ArrowOrientation arrowOrientation = this.builder.getArrowOrientation();
        int n = WhenMappings.$EnumSwitchMapping$0[arrowOrientation.ordinal()];
        switch (n) {
            case 3: {
                $this$initializeBalloonContent_u24lambda_u2d11.setPadding(paddingSize, elevation, paddingSize, elevation);
                break;
            }
            case 4: {
                $this$initializeBalloonContent_u24lambda_u2d11.setPadding(paddingSize, elevation, paddingSize, elevation);
                break;
            }
            case 2: {
                $this$initializeBalloonContent_u24lambda_u2d11.setPadding(elevation, paddingSize, elevation, RangesKt.coerceAtLeast((int)paddingSize, (int)elevation));
                break;
            }
            case 1: {
                $this$initializeBalloonContent_u24lambda_u2d11.setPadding(elevation, paddingSize, elevation, RangesKt.coerceAtLeast((int)paddingSize, (int)elevation));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeIcon() {
        Unit unit;
        boolean bl;
        Unit unit2;
        VectorTextView vectorTextView = this.binding.balloonText;
        boolean bl2 = false;
        boolean bl3 = false;
        VectorTextView $this$initializeIcon_u24lambda_u2d14 = vectorTextView;
        boolean bl4 = false;
        IconForm iconForm = this.builder.getIconForm();
        if (iconForm == null) {
            unit2 = null;
        } else {
            IconForm iconForm2 = iconForm;
            boolean bl5 = false;
            bl = false;
            IconForm it = iconForm2;
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)$this$initializeIcon_u24lambda_u2d14), (String)"");
            TextViewExtensionKt.applyIconForm($this$initializeIcon_u24lambda_u2d14, it);
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            void $this$initializeIcon_u24lambda_u2d14_u24lambda_u2d13;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)$this$initializeIcon_u24lambda_u2d14), (String)"");
            iconForm = $this$initializeIcon_u24lambda_u2d14.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)iconForm, (String)"context");
            IconForm context$iv = iconForm;
            boolean $i$f$iconForm = false;
            IconForm.Builder builder = new IconForm.Builder((Context)context$iv);
            bl = false;
            boolean bl7 = false;
            IconForm.Builder bl6 = builder;
            VectorTextView vectorTextView2 = $this$initializeIcon_u24lambda_u2d14;
            boolean bl8 = false;
            $this$initializeIcon_u24lambda_u2d14_u24lambda_u2d13.setDrawable(this.builder.getIconDrawable());
            $this$initializeIcon_u24lambda_u2d14_u24lambda_u2d13.setIconWidth(this.builder.getIconWidth());
            $this$initializeIcon_u24lambda_u2d14_u24lambda_u2d13.setIconHeight(this.builder.getIconHeight());
            $this$initializeIcon_u24lambda_u2d14_u24lambda_u2d13.setIconColor(this.builder.getIconColor());
            $this$initializeIcon_u24lambda_u2d14_u24lambda_u2d13.setIconSpace(this.builder.getIconSpace());
            $this$initializeIcon_u24lambda_u2d14_u24lambda_u2d13.setDrawableGravity(this.builder.getIconGravity());
            Unit unit3 = Unit.INSTANCE;
            TextViewExtensionKt.applyIconForm(vectorTextView2, builder.build());
        }
        $this$initializeIcon_u24lambda_u2d14.isRtlSupport(this.builder.isRtlLayout());
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeText() {
        RadiusLayout radiusLayout;
        boolean bl;
        RadiusLayout radiusLayout2;
        VectorTextView vectorTextView = this.binding.balloonText;
        boolean bl2 = false;
        boolean bl3 = false;
        VectorTextView $this$initializeText_u24lambda_u2d17 = vectorTextView;
        boolean bl4 = false;
        TextForm textForm = this.builder.getTextForm();
        if (textForm == null) {
            radiusLayout2 = null;
        } else {
            TextForm textForm2 = textForm;
            boolean bl5 = false;
            bl = false;
            TextForm it = textForm2;
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)$this$initializeText_u24lambda_u2d17), (String)"");
            TextViewExtensionKt.applyTextForm((TextView)$this$initializeText_u24lambda_u2d17, it);
            radiusLayout2 = radiusLayout = Unit.INSTANCE;
        }
        if (radiusLayout == null) {
            void $this$initializeText_u24lambda_u2d17_u24lambda_u2d16;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)$this$initializeText_u24lambda_u2d17), (String)"");
            TextView textView = (TextView)$this$initializeText_u24lambda_u2d17;
            textForm = $this$initializeText_u24lambda_u2d17.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)textForm, (String)"context");
            TextForm context$iv = textForm;
            boolean $i$f$textForm = false;
            TextForm.Builder builder = new TextForm.Builder((Context)context$iv);
            bl = false;
            boolean bl7 = false;
            TextForm.Builder bl6 = builder;
            TextView textView2 = textView;
            boolean bl8 = false;
            $this$initializeText_u24lambda_u2d17_u24lambda_u2d16.setText(this.builder.getText());
            $this$initializeText_u24lambda_u2d17_u24lambda_u2d16.setTextSize(this.builder.getTextSize());
            $this$initializeText_u24lambda_u2d17_u24lambda_u2d16.setTextColor(this.builder.getTextColor());
            $this$initializeText_u24lambda_u2d17_u24lambda_u2d16.setTextIsHtml(this.builder.getTextIsHtml());
            $this$initializeText_u24lambda_u2d17_u24lambda_u2d16.setTextGravity(this.builder.getTextGravity());
            $this$initializeText_u24lambda_u2d17_u24lambda_u2d16.setTextTypeface(this.builder.getTextTypeface());
            $this$initializeText_u24lambda_u2d17_u24lambda_u2d16.setTextTypeface(this.builder.getTextTypefaceObject());
            $this$initializeText_u24lambda_u2d17.setMovementMethod(this.builder.getMovementMethod());
            Unit unit = Unit.INSTANCE;
            TextViewExtensionKt.applyTextForm(textView2, builder.build());
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)$this$initializeText_u24lambda_u2d17), (String)"this");
        TextView textView = (TextView)$this$initializeText_u24lambda_u2d17;
        radiusLayout = this.binding.balloonCard;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
        this.measureTextWidth(textView, (View)radiusLayout);
    }

    private final void initializeBalloonLayout() {
        if (this.hasCustomLayout()) {
            this.initializeCustomLayout();
        } else {
            this.initializeIcon();
            this.initializeText();
        }
    }

    private final boolean hasCustomLayout() {
        return this.builder.getLayoutRes() != null || this.builder.getLayout() != null;
    }

    private final void initializeCustomLayout() {
        Integer n;
        Integer n2;
        Object object = this.builder.getLayoutRes();
        if (object == null) {
            n2 = null;
        } else {
            Integer n3 = object;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n3).intValue();
            boolean bl3 = false;
            n2 = LayoutInflater.from((Context)this.context).inflate(it, (ViewGroup)this.binding.balloonCard, false);
        }
        Integer n4 = n2;
        if (n4 == null) {
            object = this.builder.getLayout();
            if (object == null) {
                throw new IllegalArgumentException("The custom layout is null.");
            }
            n = object;
        } else {
            n = n4;
        }
        Integer layout2 = n;
        object = layout2.getParent();
        ViewGroup parentView = object instanceof ViewGroup ? (ViewGroup)object : null;
        object = parentView;
        if (object != null) {
            object.removeView((View)layout2);
        }
        this.binding.balloonCard.removeAllViews();
        this.binding.balloonCard.addView((View)layout2);
        object = this.binding.balloonCard;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.balloonCard");
        this.traverseAndMeasureTextWidth((ViewGroup)object);
    }

    private final void initializeBalloonOverlay() {
        if (this.builder.isVisibleOverlay()) {
            BalloonAnchorOverlayView balloonAnchorOverlayView = this.overlayBinding.balloonOverlayView;
            boolean bl = false;
            boolean bl2 = false;
            BalloonAnchorOverlayView $this$initializeBalloonOverlay_u24lambda_u2d19 = balloonAnchorOverlayView;
            boolean bl3 = false;
            $this$initializeBalloonOverlay_u24lambda_u2d19.setOverlayColor(this.builder.getOverlayColor());
            $this$initializeBalloonOverlay_u24lambda_u2d19.setOverlayPadding(this.builder.getOverlayPadding());
            $this$initializeBalloonOverlay_u24lambda_u2d19.setOverlayPosition(this.builder.getOverlayPosition());
            $this$initializeBalloonOverlay_u24lambda_u2d19.setBalloonOverlayShape(this.builder.getOverlayShape());
            $this$initializeBalloonOverlay_u24lambda_u2d19.setOverlayPaddingColor(this.builder.getOverlayPaddingColor());
            this.getOverlayWindow().setClippingEnabled(false);
        }
    }

    private final void applyBalloonAnimation() {
        if (this.builder.getBalloonAnimationStyle() == Integer.MIN_VALUE) {
            BalloonAnimation balloonAnimation = this.builder.getBalloonAnimation();
            int n = WhenMappings.$EnumSwitchMapping$2[balloonAnimation.ordinal()];
            switch (n) {
                case 1: {
                    this.bodyWindow.setAnimationStyle(R.style.Balloon_Elastic_Anim);
                    break;
                }
                case 2: {
                    View view = this.bodyWindow.getContentView();
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"bodyWindow.contentView");
                    ViewExtensionKt.circularRevealed(view, this.builder.getCircularDuration());
                    this.bodyWindow.setAnimationStyle(R.style.Balloon_Normal_Dispose_Anim);
                    break;
                }
                case 3: {
                    this.bodyWindow.setAnimationStyle(R.style.Balloon_Fade_Anim);
                    break;
                }
                case 4: {
                    this.bodyWindow.setAnimationStyle(R.style.Balloon_Overshoot_Anim);
                    break;
                }
                case 5: {
                    this.bodyWindow.setAnimationStyle(R.style.Balloon_Normal_Anim);
                }
            }
        } else {
            this.bodyWindow.setAnimationStyle(this.builder.getBalloonAnimationStyle());
        }
    }

    private final void applyBalloonOverlayAnimation() {
        if (this.builder.getBalloonOverlayAnimationStyle() == Integer.MIN_VALUE) {
            BalloonOverlayAnimation balloonOverlayAnimation = this.builder.getBalloonOverlayAnimation();
            int n = WhenMappings.$EnumSwitchMapping$3[balloonOverlayAnimation.ordinal()];
            if (n == 1) {
                this.overlayWindow.setAnimationStyle(R.style.Balloon_Fade_Anim);
            } else {
                this.overlayWindow.setAnimationStyle(R.style.Balloon_Normal_Anim);
            }
        } else {
            this.overlayWindow.setAnimationStyle(this.builder.getBalloonAnimationStyle());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Animation getBalloonHighlightAnimation() {
        block19: {
            block18: {
                if (this.builder.getBalloonHighlightAnimationStyle() != -2147483648) break block18;
                var2_1 = this.builder.getBalloonHighlightAnimation();
                var3_2 = WhenMappings.$EnumSwitchMapping$4[var2_1.ordinal()];
                switch (var3_2) {
                    case 1: {
                        if (!this.builder.isVisibleArrow()) ** GOTO lbl24
                        var4_3 = this.builder.getArrowOrientation();
                        var5_4 = WhenMappings.$EnumSwitchMapping$0[var4_3.ordinal()];
                        switch (var5_4) {
                            case 2: {
                                v0 = R.anim.balloon_heartbeat_bottom;
                                break block19;
                            }
                            case 1: {
                                v0 = R.anim.balloon_heartbeat_top;
                                break block19;
                            }
                            case 3: {
                                v0 = R.anim.balloon_heartbeat_right;
                                break block19;
                            }
                            case 4: {
                                v0 = R.anim.balloon_heartbeat_left;
                                break block19;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
lbl24:
                        // 1 sources

                        v0 = R.anim.balloon_heartbeat_center;
                        break block19;
                    }
                    case 2: {
                        var4_3 = this.builder.getArrowOrientation();
                        var5_4 = WhenMappings.$EnumSwitchMapping$0[var4_3.ordinal()];
                        switch (var5_4) {
                            case 2: {
                                v0 = R.anim.balloon_shake_bottom;
                                break block19;
                            }
                            case 1: {
                                v0 = R.anim.balloon_shake_top;
                                break block19;
                            }
                            case 3: {
                                v0 = R.anim.balloon_shake_right;
                                break block19;
                            }
                            case 4: {
                                v0 = R.anim.balloon_shake_left;
                                break block19;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    case 3: {
                        v0 = R.anim.balloon_fade;
                        break block19;
                    }
                    case 4: {
                        return this.builder.getBalloonRotateAnimation();
                    }
                    default: {
                        return null;
                    }
                }
            }
            v0 = this.builder.getBalloonHighlightAnimationStyle();
        }
        animRes = v0;
        return AnimationUtils.loadAnimation((Context)this.context, (int)animRes);
    }

    private final void startBalloonHighlightAnimation() {
        this.binding.balloon.post(() -> Balloon.startBalloonHighlightAnimation$lambda-22(this));
    }

    private final void stopBalloonHighlightAnimation() {
        FrameLayout frameLayout = this.binding.balloon;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout $this$stopBalloonHighlightAnimation_u24lambda_u2d24 = frameLayout;
        boolean bl3 = false;
        Animation animation = $this$stopBalloonHighlightAnimation_u24lambda_u2d24.getAnimation();
        if (animation != null) {
            Animation animation2 = animation;
            boolean bl4 = false;
            boolean bl5 = false;
            Animation $this$stopBalloonHighlightAnimation_u24lambda_u2d24_u24lambda_u2d23 = animation2;
            boolean bl6 = false;
            $this$stopBalloonHighlightAnimation_u24lambda_u2d24_u24lambda_u2d23.cancel();
            $this$stopBalloonHighlightAnimation_u24lambda_u2d24_u24lambda_u2d23.reset();
        }
        $this$stopBalloonHighlightAnimation_u24lambda_u2d24.clearAnimation();
    }

    public final boolean shouldShowUp() {
        boolean bl;
        String string = this.builder.getPreferenceName();
        if (string == null) {
            bl = true;
        } else {
            boolean bl2;
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it = string2;
            boolean bl5 = false;
            bl = bl2 = this.getBalloonPersistence().shouldShowUp(it, this.builder.getShowTimes());
        }
        return bl;
    }

    @MainThread
    private final void show(View anchor, Function0<Unit> block) {
        boolean $i$f$show = false;
        if (this.canShowBalloonWindow(anchor)) {
            anchor.post(new Runnable(this, anchor, block){
                final /* synthetic */ Balloon this$0;
                final /* synthetic */ View $anchor;
                final /* synthetic */ Function0<Unit> $block;
                {
                    this.this$0 = $receiver;
                    this.$anchor = $anchor;
                    this.$block = $block;
                }

                public final void run() {
                    Object object;
                    Object object2 = Balloon.access$canShowBalloonWindow(this.this$0, this.$anchor);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean it = (Boolean)object2;
                    boolean bl3 = false;
                    Object object3 = object = it ? object2 : null;
                    if (object == null) {
                        return;
                    }
                    ((Boolean)object).booleanValue();
                    object = Balloon.access$getBuilder$p(this.this$0).getPreferenceName();
                    if (object != null) {
                        object2 = object;
                        Balloon balloon2 = this.this$0;
                        bl2 = false;
                        boolean bl4 = false;
                        Object it2 = object2;
                        boolean bl5 = false;
                        if (Balloon.access$getBalloonPersistence(balloon2).shouldShowUp((String)it2, Balloon.access$getBuilder$p(balloon2).getShowTimes())) {
                            Balloon.access$getBalloonPersistence(balloon2).putIncrementedCounts((String)it2);
                        } else {
                            Function0<Unit> function0 = Balloon.access$getBuilder$p(balloon2).getRunIfReachedShowCounts();
                            if (function0 != null) {
                                function0.invoke();
                            }
                            return;
                        }
                    }
                    Balloon.access$setShowing$p(this.this$0, true);
                    long dismissDelay = Balloon.access$getBuilder$p(this.this$0).getAutoDismissDuration();
                    if (dismissDelay != -1L) {
                        this.this$0.dismissWithDelay(dismissDelay);
                    }
                    if (Balloon.access$hasCustomLayout(this.this$0)) {
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        Balloon.access$traverseAndMeasureTextWidth(this.this$0, (ViewGroup)radiusLayout);
                    } else {
                        Object object4 = Balloon.access$getBinding$p((Balloon)this.this$0).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonText");
                        TextView textView = (TextView)object4;
                        object4 = Balloon.access$getBinding$p((Balloon)this.this$0).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonCard");
                        Balloon.access$measureTextWidth(this.this$0, textView, (View)object4);
                    }
                    Balloon.access$getBinding$p(this.this$0).getRoot().measure(0, 0);
                    this.this$0.getBodyWindow().setWidth(this.this$0.getMeasuredWidth());
                    this.this$0.getBodyWindow().setHeight(this.this$0.getMeasuredHeight());
                    Balloon.access$getBinding$p((Balloon)this.this$0).balloonText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    Balloon.access$initializeArrow(this.this$0, this.$anchor);
                    Balloon.access$initializeBalloonContent(this.this$0);
                    Balloon.access$applyBalloonOverlayAnimation(this.this$0);
                    Balloon.access$showOverlayWindow(this.this$0, this.$anchor);
                    Balloon.access$passTouchEventToAnchor(this.this$0, this.$anchor);
                    Balloon.access$applyBalloonAnimation(this.this$0);
                    Balloon.access$startBalloonHighlightAnimation(this.this$0);
                    this.$block.invoke();
                }
            });
        } else if (this.builder.getDismissWhenShowAgain()) {
            this.dismiss();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canShowBalloonWindow(View anchor) {
        if (this.isShowing) return false;
        if (this.destroyed) return false;
        Context $this$isFinishing$iv = this.context;
        boolean $i$f$isFinishing = false;
        if ($this$isFinishing$iv instanceof Activity && ((Activity)$this$isFinishing$iv).isFinishing()) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        if (this.bodyWindow.getContentView().getParent() != null) return false;
        if (!ViewCompat.isAttachedToWindow((View)anchor)) return false;
        return true;
    }

    private final void showOverlayWindow(View anchor) {
        if (this.builder.isVisibleOverlay()) {
            this.overlayBinding.balloonOverlayView.setAnchorView(anchor);
            this.overlayWindow.showAtLocation(anchor, 17, 0, 0);
        }
    }

    @MainThread
    private final Balloon relay(Balloon balloon2, Function1<? super Balloon, Unit> block) {
        boolean $i$f$relay = false;
        this.setOnBalloonDismissListener((Function0)new Function0<Unit>(this, block, balloon2){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Function1<Balloon, Unit> $block;
            final /* synthetic */ Balloon $balloon;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                this.$balloon = $balloon;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    this.$block.invoke((Object)this.$balloon);
                }
            }
        });
        return balloon2;
    }

    @JvmOverloads
    public final void showAtCenter(@NotNull View anchor, int xOff, int yOff, @NotNull BalloonCenterAlign centerAlign) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)((Object)centerAlign), (String)"centerAlign");
        int halfAnchorWidth = MathKt.roundToInt((float)((float)anchor.getMeasuredWidth() * 0.5f));
        int halfAnchorHeight = MathKt.roundToInt((float)((float)anchor.getMeasuredHeight() * 0.5f));
        int halfBalloonWidth = MathKt.roundToInt((float)((float)this.getMeasuredWidth() * 0.5f));
        int halfBalloonHeight = MathKt.roundToInt((float)((float)this.getMeasuredHeight() * 0.5f));
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (this_$iv.canShowBalloonWindow(anchor)) {
            anchor.post(new Runnable(this_$iv, anchor, centerAlign, this, anchor, halfAnchorWidth, halfBalloonWidth, xOff, halfAnchorHeight, yOff, halfBalloonHeight){
                final /* synthetic */ Balloon this$0$inline_fun;
                final /* synthetic */ View $anchor;
                final /* synthetic */ BalloonCenterAlign $centerAlign$inlined;
                final /* synthetic */ Balloon this$0;
                final /* synthetic */ View $anchor$inlined;
                final /* synthetic */ int $halfAnchorWidth$inlined;
                final /* synthetic */ int $halfBalloonWidth$inlined;
                final /* synthetic */ int $xOff$inlined;
                final /* synthetic */ int $halfAnchorHeight$inlined;
                final /* synthetic */ int $yOff$inlined;
                final /* synthetic */ int $halfBalloonHeight$inlined;
                {
                    this.this$0$inline_fun = $receiver;
                    this.$anchor = $anchor;
                    this.$centerAlign$inlined = balloonCenterAlign;
                    this.this$0 = balloon2;
                    this.$anchor$inlined = view;
                    this.$halfAnchorWidth$inlined = n;
                    this.$halfBalloonWidth$inlined = n2;
                    this.$xOff$inlined = n3;
                    this.$halfAnchorHeight$inlined = n4;
                    this.$yOff$inlined = n5;
                    this.$halfBalloonHeight$inlined = n6;
                }

                public final void run() {
                    Object object;
                    Object object2 = Balloon.access$canShowBalloonWindow(this.this$0$inline_fun, this.$anchor);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean it = (Boolean)object2;
                    boolean bl3 = false;
                    Object object3 = object = it ? object2 : null;
                    if (object == null) {
                        return;
                    }
                    ((Boolean)object).booleanValue();
                    object = Balloon.access$getBuilder$p(this.this$0$inline_fun).getPreferenceName();
                    if (object != null) {
                        object2 = object;
                        Balloon balloon2 = this.this$0$inline_fun;
                        bl2 = false;
                        boolean bl4 = false;
                        Object it2 = object2;
                        boolean bl5 = false;
                        if (Balloon.access$getBalloonPersistence(balloon2).shouldShowUp((String)it2, Balloon.access$getBuilder$p(balloon2).getShowTimes())) {
                            Balloon.access$getBalloonPersistence(balloon2).putIncrementedCounts((String)it2);
                        } else {
                            Function0<Unit> function0 = Balloon.access$getBuilder$p(balloon2).getRunIfReachedShowCounts();
                            if (function0 != null) {
                                function0.invoke();
                            }
                            return;
                        }
                    }
                    Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                    long dismissDelay = Balloon.access$getBuilder$p(this.this$0$inline_fun).getAutoDismissDuration();
                    if (dismissDelay != -1L) {
                        this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                    }
                    if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                    } else {
                        Object object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonText");
                        TextView textView = (TextView)object4;
                        object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonCard");
                        Balloon.access$measureTextWidth(this.this$0$inline_fun, textView, (View)object4);
                    }
                    Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                    this.this$0$inline_fun.getBodyWindow().setWidth(this.this$0$inline_fun.getMeasuredWidth());
                    this.this$0$inline_fun.getBodyWindow().setHeight(this.this$0$inline_fun.getMeasuredHeight());
                    Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                    Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                    Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$passTouchEventToAnchor(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                    Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                    boolean bl6 = false;
                    BalloonCenterAlign balloonCenterAlign = this.$centerAlign$inlined;
                    int n = WhenMappings.$EnumSwitchMapping$5[balloonCenterAlign.ordinal()];
                    switch (n) {
                        case 1: {
                            this.this$0.getBodyWindow().showAsDropDown(this.$anchor$inlined, Balloon.access$getBuilder$p(this.this$0).getSupportRtlLayoutFactor() * (this.$halfAnchorWidth$inlined - this.$halfBalloonWidth$inlined + this.$xOff$inlined), -(this.this$0.getMeasuredHeight() + this.$halfAnchorHeight$inlined) + this.$yOff$inlined);
                            break;
                        }
                        case 2: {
                            this.this$0.getBodyWindow().showAsDropDown(this.$anchor$inlined, Balloon.access$getBuilder$p(this.this$0).getSupportRtlLayoutFactor() * (this.$halfAnchorWidth$inlined - this.$halfBalloonWidth$inlined + this.$xOff$inlined), -this.$halfBalloonHeight$inlined + this.$halfAnchorWidth$inlined + this.$yOff$inlined);
                            break;
                        }
                        case 3: {
                            this.this$0.getBodyWindow().showAsDropDown(this.$anchor$inlined, Balloon.access$getBuilder$p(this.this$0).getSupportRtlLayoutFactor() * (this.$halfAnchorWidth$inlined - this.this$0.getMeasuredWidth() + this.$xOff$inlined), -this.this$0.getMeasuredHeight() + this.$halfAnchorHeight$inlined + this.$yOff$inlined);
                            break;
                        }
                        case 4: {
                            this.this$0.getBodyWindow().showAsDropDown(this.$anchor$inlined, Balloon.access$getBuilder$p(this.this$0).getSupportRtlLayoutFactor() * (this.$halfAnchorWidth$inlined + this.this$0.getMeasuredWidth() + this.$xOff$inlined), -this.this$0.getMeasuredHeight() + this.$halfAnchorHeight$inlined + this.$yOff$inlined);
                        }
                    }
                }
            });
        } else if (this_$iv.builder.getDismissWhenShowAgain()) {
            this_$iv.dismiss();
        }
    }

    public static /* synthetic */ void showAtCenter$default(Balloon balloon2, View view, int n, int n2, BalloonCenterAlign balloonCenterAlign, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            balloonCenterAlign = BalloonCenterAlign.TOP;
        }
        balloon2.showAtCenter(view, n, n2, balloonCenterAlign);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAtCenter(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff, @NotNull BalloonCenterAlign centerAlign) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)((Object)centerAlign), (String)"centerAlign");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff, centerAlign){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            final /* synthetic */ BalloonCenterAlign $centerAlign$inlined;
            {
                this.this$0 = $receiver;
                this.$balloon = $balloon;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                this.$centerAlign$inlined = balloonCenterAlign;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAtCenter(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined, this.$centerAlign$inlined);
                }
            }
        });
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAtCenter$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, BalloonCenterAlign balloonCenterAlign, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x10) != 0) {
            balloonCenterAlign = BalloonCenterAlign.TOP;
        }
        return balloon2.relayShowAtCenter(balloon3, view, n, n2, balloonCenterAlign);
    }

    @JvmOverloads
    public final void showAsDropDown(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (this_$iv.canShowBalloonWindow(anchor)) {
            anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                final /* synthetic */ Balloon this$0$inline_fun;
                final /* synthetic */ View $anchor;
                final /* synthetic */ Balloon this$0;
                final /* synthetic */ View $anchor$inlined;
                final /* synthetic */ int $xOff$inlined;
                final /* synthetic */ int $yOff$inlined;
                {
                    this.this$0$inline_fun = $receiver;
                    this.$anchor = $anchor;
                    this.this$0 = balloon2;
                    this.$anchor$inlined = view;
                    this.$xOff$inlined = n;
                    this.$yOff$inlined = n2;
                }

                public final void run() {
                    Object object;
                    Object object2 = Balloon.access$canShowBalloonWindow(this.this$0$inline_fun, this.$anchor);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean it = (Boolean)object2;
                    boolean bl3 = false;
                    Object object3 = object = it ? object2 : null;
                    if (object == null) {
                        return;
                    }
                    ((Boolean)object).booleanValue();
                    object = Balloon.access$getBuilder$p(this.this$0$inline_fun).getPreferenceName();
                    if (object != null) {
                        object2 = object;
                        Balloon balloon2 = this.this$0$inline_fun;
                        bl2 = false;
                        boolean bl4 = false;
                        Object it2 = object2;
                        boolean bl5 = false;
                        if (Balloon.access$getBalloonPersistence(balloon2).shouldShowUp((String)it2, Balloon.access$getBuilder$p(balloon2).getShowTimes())) {
                            Balloon.access$getBalloonPersistence(balloon2).putIncrementedCounts((String)it2);
                        } else {
                            Function0<Unit> function0 = Balloon.access$getBuilder$p(balloon2).getRunIfReachedShowCounts();
                            if (function0 != null) {
                                function0.invoke();
                            }
                            return;
                        }
                    }
                    Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                    long dismissDelay = Balloon.access$getBuilder$p(this.this$0$inline_fun).getAutoDismissDuration();
                    if (dismissDelay != -1L) {
                        this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                    }
                    if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                    } else {
                        Object object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonText");
                        TextView textView = (TextView)object4;
                        object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonCard");
                        Balloon.access$measureTextWidth(this.this$0$inline_fun, textView, (View)object4);
                    }
                    Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                    this.this$0$inline_fun.getBodyWindow().setWidth(this.this$0$inline_fun.getMeasuredWidth());
                    this.this$0$inline_fun.getBodyWindow().setHeight(this.this$0$inline_fun.getMeasuredHeight());
                    Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                    Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                    Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$passTouchEventToAnchor(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                    Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                    boolean bl6 = false;
                    this.this$0.getBodyWindow().showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            });
        } else if (this_$iv.builder.getDismissWhenShowAgain()) {
            this_$iv.dismiss();
        }
    }

    public static /* synthetic */ void showAsDropDown$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAsDropDown(view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAsDropDown(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = $receiver;
                this.$balloon = $balloon;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAsDropDown(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        });
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAsDropDown$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShowAsDropDown(balloon3, view, n, n2);
    }

    @JvmOverloads
    public final void showAlignTop(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (this_$iv.canShowBalloonWindow(anchor)) {
            anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                final /* synthetic */ Balloon this$0$inline_fun;
                final /* synthetic */ View $anchor;
                final /* synthetic */ Balloon this$0;
                final /* synthetic */ View $anchor$inlined;
                final /* synthetic */ int $xOff$inlined;
                final /* synthetic */ int $yOff$inlined;
                {
                    this.this$0$inline_fun = $receiver;
                    this.$anchor = $anchor;
                    this.this$0 = balloon2;
                    this.$anchor$inlined = view;
                    this.$xOff$inlined = n;
                    this.$yOff$inlined = n2;
                }

                public final void run() {
                    Object object;
                    Object object2 = Balloon.access$canShowBalloonWindow(this.this$0$inline_fun, this.$anchor);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean it = (Boolean)object2;
                    boolean bl3 = false;
                    Object object3 = object = it ? object2 : null;
                    if (object == null) {
                        return;
                    }
                    ((Boolean)object).booleanValue();
                    object = Balloon.access$getBuilder$p(this.this$0$inline_fun).getPreferenceName();
                    if (object != null) {
                        object2 = object;
                        Balloon balloon2 = this.this$0$inline_fun;
                        bl2 = false;
                        boolean bl4 = false;
                        Object it2 = object2;
                        boolean bl5 = false;
                        if (Balloon.access$getBalloonPersistence(balloon2).shouldShowUp((String)it2, Balloon.access$getBuilder$p(balloon2).getShowTimes())) {
                            Balloon.access$getBalloonPersistence(balloon2).putIncrementedCounts((String)it2);
                        } else {
                            Function0<Unit> function0 = Balloon.access$getBuilder$p(balloon2).getRunIfReachedShowCounts();
                            if (function0 != null) {
                                function0.invoke();
                            }
                            return;
                        }
                    }
                    Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                    long dismissDelay = Balloon.access$getBuilder$p(this.this$0$inline_fun).getAutoDismissDuration();
                    if (dismissDelay != -1L) {
                        this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                    }
                    if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                    } else {
                        Object object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonText");
                        TextView textView = (TextView)object4;
                        object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonCard");
                        Balloon.access$measureTextWidth(this.this$0$inline_fun, textView, (View)object4);
                    }
                    Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                    this.this$0$inline_fun.getBodyWindow().setWidth(this.this$0$inline_fun.getMeasuredWidth());
                    this.this$0$inline_fun.getBodyWindow().setHeight(this.this$0$inline_fun.getMeasuredHeight());
                    Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                    Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                    Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$passTouchEventToAnchor(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                    Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                    boolean bl6 = false;
                    this.this$0.getBodyWindow().showAsDropDown(this.$anchor$inlined, Balloon.access$getBuilder$p(this.this$0).getSupportRtlLayoutFactor() * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasuredWidth() / 2 + this.$xOff$inlined), -this.this$0.getMeasuredHeight() - this.$anchor$inlined.getMeasuredHeight() + this.$yOff$inlined);
                }
            });
        } else if (this_$iv.builder.getDismissWhenShowAgain()) {
            this_$iv.dismiss();
        }
    }

    public static /* synthetic */ void showAlignTop$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAlignTop(view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignTop(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = $receiver;
                this.$balloon = $balloon;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignTop(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        });
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAlignTop$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShowAlignTop(balloon3, view, n, n2);
    }

    @JvmOverloads
    public final void showAlignBottom(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (this_$iv.canShowBalloonWindow(anchor)) {
            anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                final /* synthetic */ Balloon this$0$inline_fun;
                final /* synthetic */ View $anchor;
                final /* synthetic */ Balloon this$0;
                final /* synthetic */ View $anchor$inlined;
                final /* synthetic */ int $xOff$inlined;
                final /* synthetic */ int $yOff$inlined;
                {
                    this.this$0$inline_fun = $receiver;
                    this.$anchor = $anchor;
                    this.this$0 = balloon2;
                    this.$anchor$inlined = view;
                    this.$xOff$inlined = n;
                    this.$yOff$inlined = n2;
                }

                public final void run() {
                    Object object;
                    Object object2 = Balloon.access$canShowBalloonWindow(this.this$0$inline_fun, this.$anchor);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean it = (Boolean)object2;
                    boolean bl3 = false;
                    Object object3 = object = it ? object2 : null;
                    if (object == null) {
                        return;
                    }
                    ((Boolean)object).booleanValue();
                    object = Balloon.access$getBuilder$p(this.this$0$inline_fun).getPreferenceName();
                    if (object != null) {
                        object2 = object;
                        Balloon balloon2 = this.this$0$inline_fun;
                        bl2 = false;
                        boolean bl4 = false;
                        Object it2 = object2;
                        boolean bl5 = false;
                        if (Balloon.access$getBalloonPersistence(balloon2).shouldShowUp((String)it2, Balloon.access$getBuilder$p(balloon2).getShowTimes())) {
                            Balloon.access$getBalloonPersistence(balloon2).putIncrementedCounts((String)it2);
                        } else {
                            Function0<Unit> function0 = Balloon.access$getBuilder$p(balloon2).getRunIfReachedShowCounts();
                            if (function0 != null) {
                                function0.invoke();
                            }
                            return;
                        }
                    }
                    Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                    long dismissDelay = Balloon.access$getBuilder$p(this.this$0$inline_fun).getAutoDismissDuration();
                    if (dismissDelay != -1L) {
                        this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                    }
                    if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                    } else {
                        Object object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonText");
                        TextView textView = (TextView)object4;
                        object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonCard");
                        Balloon.access$measureTextWidth(this.this$0$inline_fun, textView, (View)object4);
                    }
                    Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                    this.this$0$inline_fun.getBodyWindow().setWidth(this.this$0$inline_fun.getMeasuredWidth());
                    this.this$0$inline_fun.getBodyWindow().setHeight(this.this$0$inline_fun.getMeasuredHeight());
                    Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                    Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                    Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$passTouchEventToAnchor(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                    Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                    boolean bl6 = false;
                    this.this$0.getBodyWindow().showAsDropDown(this.$anchor$inlined, Balloon.access$getBuilder$p(this.this$0).getSupportRtlLayoutFactor() * (this.$anchor$inlined.getMeasuredWidth() / 2 - this.this$0.getMeasuredWidth() / 2 + this.$xOff$inlined), this.$yOff$inlined);
                }
            });
        } else if (this_$iv.builder.getDismissWhenShowAgain()) {
            this_$iv.dismiss();
        }
    }

    public static /* synthetic */ void showAlignBottom$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAlignBottom(view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignBottom(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = $receiver;
                this.$balloon = $balloon;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignBottom(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        });
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAlignBottom$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShowAlignBottom(balloon3, view, n, n2);
    }

    @JvmOverloads
    public final void showAlignRight(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (this_$iv.canShowBalloonWindow(anchor)) {
            anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                final /* synthetic */ Balloon this$0$inline_fun;
                final /* synthetic */ View $anchor;
                final /* synthetic */ Balloon this$0;
                final /* synthetic */ View $anchor$inlined;
                final /* synthetic */ int $xOff$inlined;
                final /* synthetic */ int $yOff$inlined;
                {
                    this.this$0$inline_fun = $receiver;
                    this.$anchor = $anchor;
                    this.this$0 = balloon2;
                    this.$anchor$inlined = view;
                    this.$xOff$inlined = n;
                    this.$yOff$inlined = n2;
                }

                public final void run() {
                    Object object;
                    Object object2 = Balloon.access$canShowBalloonWindow(this.this$0$inline_fun, this.$anchor);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean it = (Boolean)object2;
                    boolean bl3 = false;
                    Object object3 = object = it ? object2 : null;
                    if (object == null) {
                        return;
                    }
                    ((Boolean)object).booleanValue();
                    object = Balloon.access$getBuilder$p(this.this$0$inline_fun).getPreferenceName();
                    if (object != null) {
                        object2 = object;
                        Balloon balloon2 = this.this$0$inline_fun;
                        bl2 = false;
                        boolean bl4 = false;
                        Object it2 = object2;
                        boolean bl5 = false;
                        if (Balloon.access$getBalloonPersistence(balloon2).shouldShowUp((String)it2, Balloon.access$getBuilder$p(balloon2).getShowTimes())) {
                            Balloon.access$getBalloonPersistence(balloon2).putIncrementedCounts((String)it2);
                        } else {
                            Function0<Unit> function0 = Balloon.access$getBuilder$p(balloon2).getRunIfReachedShowCounts();
                            if (function0 != null) {
                                function0.invoke();
                            }
                            return;
                        }
                    }
                    Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                    long dismissDelay = Balloon.access$getBuilder$p(this.this$0$inline_fun).getAutoDismissDuration();
                    if (dismissDelay != -1L) {
                        this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                    }
                    if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                    } else {
                        Object object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonText");
                        TextView textView = (TextView)object4;
                        object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonCard");
                        Balloon.access$measureTextWidth(this.this$0$inline_fun, textView, (View)object4);
                    }
                    Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                    this.this$0$inline_fun.getBodyWindow().setWidth(this.this$0$inline_fun.getMeasuredWidth());
                    this.this$0$inline_fun.getBodyWindow().setHeight(this.this$0$inline_fun.getMeasuredHeight());
                    Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                    Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                    Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$passTouchEventToAnchor(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                    Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                    boolean bl6 = false;
                    this.this$0.getBodyWindow().showAsDropDown(this.$anchor$inlined, this.$anchor$inlined.getMeasuredWidth() + this.$xOff$inlined, -(this.this$0.getMeasuredHeight() / 2) - this.$anchor$inlined.getMeasuredHeight() / 2 + this.$yOff$inlined);
                }
            });
        } else if (this_$iv.builder.getDismissWhenShowAgain()) {
            this_$iv.dismiss();
        }
    }

    public static /* synthetic */ void showAlignRight$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAlignRight(view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignRight(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = $receiver;
                this.$balloon = $balloon;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignRight(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        });
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAlignRight$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShowAlignRight(balloon3, view, n, n2);
    }

    @JvmOverloads
    public final void showAlignLeft(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$show = false;
        if (this_$iv.canShowBalloonWindow(anchor)) {
            anchor.post(new Runnable(this_$iv, anchor, this, anchor, xOff, yOff){
                final /* synthetic */ Balloon this$0$inline_fun;
                final /* synthetic */ View $anchor;
                final /* synthetic */ Balloon this$0;
                final /* synthetic */ View $anchor$inlined;
                final /* synthetic */ int $xOff$inlined;
                final /* synthetic */ int $yOff$inlined;
                {
                    this.this$0$inline_fun = $receiver;
                    this.$anchor = $anchor;
                    this.this$0 = balloon2;
                    this.$anchor$inlined = view;
                    this.$xOff$inlined = n;
                    this.$yOff$inlined = n2;
                }

                public final void run() {
                    Object object;
                    Object object2 = Balloon.access$canShowBalloonWindow(this.this$0$inline_fun, this.$anchor);
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean it = (Boolean)object2;
                    boolean bl3 = false;
                    Object object3 = object = it ? object2 : null;
                    if (object == null) {
                        return;
                    }
                    ((Boolean)object).booleanValue();
                    object = Balloon.access$getBuilder$p(this.this$0$inline_fun).getPreferenceName();
                    if (object != null) {
                        object2 = object;
                        Balloon balloon2 = this.this$0$inline_fun;
                        bl2 = false;
                        boolean bl4 = false;
                        Object it2 = object2;
                        boolean bl5 = false;
                        if (Balloon.access$getBalloonPersistence(balloon2).shouldShowUp((String)it2, Balloon.access$getBuilder$p(balloon2).getShowTimes())) {
                            Balloon.access$getBalloonPersistence(balloon2).putIncrementedCounts((String)it2);
                        } else {
                            Function0<Unit> function0 = Balloon.access$getBuilder$p(balloon2).getRunIfReachedShowCounts();
                            if (function0 != null) {
                                function0.invoke();
                            }
                            return;
                        }
                    }
                    Balloon.access$setShowing$p(this.this$0$inline_fun, true);
                    long dismissDelay = Balloon.access$getBuilder$p(this.this$0$inline_fun).getAutoDismissDuration();
                    if (dismissDelay != -1L) {
                        this.this$0$inline_fun.dismissWithDelay(dismissDelay);
                    }
                    if (Balloon.access$hasCustomLayout(this.this$0$inline_fun)) {
                        RadiusLayout radiusLayout = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
                        Balloon.access$traverseAndMeasureTextWidth(this.this$0$inline_fun, (ViewGroup)radiusLayout);
                    } else {
                        Object object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonText");
                        TextView textView = (TextView)object4;
                        object4 = Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonCard;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"binding.balloonCard");
                        Balloon.access$measureTextWidth(this.this$0$inline_fun, textView, (View)object4);
                    }
                    Balloon.access$getBinding$p(this.this$0$inline_fun).getRoot().measure(0, 0);
                    this.this$0$inline_fun.getBodyWindow().setWidth(this.this$0$inline_fun.getMeasuredWidth());
                    this.this$0$inline_fun.getBodyWindow().setHeight(this.this$0$inline_fun.getMeasuredHeight());
                    Balloon.access$getBinding$p((Balloon)this.this$0$inline_fun).balloonText.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    Balloon.access$initializeArrow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$initializeBalloonContent(this.this$0$inline_fun);
                    Balloon.access$applyBalloonOverlayAnimation(this.this$0$inline_fun);
                    Balloon.access$showOverlayWindow(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$passTouchEventToAnchor(this.this$0$inline_fun, this.$anchor);
                    Balloon.access$applyBalloonAnimation(this.this$0$inline_fun);
                    Balloon.access$startBalloonHighlightAnimation(this.this$0$inline_fun);
                    boolean bl6 = false;
                    this.this$0.getBodyWindow().showAsDropDown(this.$anchor$inlined, -this.this$0.getMeasuredWidth() + this.$xOff$inlined, -(this.this$0.getMeasuredHeight() / 2) - this.$anchor$inlined.getMeasuredHeight() / 2 + this.$yOff$inlined);
                }
            });
        } else if (this_$iv.builder.getDismissWhenShowAgain()) {
            this_$iv.dismiss();
        }
    }

    public static /* synthetic */ void showAlignLeft$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.showAlignLeft(view, n, n2);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignLeft(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$relay = false;
        this_$iv.setOnBalloonDismissListener((Function0)new Function0<Unit>(this_$iv, balloon2, anchor, xOff, yOff){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ Balloon $balloon;
            final /* synthetic */ View $anchor$inlined;
            final /* synthetic */ int $xOff$inlined;
            final /* synthetic */ int $yOff$inlined;
            {
                this.this$0 = $receiver;
                this.$balloon = $balloon;
                this.$anchor$inlined = view;
                this.$xOff$inlined = n;
                this.$yOff$inlined = n2;
                super(0);
            }

            public final void invoke() {
                if (!Balloon.access$getDestroyed$p(this.this$0)) {
                    Balloon it = this.$balloon;
                    boolean bl = false;
                    it.showAlignLeft(this.$anchor$inlined, this.$xOff$inlined, this.$yOff$inlined);
                }
            }
        });
        return balloon2;
    }

    public static /* synthetic */ Balloon relayShowAlignLeft$default(Balloon balloon2, Balloon balloon3, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        return balloon2.relayShowAlignLeft(balloon3, view, n, n2);
    }

    @JvmOverloads
    public final void update(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon this_$iv = this;
        boolean $i$f$update = false;
        if (this_$iv.isShowing()) {
            this_$iv.initializeArrow(anchor);
            boolean bl = false;
            this.getBodyWindow().update(anchor, xOff, yOff, this.getMeasuredWidth(), this.getMeasuredHeight());
            if (this.builder.isVisibleOverlay()) {
                ((Balloon)this).overlayBinding.balloonOverlayView.forceInvalidate();
            }
        }
    }

    public static /* synthetic */ void update$default(Balloon balloon2, View view, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        balloon2.update(view, n, n2);
    }

    @MainThread
    private final void update(View anchor, Function0<Unit> block) {
        boolean $i$f$update = false;
        if (this.isShowing()) {
            this.initializeArrow(anchor);
            block.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dismiss() {
        if (this.isShowing) {
            Function0 dismissWindow2 = (Function0)new Function0<Unit>(this){
                final /* synthetic */ Balloon this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Balloon.access$setShowing$p(this.this$0, false);
                    this.this$0.getBodyWindow().dismiss();
                    this.this$0.getOverlayWindow().dismiss();
                    Balloon.access$getHandler(this.this$0).removeCallbacks((Runnable)Balloon.access$getAutoDismissRunnable(this.this$0));
                }
            };
            if (this.builder.getBalloonAnimation() == BalloonAnimation.CIRCULAR) {
                View view = this.bodyWindow.getContentView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"this.bodyWindow.contentView");
                long circularDuration$iv = this.builder.getCircularDuration();
                boolean $i$f$circularUnRevealed = false;
                boolean $i$f$runOnAfterSDK21 = false;
                if (Build.VERSION.SDK_INT >= 21) {
                    void $this$circularUnRevealed$iv;
                    boolean bl = false;
                    $this$circularUnRevealed$iv.post(new Runnable((View)$this$circularUnRevealed$iv, circularDuration$iv, dismissWindow2){
                        final /* synthetic */ View $this_circularUnRevealed;
                        final /* synthetic */ long $circularDuration;
                        final /* synthetic */ Function0 $dismissWindow$inlined;
                        {
                            this.$this_circularUnRevealed = $receiver;
                            this.$circularDuration = $circularDuration;
                            this.$dismissWindow$inlined = function0;
                        }

                        public final void run() {
                            if (this.$this_circularUnRevealed.isAttachedToWindow()) {
                                int n = this.$this_circularUnRevealed.getWidth();
                                int n2 = this.$this_circularUnRevealed.getHeight();
                                boolean bl = false;
                                Animator animator = ViewAnimationUtils.createCircularReveal((View)this.$this_circularUnRevealed, (int)((this.$this_circularUnRevealed.getLeft() + this.$this_circularUnRevealed.getRight()) / 2), (int)((this.$this_circularUnRevealed.getTop() + this.$this_circularUnRevealed.getBottom()) / 2), (float)Math.max(n, n2), (float)0.0f);
                                long l = this.$circularDuration;
                                boolean bl2 = false;
                                boolean bl3 = false;
                                Animator $this$run_u24lambda_u2d0 = animator;
                                boolean bl4 = false;
                                $this$run_u24lambda_u2d0.setDuration(l);
                                $this$run_u24lambda_u2d0.start();
                                animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this.$dismissWindow$inlined){
                                    final /* synthetic */ Function0 $dismissWindow$inlined;
                                    {
                                        this.$dismissWindow$inlined = function0;
                                    }

                                    public void onAnimationEnd(@Nullable Animator animation) {
                                        super.onAnimationEnd(animation);
                                        boolean bl = false;
                                        this.$dismissWindow$inlined.invoke();
                                    }
                                });
                            }
                        }
                    });
                }
            } else {
                dismissWindow2.invoke();
            }
        }
    }

    public final boolean dismissWithDelay(long delay) {
        return this.getHandler().postDelayed((Runnable)this.getAutoDismissRunnable(), delay);
    }

    public final void setOnBalloonClickListener(@Nullable OnBalloonClickListener onBalloonClickListener) {
        this.binding.balloonWrapper.setOnClickListener(arg_0 -> Balloon.setOnBalloonClickListener$lambda-40(onBalloonClickListener, this, arg_0));
    }

    public final void clearAllPreferences() {
        this.getBalloonPersistence().clearAllPreferences();
    }

    public final /* synthetic */ void setOnBalloonClickListener(Function1 block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.setOnBalloonClickListener(new OnBalloonClickListener(block){
            private final /* synthetic */ Function1 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void onBalloonClick(View view) {
                this.function.invoke((Object)view);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof OnBalloonClickListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    public final void setOnBalloonInitializedListener(@Nullable OnBalloonInitializedListener onBalloonInitializedListener) {
        this.onBalloonInitializedListener = onBalloonInitializedListener;
    }

    public final /* synthetic */ void setOnBalloonInitializedListener(Function1 block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.setOnBalloonInitializedListener(new OnBalloonInitializedListener(block){
            private final /* synthetic */ Function1 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void onBalloonInitialized(View contentView) {
                this.function.invoke((Object)contentView);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof OnBalloonInitializedListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    public final void setOnBalloonDismissListener(@Nullable OnBalloonDismissListener onBalloonDismissListener) {
        this.bodyWindow.setOnDismissListener(() -> Balloon.setOnBalloonDismissListener$lambda-41(this, onBalloonDismissListener));
    }

    public final /* synthetic */ void setOnBalloonDismissListener(Function0 block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.setOnBalloonDismissListener(new OnBalloonDismissListener(block){
            private final /* synthetic */ Function0 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void onBalloonDismiss() {
                this.function.invoke();
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof OnBalloonDismissListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    public final void setOnBalloonOutsideTouchListener(@Nullable OnBalloonOutsideTouchListener onBalloonOutsideTouchListener) {
        this.bodyWindow.setTouchInterceptor(new View.OnTouchListener(this, onBalloonOutsideTouchListener){
            final /* synthetic */ Balloon this$0;
            final /* synthetic */ OnBalloonOutsideTouchListener $onBalloonOutsideTouchListener;
            {
                this.this$0 = $receiver;
                this.$onBalloonOutsideTouchListener = $onBalloonOutsideTouchListener;
            }

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getAction() == 4) {
                    OnBalloonOutsideTouchListener onBalloonOutsideTouchListener;
                    if (Balloon.access$getBuilder$p(this.this$0).getDismissWhenTouchOutside()) {
                        this.this$0.dismiss();
                    }
                    if ((onBalloonOutsideTouchListener = this.$onBalloonOutsideTouchListener) != null) {
                        onBalloonOutsideTouchListener.onBalloonOutsideTouch(view, event);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public final /* synthetic */ void setOnBalloonOutsideTouchListener(Function2 block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.setOnBalloonOutsideTouchListener(new OnBalloonOutsideTouchListener(block){
            private final /* synthetic */ Function2 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void onBalloonOutsideTouch(View view, MotionEvent event) {
                this.function.invoke((Object)view, (Object)event);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof OnBalloonOutsideTouchListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    public final void setOnBalloonTouchListener(@Nullable View.OnTouchListener onTouchListener) {
        if (onTouchListener != null) {
            this.bodyWindow.setTouchInterceptor(onTouchListener);
        }
    }

    public final void setOnBalloonOverlayTouchListener(@Nullable View.OnTouchListener onTouchListener) {
        if (onTouchListener != null) {
            this.overlayWindow.setTouchInterceptor(onTouchListener);
        }
    }

    public final void setOnBalloonOverlayTouchListener(@NotNull Function2<? super View, ? super MotionEvent, Boolean> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Function2<? super View, ? super MotionEvent, Boolean> function2 = block;
        this.setOnBalloonOverlayTouchListener((arg_0, arg_1) -> Balloon.setOnBalloonOverlayTouchListener$lambda-42(function2, arg_0, arg_1));
    }

    private final void passTouchEventToAnchor(View anchor) {
        if (!this.builder.getPassTouchEventToAnchor()) {
            return;
        }
        this.setOnBalloonOverlayTouchListener((Function2<? super View, ? super MotionEvent, Boolean>)((Function2)new Function2<View, MotionEvent, Boolean>(anchor){
            final /* synthetic */ View $anchor;
            {
                this.$anchor = $anchor;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull View view, @NotNull MotionEvent event) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                view.performClick();
                Rect rect = new Rect();
                this.$anchor.getGlobalVisibleRect(rect);
                if (rect.contains((int)event.getRawX(), (int)event.getRawY())) {
                    this.$anchor.getRootView().dispatchTouchEvent(event);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }));
    }

    public final void setOnBalloonOverlayClickListener(@Nullable OnBalloonOverlayClickListener onBalloonOverlayClickListener) {
        this.overlayBinding.getRoot().setOnClickListener(arg_0 -> Balloon.setOnBalloonOverlayClickListener$lambda-43(onBalloonOverlayClickListener, this, arg_0));
    }

    public final /* synthetic */ void setOnBalloonOverlayClickListener(Function0 block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.setOnBalloonOverlayClickListener(new OnBalloonOverlayClickListener(block){
            private final /* synthetic */ Function0 function;
            {
                this.function = function;
            }

            public final /* synthetic */ void onBalloonOverlayClick() {
                this.function.invoke();
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof OnBalloonOverlayClickListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    @NotNull
    public final Balloon setIsAttachedInDecor(boolean value2) {
        Balloon balloon2 = this;
        boolean bl = false;
        boolean bl2 = false;
        Balloon $this$setIsAttachedInDecor_u24lambda_u2d45 = balloon2;
        boolean bl3 = false;
        boolean $i$f$runOnAfterSDK22 = false;
        if (Build.VERSION.SDK_INT >= 22) {
            boolean bl4 = false;
            $this$setIsAttachedInDecor_u24lambda_u2d45.getBodyWindow().setAttachedInDecor(value2);
        }
        return balloon2;
    }

    public final int getMeasuredWidth() {
        int n;
        boolean $i$f$getDisplaySize = false;
        int displayWidth = new Point((int)Resources.getSystem().getDisplayMetrics().widthPixels, (int)Resources.getSystem().getDisplayMetrics().heightPixels).x;
        if (!(this.builder.getWidthRatio() == 0.0f)) {
            n = (int)((float)displayWidth * this.builder.getWidthRatio());
        } else if (!(this.builder.getMinWidthRatio() == 0.0f) || !(this.builder.getMaxWidthRatio() == 0.0f)) {
            float maxWidthRatio = !(this.builder.getMaxWidthRatio() == 0.0f) ? this.builder.getMaxWidthRatio() : 1.0f;
            n = RangesKt.coerceIn((int)this.binding.getRoot().getMeasuredWidth(), (int)((int)((float)displayWidth * this.builder.getMinWidthRatio())), (int)((int)((float)displayWidth * maxWidthRatio)));
        } else {
            n = this.builder.getWidth() != Integer.MIN_VALUE ? RangesKt.coerceAtMost((int)this.builder.getWidth(), (int)displayWidth) : RangesKt.coerceIn((int)this.binding.getRoot().getMeasuredWidth(), (int)this.builder.getMinWidth(), (int)this.builder.getMaxWidth());
        }
        return n;
    }

    private final void measureTextWidth(TextView textView, View rootView) {
        Drawable[] $this$sumOfCompoundPadding$iv;
        boolean bl = false;
        boolean bl2 = false;
        Drawable[] $this$measureTextWidth_u24lambda_u2d46 = textView;
        boolean bl3 = false;
        int measuredTextWidth = (int)textView.getPaint().measureText(((Object)textView.getText()).toString());
        Drawable[] drawableArray = $this$measureTextWidth_u24lambda_u2d46.getCompoundDrawablesRelative();
        Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"compoundDrawablesRelative");
        if (DrawableExtensionKt.isExistHorizontalDrawable(drawableArray)) {
            drawableArray = $this$measureTextWidth_u24lambda_u2d46.getCompoundDrawablesRelative();
            Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"compoundDrawablesRelative");
            $this$measureTextWidth_u24lambda_u2d46.setMinHeight(DrawableExtensionKt.getIntrinsicHeight(drawableArray));
            drawableArray = $this$measureTextWidth_u24lambda_u2d46.getCompoundDrawablesRelative();
            Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"compoundDrawablesRelative");
            $this$sumOfCompoundPadding$iv = $this$measureTextWidth_u24lambda_u2d46;
            boolean $i$f$getSumOfCompoundPadding = false;
            measuredTextWidth += DrawableExtensionKt.getSumOfIntrinsicWidth(drawableArray) + ($this$sumOfCompoundPadding$iv.getCompoundPaddingStart() + $this$sumOfCompoundPadding$iv.getCompoundPaddingEnd());
        } else {
            $this$sumOfCompoundPadding$iv = $this$measureTextWidth_u24lambda_u2d46.getCompoundDrawables();
            Intrinsics.checkNotNullExpressionValue((Object)$this$sumOfCompoundPadding$iv, (String)"compoundDrawables");
            if (DrawableExtensionKt.isExistHorizontalDrawable($this$sumOfCompoundPadding$iv)) {
                $this$sumOfCompoundPadding$iv = $this$measureTextWidth_u24lambda_u2d46.getCompoundDrawables();
                Intrinsics.checkNotNullExpressionValue((Object)$this$sumOfCompoundPadding$iv, (String)"compoundDrawables");
                $this$measureTextWidth_u24lambda_u2d46.setMinHeight(DrawableExtensionKt.getIntrinsicHeight($this$sumOfCompoundPadding$iv));
                $this$sumOfCompoundPadding$iv = $this$measureTextWidth_u24lambda_u2d46.getCompoundDrawables();
                Intrinsics.checkNotNullExpressionValue((Object)$this$sumOfCompoundPadding$iv, (String)"compoundDrawables");
                int n = DrawableExtensionKt.getSumOfIntrinsicWidth($this$sumOfCompoundPadding$iv);
                $this$sumOfCompoundPadding$iv = $this$measureTextWidth_u24lambda_u2d46;
                boolean $i$f$getSumOfCompoundPadding = false;
                measuredTextWidth += n + ($this$sumOfCompoundPadding$iv.getCompoundPaddingStart() + $this$sumOfCompoundPadding$iv.getCompoundPaddingEnd());
            }
        }
        $this$measureTextWidth_u24lambda_u2d46.setMaxWidth(this.getMeasuredTextWidth(measuredTextWidth, rootView));
    }

    /*
     * WARNING - void declaration
     */
    private final void traverseAndMeasureTextWidth(ViewGroup parent) {
        ViewGroup $this$forEach$iv = parent;
        boolean $i$f$forEach = false;
        int n = 0;
        int n2 = $this$forEach$iv.getChildCount();
        while (n < n2) {
            View child;
            void index$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getChildAt((int)index$iv), (String)"getChildAt(index)");
            boolean bl = false;
            if (child instanceof TextView) {
                this.measureTextWidth((TextView)child, (View)parent);
            } else if (child instanceof ViewGroup) {
                this.traverseAndMeasureTextWidth((ViewGroup)child);
            }
            ++index$iv;
        }
    }

    private final int getMeasuredTextWidth(int measuredWidth, View rootView) {
        int n;
        boolean $i$f$getDisplaySize = false;
        int displayWidth = new Point((int)Resources.getSystem().getDisplayMetrics().widthPixels, (int)Resources.getSystem().getDisplayMetrics().heightPixels).x;
        int spaces = rootView.getPaddingLeft() + rootView.getPaddingRight() + (this.builder.getIconDrawable() != null ? this.builder.getIconWidth() + this.builder.getIconSpace() : 0 + this.builder.getMarginRight() + this.builder.getMarginLeft() + this.builder.getArrowSize() * 2);
        int maxTextWidth = this.builder.getMaxWidth() - spaces;
        if (!(this.builder.getWidthRatio() == 0.0f)) {
            n = (int)((float)displayWidth * this.builder.getWidthRatio()) - spaces;
        } else if (!(this.builder.getMinWidthRatio() == 0.0f) || !(this.builder.getMaxWidthRatio() == 0.0f)) {
            float maxWidthRatio = !(this.builder.getMaxWidthRatio() == 0.0f) ? this.builder.getMaxWidthRatio() : 1.0f;
            n = RangesKt.coerceAtMost((int)measuredWidth, (int)((int)((float)displayWidth * maxWidthRatio) - spaces));
        } else {
            n = this.builder.getWidth() != Integer.MIN_VALUE && this.builder.getWidth() <= displayWidth ? this.builder.getWidth() - spaces : RangesKt.coerceAtMost((int)measuredWidth, (int)maxTextWidth);
        }
        return n;
    }

    public final int getMeasuredHeight() {
        if (this.builder.getHeight() != Integer.MIN_VALUE) {
            return this.builder.getHeight();
        }
        return this.binding.getRoot().getMeasuredHeight();
    }

    @NotNull
    public final ViewGroup getContentView() {
        RadiusLayout radiusLayout = this.binding.balloonCard;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)radiusLayout), (String)"binding.balloonCard");
        return (ViewGroup)radiusLayout;
    }

    @NotNull
    public final View getBalloonArrowView() {
        AppCompatImageView appCompatImageView = this.binding.balloonArrow;
        Intrinsics.checkNotNullExpressionValue((Object)appCompatImageView, (String)"binding.balloonArrow");
        return (View)appCompatImageView;
    }

    public void onPause(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onPause(owner);
        if (this.builder.getDismissWhenLifecycleOnPause()) {
            this.dismiss();
        }
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onDestroy(owner);
        this.destroyed = true;
        this.overlayWindow.dismiss();
        this.bodyWindow.dismiss();
    }

    @JvmOverloads
    public final void showAtCenter(@NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAtCenter$default(this, anchor, xOff, yOff, null, 8, null);
    }

    @JvmOverloads
    public final void showAtCenter(@NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAtCenter$default(this, anchor, xOff, 0, null, 12, null);
    }

    @JvmOverloads
    public final void showAtCenter(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAtCenter$default(this, anchor, 0, 0, null, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAtCenter(@NotNull Balloon balloon2, @NotNull View anchor, int xOff, int yOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAtCenter$default(this, balloon2, anchor, xOff, yOff, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAtCenter(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAtCenter$default(this, balloon2, anchor, xOff, 0, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAtCenter(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAtCenter$default(this, balloon2, anchor, 0, 0, null, 28, null);
    }

    @JvmOverloads
    public final void showAsDropDown(@NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAsDropDown$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAsDropDown(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAsDropDown$default(this, anchor, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAsDropDown(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAsDropDown$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAsDropDown(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAsDropDown$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    @JvmOverloads
    public final void showAlignTop(@NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAlignTop$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAlignTop(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAlignTop$default(this, anchor, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignTop(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAlignTop$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignTop(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAlignTop$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    @JvmOverloads
    public final void showAlignBottom(@NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAlignBottom$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAlignBottom(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAlignBottom$default(this, anchor, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignBottom(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAlignBottom$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignBottom(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAlignBottom$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    @JvmOverloads
    public final void showAlignRight(@NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAlignRight$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAlignRight(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAlignRight$default(this, anchor, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignRight(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAlignRight$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignRight(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAlignRight$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    @JvmOverloads
    public final void showAlignLeft(@NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAlignLeft$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void showAlignLeft(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.showAlignLeft$default(this, anchor, 0, 0, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignLeft(@NotNull Balloon balloon2, @NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAlignLeft$default(this, balloon2, anchor, xOff, 0, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Balloon relayShowAlignLeft(@NotNull Balloon balloon2, @NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return Balloon.relayShowAlignLeft$default(this, balloon2, anchor, 0, 0, 12, null);
    }

    @JvmOverloads
    public final void update(@NotNull View anchor, int xOff) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.update$default(this, anchor, xOff, 0, 4, null);
    }

    @JvmOverloads
    public final void update(@NotNull View anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Balloon.update$default(this, anchor, 0, 0, 6, null);
    }

    private static final void initializeArrow$lambda-5$lambda-4(Balloon this$0, View $anchor, AppCompatImageView $this_with) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$anchor, (String)"$anchor");
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Object object = this$0.onBalloonInitializedListener;
        if (object != null) {
            object.onBalloonInitialized((View)this$0.getContentView());
        }
        this$0.adjustArrowOrientationByRules($anchor);
        object = this$0.builder.getArrowOrientation();
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                $this_with.setRotation(180.0f);
                $this_with.setX(this$0.getArrowConstraintPositionX($anchor));
                $this_with.setY(this$0.binding.balloonCard.getY() + (float)this$0.binding.balloonCard.getHeight() - 1.0f);
                ViewCompat.setElevation((View)((View)$this_with), (float)this$0.builder.getArrowElevation());
                if (!this$0.builder.getArrowColorMatchBalloon()) break;
                $this_with.setForeground((Drawable)new BitmapDrawable($this_with.getResources(), this$0.adjustArrowColorByMatchingCardBackground((ImageView)$this_with, $this_with.getX(), this$0.binding.balloonCard.getHeight())));
                break;
            }
            case 2: {
                $this_with.setRotation(0.0f);
                $this_with.setX(this$0.getArrowConstraintPositionX($anchor));
                $this_with.setY(this$0.binding.balloonCard.getY() - (float)this$0.builder.getArrowSize() + 1.0f);
                if (!this$0.builder.getArrowColorMatchBalloon()) break;
                $this_with.setForeground((Drawable)new BitmapDrawable($this_with.getResources(), this$0.adjustArrowColorByMatchingCardBackground((ImageView)$this_with, $this_with.getX(), 0.0f)));
                break;
            }
            case 3: {
                $this_with.setRotation(-90.0f);
                $this_with.setX(this$0.binding.balloonCard.getX() - (float)this$0.builder.getArrowSize() + 1.0f);
                $this_with.setY(this$0.getArrowConstraintPositionY($anchor));
                if (!this$0.builder.getArrowColorMatchBalloon()) break;
                $this_with.setForeground((Drawable)new BitmapDrawable($this_with.getResources(), this$0.adjustArrowColorByMatchingCardBackground((ImageView)$this_with, 0.0f, $this_with.getY())));
                break;
            }
            case 4: {
                $this_with.setRotation(90.0f);
                $this_with.setX(this$0.binding.balloonCard.getX() + (float)this$0.binding.balloonCard.getWidth() - 1.0f);
                $this_with.setY(this$0.getArrowConstraintPositionY($anchor));
                if (!this$0.builder.getArrowColorMatchBalloon()) break;
                $this_with.setForeground((Drawable)new BitmapDrawable($this_with.getResources(), this$0.adjustArrowColorByMatchingCardBackground((ImageView)$this_with, this$0.binding.balloonCard.getWidth(), $this_with.getY())));
            }
        }
        ViewExtensionKt.visible((View)$this_with, this$0.builder.isVisibleArrow());
    }

    private static final void startBalloonHighlightAnimation$lambda-22$lambda-21(Balloon this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Animation animation = this$0.getBalloonHighlightAnimation();
        if (animation != null) {
            Animation animation2 = animation;
            boolean bl = false;
            boolean bl2 = false;
            Animation animation3 = animation2;
            boolean bl3 = false;
            this$0.binding.balloon.startAnimation(animation3);
        }
    }

    private static final void startBalloonHighlightAnimation$lambda-22(Balloon this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        new Handler(Looper.getMainLooper()).postDelayed(() -> Balloon.startBalloonHighlightAnimation$lambda-22$lambda-21(this$0), this$0.builder.getBalloonHighlightAnimationStartDelay());
    }

    private static final void setOnBalloonClickListener$lambda-40(OnBalloonClickListener $onBalloonClickListener, Balloon this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        OnBalloonClickListener onBalloonClickListener = $onBalloonClickListener;
        if (onBalloonClickListener != null) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            onBalloonClickListener.onBalloonClick(it);
        }
        if (this$0.builder.getDismissWhenClicked()) {
            this$0.dismiss();
        }
    }

    private static final void setOnBalloonDismissListener$lambda-41(Balloon this$0, OnBalloonDismissListener $onBalloonDismissListener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.stopBalloonHighlightAnimation();
        this$0.dismiss();
        OnBalloonDismissListener onBalloonDismissListener = $onBalloonDismissListener;
        if (onBalloonDismissListener != null) {
            onBalloonDismissListener.onBalloonDismiss();
        }
    }

    private static final boolean setOnBalloonOverlayTouchListener$lambda-42(Function2 $tmp0, View p0, MotionEvent p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void setOnBalloonOverlayClickListener$lambda-43(OnBalloonOverlayClickListener $onBalloonOverlayClickListener, Balloon this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        OnBalloonOverlayClickListener onBalloonOverlayClickListener = $onBalloonOverlayClickListener;
        if (onBalloonOverlayClickListener != null) {
            onBalloonOverlayClickListener.onBalloonOverlayClick();
        }
        if (this$0.builder.getDismissWhenOverlayClicked()) {
            this$0.dismiss();
        }
    }

    public static final /* synthetic */ void access$setShowing$p(Balloon $this, boolean bl) {
        $this.isShowing = bl;
    }

    public static final /* synthetic */ boolean access$hasCustomLayout(Balloon $this) {
        return $this.hasCustomLayout();
    }

    public static final /* synthetic */ void access$traverseAndMeasureTextWidth(Balloon $this, ViewGroup parent) {
        $this.traverseAndMeasureTextWidth(parent);
    }

    public static final /* synthetic */ BalloonLayoutBodyBinding access$getBinding$p(Balloon $this) {
        return $this.binding;
    }

    public static final /* synthetic */ void access$measureTextWidth(Balloon $this, TextView textView, View rootView) {
        $this.measureTextWidth(textView, rootView);
    }

    public static final /* synthetic */ void access$initializeBalloonContent(Balloon $this) {
        $this.initializeBalloonContent();
    }

    public static final /* synthetic */ void access$applyBalloonOverlayAnimation(Balloon $this) {
        $this.applyBalloonOverlayAnimation();
    }

    public static final /* synthetic */ void access$showOverlayWindow(Balloon $this, View anchor) {
        $this.showOverlayWindow(anchor);
    }

    public static final /* synthetic */ void access$passTouchEventToAnchor(Balloon $this, View anchor) {
        $this.passTouchEventToAnchor(anchor);
    }

    public static final /* synthetic */ void access$applyBalloonAnimation(Balloon $this) {
        $this.applyBalloonAnimation();
    }

    public static final /* synthetic */ void access$startBalloonHighlightAnimation(Balloon $this) {
        $this.startBalloonHighlightAnimation();
    }

    public static final /* synthetic */ BalloonPersistence access$getBalloonPersistence(Balloon $this) {
        return $this.getBalloonPersistence();
    }

    public static final /* synthetic */ boolean access$getDestroyed$p(Balloon $this) {
        return $this.destroyed;
    }

    public static final /* synthetic */ Handler access$getHandler(Balloon $this) {
        return $this.getHandler();
    }

    public static final /* synthetic */ AutoDismissRunnable access$getAutoDismissRunnable(Balloon $this) {
        return $this.getAutoDismissRunnable();
    }

    public /* synthetic */ Balloon(Context context, Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(context, builder);
    }

    public static final /* synthetic */ Context access$getContext$p(Balloon $this) {
        return $this.context;
    }

    @BalloonInlineDsl
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b6\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u00fa\u0002\u001a\u00030\u00fb\u0002J\u0018\u0010\u00c8\u0002\u001a\u00020\u00002\u000f\u0010\u00fc\u0002\u001a\n\u0012\u0005\u0012\u00030\u00c7\u00020\u00c6\u0002J\u0011\u0010\u00c8\u0002\u001a\u00020\u00002\b\u0010\u00fd\u0002\u001a\u00030\u00fe\u0002J\u0011\u0010\n\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\u0006J\u0011\u0010\u0010\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u000f\u0010\u0014\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u0006J\u0012\u0010\u0080\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010\u0017\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0081\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010\u001a\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u000f\u0010\u001f\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0012\u0010\u0082\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010%\u001a\u00020\u00002\t\u0010\u00ff\u0002\u001a\u0004\u0018\u00010!J\u0012\u0010\u0083\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0013\u0010)\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fH\u0007J\u0014\u0010\u0084\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fH\u0007J\u0011\u0010.\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0085\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u000f\u00103\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020/J\u000f\u00109\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u000205J\u0011\u0010=\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\u0006J\u000f\u0010B\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020>J\u0011\u0010F\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0086\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010I\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0087\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010L\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0088\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u000f\u0010Q\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020MJ\u0011\u0010U\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0089\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010X\u001a\u00020\u00002\t\u0010\u00ff\u0002\u001a\u0004\u0018\u00010!J\u0012\u0010\u008a\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u000f\u0010]\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020YJ\u0011\u0010a\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u001c\u0010f\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020b2\t\b\u0002\u0010\u008b\u0003\u001a\u00020MH\u0007J\u001f\u0010\u008c\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\f2\t\b\u0002\u0010\u008b\u0003\u001a\u00020MH\u0007J\u000f\u0010r\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020nJ\u0011\u0010v\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u000f\u0010\u008d\u0003\u001a\u00020\u00002\u0006\u0010x\u001a\u00020wJ\u000f\u0010\u007f\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020MJ\u0012\u0010\u0082\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\u0006J\u0012\u0010\u008e\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0010\u0010\u0085\u0001\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0010\u0010\u0088\u0001\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0010\u0010\u008b\u0001\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0010\u0010\u008e\u0001\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0010\u0010\u0091\u0001\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0014\u0010\u0094\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fH\u0007J\u0014\u0010\u008f\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fH\u0007J\u0010\u0010\u00b6\u0001\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0012\u0010\u0097\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0090\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u009a\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0091\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u009d\u0001\u001a\u00020\u00002\t\u0010\u00ff\u0002\u001a\u0004\u0018\u00010!J\u0012\u0010\u0092\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010\u00a2\u0001\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u009e\u0001J\u0011\u0010\u00a8\u0001\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00a4\u0001J\u0012\u0010\u00ac\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0093\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0094\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0095\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00af\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0096\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b2\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u0097\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0010\u0010\u0098\u0003\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0010\u0010\u0099\u0003\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0010\u0010\u009a\u0003\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0010\u0010\u009b\u0003\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ#\u0010\u00c3\u0001\u001a\u00020\u0000\"\n\b\u0000\u0010\u009c\u0003*\u00030\u009d\u00032\b\u0010\u009e\u0003\u001a\u0003H\u009c\u0003\u00a2\u0006\u0003\u0010\u009f\u0003J\u0011\u0010\u00c3\u0001\u001a\u00020\u00002\b\u0010\u00c0\u0001\u001a\u00030\u00bf\u0001J\u0012\u0010\u00c3\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00c5\u0001\u001a\u00020\fJ\u0011\u0010\u00cf\u0001\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00cb\u0001J\u0013\u0010\u00d5\u0001\u001a\u00020\u00002\n\u0010\u00ff\u0002\u001a\u0005\u0018\u00010\u00d1\u0001J\u0012\u0010\u00a0\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00d9\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a1\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a2\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a3\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00dc\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a4\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a5\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00df\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a6\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00e2\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a7\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a8\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a9\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00e5\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00e8\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\u0006J\u0012\u0010\u00aa\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00eb\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00ee\u0001\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\u0006J\u0012\u0010\u00ab\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010\u00f3\u0001\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00ef\u0001J\u001f\u0010\u00f9\u0001\u001a\u00020\u00002\u0016\u0010\u00fc\u0002\u001a\u0011\u0012\u0005\u0012\u00030\u00bf\u0001\u0012\u0005\u0012\u00030\u00c7\u00020\u00ac\u0003J\u0011\u0010\u00f9\u0001\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00f5\u0001J\u0018\u0010\u00ff\u0001\u001a\u00020\u00002\u000f\u0010\u00fc\u0002\u001a\n\u0012\u0005\u0012\u00030\u00c7\u00020\u00c6\u0002J\u0011\u0010\u00ff\u0001\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00fb\u0001J\u001f\u0010\u0085\u0002\u001a\u00020\u00002\u0016\u0010\u00fc\u0002\u001a\u0011\u0012\u0005\u0012\u00030\u00bf\u0001\u0012\u0005\u0012\u00030\u00c7\u00020\u00ac\u0003J\u0011\u0010\u0085\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u0081\u0002J&\u0010\u008b\u0002\u001a\u00020\u00002\u001d\u0010\u00fc\u0002\u001a\u0018\u0012\u0005\u0012\u00030\u00bf\u0001\u0012\u0005\u0012\u00030\u00ae\u0003\u0012\u0005\u0012\u00030\u00c7\u00020\u00ad\u0003J\u0011\u0010\u008b\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u0087\u0002J\u0018\u0010\u0091\u0002\u001a\u00020\u00002\u000f\u0010\u00fc\u0002\u001a\n\u0012\u0005\u0012\u00030\u00c7\u00020\u00c6\u0002J\u0011\u0010\u0091\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u008d\u0002J\u0011\u0010\u0097\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u0093\u0002J\u0011\u0010\u009b\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u0093\u0002J\u0012\u0010\u009e\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00af\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00a1\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\u0006J\u0012\u0010\u00a4\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b0\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b1\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010\u00a9\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00a5\u0002J\u0011\u0010\u00af\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00ab\u0002J\u0012\u0010\u00b2\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b3\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b3\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b4\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b5\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b6\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b6\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b7\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b9\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b8\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00bc\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00b9\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00ba\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00bb\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010\u00c4\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00c0\u0002J\u0010\u0010\u00bc\u0003\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0010\u0010\u00bd\u0003\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\fJ\u001d\u0010\u00be\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00f4\u0002\u001a\u00020\f2\t\b\u0001\u0010\u0095\u0001\u001a\u00020\fJ\u001d\u0010\u00bf\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00f4\u0002\u001a\u00020\f2\t\b\u0001\u0010\u0095\u0001\u001a\u00020\fJ\u0011\u0010\u00d7\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00d3\u0002J\u0012\u0010\u00db\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00c0\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010\u00e0\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00dc\u0002J\u0010\u0010\u00e4\u0002\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\fJ\u0010\u0010\u00e7\u0002\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\u001bJ\u0012\u0010\u00c1\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00ea\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\u0006J\u0012\u0010\u00c2\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0011\u0010\u00ed\u0002\u001a\u00020\u00002\b\u0010\u00ff\u0002\u001a\u00030\u00ee\u0002J\u0010\u0010\u00ed\u0002\u001a\u00020\u00002\u0007\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00f6\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fJ\u0012\u0010\u00f9\u0002\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\u0006J\u0012\u0010\u00c3\u0003\u001a\u00020\u00002\t\b\u0001\u0010\u00ff\u0002\u001a\u00020\fR&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR$\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R&\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R(\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u0005\u001a\u0004\u0018\u00010!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010'\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\t\"\u0004\b)\u0010\u000bR\u0012\u0010*\u001a\u00020\u00068\u00c7\u0002\u00a2\u0006\u0006\u001a\u0004\b+\u0010\tR$\u0010,\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u000f\"\u0004\b.\u0010\u0011R$\u00100\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020/@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00106\u001a\u0002052\u0006\u0010\u0005\u001a\u000205@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R&\u0010;\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\t\"\u0004\b=\u0010\u000bR$\u0010?\u001a\u00020>2\u0006\u0010\u0005\u001a\u00020>@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR$\u0010D\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u000f\"\u0004\bF\u0010\u0011R&\u0010G\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u000f\"\u0004\bI\u0010\u0011R$\u0010J\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u000f\"\u0004\bL\u0010\u0011R$\u0010N\u001a\u00020M2\u0006\u0010\u0005\u001a\u00020M@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR&\u0010S\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\u000f\"\u0004\bU\u0010\u0011R(\u0010V\u001a\u0004\u0018\u00010!2\b\u0010\u0005\u001a\u0004\u0018\u00010!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010$\"\u0004\bX\u0010&R$\u0010Z\u001a\u00020Y2\u0006\u0010\u0005\u001a\u00020Y@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R&\u0010_\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010\u000f\"\u0004\ba\u0010\u0011R$\u0010c\u001a\u00020b2\u0006\u0010\u0005\u001a\u00020b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR$\u0010h\u001a\u00020M2\u0006\u0010\u0005\u001a\u00020M@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010P\"\u0004\bj\u0010RR&\u0010k\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010\u000f\"\u0004\bm\u0010\u0011R$\u0010o\u001a\u00020n2\u0006\u0010\u0005\u001a\u00020n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010q\"\u0004\br\u0010sR&\u0010t\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bu\u0010\u000f\"\u0004\bv\u0010\u0011R(\u0010x\u001a\u0004\u0018\u00010w2\b\u0010\u0005\u001a\u0004\u0018\u00010w@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\by\u0010z\"\u0004\b{\u0010|R$\u0010}\u001a\u00020M2\u0006\u0010\u0005\u001a\u00020M@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b~\u0010P\"\u0004\b\u007f\u0010RR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0080\u0001\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0081\u0001\u0010\t\"\u0005\b\u0082\u0001\u0010\u000bR'\u0010\u0083\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0084\u0001\u0010\u001e\"\u0005\b\u0085\u0001\u0010 R'\u0010\u0086\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0087\u0001\u0010\u001e\"\u0005\b\u0088\u0001\u0010 R'\u0010\u0089\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008a\u0001\u0010\u001e\"\u0005\b\u008b\u0001\u0010 R'\u0010\u008c\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008d\u0001\u0010\u001e\"\u0005\b\u008e\u0001\u0010 R'\u0010\u008f\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0090\u0001\u0010\u001e\"\u0005\b\u0091\u0001\u0010 R'\u0010\u0092\u0001\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0093\u0001\u0010\t\"\u0005\b\u0094\u0001\u0010\u000bR)\u0010\u0095\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0096\u0001\u0010\u000f\"\u0005\b\u0097\u0001\u0010\u0011R)\u0010\u0098\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0099\u0001\u0010\u000f\"\u0005\b\u009a\u0001\u0010\u0011R+\u0010\u009b\u0001\u001a\u0004\u0018\u00010!2\b\u0010\u0005\u001a\u0004\u0018\u00010!@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u009c\u0001\u0010$\"\u0005\b\u009d\u0001\u0010&R/\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u009e\u00012\t\u0010\u0005\u001a\u0005\u0018\u00010\u009e\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00a0\u0001\u0010\u00a1\u0001\"\u0006\b\u00a2\u0001\u0010\u00a3\u0001R+\u0010\u00a5\u0001\u001a\u00030\u00a4\u00012\u0007\u0010\u0005\u001a\u00030\u00a4\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00a6\u0001\u0010\u00a7\u0001\"\u0006\b\u00a8\u0001\u0010\u00a9\u0001R)\u0010\u00aa\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00ab\u0001\u0010\u000f\"\u0005\b\u00ac\u0001\u0010\u0011R)\u0010\u00ad\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00ae\u0001\u0010\u000f\"\u0005\b\u00af\u0001\u0010\u0011R)\u0010\u00b0\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b1\u0001\u0010\u000f\"\u0005\b\u00b2\u0001\u0010\u0011R'\u0010\u00b3\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b3\u0001\u0010\u001e\"\u0005\b\u00b4\u0001\u0010 R'\u0010\u00b5\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b5\u0001\u0010\u001e\"\u0005\b\u00b6\u0001\u0010 R'\u0010\u00b7\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b7\u0001\u0010\u001e\"\u0005\b\u00b8\u0001\u0010 R'\u0010\u00b9\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b9\u0001\u0010\u001e\"\u0005\b\u00ba\u0001\u0010 R'\u0010\u00bb\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00bb\u0001\u0010\u001e\"\u0005\b\u00bc\u0001\u0010 R'\u0010\u00bd\u0001\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00bd\u0001\u0010\u001e\"\u0005\b\u00be\u0001\u0010 R/\u0010\u00c0\u0001\u001a\u0005\u0018\u00010\u00bf\u00012\t\u0010\u0005\u001a\u0005\u0018\u00010\u00bf\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00c1\u0001\u0010\u00c2\u0001\"\u0006\b\u00c3\u0001\u0010\u00c4\u0001R2\u0010\u00c5\u0001\u001a\u0004\u0018\u00010\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0015\n\u0003\u0010\u00ca\u0001\u001a\u0006\b\u00c6\u0001\u0010\u00c7\u0001\"\u0006\b\u00c8\u0001\u0010\u00c9\u0001R/\u0010\u00cc\u0001\u001a\u0005\u0018\u00010\u00cb\u00012\t\u0010\u0005\u001a\u0005\u0018\u00010\u00cb\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00cd\u0001\u0010\u00ce\u0001\"\u0006\b\u00cf\u0001\u0010\u00d0\u0001R/\u0010\u00d2\u0001\u001a\u0005\u0018\u00010\u00d1\u00012\t\u0010\u0005\u001a\u0005\u0018\u00010\u00d1\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00d3\u0001\u0010\u00d4\u0001\"\u0006\b\u00d5\u0001\u0010\u00d6\u0001R)\u0010\u00d7\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00d8\u0001\u0010\u000f\"\u0005\b\u00d9\u0001\u0010\u0011R)\u0010\u00da\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00db\u0001\u0010\u000f\"\u0005\b\u00dc\u0001\u0010\u0011R)\u0010\u00dd\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00de\u0001\u0010\u000f\"\u0005\b\u00df\u0001\u0010\u0011R)\u0010\u00e0\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00e1\u0001\u0010\u000f\"\u0005\b\u00e2\u0001\u0010\u0011R)\u0010\u00e3\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00e4\u0001\u0010\u000f\"\u0005\b\u00e5\u0001\u0010\u0011R)\u0010\u00e6\u0001\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00e7\u0001\u0010\t\"\u0005\b\u00e8\u0001\u0010\u000bR)\u0010\u00e9\u0001\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00ea\u0001\u0010\u000f\"\u0005\b\u00eb\u0001\u0010\u0011R)\u0010\u00ec\u0001\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00ed\u0001\u0010\t\"\u0005\b\u00ee\u0001\u0010\u000bR/\u0010\u00f0\u0001\u001a\u0005\u0018\u00010\u00ef\u00012\t\u0010\u0005\u001a\u0005\u0018\u00010\u00ef\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00f1\u0001\u0010\u00f2\u0001\"\u0006\b\u00f3\u0001\u0010\u00f4\u0001R/\u0010\u00f6\u0001\u001a\u0005\u0018\u00010\u00f5\u00012\t\u0010\u0005\u001a\u0005\u0018\u00010\u00f5\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00f7\u0001\u0010\u00f8\u0001\"\u0006\b\u00f9\u0001\u0010\u00fa\u0001R/\u0010\u00fc\u0001\u001a\u0005\u0018\u00010\u00fb\u00012\t\u0010\u0005\u001a\u0005\u0018\u00010\u00fb\u0001@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00fd\u0001\u0010\u00fe\u0001\"\u0006\b\u00ff\u0001\u0010\u0080\u0002R/\u0010\u0082\u0002\u001a\u0005\u0018\u00010\u0081\u00022\t\u0010\u0005\u001a\u0005\u0018\u00010\u0081\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0083\u0002\u0010\u0084\u0002\"\u0006\b\u0085\u0002\u0010\u0086\u0002R/\u0010\u0088\u0002\u001a\u0005\u0018\u00010\u0087\u00022\t\u0010\u0005\u001a\u0005\u0018\u00010\u0087\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0089\u0002\u0010\u008a\u0002\"\u0006\b\u008b\u0002\u0010\u008c\u0002R/\u0010\u008e\u0002\u001a\u0005\u0018\u00010\u008d\u00022\t\u0010\u0005\u001a\u0005\u0018\u00010\u008d\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008f\u0002\u0010\u0090\u0002\"\u0006\b\u0091\u0002\u0010\u0092\u0002R/\u0010\u0094\u0002\u001a\u0005\u0018\u00010\u0093\u00022\t\u0010\u0005\u001a\u0005\u0018\u00010\u0093\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0095\u0002\u0010\u0096\u0002\"\u0006\b\u0097\u0002\u0010\u0098\u0002R/\u0010\u0099\u0002\u001a\u0005\u0018\u00010\u0093\u00022\t\u0010\u0005\u001a\u0005\u0018\u00010\u0093\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u009a\u0002\u0010\u0096\u0002\"\u0006\b\u009b\u0002\u0010\u0098\u0002R)\u0010\u009c\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u009d\u0002\u0010\u000f\"\u0005\b\u009e\u0002\u0010\u0011R)\u0010\u009f\u0002\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a0\u0002\u0010\t\"\u0005\b\u00a1\u0002\u0010\u000bR)\u0010\u00a2\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a3\u0002\u0010\u000f\"\u0005\b\u00a4\u0002\u0010\u0011R/\u0010\u00a6\u0002\u001a\u0005\u0018\u00010\u00a5\u00022\t\u0010\u0005\u001a\u0005\u0018\u00010\u00a5\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00a7\u0002\u0010\u00a8\u0002\"\u0006\b\u00a9\u0002\u0010\u00aa\u0002R+\u0010\u00ac\u0002\u001a\u00030\u00ab\u00022\u0007\u0010\u0005\u001a\u00030\u00ab\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00ad\u0002\u0010\u00ae\u0002\"\u0006\b\u00af\u0002\u0010\u00b0\u0002R)\u0010\u00b1\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b2\u0002\u0010\u000f\"\u0005\b\u00b3\u0002\u0010\u0011R)\u0010\u00b4\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b5\u0002\u0010\u000f\"\u0005\b\u00b6\u0002\u0010\u0011R)\u0010\u00b7\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00b8\u0002\u0010\u000f\"\u0005\b\u00b9\u0002\u0010\u0011R)\u0010\u00ba\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00bb\u0002\u0010\u000f\"\u0005\b\u00bc\u0002\u0010\u0011R'\u0010\u00bd\u0002\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00be\u0002\u0010\u001e\"\u0005\b\u00bf\u0002\u0010 R/\u0010\u00c1\u0002\u001a\u0005\u0018\u00010\u00c0\u00022\t\u0010\u0005\u001a\u0005\u0018\u00010\u00c0\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00c2\u0002\u0010\u00c3\u0002\"\u0006\b\u00c4\u0002\u0010\u00c5\u0002R=\u0010\u00c8\u0002\u001a\f\u0012\u0005\u0012\u00030\u00c7\u0002\u0018\u00010\u00c6\u00022\u0010\u0010\u0005\u001a\f\u0012\u0005\u0012\u00030\u00c7\u0002\u0018\u00010\u00c6\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00c9\u0002\u0010\u00ca\u0002\"\u0006\b\u00cb\u0002\u0010\u00cc\u0002R'\u0010\u00cd\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00ce\u0002\u0010\u000f\"\u0005\b\u00cf\u0002\u0010\u0011R'\u0010\u00d0\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00d1\u0002\u0010\u000f\"\u0005\b\u00d2\u0002\u0010\u0011R+\u0010\u00d4\u0002\u001a\u00030\u00d3\u00022\u0007\u0010\u0005\u001a\u00030\u00d3\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00d5\u0002\u0010\u00d6\u0002\"\u0006\b\u00d7\u0002\u0010\u00d8\u0002R)\u0010\u00d9\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00da\u0002\u0010\u000f\"\u0005\b\u00db\u0002\u0010\u0011R/\u0010\u00dd\u0002\u001a\u0005\u0018\u00010\u00dc\u00022\t\u0010\u0005\u001a\u0005\u0018\u00010\u00dc\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00de\u0002\u0010\u00df\u0002\"\u0006\b\u00e0\u0002\u0010\u00e1\u0002R'\u0010\u00e2\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00e3\u0002\u0010\u000f\"\u0005\b\u00e4\u0002\u0010\u0011R'\u0010\u00e5\u0002\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00e6\u0002\u0010\u001e\"\u0005\b\u00e7\u0002\u0010 R)\u0010\u00e8\u0002\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00e9\u0002\u0010\t\"\u0005\b\u00ea\u0002\u0010\u000bR'\u0010\u00eb\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00ec\u0002\u0010\u000f\"\u0005\b\u00ed\u0002\u0010\u0011R/\u0010\u00ef\u0002\u001a\u0005\u0018\u00010\u00ee\u00022\t\u0010\u0005\u001a\u0005\u0018\u00010\u00ee\u0002@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u00f0\u0002\u0010\u00f1\u0002\"\u0006\b\u00f2\u0002\u0010\u00f3\u0002R)\u0010\u00f4\u0002\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00f5\u0002\u0010\u000f\"\u0005\b\u00f6\u0002\u0010\u0011R)\u0010\u00f7\u0002\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@FX\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00f8\u0002\u0010\t\"\u0005\b\u00f9\u0002\u0010\u000b\u00a8\u0006\u00c4\u0003"}, d2={"Lcom/skydoves/balloon/Balloon$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "<set-?>", "", "alpha", "getAlpha", "()F", "setAlpha", "(F)V", "", "arrowAlignAnchorPadding", "getArrowAlignAnchorPadding", "()I", "setArrowAlignAnchorPadding", "(I)V", "arrowAlignAnchorPaddingRatio", "getArrowAlignAnchorPaddingRatio", "setArrowAlignAnchorPaddingRatio", "arrowBottomPadding", "getArrowBottomPadding", "setArrowBottomPadding", "arrowColor", "getArrowColor", "setArrowColor", "", "arrowColorMatchBalloon", "getArrowColorMatchBalloon", "()Z", "setArrowColorMatchBalloon", "(Z)V", "Landroid/graphics/drawable/Drawable;", "arrowDrawable", "getArrowDrawable", "()Landroid/graphics/drawable/Drawable;", "setArrowDrawable", "(Landroid/graphics/drawable/Drawable;)V", "arrowElevation", "getArrowElevation", "setArrowElevation", "arrowHalfSize", "getArrowHalfSize", "arrowLeftPadding", "getArrowLeftPadding", "setArrowLeftPadding", "Lcom/skydoves/balloon/ArrowOrientation;", "arrowOrientation", "getArrowOrientation", "()Lcom/skydoves/balloon/ArrowOrientation;", "setArrowOrientation", "(Lcom/skydoves/balloon/ArrowOrientation;)V", "Lcom/skydoves/balloon/ArrowOrientationRules;", "arrowOrientationRules", "getArrowOrientationRules", "()Lcom/skydoves/balloon/ArrowOrientationRules;", "setArrowOrientationRules", "(Lcom/skydoves/balloon/ArrowOrientationRules;)V", "arrowPosition", "getArrowPosition", "setArrowPosition", "Lcom/skydoves/balloon/ArrowPositionRules;", "arrowPositionRules", "getArrowPositionRules", "()Lcom/skydoves/balloon/ArrowPositionRules;", "setArrowPositionRules", "(Lcom/skydoves/balloon/ArrowPositionRules;)V", "arrowRightPadding", "getArrowRightPadding", "setArrowRightPadding", "arrowSize", "getArrowSize", "setArrowSize", "arrowTopPadding", "getArrowTopPadding", "setArrowTopPadding", "", "autoDismissDuration", "getAutoDismissDuration", "()J", "setAutoDismissDuration", "(J)V", "backgroundColor", "getBackgroundColor", "setBackgroundColor", "backgroundDrawable", "getBackgroundDrawable", "setBackgroundDrawable", "Lcom/skydoves/balloon/BalloonAnimation;", "balloonAnimation", "getBalloonAnimation", "()Lcom/skydoves/balloon/BalloonAnimation;", "setBalloonAnimation", "(Lcom/skydoves/balloon/BalloonAnimation;)V", "balloonAnimationStyle", "getBalloonAnimationStyle", "setBalloonAnimationStyle", "Lcom/skydoves/balloon/BalloonHighlightAnimation;", "balloonHighlightAnimation", "getBalloonHighlightAnimation", "()Lcom/skydoves/balloon/BalloonHighlightAnimation;", "setBalloonHighlightAnimation", "(Lcom/skydoves/balloon/BalloonHighlightAnimation;)V", "balloonHighlightAnimationStartDelay", "getBalloonHighlightAnimationStartDelay", "setBalloonHighlightAnimationStartDelay", "balloonHighlightAnimationStyle", "getBalloonHighlightAnimationStyle", "setBalloonHighlightAnimationStyle", "Lcom/skydoves/balloon/overlay/BalloonOverlayAnimation;", "balloonOverlayAnimation", "getBalloonOverlayAnimation", "()Lcom/skydoves/balloon/overlay/BalloonOverlayAnimation;", "setBalloonOverlayAnimation", "(Lcom/skydoves/balloon/overlay/BalloonOverlayAnimation;)V", "balloonOverlayAnimationStyle", "getBalloonOverlayAnimationStyle", "setBalloonOverlayAnimationStyle", "Lcom/skydoves/balloon/animations/BalloonRotateAnimation;", "balloonRotateAnimation", "getBalloonRotateAnimation", "()Lcom/skydoves/balloon/animations/BalloonRotateAnimation;", "setBalloonRotateAnimation", "(Lcom/skydoves/balloon/animations/BalloonRotateAnimation;)V", "circularDuration", "getCircularDuration", "setCircularDuration", "cornerRadius", "getCornerRadius", "setCornerRadius", "dismissWhenClicked", "getDismissWhenClicked", "setDismissWhenClicked", "dismissWhenLifecycleOnPause", "getDismissWhenLifecycleOnPause", "setDismissWhenLifecycleOnPause", "dismissWhenOverlayClicked", "getDismissWhenOverlayClicked", "setDismissWhenOverlayClicked", "dismissWhenShowAgain", "getDismissWhenShowAgain", "setDismissWhenShowAgain", "dismissWhenTouchOutside", "getDismissWhenTouchOutside", "setDismissWhenTouchOutside", "elevation", "getElevation", "setElevation", "height", "getHeight", "setHeight", "iconColor", "getIconColor", "setIconColor", "iconDrawable", "getIconDrawable", "setIconDrawable", "Lcom/skydoves/balloon/IconForm;", "iconForm", "getIconForm", "()Lcom/skydoves/balloon/IconForm;", "setIconForm", "(Lcom/skydoves/balloon/IconForm;)V", "Lcom/skydoves/balloon/IconGravity;", "iconGravity", "getIconGravity", "()Lcom/skydoves/balloon/IconGravity;", "setIconGravity", "(Lcom/skydoves/balloon/IconGravity;)V", "iconHeight", "getIconHeight", "setIconHeight", "iconSpace", "getIconSpace", "setIconSpace", "iconWidth", "getIconWidth", "setIconWidth", "isAttachedInDecor", "setAttachedInDecor", "isFocusable", "setFocusable", "isRtlLayout", "setRtlLayout", "isStatusBarVisible", "setStatusBarVisible", "isVisibleArrow", "setVisibleArrow", "isVisibleOverlay", "setVisibleOverlay", "Landroid/view/View;", "layout", "getLayout", "()Landroid/view/View;", "setLayout", "(Landroid/view/View;)V", "layoutRes", "getLayoutRes", "()Ljava/lang/Integer;", "setLayoutRes", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "Landroidx/lifecycle/LifecycleObserver;", "lifecycleObserver", "getLifecycleObserver", "()Landroidx/lifecycle/LifecycleObserver;", "setLifecycleObserver", "(Landroidx/lifecycle/LifecycleObserver;)V", "Landroidx/lifecycle/LifecycleOwner;", "lifecycleOwner", "getLifecycleOwner", "()Landroidx/lifecycle/LifecycleOwner;", "setLifecycleOwner", "(Landroidx/lifecycle/LifecycleOwner;)V", "marginBottom", "getMarginBottom", "setMarginBottom", "marginLeft", "getMarginLeft", "setMarginLeft", "marginRight", "getMarginRight", "setMarginRight", "marginTop", "getMarginTop", "setMarginTop", "maxWidth", "getMaxWidth", "setMaxWidth", "maxWidthRatio", "getMaxWidthRatio", "setMaxWidthRatio", "minWidth", "getMinWidth", "setMinWidth", "minWidthRatio", "getMinWidthRatio", "setMinWidthRatio", "Landroid/text/method/MovementMethod;", "movementMethod", "getMovementMethod", "()Landroid/text/method/MovementMethod;", "setMovementMethod", "(Landroid/text/method/MovementMethod;)V", "Lcom/skydoves/balloon/OnBalloonClickListener;", "onBalloonClickListener", "getOnBalloonClickListener", "()Lcom/skydoves/balloon/OnBalloonClickListener;", "setOnBalloonClickListener", "(Lcom/skydoves/balloon/OnBalloonClickListener;)V", "Lcom/skydoves/balloon/OnBalloonDismissListener;", "onBalloonDismissListener", "getOnBalloonDismissListener", "()Lcom/skydoves/balloon/OnBalloonDismissListener;", "setOnBalloonDismissListener", "(Lcom/skydoves/balloon/OnBalloonDismissListener;)V", "Lcom/skydoves/balloon/OnBalloonInitializedListener;", "onBalloonInitializedListener", "getOnBalloonInitializedListener", "()Lcom/skydoves/balloon/OnBalloonInitializedListener;", "setOnBalloonInitializedListener", "(Lcom/skydoves/balloon/OnBalloonInitializedListener;)V", "Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "onBalloonOutsideTouchListener", "getOnBalloonOutsideTouchListener", "()Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;", "setOnBalloonOutsideTouchListener", "(Lcom/skydoves/balloon/OnBalloonOutsideTouchListener;)V", "Lcom/skydoves/balloon/OnBalloonOverlayClickListener;", "onBalloonOverlayClickListener", "getOnBalloonOverlayClickListener", "()Lcom/skydoves/balloon/OnBalloonOverlayClickListener;", "setOnBalloonOverlayClickListener", "(Lcom/skydoves/balloon/OnBalloonOverlayClickListener;)V", "Landroid/view/View$OnTouchListener;", "onBalloonOverlayTouchListener", "getOnBalloonOverlayTouchListener", "()Landroid/view/View$OnTouchListener;", "setOnBalloonOverlayTouchListener", "(Landroid/view/View$OnTouchListener;)V", "onBalloonTouchListener", "getOnBalloonTouchListener", "setOnBalloonTouchListener", "overlayColor", "getOverlayColor", "setOverlayColor", "overlayPadding", "getOverlayPadding", "setOverlayPadding", "overlayPaddingColor", "getOverlayPaddingColor", "setOverlayPaddingColor", "Landroid/graphics/Point;", "overlayPosition", "getOverlayPosition", "()Landroid/graphics/Point;", "setOverlayPosition", "(Landroid/graphics/Point;)V", "Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "overlayShape", "getOverlayShape", "()Lcom/skydoves/balloon/overlay/BalloonOverlayShape;", "setOverlayShape", "(Lcom/skydoves/balloon/overlay/BalloonOverlayShape;)V", "paddingBottom", "getPaddingBottom", "setPaddingBottom", "paddingLeft", "getPaddingLeft", "setPaddingLeft", "paddingRight", "getPaddingRight", "setPaddingRight", "paddingTop", "getPaddingTop", "setPaddingTop", "passTouchEventToAnchor", "getPassTouchEventToAnchor", "setPassTouchEventToAnchor", "", "preferenceName", "getPreferenceName", "()Ljava/lang/String;", "setPreferenceName", "(Ljava/lang/String;)V", "Lkotlin/Function0;", "", "runIfReachedShowCounts", "getRunIfReachedShowCounts", "()Lkotlin/jvm/functions/Function0;", "setRunIfReachedShowCounts", "(Lkotlin/jvm/functions/Function0;)V", "showTimes", "getShowTimes", "setShowTimes", "supportRtlLayoutFactor", "getSupportRtlLayoutFactor", "setSupportRtlLayoutFactor", "", "text", "getText", "()Ljava/lang/CharSequence;", "setText", "(Ljava/lang/CharSequence;)V", "textColor", "getTextColor", "setTextColor", "Lcom/skydoves/balloon/TextForm;", "textForm", "getTextForm", "()Lcom/skydoves/balloon/TextForm;", "setTextForm", "(Lcom/skydoves/balloon/TextForm;)V", "textGravity", "getTextGravity", "setTextGravity", "textIsHtml", "getTextIsHtml", "setTextIsHtml", "textSize", "getTextSize", "setTextSize", "textTypeface", "getTextTypeface", "setTextTypeface", "Landroid/graphics/Typeface;", "textTypefaceObject", "getTextTypefaceObject", "()Landroid/graphics/Typeface;", "setTextTypefaceObject", "(Landroid/graphics/Typeface;)V", "width", "getWidth", "setWidth", "widthRatio", "getWidthRatio", "setWidthRatio", "build", "Lcom/skydoves/balloon/Balloon;", "block", "runnable", "Ljava/lang/Runnable;", "value", "setArrowAlignAnchorPaddingResource", "setArrowBottomPaddingResource", "setArrowColorResource", "setArrowDrawableResource", "setArrowElevationResource", "setArrowLeftPaddingResource", "setArrowRightPaddingResource", "setArrowSizeResource", "setArrowTopPaddingResource", "setBackgroundColorResource", "setBackgroundDrawableResource", "startDelay", "setBalloonHighlightAnimationResource", "setBalloonRotationAnimation", "setCornerRadiusResource", "setElevationResource", "setHeightResource", "setIconColorResource", "setIconDrawableResource", "setIconHeightResource", "setIconSize", "setIconSizeResource", "setIconSpaceResource", "setIconWidthResource", "setIsAttachedInDecor", "setIsStatusBarVisible", "setIsVisibleArrow", "setIsVisibleOverlay", "T", "Landroidx/viewbinding/ViewBinding;", "binding", "(Landroidx/viewbinding/ViewBinding;)Lcom/skydoves/balloon/Balloon$Builder;", "setMargin", "setMarginBottomResource", "setMarginHorizontal", "setMarginHorizontalResource", "setMarginLeftResource", "setMarginResource", "setMarginRightResource", "setMarginTopResource", "setMarginVertical", "setMarginVerticalResource", "setMaxWidthResource", "setMinWidthResource", "Lkotlin/Function1;", "Lkotlin/Function2;", "Landroid/view/MotionEvent;", "setOverlayColorResource", "setOverlayPaddingColorResource", "setOverlayPaddingResource", "setPadding", "setPaddingBottomResource", "setPaddingHorizontal", "setPaddingHorizontalResource", "setPaddingLeftResource", "setPaddingResource", "setPaddingRightResource", "setPaddingTopResource", "setPaddingVertical", "setPaddingVerticalResource", "setShouldPassTouchEventToAnchor", "setShowCounts", "setSize", "setSizeResource", "setTextColorResource", "setTextResource", "setTextSizeResource", "setWidthResource", "balloon_release"})
    public static final class Builder {
        @NotNull
        private final Context context;
        @Px
        private int width;
        @Px
        private int minWidth;
        @Px
        private int maxWidth;
        @FloatRange(from=0.0, to=1.0)
        private float widthRatio;
        @FloatRange(from=0.0, to=1.0)
        private float minWidthRatio;
        @FloatRange(from=0.0, to=1.0)
        private float maxWidthRatio;
        @Px
        private int height;
        @Px
        private int paddingLeft;
        @Px
        private int paddingTop;
        @Px
        private int paddingRight;
        @Px
        private int paddingBottom;
        @Px
        private int marginRight;
        @Px
        private int marginLeft;
        @Px
        private int marginTop;
        @Px
        private int marginBottom;
        private boolean isVisibleArrow;
        @ColorInt
        private int arrowColor;
        private boolean arrowColorMatchBalloon;
        @Px
        private int arrowSize;
        @FloatRange(from=0.0, to=1.0)
        private float arrowPosition;
        @NotNull
        private ArrowPositionRules arrowPositionRules;
        @NotNull
        private ArrowOrientationRules arrowOrientationRules;
        @NotNull
        private ArrowOrientation arrowOrientation;
        @Nullable
        private Drawable arrowDrawable;
        private int arrowLeftPadding;
        private int arrowRightPadding;
        private int arrowTopPadding;
        private int arrowBottomPadding;
        private int arrowAlignAnchorPadding;
        private float arrowAlignAnchorPaddingRatio;
        private float arrowElevation;
        @ColorInt
        private int backgroundColor;
        @Nullable
        private Drawable backgroundDrawable;
        @Px
        private float cornerRadius;
        @NotNull
        private CharSequence text;
        @ColorInt
        private int textColor;
        private boolean textIsHtml;
        @Nullable
        private MovementMethod movementMethod;
        @Sp
        private float textSize;
        private int textTypeface;
        @Nullable
        private Typeface textTypefaceObject;
        private int textGravity;
        @Nullable
        private TextForm textForm;
        @Nullable
        private Drawable iconDrawable;
        @NotNull
        private IconGravity iconGravity;
        @Px
        private int iconWidth;
        @Px
        private int iconHeight;
        @Px
        private int iconSpace;
        @ColorInt
        private int iconColor;
        @Nullable
        private IconForm iconForm;
        @FloatRange(from=0.0, to=1.0)
        private float alpha;
        private float elevation;
        @Nullable
        private View layout;
        @LayoutRes
        @Nullable
        private Integer layoutRes;
        private boolean isVisibleOverlay;
        @ColorInt
        private int overlayColor;
        @Px
        private float overlayPadding;
        @ColorInt
        private int overlayPaddingColor;
        @Nullable
        private Point overlayPosition;
        @NotNull
        private BalloonOverlayShape overlayShape;
        @Nullable
        private OnBalloonClickListener onBalloonClickListener;
        @Nullable
        private OnBalloonDismissListener onBalloonDismissListener;
        @Nullable
        private OnBalloonInitializedListener onBalloonInitializedListener;
        @Nullable
        private OnBalloonOutsideTouchListener onBalloonOutsideTouchListener;
        @Nullable
        private View.OnTouchListener onBalloonTouchListener;
        @Nullable
        private View.OnTouchListener onBalloonOverlayTouchListener;
        @Nullable
        private OnBalloonOverlayClickListener onBalloonOverlayClickListener;
        private boolean dismissWhenTouchOutside;
        private boolean dismissWhenShowAgain;
        private boolean dismissWhenClicked;
        private boolean dismissWhenOverlayClicked;
        private boolean dismissWhenLifecycleOnPause;
        private boolean passTouchEventToAnchor;
        private long autoDismissDuration;
        @Nullable
        private LifecycleOwner lifecycleOwner;
        @Nullable
        private LifecycleObserver lifecycleObserver;
        @StyleRes
        private int balloonAnimationStyle;
        @StyleRes
        private int balloonOverlayAnimationStyle;
        @NotNull
        private BalloonAnimation balloonAnimation;
        @NotNull
        private BalloonOverlayAnimation balloonOverlayAnimation;
        private long circularDuration;
        @NotNull
        private BalloonHighlightAnimation balloonHighlightAnimation;
        @StyleRes
        private int balloonHighlightAnimationStyle;
        private long balloonHighlightAnimationStartDelay;
        @Nullable
        private BalloonRotateAnimation balloonRotateAnimation;
        @Nullable
        private String preferenceName;
        private int showTimes;
        @Nullable
        private Function0<Unit> runIfReachedShowCounts;
        private boolean isRtlLayout;
        private int supportRtlLayoutFactor;
        private boolean isFocusable;
        private boolean isStatusBarVisible;
        private boolean isAttachedInDecor;

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.width = Integer.MIN_VALUE;
            boolean $i$f$getDisplaySize = false;
            this.maxWidth = new Point((int)Resources.getSystem().getDisplayMetrics().widthPixels, (int)Resources.getSystem().getDisplayMetrics().heightPixels).x;
            this.height = Integer.MIN_VALUE;
            this.isVisibleArrow = true;
            this.arrowColor = Integer.MIN_VALUE;
            int $this$dp$iv = 12;
            boolean $i$f$getDp = false;
            this.arrowSize = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()));
            this.arrowPosition = 0.5f;
            this.arrowPositionRules = ArrowPositionRules.ALIGN_BALLOON;
            this.arrowOrientationRules = ArrowOrientationRules.ALIGN_ANCHOR;
            this.arrowOrientation = ArrowOrientation.BOTTOM;
            this.arrowAlignAnchorPaddingRatio = 2.5f;
            this.backgroundColor = -16777216;
            float $this$dp$iv2 = 5.0f;
            $i$f$getDp = false;
            this.cornerRadius = TypedValue.applyDimension((int)1, (float)$this$dp$iv2, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
            this.text = "";
            this.textColor = -1;
            this.textSize = 12.0f;
            this.textGravity = 17;
            this.iconGravity = IconGravity.START;
            $this$dp$iv = 28;
            $i$f$getDp = false;
            this.iconWidth = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()));
            $this$dp$iv = 28;
            $i$f$getDp = false;
            this.iconHeight = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()));
            $this$dp$iv = 8;
            $i$f$getDp = false;
            this.iconSpace = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()));
            this.iconColor = Integer.MIN_VALUE;
            this.alpha = 1.0f;
            float $this$dp$iv3 = 2.0f;
            $i$f$getDp = false;
            this.elevation = TypedValue.applyDimension((int)1, (float)$this$dp$iv3, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
            this.overlayShape = BalloonOverlayOval.INSTANCE;
            this.dismissWhenTouchOutside = true;
            this.dismissWhenOverlayClicked = true;
            this.autoDismissDuration = -1L;
            this.balloonAnimationStyle = Integer.MIN_VALUE;
            this.balloonOverlayAnimationStyle = Integer.MIN_VALUE;
            this.balloonAnimation = BalloonAnimation.FADE;
            this.balloonOverlayAnimation = BalloonOverlayAnimation.FADE;
            this.circularDuration = 500L;
            this.balloonHighlightAnimation = BalloonHighlightAnimation.NONE;
            this.balloonHighlightAnimationStyle = Integer.MIN_VALUE;
            this.showTimes = 1;
            this.isRtlLayout = this.context.getResources().getConfiguration().getLayoutDirection() == 1;
            this.supportRtlLayoutFactor = DefinitionKt.unaryMinus(1, this.isRtlLayout);
            this.isFocusable = true;
            this.isStatusBarVisible = true;
            this.isAttachedInDecor = true;
        }

        public final int getWidth() {
            return this.width;
        }

        public final /* synthetic */ void setWidth(int n) {
            this.width = n;
        }

        public final int getMinWidth() {
            return this.minWidth;
        }

        public final /* synthetic */ void setMinWidth(int n) {
            this.minWidth = n;
        }

        public final int getMaxWidth() {
            return this.maxWidth;
        }

        public final /* synthetic */ void setMaxWidth(int n) {
            this.maxWidth = n;
        }

        public final float getWidthRatio() {
            return this.widthRatio;
        }

        public final /* synthetic */ void setWidthRatio(float f) {
            this.widthRatio = f;
        }

        public final float getMinWidthRatio() {
            return this.minWidthRatio;
        }

        public final /* synthetic */ void setMinWidthRatio(float f) {
            this.minWidthRatio = f;
        }

        public final float getMaxWidthRatio() {
            return this.maxWidthRatio;
        }

        public final /* synthetic */ void setMaxWidthRatio(float f) {
            this.maxWidthRatio = f;
        }

        public final int getHeight() {
            return this.height;
        }

        public final /* synthetic */ void setHeight(int n) {
            this.height = n;
        }

        public final int getPaddingLeft() {
            return this.paddingLeft;
        }

        public final /* synthetic */ void setPaddingLeft(int n) {
            this.paddingLeft = n;
        }

        public final int getPaddingTop() {
            return this.paddingTop;
        }

        public final /* synthetic */ void setPaddingTop(int n) {
            this.paddingTop = n;
        }

        public final int getPaddingRight() {
            return this.paddingRight;
        }

        public final /* synthetic */ void setPaddingRight(int n) {
            this.paddingRight = n;
        }

        public final int getPaddingBottom() {
            return this.paddingBottom;
        }

        public final /* synthetic */ void setPaddingBottom(int n) {
            this.paddingBottom = n;
        }

        public final int getMarginRight() {
            return this.marginRight;
        }

        public final /* synthetic */ void setMarginRight(int n) {
            this.marginRight = n;
        }

        public final int getMarginLeft() {
            return this.marginLeft;
        }

        public final /* synthetic */ void setMarginLeft(int n) {
            this.marginLeft = n;
        }

        public final int getMarginTop() {
            return this.marginTop;
        }

        public final /* synthetic */ void setMarginTop(int n) {
            this.marginTop = n;
        }

        public final int getMarginBottom() {
            return this.marginBottom;
        }

        public final /* synthetic */ void setMarginBottom(int n) {
            this.marginBottom = n;
        }

        public final boolean isVisibleArrow() {
            return this.isVisibleArrow;
        }

        public final /* synthetic */ void setVisibleArrow(boolean bl) {
            this.isVisibleArrow = bl;
        }

        public final int getArrowColor() {
            return this.arrowColor;
        }

        public final /* synthetic */ void setArrowColor(int n) {
            this.arrowColor = n;
        }

        public final boolean getArrowColorMatchBalloon() {
            return this.arrowColorMatchBalloon;
        }

        public final /* synthetic */ void setArrowColorMatchBalloon(boolean bl) {
            this.arrowColorMatchBalloon = bl;
        }

        public final int getArrowSize() {
            return this.arrowSize;
        }

        public final /* synthetic */ void setArrowSize(int n) {
            this.arrowSize = n;
        }

        @Px
        public final /* synthetic */ float getArrowHalfSize() {
            boolean $i$f$getArrowHalfSize = false;
            return (float)this.getArrowSize() * 0.5f;
        }

        public final float getArrowPosition() {
            return this.arrowPosition;
        }

        public final /* synthetic */ void setArrowPosition(float f) {
            this.arrowPosition = f;
        }

        @NotNull
        public final ArrowPositionRules getArrowPositionRules() {
            return this.arrowPositionRules;
        }

        public final /* synthetic */ void setArrowPositionRules(ArrowPositionRules arrowPositionRules) {
            Intrinsics.checkNotNullParameter((Object)((Object)arrowPositionRules), (String)"<set-?>");
            this.arrowPositionRules = arrowPositionRules;
        }

        @NotNull
        public final ArrowOrientationRules getArrowOrientationRules() {
            return this.arrowOrientationRules;
        }

        public final /* synthetic */ void setArrowOrientationRules(ArrowOrientationRules arrowOrientationRules) {
            Intrinsics.checkNotNullParameter((Object)((Object)arrowOrientationRules), (String)"<set-?>");
            this.arrowOrientationRules = arrowOrientationRules;
        }

        @NotNull
        public final ArrowOrientation getArrowOrientation() {
            return this.arrowOrientation;
        }

        public final /* synthetic */ void setArrowOrientation(ArrowOrientation arrowOrientation) {
            Intrinsics.checkNotNullParameter((Object)((Object)arrowOrientation), (String)"<set-?>");
            this.arrowOrientation = arrowOrientation;
        }

        @Nullable
        public final Drawable getArrowDrawable() {
            return this.arrowDrawable;
        }

        public final /* synthetic */ void setArrowDrawable(Drawable drawable) {
            this.arrowDrawable = drawable;
        }

        public final int getArrowLeftPadding() {
            return this.arrowLeftPadding;
        }

        public final /* synthetic */ void setArrowLeftPadding(int n) {
            this.arrowLeftPadding = n;
        }

        public final int getArrowRightPadding() {
            return this.arrowRightPadding;
        }

        public final /* synthetic */ void setArrowRightPadding(int n) {
            this.arrowRightPadding = n;
        }

        public final int getArrowTopPadding() {
            return this.arrowTopPadding;
        }

        public final /* synthetic */ void setArrowTopPadding(int n) {
            this.arrowTopPadding = n;
        }

        public final int getArrowBottomPadding() {
            return this.arrowBottomPadding;
        }

        public final /* synthetic */ void setArrowBottomPadding(int n) {
            this.arrowBottomPadding = n;
        }

        public final int getArrowAlignAnchorPadding() {
            return this.arrowAlignAnchorPadding;
        }

        public final /* synthetic */ void setArrowAlignAnchorPadding(int n) {
            this.arrowAlignAnchorPadding = n;
        }

        public final float getArrowAlignAnchorPaddingRatio() {
            return this.arrowAlignAnchorPaddingRatio;
        }

        public final /* synthetic */ void setArrowAlignAnchorPaddingRatio(float f) {
            this.arrowAlignAnchorPaddingRatio = f;
        }

        public final float getArrowElevation() {
            return this.arrowElevation;
        }

        public final /* synthetic */ void setArrowElevation(float f) {
            this.arrowElevation = f;
        }

        public final int getBackgroundColor() {
            return this.backgroundColor;
        }

        public final /* synthetic */ void setBackgroundColor(int n) {
            this.backgroundColor = n;
        }

        @Nullable
        public final Drawable getBackgroundDrawable() {
            return this.backgroundDrawable;
        }

        public final /* synthetic */ void setBackgroundDrawable(Drawable drawable) {
            this.backgroundDrawable = drawable;
        }

        public final float getCornerRadius() {
            return this.cornerRadius;
        }

        public final /* synthetic */ void setCornerRadius(float f) {
            this.cornerRadius = f;
        }

        @NotNull
        public final CharSequence getText() {
            return this.text;
        }

        public final /* synthetic */ void setText(CharSequence charSequence) {
            Intrinsics.checkNotNullParameter((Object)charSequence, (String)"<set-?>");
            this.text = charSequence;
        }

        public final int getTextColor() {
            return this.textColor;
        }

        public final /* synthetic */ void setTextColor(int n) {
            this.textColor = n;
        }

        public final boolean getTextIsHtml() {
            return this.textIsHtml;
        }

        public final /* synthetic */ void setTextIsHtml(boolean bl) {
            this.textIsHtml = bl;
        }

        @Nullable
        public final MovementMethod getMovementMethod() {
            return this.movementMethod;
        }

        public final /* synthetic */ void setMovementMethod(MovementMethod movementMethod) {
            this.movementMethod = movementMethod;
        }

        public final float getTextSize() {
            return this.textSize;
        }

        public final /* synthetic */ void setTextSize(float f) {
            this.textSize = f;
        }

        public final int getTextTypeface() {
            return this.textTypeface;
        }

        public final /* synthetic */ void setTextTypeface(int n) {
            this.textTypeface = n;
        }

        @Nullable
        public final Typeface getTextTypefaceObject() {
            return this.textTypefaceObject;
        }

        public final /* synthetic */ void setTextTypefaceObject(Typeface typeface) {
            this.textTypefaceObject = typeface;
        }

        public final int getTextGravity() {
            return this.textGravity;
        }

        public final /* synthetic */ void setTextGravity(int n) {
            this.textGravity = n;
        }

        @Nullable
        public final TextForm getTextForm() {
            return this.textForm;
        }

        public final /* synthetic */ void setTextForm(TextForm textForm) {
            this.textForm = textForm;
        }

        @Nullable
        public final Drawable getIconDrawable() {
            return this.iconDrawable;
        }

        public final /* synthetic */ void setIconDrawable(Drawable drawable) {
            this.iconDrawable = drawable;
        }

        @NotNull
        public final IconGravity getIconGravity() {
            return this.iconGravity;
        }

        public final /* synthetic */ void setIconGravity(IconGravity iconGravity) {
            Intrinsics.checkNotNullParameter((Object)((Object)iconGravity), (String)"<set-?>");
            this.iconGravity = iconGravity;
        }

        public final int getIconWidth() {
            return this.iconWidth;
        }

        public final /* synthetic */ void setIconWidth(int n) {
            this.iconWidth = n;
        }

        public final int getIconHeight() {
            return this.iconHeight;
        }

        public final /* synthetic */ void setIconHeight(int n) {
            this.iconHeight = n;
        }

        public final int getIconSpace() {
            return this.iconSpace;
        }

        public final /* synthetic */ void setIconSpace(int n) {
            this.iconSpace = n;
        }

        public final int getIconColor() {
            return this.iconColor;
        }

        public final /* synthetic */ void setIconColor(int n) {
            this.iconColor = n;
        }

        @Nullable
        public final IconForm getIconForm() {
            return this.iconForm;
        }

        public final /* synthetic */ void setIconForm(IconForm iconForm) {
            this.iconForm = iconForm;
        }

        public final float getAlpha() {
            return this.alpha;
        }

        public final /* synthetic */ void setAlpha(float f) {
            this.alpha = f;
        }

        public final float getElevation() {
            return this.elevation;
        }

        public final /* synthetic */ void setElevation(float f) {
            this.elevation = f;
        }

        @Nullable
        public final View getLayout() {
            return this.layout;
        }

        public final /* synthetic */ void setLayout(View view) {
            this.layout = view;
        }

        @Nullable
        public final Integer getLayoutRes() {
            return this.layoutRes;
        }

        public final /* synthetic */ void setLayoutRes(Integer n) {
            this.layoutRes = n;
        }

        public final boolean isVisibleOverlay() {
            return this.isVisibleOverlay;
        }

        public final /* synthetic */ void setVisibleOverlay(boolean bl) {
            this.isVisibleOverlay = bl;
        }

        public final int getOverlayColor() {
            return this.overlayColor;
        }

        public final /* synthetic */ void setOverlayColor(int n) {
            this.overlayColor = n;
        }

        public final float getOverlayPadding() {
            return this.overlayPadding;
        }

        public final /* synthetic */ void setOverlayPadding(float f) {
            this.overlayPadding = f;
        }

        public final int getOverlayPaddingColor() {
            return this.overlayPaddingColor;
        }

        public final /* synthetic */ void setOverlayPaddingColor(int n) {
            this.overlayPaddingColor = n;
        }

        @Nullable
        public final Point getOverlayPosition() {
            return this.overlayPosition;
        }

        public final /* synthetic */ void setOverlayPosition(Point point) {
            this.overlayPosition = point;
        }

        @NotNull
        public final BalloonOverlayShape getOverlayShape() {
            return this.overlayShape;
        }

        public final /* synthetic */ void setOverlayShape(BalloonOverlayShape balloonOverlayShape) {
            Intrinsics.checkNotNullParameter((Object)balloonOverlayShape, (String)"<set-?>");
            this.overlayShape = balloonOverlayShape;
        }

        @Nullable
        public final OnBalloonClickListener getOnBalloonClickListener() {
            return this.onBalloonClickListener;
        }

        public final /* synthetic */ void setOnBalloonClickListener(OnBalloonClickListener onBalloonClickListener) {
            this.onBalloonClickListener = onBalloonClickListener;
        }

        @Nullable
        public final OnBalloonDismissListener getOnBalloonDismissListener() {
            return this.onBalloonDismissListener;
        }

        public final /* synthetic */ void setOnBalloonDismissListener(OnBalloonDismissListener onBalloonDismissListener) {
            this.onBalloonDismissListener = onBalloonDismissListener;
        }

        @Nullable
        public final OnBalloonInitializedListener getOnBalloonInitializedListener() {
            return this.onBalloonInitializedListener;
        }

        public final /* synthetic */ void setOnBalloonInitializedListener(OnBalloonInitializedListener onBalloonInitializedListener) {
            this.onBalloonInitializedListener = onBalloonInitializedListener;
        }

        @Nullable
        public final OnBalloonOutsideTouchListener getOnBalloonOutsideTouchListener() {
            return this.onBalloonOutsideTouchListener;
        }

        public final /* synthetic */ void setOnBalloonOutsideTouchListener(OnBalloonOutsideTouchListener onBalloonOutsideTouchListener) {
            this.onBalloonOutsideTouchListener = onBalloonOutsideTouchListener;
        }

        @Nullable
        public final View.OnTouchListener getOnBalloonTouchListener() {
            return this.onBalloonTouchListener;
        }

        public final /* synthetic */ void setOnBalloonTouchListener(View.OnTouchListener onTouchListener) {
            this.onBalloonTouchListener = onTouchListener;
        }

        @Nullable
        public final View.OnTouchListener getOnBalloonOverlayTouchListener() {
            return this.onBalloonOverlayTouchListener;
        }

        public final /* synthetic */ void setOnBalloonOverlayTouchListener(View.OnTouchListener onTouchListener) {
            this.onBalloonOverlayTouchListener = onTouchListener;
        }

        @Nullable
        public final OnBalloonOverlayClickListener getOnBalloonOverlayClickListener() {
            return this.onBalloonOverlayClickListener;
        }

        public final /* synthetic */ void setOnBalloonOverlayClickListener(OnBalloonOverlayClickListener onBalloonOverlayClickListener) {
            this.onBalloonOverlayClickListener = onBalloonOverlayClickListener;
        }

        public final boolean getDismissWhenTouchOutside() {
            return this.dismissWhenTouchOutside;
        }

        public final /* synthetic */ void setDismissWhenTouchOutside(boolean bl) {
            this.dismissWhenTouchOutside = bl;
        }

        public final boolean getDismissWhenShowAgain() {
            return this.dismissWhenShowAgain;
        }

        public final /* synthetic */ void setDismissWhenShowAgain(boolean bl) {
            this.dismissWhenShowAgain = bl;
        }

        public final boolean getDismissWhenClicked() {
            return this.dismissWhenClicked;
        }

        public final /* synthetic */ void setDismissWhenClicked(boolean bl) {
            this.dismissWhenClicked = bl;
        }

        public final boolean getDismissWhenOverlayClicked() {
            return this.dismissWhenOverlayClicked;
        }

        public final /* synthetic */ void setDismissWhenOverlayClicked(boolean bl) {
            this.dismissWhenOverlayClicked = bl;
        }

        public final boolean getDismissWhenLifecycleOnPause() {
            return this.dismissWhenLifecycleOnPause;
        }

        public final /* synthetic */ void setDismissWhenLifecycleOnPause(boolean bl) {
            this.dismissWhenLifecycleOnPause = bl;
        }

        public final boolean getPassTouchEventToAnchor() {
            return this.passTouchEventToAnchor;
        }

        public final /* synthetic */ void setPassTouchEventToAnchor(boolean bl) {
            this.passTouchEventToAnchor = bl;
        }

        public final long getAutoDismissDuration() {
            return this.autoDismissDuration;
        }

        public final /* synthetic */ void setAutoDismissDuration(long l) {
            this.autoDismissDuration = l;
        }

        @Nullable
        public final LifecycleOwner getLifecycleOwner() {
            return this.lifecycleOwner;
        }

        public final /* synthetic */ void setLifecycleOwner(LifecycleOwner lifecycleOwner) {
            this.lifecycleOwner = lifecycleOwner;
        }

        @Nullable
        public final LifecycleObserver getLifecycleObserver() {
            return this.lifecycleObserver;
        }

        public final /* synthetic */ void setLifecycleObserver(LifecycleObserver lifecycleObserver) {
            this.lifecycleObserver = lifecycleObserver;
        }

        public final int getBalloonAnimationStyle() {
            return this.balloonAnimationStyle;
        }

        public final /* synthetic */ void setBalloonAnimationStyle(int n) {
            this.balloonAnimationStyle = n;
        }

        public final int getBalloonOverlayAnimationStyle() {
            return this.balloonOverlayAnimationStyle;
        }

        public final /* synthetic */ void setBalloonOverlayAnimationStyle(int n) {
            this.balloonOverlayAnimationStyle = n;
        }

        @NotNull
        public final BalloonAnimation getBalloonAnimation() {
            return this.balloonAnimation;
        }

        public final /* synthetic */ void setBalloonAnimation(BalloonAnimation balloonAnimation) {
            Intrinsics.checkNotNullParameter((Object)((Object)balloonAnimation), (String)"<set-?>");
            this.balloonAnimation = balloonAnimation;
        }

        @NotNull
        public final BalloonOverlayAnimation getBalloonOverlayAnimation() {
            return this.balloonOverlayAnimation;
        }

        public final /* synthetic */ void setBalloonOverlayAnimation(BalloonOverlayAnimation balloonOverlayAnimation) {
            Intrinsics.checkNotNullParameter((Object)((Object)balloonOverlayAnimation), (String)"<set-?>");
            this.balloonOverlayAnimation = balloonOverlayAnimation;
        }

        public final long getCircularDuration() {
            return this.circularDuration;
        }

        public final /* synthetic */ void setCircularDuration(long l) {
            this.circularDuration = l;
        }

        @NotNull
        public final BalloonHighlightAnimation getBalloonHighlightAnimation() {
            return this.balloonHighlightAnimation;
        }

        public final /* synthetic */ void setBalloonHighlightAnimation(BalloonHighlightAnimation balloonHighlightAnimation) {
            Intrinsics.checkNotNullParameter((Object)((Object)balloonHighlightAnimation), (String)"<set-?>");
            this.balloonHighlightAnimation = balloonHighlightAnimation;
        }

        public final int getBalloonHighlightAnimationStyle() {
            return this.balloonHighlightAnimationStyle;
        }

        public final /* synthetic */ void setBalloonHighlightAnimationStyle(int n) {
            this.balloonHighlightAnimationStyle = n;
        }

        public final long getBalloonHighlightAnimationStartDelay() {
            return this.balloonHighlightAnimationStartDelay;
        }

        public final /* synthetic */ void setBalloonHighlightAnimationStartDelay(long l) {
            this.balloonHighlightAnimationStartDelay = l;
        }

        @Nullable
        public final BalloonRotateAnimation getBalloonRotateAnimation() {
            return this.balloonRotateAnimation;
        }

        public final /* synthetic */ void setBalloonRotateAnimation(BalloonRotateAnimation balloonRotateAnimation) {
            this.balloonRotateAnimation = balloonRotateAnimation;
        }

        @Nullable
        public final String getPreferenceName() {
            return this.preferenceName;
        }

        public final /* synthetic */ void setPreferenceName(String string) {
            this.preferenceName = string;
        }

        public final int getShowTimes() {
            return this.showTimes;
        }

        public final /* synthetic */ void setShowTimes(int n) {
            this.showTimes = n;
        }

        @Nullable
        public final Function0<Unit> getRunIfReachedShowCounts() {
            return this.runIfReachedShowCounts;
        }

        public final /* synthetic */ void setRunIfReachedShowCounts(Function0 function0) {
            this.runIfReachedShowCounts = function0;
        }

        public final boolean isRtlLayout() {
            return this.isRtlLayout;
        }

        public final /* synthetic */ void setRtlLayout(boolean bl) {
            this.isRtlLayout = bl;
        }

        public final int getSupportRtlLayoutFactor() {
            return this.supportRtlLayoutFactor;
        }

        public final /* synthetic */ void setSupportRtlLayoutFactor(int n) {
            this.supportRtlLayoutFactor = n;
        }

        public final boolean isFocusable() {
            return this.isFocusable;
        }

        public final /* synthetic */ void setFocusable(boolean bl) {
            this.isFocusable = bl;
        }

        public final boolean isStatusBarVisible() {
            return this.isStatusBarVisible;
        }

        public final /* synthetic */ void setStatusBarVisible(boolean bl) {
            this.isStatusBarVisible = bl;
        }

        public final boolean isAttachedInDecor() {
            return this.isAttachedInDecor;
        }

        public final /* synthetic */ void setAttachedInDecor(boolean bl) {
            this.isAttachedInDecor = bl;
        }

        @NotNull
        public final Builder setWidth(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setWidth_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            boolean bl4 = value2 > 0 || value2 == Integer.MIN_VALUE;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "The width of the balloon must bigger than zero.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setWidth_u24lambda_u2d1.setWidth(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setWidthResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setWidthResource_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            $this$setWidthResource_u24lambda_u2d2.setWidth(ContextExtensionKt.dimenPixel($this$setWidthResource_u24lambda_u2d2.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setMinWidth(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMinWidth_u24lambda_u2d3 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setMinWidth_u24lambda_u2d3.setMinWidth(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setMinWidthResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMinWidthResource_u24lambda_u2d4 = builder;
            boolean bl3 = false;
            $this$setMinWidthResource_u24lambda_u2d4.setMinWidth(ContextExtensionKt.dimenPixel($this$setMinWidthResource_u24lambda_u2d4.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setMaxWidth(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMaxWidth_u24lambda_u2d5 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setMaxWidth_u24lambda_u2d5.setMaxWidth(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setMaxWidthResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMaxWidthResource_u24lambda_u2d6 = builder;
            boolean bl3 = false;
            $this$setMaxWidthResource_u24lambda_u2d6.setMaxWidth(ContextExtensionKt.dimenPixel($this$setMaxWidthResource_u24lambda_u2d6.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setWidthRatio(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setWidthRatio_u24lambda_u2d7 = builder;
            boolean bl3 = false;
            $this$setWidthRatio_u24lambda_u2d7.setWidthRatio(value2);
            return builder;
        }

        @NotNull
        public final Builder setMinWidthRatio(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMinWidthRatio_u24lambda_u2d8 = builder;
            boolean bl3 = false;
            $this$setMinWidthRatio_u24lambda_u2d8.setMinWidthRatio(value2);
            return builder;
        }

        @NotNull
        public final Builder setMaxWidthRatio(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMaxWidthRatio_u24lambda_u2d9 = builder;
            boolean bl3 = false;
            $this$setMaxWidthRatio_u24lambda_u2d9.setMaxWidthRatio(value2);
            return builder;
        }

        @NotNull
        public final Builder setHeight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setHeight_u24lambda_u2d11 = builder;
            boolean bl3 = false;
            boolean bl4 = value2 > 0 || value2 == Integer.MIN_VALUE;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "The height of the balloon must bigger than zero.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setHeight_u24lambda_u2d11.setHeight(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setHeightResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setHeightResource_u24lambda_u2d12 = builder;
            boolean bl3 = false;
            $this$setHeightResource_u24lambda_u2d12.setHeight(ContextExtensionKt.dimenPixel($this$setHeightResource_u24lambda_u2d12.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setSize(@Dp int width, @Dp int height) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setSize_u24lambda_u2d13 = builder;
            boolean bl3 = false;
            $this$setSize_u24lambda_u2d13.setWidth(width);
            $this$setSize_u24lambda_u2d13.setHeight(height);
            return builder;
        }

        @NotNull
        public final Builder setSizeResource(@DimenRes int width, @DimenRes int height) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setSizeResource_u24lambda_u2d14 = builder;
            boolean bl3 = false;
            $this$setSizeResource_u24lambda_u2d14.setWidthResource(width);
            $this$setSizeResource_u24lambda_u2d14.setHeightResource(height);
            return builder;
        }

        @NotNull
        public final Builder setPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPadding_u24lambda_u2d15 = builder;
            boolean bl3 = false;
            $this$setPadding_u24lambda_u2d15.setPaddingLeft(value2);
            $this$setPadding_u24lambda_u2d15.setPaddingTop(value2);
            $this$setPadding_u24lambda_u2d15.setPaddingRight(value2);
            $this$setPadding_u24lambda_u2d15.setPaddingBottom(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingResource_u24lambda_u2d16 = builder;
            boolean bl3 = false;
            int padding = ContextExtensionKt.dimenPixel($this$setPaddingResource_u24lambda_u2d16.context, value2);
            $this$setPaddingResource_u24lambda_u2d16.setPaddingLeft(padding);
            $this$setPaddingResource_u24lambda_u2d16.setPaddingTop(padding);
            $this$setPaddingResource_u24lambda_u2d16.setPaddingRight(padding);
            $this$setPaddingResource_u24lambda_u2d16.setPaddingBottom(padding);
            return builder;
        }

        @NotNull
        public final Builder setPaddingHorizontal(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingHorizontal_u24lambda_u2d17 = builder;
            boolean bl3 = false;
            $this$setPaddingHorizontal_u24lambda_u2d17.setPaddingLeft(value2);
            $this$setPaddingHorizontal_u24lambda_u2d17.setPaddingRight(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingHorizontalResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingHorizontalResource_u24lambda_u2d18 = builder;
            boolean bl3 = false;
            $this$setPaddingHorizontalResource_u24lambda_u2d18.setPaddingLeftResource(value2);
            $this$setPaddingHorizontalResource_u24lambda_u2d18.setPaddingRightResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingVertical(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingVertical_u24lambda_u2d19 = builder;
            boolean bl3 = false;
            $this$setPaddingVertical_u24lambda_u2d19.setPaddingTop(value2);
            $this$setPaddingVertical_u24lambda_u2d19.setPaddingBottom(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingVerticalResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingVerticalResource_u24lambda_u2d20 = builder;
            boolean bl3 = false;
            $this$setPaddingVerticalResource_u24lambda_u2d20.setPaddingTopResource(value2);
            $this$setPaddingVerticalResource_u24lambda_u2d20.setPaddingBottomResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setPaddingLeft(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingLeft_u24lambda_u2d21 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setPaddingLeft_u24lambda_u2d21.setPaddingLeft(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setPaddingLeftResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingLeftResource_u24lambda_u2d22 = builder;
            boolean bl3 = false;
            $this$setPaddingLeftResource_u24lambda_u2d22.setPaddingLeft(ContextExtensionKt.dimenPixel($this$setPaddingLeftResource_u24lambda_u2d22.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setPaddingTop(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingTop_u24lambda_u2d23 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setPaddingTop_u24lambda_u2d23.setPaddingTop(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setPaddingTopResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingTopResource_u24lambda_u2d24 = builder;
            boolean bl3 = false;
            $this$setPaddingTopResource_u24lambda_u2d24.setPaddingTop(ContextExtensionKt.dimenPixel($this$setPaddingTopResource_u24lambda_u2d24.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setPaddingRight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingRight_u24lambda_u2d25 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setPaddingRight_u24lambda_u2d25.setPaddingRight(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setPaddingRightResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingRightResource_u24lambda_u2d26 = builder;
            boolean bl3 = false;
            $this$setPaddingRightResource_u24lambda_u2d26.setPaddingRight(ContextExtensionKt.dimenPixel($this$setPaddingRightResource_u24lambda_u2d26.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setPaddingBottom(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingBottom_u24lambda_u2d27 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setPaddingBottom_u24lambda_u2d27.setPaddingBottom(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setPaddingBottomResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPaddingBottomResource_u24lambda_u2d28 = builder;
            boolean bl3 = false;
            $this$setPaddingBottomResource_u24lambda_u2d28.setPaddingBottom(ContextExtensionKt.dimenPixel($this$setPaddingBottomResource_u24lambda_u2d28.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setMargin(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMargin_u24lambda_u2d29 = builder;
            boolean bl3 = false;
            $this$setMargin_u24lambda_u2d29.setMarginLeft(value2);
            $this$setMargin_u24lambda_u2d29.setMarginTop(value2);
            $this$setMargin_u24lambda_u2d29.setMarginRight(value2);
            $this$setMargin_u24lambda_u2d29.setMarginBottom(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginResource_u24lambda_u2d30 = builder;
            boolean bl3 = false;
            int margin = ContextExtensionKt.dimenPixel($this$setMarginResource_u24lambda_u2d30.context, value2);
            $this$setMarginResource_u24lambda_u2d30.setMarginLeft(margin);
            $this$setMarginResource_u24lambda_u2d30.setMarginTop(margin);
            $this$setMarginResource_u24lambda_u2d30.setMarginRight(margin);
            $this$setMarginResource_u24lambda_u2d30.setMarginBottom(margin);
            return builder;
        }

        @NotNull
        public final Builder setMarginHorizontal(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginHorizontal_u24lambda_u2d31 = builder;
            boolean bl3 = false;
            $this$setMarginHorizontal_u24lambda_u2d31.setMarginLeft(value2);
            $this$setMarginHorizontal_u24lambda_u2d31.setMarginRight(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginHorizontalResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginHorizontalResource_u24lambda_u2d32 = builder;
            boolean bl3 = false;
            $this$setMarginHorizontalResource_u24lambda_u2d32.setMarginLeftResource(value2);
            $this$setMarginHorizontalResource_u24lambda_u2d32.setMarginRightResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginVertical(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginVertical_u24lambda_u2d33 = builder;
            boolean bl3 = false;
            $this$setMarginVertical_u24lambda_u2d33.setMarginTop(value2);
            $this$setMarginVertical_u24lambda_u2d33.setMarginBottom(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginVerticalResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginVerticalResource_u24lambda_u2d34 = builder;
            boolean bl3 = false;
            $this$setMarginVerticalResource_u24lambda_u2d34.setMarginTopResource(value2);
            $this$setMarginVerticalResource_u24lambda_u2d34.setMarginBottomResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setMarginLeft(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginLeft_u24lambda_u2d35 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setMarginLeft_u24lambda_u2d35.setMarginLeft(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setMarginLeftResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginLeftResource_u24lambda_u2d36 = builder;
            boolean bl3 = false;
            $this$setMarginLeftResource_u24lambda_u2d36.setMarginLeft(ContextExtensionKt.dimenPixel($this$setMarginLeftResource_u24lambda_u2d36.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setMarginTop(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginTop_u24lambda_u2d37 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setMarginTop_u24lambda_u2d37.setMarginTop(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setMarginTopResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginTopResource_u24lambda_u2d38 = builder;
            boolean bl3 = false;
            $this$setMarginTopResource_u24lambda_u2d38.setMarginTop(ContextExtensionKt.dimenPixel($this$setMarginTopResource_u24lambda_u2d38.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setMarginRight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginRight_u24lambda_u2d39 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setMarginRight_u24lambda_u2d39.setMarginRight(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setMarginRightResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginRightResource_u24lambda_u2d40 = builder;
            boolean bl3 = false;
            $this$setMarginRightResource_u24lambda_u2d40.setMarginRight(ContextExtensionKt.dimenPixel($this$setMarginRightResource_u24lambda_u2d40.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setMarginBottom(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginBottom_u24lambda_u2d41 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setMarginBottom_u24lambda_u2d41.setMarginBottom(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setMarginBottomResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMarginBottomResource_u24lambda_u2d42 = builder;
            boolean bl3 = false;
            $this$setMarginBottomResource_u24lambda_u2d42.setMarginBottom(ContextExtensionKt.dimenPixel($this$setMarginBottomResource_u24lambda_u2d42.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setIsVisibleArrow(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIsVisibleArrow_u24lambda_u2d43 = builder;
            boolean bl3 = false;
            $this$setIsVisibleArrow_u24lambda_u2d43.setVisibleArrow(value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowColor_u24lambda_u2d44 = builder;
            boolean bl3 = false;
            $this$setArrowColor_u24lambda_u2d44.setArrowColor(value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowColorMatchBalloon(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowColorMatchBalloon_u24lambda_u2d45 = builder;
            boolean bl3 = false;
            $this$setArrowColorMatchBalloon_u24lambda_u2d45.setArrowColorMatchBalloon(value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowColorResource_u24lambda_u2d46 = builder;
            boolean bl3 = false;
            $this$setArrowColorResource_u24lambda_u2d46.setArrowColor(ContextExtensionKt.contextColor($this$setArrowColorResource_u24lambda_u2d46.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setArrowSize(@Dp int value2) {
            int n;
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowSize_u24lambda_u2d47 = builder;
            boolean bl3 = false;
            if (value2 == Integer.MIN_VALUE) {
                n = Integer.MIN_VALUE;
            } else {
                int $this$dp$iv = value2;
                boolean $i$f$getDp = false;
                n = MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()));
            }
            $this$setArrowSize_u24lambda_u2d47.setArrowSize(n);
            return builder;
        }

        @NotNull
        public final Builder setArrowSizeResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowSizeResource_u24lambda_u2d48 = builder;
            boolean bl3 = false;
            $this$setArrowSizeResource_u24lambda_u2d48.setArrowSize(ContextExtensionKt.dimenPixel($this$setArrowSizeResource_u24lambda_u2d48.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setArrowPosition(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowPosition_u24lambda_u2d49 = builder;
            boolean bl3 = false;
            $this$setArrowPosition_u24lambda_u2d49.setArrowPosition(value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowPositionRules(@NotNull ArrowPositionRules value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowPositionRules_u24lambda_u2d50 = builder;
            boolean bl3 = false;
            $this$setArrowPositionRules_u24lambda_u2d50.setArrowPositionRules(value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowOrientation(@NotNull ArrowOrientation value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowOrientation_u24lambda_u2d51 = builder;
            boolean bl3 = false;
            $this$setArrowOrientation_u24lambda_u2d51.setArrowOrientation(value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowOrientationRules(@NotNull ArrowOrientationRules value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowOrientationRules_u24lambda_u2d52 = builder;
            boolean bl3 = false;
            $this$setArrowOrientationRules_u24lambda_u2d52.setArrowOrientationRules(value2);
            return builder;
        }

        @NotNull
        public final Builder setArrowDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowDrawable_u24lambda_u2d53 = builder;
            boolean bl3 = false;
            Drawable drawable = value2;
            $this$setArrowDrawable_u24lambda_u2d53.setArrowDrawable(drawable == null ? null : drawable.mutate());
            if (value2 != null && $this$setArrowDrawable_u24lambda_u2d53.getArrowSize() == Integer.MIN_VALUE) {
                int n = value2.getIntrinsicWidth();
                int n2 = value2.getIntrinsicHeight();
                boolean bl4 = false;
                $this$setArrowDrawable_u24lambda_u2d53.setArrowSize(Math.max(n, n2));
            }
            return builder;
        }

        @NotNull
        public final Builder setArrowDrawableResource(@DrawableRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowDrawableResource_u24lambda_u2d54 = builder;
            boolean bl3 = false;
            $this$setArrowDrawableResource_u24lambda_u2d54.setArrowDrawable(ContextExtensionKt.contextDrawable($this$setArrowDrawableResource_u24lambda_u2d54.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setArrowLeftPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowLeftPadding_u24lambda_u2d55 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setArrowLeftPadding_u24lambda_u2d55.setArrowLeftPadding(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setArrowLeftPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowLeftPaddingResource_u24lambda_u2d56 = builder;
            boolean bl3 = false;
            $this$setArrowLeftPaddingResource_u24lambda_u2d56.setArrowLeftPadding(ContextExtensionKt.dimenPixel($this$setArrowLeftPaddingResource_u24lambda_u2d56.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setArrowRightPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowRightPadding_u24lambda_u2d57 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setArrowRightPadding_u24lambda_u2d57.setArrowRightPadding(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setArrowRightPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowRightPaddingResource_u24lambda_u2d58 = builder;
            boolean bl3 = false;
            $this$setArrowRightPaddingResource_u24lambda_u2d58.setArrowRightPadding(ContextExtensionKt.dimenPixel($this$setArrowRightPaddingResource_u24lambda_u2d58.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setArrowTopPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowTopPadding_u24lambda_u2d59 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setArrowTopPadding_u24lambda_u2d59.setArrowTopPadding(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setArrowTopPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowTopPaddingResource_u24lambda_u2d60 = builder;
            boolean bl3 = false;
            $this$setArrowTopPaddingResource_u24lambda_u2d60.setArrowTopPadding(ContextExtensionKt.dimenPixel($this$setArrowTopPaddingResource_u24lambda_u2d60.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setArrowBottomPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowBottomPadding_u24lambda_u2d61 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setArrowBottomPadding_u24lambda_u2d61.setArrowBottomPadding(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setArrowBottomPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowBottomPaddingResource_u24lambda_u2d62 = builder;
            boolean bl3 = false;
            $this$setArrowBottomPaddingResource_u24lambda_u2d62.setArrowBottomPadding(ContextExtensionKt.dimenPixel($this$setArrowBottomPaddingResource_u24lambda_u2d62.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setArrowAlignAnchorPadding(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowAlignAnchorPadding_u24lambda_u2d63 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setArrowAlignAnchorPadding_u24lambda_u2d63.setArrowAlignAnchorPadding(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setArrowAlignAnchorPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowAlignAnchorPaddingResource_u24lambda_u2d64 = builder;
            boolean bl3 = false;
            $this$setArrowAlignAnchorPaddingResource_u24lambda_u2d64.setArrowAlignAnchorPadding(ContextExtensionKt.dimenPixel($this$setArrowAlignAnchorPaddingResource_u24lambda_u2d64.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setArrowAlignAnchorPaddingRatio(float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowAlignAnchorPaddingRatio_u24lambda_u2d65 = builder;
            boolean bl3 = false;
            $this$setArrowAlignAnchorPaddingRatio_u24lambda_u2d65.setArrowAlignAnchorPaddingRatio(value2);
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setArrowElevation(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowElevation_u24lambda_u2d66 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setArrowElevation_u24lambda_u2d66.setArrowElevation((float)MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setArrowElevationResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setArrowElevationResource_u24lambda_u2d67 = builder;
            boolean bl3 = false;
            $this$setArrowElevationResource_u24lambda_u2d67.setArrowElevation(ContextExtensionKt.dimen($this$setArrowElevationResource_u24lambda_u2d67.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBackgroundColor_u24lambda_u2d68 = builder;
            boolean bl3 = false;
            $this$setBackgroundColor_u24lambda_u2d68.setBackgroundColor(value2);
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBackgroundColorResource_u24lambda_u2d69 = builder;
            boolean bl3 = false;
            $this$setBackgroundColorResource_u24lambda_u2d69.setBackgroundColor(ContextExtensionKt.contextColor($this$setBackgroundColorResource_u24lambda_u2d69.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setBackgroundDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBackgroundDrawable_u24lambda_u2d70 = builder;
            boolean bl3 = false;
            Drawable drawable = value2;
            $this$setBackgroundDrawable_u24lambda_u2d70.setBackgroundDrawable(drawable == null ? null : drawable.mutate());
            return builder;
        }

        @NotNull
        public final Builder setBackgroundDrawableResource(@DrawableRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBackgroundDrawableResource_u24lambda_u2d71 = builder;
            boolean bl3 = false;
            Drawable drawable = ContextExtensionKt.contextDrawable($this$setBackgroundDrawableResource_u24lambda_u2d71.context, value2);
            $this$setBackgroundDrawableResource_u24lambda_u2d71.setBackgroundDrawable(drawable == null ? null : drawable.mutate());
            return builder;
        }

        @NotNull
        public final Builder setCornerRadius(@Dp float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setCornerRadius_u24lambda_u2d72 = builder;
            boolean bl3 = false;
            float $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setCornerRadius_u24lambda_u2d72.setCornerRadius(TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setCornerRadiusResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setCornerRadiusResource_u24lambda_u2d73 = builder;
            boolean bl3 = false;
            $this$setCornerRadiusResource_u24lambda_u2d73.setCornerRadius(ContextExtensionKt.dimen($this$setCornerRadiusResource_u24lambda_u2d73.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setText(@NotNull CharSequence value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setText_u24lambda_u2d74 = builder;
            boolean bl3 = false;
            $this$setText_u24lambda_u2d74.setText(value2);
            return builder;
        }

        @NotNull
        public final Builder setTextResource(@StringRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextResource_u24lambda_u2d75 = builder;
            boolean bl3 = false;
            String string = $this$setTextResource_u24lambda_u2d75.context.getString(value2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(value)");
            $this$setTextResource_u24lambda_u2d75.setText(string);
            return builder;
        }

        @NotNull
        public final Builder setTextColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextColor_u24lambda_u2d76 = builder;
            boolean bl3 = false;
            $this$setTextColor_u24lambda_u2d76.setTextColor(value2);
            return builder;
        }

        @NotNull
        public final Builder setTextColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextColorResource_u24lambda_u2d77 = builder;
            boolean bl3 = false;
            $this$setTextColorResource_u24lambda_u2d77.setTextColor(ContextExtensionKt.contextColor($this$setTextColorResource_u24lambda_u2d77.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setTextIsHtml(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextIsHtml_u24lambda_u2d78 = builder;
            boolean bl3 = false;
            $this$setTextIsHtml_u24lambda_u2d78.setTextIsHtml(value2);
            return builder;
        }

        @NotNull
        public final Builder setMovementMethod(@NotNull MovementMethod value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setMovementMethod_u24lambda_u2d79 = builder;
            boolean bl3 = false;
            $this$setMovementMethod_u24lambda_u2d79.setMovementMethod(value2);
            return builder;
        }

        @NotNull
        public final Builder setTextSize(@Sp float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextSize_u24lambda_u2d80 = builder;
            boolean bl3 = false;
            $this$setTextSize_u24lambda_u2d80.setTextSize(value2);
            return builder;
        }

        @NotNull
        public final Builder setTextSizeResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextSizeResource_u24lambda_u2d81 = builder;
            boolean bl3 = false;
            $this$setTextSizeResource_u24lambda_u2d81.setTextSize(ContextExtensionKt.px2Sp($this$setTextSizeResource_u24lambda_u2d81.context, ContextExtensionKt.dimen($this$setTextSizeResource_u24lambda_u2d81.context, value2)));
            return builder;
        }

        @NotNull
        public final Builder setTextTypeface(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextTypeface_u24lambda_u2d82 = builder;
            boolean bl3 = false;
            $this$setTextTypeface_u24lambda_u2d82.setTextTypeface(value2);
            return builder;
        }

        @NotNull
        public final Builder setTextTypeface(@NotNull Typeface value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextTypeface_u24lambda_u2d83 = builder;
            boolean bl3 = false;
            $this$setTextTypeface_u24lambda_u2d83.setTextTypefaceObject(value2);
            return builder;
        }

        @NotNull
        public final Builder setTextGravity(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextGravity_u24lambda_u2d84 = builder;
            boolean bl3 = false;
            $this$setTextGravity_u24lambda_u2d84.setTextGravity(value2);
            return builder;
        }

        @NotNull
        public final Builder setTextForm(@NotNull TextForm value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setTextForm_u24lambda_u2d85 = builder;
            boolean bl3 = false;
            $this$setTextForm_u24lambda_u2d85.setTextForm(value2);
            return builder;
        }

        @NotNull
        public final Builder setIconDrawable(@Nullable Drawable value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconDrawable_u24lambda_u2d86 = builder;
            boolean bl3 = false;
            Drawable drawable = value2;
            $this$setIconDrawable_u24lambda_u2d86.setIconDrawable(drawable == null ? null : drawable.mutate());
            return builder;
        }

        @NotNull
        public final Builder setIconDrawableResource(@DrawableRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconDrawableResource_u24lambda_u2d87 = builder;
            boolean bl3 = false;
            Drawable drawable = ContextExtensionKt.contextDrawable($this$setIconDrawableResource_u24lambda_u2d87.context, value2);
            $this$setIconDrawableResource_u24lambda_u2d87.setIconDrawable(drawable == null ? null : drawable.mutate());
            return builder;
        }

        @NotNull
        public final Builder setIconGravity(@NotNull IconGravity value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconGravity_u24lambda_u2d88 = builder;
            boolean bl3 = false;
            $this$setIconGravity_u24lambda_u2d88.setIconGravity(value2);
            return builder;
        }

        @NotNull
        public final Builder setIconWidth(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconWidth_u24lambda_u2d89 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setIconWidth_u24lambda_u2d89.setIconWidth(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setIconWidthResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconWidthResource_u24lambda_u2d90 = builder;
            boolean bl3 = false;
            $this$setIconWidthResource_u24lambda_u2d90.setIconWidth(ContextExtensionKt.dimenPixel($this$setIconWidthResource_u24lambda_u2d90.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setIconHeight(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconHeight_u24lambda_u2d91 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setIconHeight_u24lambda_u2d91.setIconHeight(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setIconHeightResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconHeightResource_u24lambda_u2d92 = builder;
            boolean bl3 = false;
            $this$setIconHeightResource_u24lambda_u2d92.setIconHeight(ContextExtensionKt.dimenPixel($this$setIconHeightResource_u24lambda_u2d92.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setIconSize(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconSize_u24lambda_u2d93 = builder;
            boolean bl3 = false;
            $this$setIconSize_u24lambda_u2d93.setIconWidth(value2);
            $this$setIconSize_u24lambda_u2d93.setIconHeight(value2);
            return builder;
        }

        @NotNull
        public final Builder setIconSizeResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconSizeResource_u24lambda_u2d94 = builder;
            boolean bl3 = false;
            $this$setIconSizeResource_u24lambda_u2d94.setIconWidthResource(value2);
            $this$setIconSizeResource_u24lambda_u2d94.setIconHeightResource(value2);
            return builder;
        }

        @NotNull
        public final Builder setIconColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconColor_u24lambda_u2d95 = builder;
            boolean bl3 = false;
            $this$setIconColor_u24lambda_u2d95.setIconColor(value2);
            return builder;
        }

        @NotNull
        public final Builder setIconColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconColorResource_u24lambda_u2d96 = builder;
            boolean bl3 = false;
            $this$setIconColorResource_u24lambda_u2d96.setIconColor(ContextExtensionKt.contextColor($this$setIconColorResource_u24lambda_u2d96.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setIconSpace(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconSpace_u24lambda_u2d97 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setIconSpace_u24lambda_u2d97.setIconSpace(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @NotNull
        public final Builder setIconSpaceResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconSpaceResource_u24lambda_u2d98 = builder;
            boolean bl3 = false;
            $this$setIconSpaceResource_u24lambda_u2d98.setIconSpace(ContextExtensionKt.dimenPixel($this$setIconSpaceResource_u24lambda_u2d98.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setIconForm(@NotNull IconForm value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIconForm_u24lambda_u2d99 = builder;
            boolean bl3 = false;
            $this$setIconForm_u24lambda_u2d99.setIconForm(value2);
            return builder;
        }

        @NotNull
        public final Builder setAlpha(@FloatRange(from=0.0, to=1.0) float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setAlpha_u24lambda_u2d100 = builder;
            boolean bl3 = false;
            $this$setAlpha_u24lambda_u2d100.setAlpha(value2);
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setElevation(@Dp int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setElevation_u24lambda_u2d101 = builder;
            boolean bl3 = false;
            int $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setElevation_u24lambda_u2d101.setElevation((float)MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
            return builder;
        }

        @TargetApi(value=21)
        @NotNull
        public final Builder setElevationResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setElevationResource_u24lambda_u2d102 = builder;
            boolean bl3 = false;
            $this$setElevationResource_u24lambda_u2d102.setElevation(ContextExtensionKt.dimen($this$setElevationResource_u24lambda_u2d102.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setLayout(@LayoutRes int layoutRes) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setLayout_u24lambda_u2d103 = builder;
            boolean bl3 = false;
            $this$setLayout_u24lambda_u2d103.setLayoutRes(layoutRes);
            return builder;
        }

        @NotNull
        public final Builder setLayout(@NotNull View layout) {
            Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setLayout_u24lambda_u2d104 = builder;
            boolean bl3 = false;
            $this$setLayout_u24lambda_u2d104.setLayout(layout);
            return builder;
        }

        @NotNull
        public final <T extends ViewBinding> Builder setLayout(@NotNull T binding) {
            Intrinsics.checkNotNullParameter(binding, (String)"binding");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setLayout_u24lambda_u2d105 = builder;
            boolean bl3 = false;
            $this$setLayout_u24lambda_u2d105.setLayout(binding.getRoot());
            return builder;
        }

        @NotNull
        public final Builder setIsVisibleOverlay(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIsVisibleOverlay_u24lambda_u2d106 = builder;
            boolean bl3 = false;
            $this$setIsVisibleOverlay_u24lambda_u2d106.setVisibleOverlay(value2);
            return builder;
        }

        @NotNull
        public final Builder setOverlayColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOverlayColor_u24lambda_u2d107 = builder;
            boolean bl3 = false;
            $this$setOverlayColor_u24lambda_u2d107.setOverlayColor(value2);
            return builder;
        }

        @NotNull
        public final Builder setOverlayColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOverlayColorResource_u24lambda_u2d108 = builder;
            boolean bl3 = false;
            $this$setOverlayColorResource_u24lambda_u2d108.setOverlayColor(ContextExtensionKt.contextColor($this$setOverlayColorResource_u24lambda_u2d108.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setOverlayPadding(@Dp float value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOverlayPadding_u24lambda_u2d109 = builder;
            boolean bl3 = false;
            float $this$dp$iv = value2;
            boolean $i$f$getDp = false;
            $this$setOverlayPadding_u24lambda_u2d109.setOverlayPadding(TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()));
            return builder;
        }

        @NotNull
        public final Builder setOverlayPaddingResource(@DimenRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOverlayPaddingResource_u24lambda_u2d110 = builder;
            boolean bl3 = false;
            $this$setOverlayPaddingResource_u24lambda_u2d110.setOverlayPadding(ContextExtensionKt.dimen($this$setOverlayPaddingResource_u24lambda_u2d110.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setOverlayPaddingColor(@ColorInt int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOverlayPaddingColor_u24lambda_u2d111 = builder;
            boolean bl3 = false;
            $this$setOverlayPaddingColor_u24lambda_u2d111.setOverlayPaddingColor(value2);
            return builder;
        }

        @NotNull
        public final Builder setOverlayPaddingColorResource(@ColorRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOverlayPaddingColorResource_u24lambda_u2d112 = builder;
            boolean bl3 = false;
            $this$setOverlayPaddingColorResource_u24lambda_u2d112.setOverlayPaddingColor(ContextExtensionKt.contextColor($this$setOverlayPaddingColorResource_u24lambda_u2d112.context, value2));
            return builder;
        }

        @NotNull
        public final Builder setOverlayPosition(@NotNull Point value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOverlayPosition_u24lambda_u2d113 = builder;
            boolean bl3 = false;
            $this$setOverlayPosition_u24lambda_u2d113.setOverlayPosition(value2);
            return builder;
        }

        @NotNull
        public final Builder setOverlayShape(@NotNull BalloonOverlayShape value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOverlayShape_u24lambda_u2d114 = builder;
            boolean bl3 = false;
            $this$setOverlayShape_u24lambda_u2d114.setOverlayShape(value2);
            return builder;
        }

        @NotNull
        public final Builder setIsStatusBarVisible(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIsStatusBarVisible_u24lambda_u2d115 = builder;
            boolean bl3 = false;
            $this$setIsStatusBarVisible_u24lambda_u2d115.setStatusBarVisible(value2);
            return builder;
        }

        @NotNull
        public final Builder setIsAttachedInDecor(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setIsAttachedInDecor_u24lambda_u2d116 = builder;
            boolean bl3 = false;
            $this$setIsAttachedInDecor_u24lambda_u2d116.setAttachedInDecor(value2);
            return builder;
        }

        @NotNull
        public final Builder setLifecycleOwner(@Nullable LifecycleOwner value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setLifecycleOwner_u24lambda_u2d117 = builder;
            boolean bl3 = false;
            $this$setLifecycleOwner_u24lambda_u2d117.setLifecycleOwner(value2);
            return builder;
        }

        @NotNull
        public final Builder setLifecycleObserver(@NotNull LifecycleObserver value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setLifecycleObserver_u24lambda_u2d118 = builder;
            boolean bl3 = false;
            $this$setLifecycleObserver_u24lambda_u2d118.setLifecycleObserver(value2);
            return builder;
        }

        @NotNull
        public final Builder setBalloonAnimation(@NotNull BalloonAnimation value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBalloonAnimation_u24lambda_u2d119 = builder;
            boolean bl3 = false;
            $this$setBalloonAnimation_u24lambda_u2d119.setBalloonAnimation(value2);
            if (value2 == BalloonAnimation.CIRCULAR) {
                $this$setBalloonAnimation_u24lambda_u2d119.setFocusable(false);
            }
            return builder;
        }

        @NotNull
        public final Builder setBalloonAnimationStyle(@StyleRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBalloonAnimationStyle_u24lambda_u2d120 = builder;
            boolean bl3 = false;
            $this$setBalloonAnimationStyle_u24lambda_u2d120.setBalloonAnimationStyle(value2);
            return builder;
        }

        @NotNull
        public final Builder setBalloonOverlayAnimation(@NotNull BalloonOverlayAnimation value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBalloonOverlayAnimation_u24lambda_u2d121 = builder;
            boolean bl3 = false;
            $this$setBalloonOverlayAnimation_u24lambda_u2d121.setBalloonOverlayAnimation(value2);
            return builder;
        }

        @NotNull
        public final Builder setBalloonOverlayAnimationStyle(@StyleRes int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBalloonOverlayAnimationStyle_u24lambda_u2d122 = builder;
            boolean bl3 = false;
            $this$setBalloonOverlayAnimationStyle_u24lambda_u2d122.setBalloonOverlayAnimationStyle(value2);
            return builder;
        }

        @NotNull
        public final Builder setCircularDuration(long value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setCircularDuration_u24lambda_u2d123 = builder;
            boolean bl3 = false;
            $this$setCircularDuration_u24lambda_u2d123.setCircularDuration(value2);
            return builder;
        }

        @JvmOverloads
        @NotNull
        public final Builder setBalloonHighlightAnimation(@NotNull BalloonHighlightAnimation value2, long startDelay) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBalloonHighlightAnimation_u24lambda_u2d124 = builder;
            boolean bl3 = false;
            $this$setBalloonHighlightAnimation_u24lambda_u2d124.setBalloonHighlightAnimation(value2);
            $this$setBalloonHighlightAnimation_u24lambda_u2d124.setBalloonHighlightAnimationStartDelay(startDelay);
            return builder;
        }

        public static /* synthetic */ Builder setBalloonHighlightAnimation$default(Builder builder, BalloonHighlightAnimation balloonHighlightAnimation, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 0L;
            }
            return builder.setBalloonHighlightAnimation(balloonHighlightAnimation, l);
        }

        @JvmOverloads
        @NotNull
        public final Builder setBalloonHighlightAnimationResource(@AnimRes int value2, long startDelay) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBalloonHighlightAnimationResource_u24lambda_u2d125 = builder;
            boolean bl3 = false;
            $this$setBalloonHighlightAnimationResource_u24lambda_u2d125.setBalloonHighlightAnimationStyle(value2);
            $this$setBalloonHighlightAnimationResource_u24lambda_u2d125.setBalloonHighlightAnimationStartDelay(startDelay);
            return builder;
        }

        public static /* synthetic */ Builder setBalloonHighlightAnimationResource$default(Builder builder, int n, long l, int n2, Object object) {
            if ((n2 & 2) != 0) {
                l = 0L;
            }
            return builder.setBalloonHighlightAnimationResource(n, l);
        }

        @NotNull
        public final Builder setBalloonRotationAnimation(@NotNull BalloonRotateAnimation balloonRotateAnimation) {
            Intrinsics.checkNotNullParameter((Object)((Object)balloonRotateAnimation), (String)"balloonRotateAnimation");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setBalloonRotationAnimation_u24lambda_u2d126 = builder;
            boolean bl3 = false;
            $this$setBalloonRotationAnimation_u24lambda_u2d126.setBalloonRotateAnimation(balloonRotateAnimation);
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonClickListener(@NotNull OnBalloonClickListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonClickListener_u24lambda_u2d127 = builder;
            boolean bl3 = false;
            $this$setOnBalloonClickListener_u24lambda_u2d127.setOnBalloonClickListener(value2);
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonDismissListener(@NotNull OnBalloonDismissListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonDismissListener_u24lambda_u2d128 = builder;
            boolean bl3 = false;
            $this$setOnBalloonDismissListener_u24lambda_u2d128.setOnBalloonDismissListener(value2);
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonInitializedListener(@NotNull OnBalloonInitializedListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonInitializedListener_u24lambda_u2d129 = builder;
            boolean bl3 = false;
            $this$setOnBalloonInitializedListener_u24lambda_u2d129.setOnBalloonInitializedListener(value2);
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOutsideTouchListener(@NotNull OnBalloonOutsideTouchListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonOutsideTouchListener_u24lambda_u2d130 = builder;
            boolean bl3 = false;
            $this$setOnBalloonOutsideTouchListener_u24lambda_u2d130.setOnBalloonOutsideTouchListener(value2);
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonTouchListener(@NotNull View.OnTouchListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonTouchListener_u24lambda_u2d131 = builder;
            boolean bl3 = false;
            $this$setOnBalloonTouchListener_u24lambda_u2d131.setOnBalloonTouchListener(value2);
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOverlayClickListener(@NotNull OnBalloonOverlayClickListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonOverlayClickListener_u24lambda_u2d132 = builder;
            boolean bl3 = false;
            $this$setOnBalloonOverlayClickListener_u24lambda_u2d132.setOnBalloonOverlayClickListener(value2);
            return builder;
        }

        public final /* synthetic */ Builder setOnBalloonClickListener(Function1 block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonClickListener_u24lambda_u2d133 = builder;
            boolean bl3 = false;
            $this$setOnBalloonClickListener_u24lambda_u2d133.setOnBalloonClickListener(new OnBalloonClickListener(block){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ void onBalloonClick(View view) {
                    this.function.invoke((Object)view);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof OnBalloonClickListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
            return builder;
        }

        public final /* synthetic */ Builder setOnBalloonDismissListener(Function0 block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonDismissListener_u24lambda_u2d134 = builder;
            boolean bl3 = false;
            $this$setOnBalloonDismissListener_u24lambda_u2d134.setOnBalloonDismissListener(new OnBalloonDismissListener(block){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ void onBalloonDismiss() {
                    this.function.invoke();
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof OnBalloonDismissListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
            return builder;
        }

        public final /* synthetic */ Builder setOnBalloonInitializedListener(Function1 block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonInitializedListener_u24lambda_u2d135 = builder;
            boolean bl3 = false;
            $this$setOnBalloonInitializedListener_u24lambda_u2d135.setOnBalloonInitializedListener(new OnBalloonInitializedListener(block){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ void onBalloonInitialized(View contentView) {
                    this.function.invoke((Object)contentView);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof OnBalloonInitializedListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
            return builder;
        }

        public final /* synthetic */ Builder setOnBalloonOutsideTouchListener(Function2 block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonOutsideTouchListener_u24lambda_u2d136 = builder;
            boolean bl3 = false;
            $this$setOnBalloonOutsideTouchListener_u24lambda_u2d136.setOnBalloonOutsideTouchListener(new OnBalloonOutsideTouchListener(block){
                private final /* synthetic */ Function2 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ void onBalloonOutsideTouch(View view, MotionEvent event) {
                    this.function.invoke((Object)view, (Object)event);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof OnBalloonOutsideTouchListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
            $this$setOnBalloonOutsideTouchListener_u24lambda_u2d136.setDismissWhenTouchOutside(false);
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOverlayClickListener(@NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonOverlayClickListener_u24lambda_u2d137 = builder;
            boolean bl3 = false;
            $this$setOnBalloonOverlayClickListener_u24lambda_u2d137.setOnBalloonOverlayClickListener(new OnBalloonOverlayClickListener(block){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ void onBalloonOverlayClick() {
                    this.function.invoke();
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)this.function;
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof OnBalloonOverlayClickListener ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenTouchOutside(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setDismissWhenTouchOutside_u24lambda_u2d138 = builder;
            boolean bl3 = false;
            $this$setDismissWhenTouchOutside_u24lambda_u2d138.setDismissWhenTouchOutside(value2);
            if (!value2) {
                $this$setDismissWhenTouchOutside_u24lambda_u2d138.setFocusable(value2);
            }
            return builder;
        }

        @NotNull
        public final Builder setOnBalloonOverlayTouchListener(@NotNull View.OnTouchListener value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setOnBalloonOverlayTouchListener_u24lambda_u2d139 = builder;
            boolean bl3 = false;
            $this$setOnBalloonOverlayTouchListener_u24lambda_u2d139.setOnBalloonOverlayTouchListener(value2);
            $this$setOnBalloonOverlayTouchListener_u24lambda_u2d139.setDismissWhenOverlayClicked(false);
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenShowAgain(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setDismissWhenShowAgain_u24lambda_u2d140 = builder;
            boolean bl3 = false;
            $this$setDismissWhenShowAgain_u24lambda_u2d140.setDismissWhenShowAgain(value2);
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenClicked(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setDismissWhenClicked_u24lambda_u2d141 = builder;
            boolean bl3 = false;
            $this$setDismissWhenClicked_u24lambda_u2d141.setDismissWhenClicked(value2);
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenLifecycleOnPause(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setDismissWhenLifecycleOnPause_u24lambda_u2d142 = builder;
            boolean bl3 = false;
            $this$setDismissWhenLifecycleOnPause_u24lambda_u2d142.setDismissWhenLifecycleOnPause(value2);
            return builder;
        }

        @NotNull
        public final Builder setDismissWhenOverlayClicked(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setDismissWhenOverlayClicked_u24lambda_u2d143 = builder;
            boolean bl3 = false;
            $this$setDismissWhenOverlayClicked_u24lambda_u2d143.setDismissWhenOverlayClicked(value2);
            return builder;
        }

        @NotNull
        public final Builder setShouldPassTouchEventToAnchor(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setShouldPassTouchEventToAnchor_u24lambda_u2d144 = builder;
            boolean bl3 = false;
            $this$setShouldPassTouchEventToAnchor_u24lambda_u2d144.setPassTouchEventToAnchor(value2);
            return builder;
        }

        @NotNull
        public final Builder setAutoDismissDuration(long value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setAutoDismissDuration_u24lambda_u2d145 = builder;
            boolean bl3 = false;
            $this$setAutoDismissDuration_u24lambda_u2d145.setAutoDismissDuration(value2);
            return builder;
        }

        @NotNull
        public final Builder setPreferenceName(@NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setPreferenceName_u24lambda_u2d146 = builder;
            boolean bl3 = false;
            $this$setPreferenceName_u24lambda_u2d146.setPreferenceName(value2);
            return builder;
        }

        @NotNull
        public final Builder setShowCounts(int value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setShowCounts_u24lambda_u2d147 = builder;
            boolean bl3 = false;
            $this$setShowCounts_u24lambda_u2d147.setShowTimes(value2);
            return builder;
        }

        @NotNull
        public final Builder runIfReachedShowCounts(@NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$runIfReachedShowCounts_u24lambda_u2d148 = builder;
            boolean bl3 = false;
            $this$runIfReachedShowCounts_u24lambda_u2d148.setRunIfReachedShowCounts(block);
            return builder;
        }

        @NotNull
        public final Builder runIfReachedShowCounts(@NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$runIfReachedShowCounts_u24lambda_u2d149 = builder;
            boolean bl3 = false;
            $this$runIfReachedShowCounts_u24lambda_u2d149.runIfReachedShowCounts((Function0<Unit>)((Function0)new Function0<Unit>(runnable){
                final /* synthetic */ Runnable $runnable;
                {
                    this.$runnable = $runnable;
                    super(0);
                }

                public final void invoke() {
                    this.$runnable.run();
                }
            }));
            return builder;
        }

        @NotNull
        public final Builder setFocusable(boolean value2) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setFocusable_u24lambda_u2d150 = builder;
            boolean bl3 = false;
            $this$setFocusable_u24lambda_u2d150.setFocusable(value2);
            return builder;
        }

        @NotNull
        public final Balloon build() {
            return new Balloon(this.context, this, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder setBalloonHighlightAnimation(@NotNull BalloonHighlightAnimation value2) {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            return Builder.setBalloonHighlightAnimation$default(this, value2, 0L, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder setBalloonHighlightAnimationResource(@AnimRes int value2) {
            return Builder.setBalloonHighlightAnimationResource$default(this, value2, 0L, 2, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lcom/skydoves/balloon/Balloon$Factory;", "", "()V", "create", "Lcom/skydoves/balloon/Balloon;", "context", "Landroid/content/Context;", "lifecycle", "Landroidx/lifecycle/LifecycleOwner;", "balloon_release"})
    public static abstract class Factory {
        @NotNull
        public abstract Balloon create(@NotNull Context var1, @Nullable LifecycleOwner var2);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;

        static {
            int[] nArray = new int[ArrowOrientation.values().length];
            nArray[ArrowOrientation.BOTTOM.ordinal()] = 1;
            nArray[ArrowOrientation.TOP.ordinal()] = 2;
            nArray[ArrowOrientation.LEFT.ordinal()] = 3;
            nArray[ArrowOrientation.RIGHT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ArrowPositionRules.values().length];
            nArray[ArrowPositionRules.ALIGN_BALLOON.ordinal()] = 1;
            nArray[ArrowPositionRules.ALIGN_ANCHOR.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[BalloonAnimation.values().length];
            nArray[BalloonAnimation.ELASTIC.ordinal()] = 1;
            nArray[BalloonAnimation.CIRCULAR.ordinal()] = 2;
            nArray[BalloonAnimation.FADE.ordinal()] = 3;
            nArray[BalloonAnimation.OVERSHOOT.ordinal()] = 4;
            nArray[BalloonAnimation.NONE.ordinal()] = 5;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[BalloonOverlayAnimation.values().length];
            nArray[BalloonOverlayAnimation.FADE.ordinal()] = 1;
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[BalloonHighlightAnimation.values().length];
            nArray[BalloonHighlightAnimation.HEARTBEAT.ordinal()] = 1;
            nArray[BalloonHighlightAnimation.SHAKE.ordinal()] = 2;
            nArray[BalloonHighlightAnimation.BREATH.ordinal()] = 3;
            nArray[BalloonHighlightAnimation.ROTATE.ordinal()] = 4;
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[BalloonCenterAlign.values().length];
            nArray[BalloonCenterAlign.TOP.ordinal()] = 1;
            nArray[BalloonCenterAlign.BOTTOM.ordinal()] = 2;
            nArray[BalloonCenterAlign.START.ordinal()] = 3;
            nArray[BalloonCenterAlign.END.ordinal()] = 4;
            $EnumSwitchMapping$5 = nArray;
        }
    }
}

