/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.androidveil;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.Px;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.facebook.shimmer.Shimmer;
import com.skydoves.androidveil.R;
import com.skydoves.androidveil.ResourceExtensionKt;
import com.skydoves.androidveil.VeilParams;
import com.skydoves.androidveil.VeiledAdapter;
import com.skydoves.androidveil.VeiledItemOnClickListener;
import com.skydoves.androidveil.ViewExtensionKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\tJ\b\u0010.\u001a\u00020,H\u0002J\u0012\u0010/\u001a\u00020,2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u00100\u001a\u00020'J\u0006\u00101\u001a\u00020'J\b\u00102\u001a\u00020,H\u0002J\u0014\u00103\u001a\u00020,2\f\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u000105J\u001c\u00103\u001a\u00020,2\f\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u0001052\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020,2\u0006\u00106\u001a\u000207J\u0010\u00109\u001a\u00020,2\b\b\u0001\u0010\u001a\u001a\u00020\tJ\u0018\u00109\u001a\u00020,2\b\b\u0001\u0010\u001a\u001a\u00020\t2\u0006\u0010:\u001a\u00020;J \u00109\u001a\u00020,2\b\b\u0001\u0010\u001a\u001a\u00020\t2\u0006\u0010:\u001a\u00020;2\u0006\u0010-\u001a\u00020\tJ\u0018\u00109\u001a\u00020,2\b\b\u0001\u0010\u001a\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tJ\u0006\u0010<\u001a\u00020,J\u0006\u0010=\u001a\u00020,J\b\u0010>\u001a\u00020,H\u0002J\b\u0010?\u001a\u00020,H\u0002R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0011\"\u0004\b$\u0010\u0013R\u000e\u0010%\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/skydoves/androidveil/VeilRecyclerFrameView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "baseAlpha", "", "baseColor", "defaultChildVisible", "", "getDefaultChildVisible", "()Z", "setDefaultChildVisible", "(Z)V", "drawable", "Landroid/graphics/drawable/Drawable;", "dropOff", "highlightAlpha", "highlightColor", "isVeiled", "layout", "radius", "shimmer", "Lcom/facebook/shimmer/Shimmer;", "getShimmer", "()Lcom/facebook/shimmer/Shimmer;", "setShimmer", "(Lcom/facebook/shimmer/Shimmer;)V", "shimmerEnable", "getShimmerEnable", "setShimmerEnable", "threshold", "userRecyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "veiledAdapter", "Lcom/skydoves/androidveil/VeiledAdapter;", "veiledRecyclerView", "addVeiledItems", "", "size", "applyOverScrollMode", "getAttrs", "getRecyclerView", "getVeiledRecyclerView", "onCreate", "setAdapter", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "layoutManager", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "setLayoutManager", "setVeilLayout", "onItemClickListener", "Lcom/skydoves/androidveil/VeiledItemOnClickListener;", "unVeil", "veil", "visibleUserRecyclerView", "visibleVeilRecyclerView", "androidveil_release"})
public final class VeilRecyclerFrameView
extends RelativeLayout {
    private final RecyclerView userRecyclerView;
    private final RecyclerView veiledRecyclerView;
    private VeiledAdapter veiledAdapter;
    private boolean isVeiled;
    @ColorInt
    private int baseColor;
    @ColorInt
    private int highlightColor;
    @FloatRange(from=0.0, to=1.0)
    private float baseAlpha;
    @FloatRange(from=0.0, to=1.0)
    private float highlightAlpha;
    @FloatRange(from=0.0, to=1.0)
    private float dropOff;
    @LayoutRes
    private int layout;
    @Px
    private float radius;
    private Drawable drawable;
    @Nullable
    private Shimmer shimmer;
    private boolean shimmerEnable;
    private boolean defaultChildVisible;
    private final int threshold;

    @Nullable
    public final Shimmer getShimmer() {
        return this.shimmer;
    }

    public final void setShimmer(@Nullable Shimmer shimmer) {
        this.shimmer = shimmer;
    }

    public final boolean getShimmerEnable() {
        return this.shimmerEnable;
    }

    public final void setShimmerEnable(boolean bl) {
        this.shimmerEnable = bl;
    }

    public final boolean getDefaultChildVisible() {
        return this.defaultChildVisible;
    }

    public final void setDefaultChildVisible(boolean bl) {
        this.defaultChildVisible = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.VeilRecyclerFrameView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026le.VeilRecyclerFrameView)");
        TypedArray a = typedArray;
        try {
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_veiled)) {
                this.isVeiled = a.getBoolean(R.styleable.VeilRecyclerFrameView_veilFrame_veiled, this.isVeiled);
            }
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_layout)) {
                this.layout = a.getResourceId(R.styleable.VeilRecyclerFrameView_veilFrame_layout, -1);
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_drawable)) {
                this.drawable = a.getDrawable(R.styleable.VeilRecyclerFrameView_veilFrame_drawable);
            }
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_radius)) {
                this.radius = a.getDimension(R.styleable.VeilRecyclerFrameView_veilFrame_radius, this.radius);
            }
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_shimmerEnable)) {
                this.shimmerEnable = a.getBoolean(R.styleable.VeilRecyclerFrameView_veilFrame_shimmerEnable, this.shimmerEnable);
            }
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_baseColor)) {
                this.baseColor = a.getColor(R.styleable.VeilRecyclerFrameView_veilFrame_baseColor, this.baseColor);
            }
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_highlightColor)) {
                this.highlightColor = a.getColor(R.styleable.VeilRecyclerFrameView_veilFrame_highlightColor, this.highlightColor);
            }
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_baseAlpha)) {
                this.baseAlpha = a.getFloat(R.styleable.VeilRecyclerFrameView_veilFrame_baseAlpha, this.baseAlpha);
            }
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_highlightAlpha)) {
                this.highlightAlpha = a.getFloat(R.styleable.VeilRecyclerFrameView_veilFrame_highlightAlpha, this.highlightAlpha);
            }
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_dropOff)) {
                this.dropOff = a.getFloat(R.styleable.VeilRecyclerFrameView_veilFrame_dropOff, this.dropOff);
            }
            if (a.hasValue(R.styleable.VeilRecyclerFrameView_veilFrame_defaultChildVisible)) {
                this.defaultChildVisible = a.getBoolean(R.styleable.VeilRecyclerFrameView_veilFrame_defaultChildVisible, this.defaultChildVisible);
            }
        }
        finally {
            a.recycle();
        }
    }

    private final void onCreate() {
        this.addView((View)this.userRecyclerView, -1, -1);
        this.addView((View)this.veiledRecyclerView, -1, -1);
        this.veiledRecyclerView.setHasFixedSize(true);
        this.applyOverScrollMode();
        boolean bl = this.isVeiled;
        if (bl) {
            this.visibleVeilRecyclerView();
        } else if (!bl) {
            this.visibleUserRecyclerView();
        }
        if (this.layout != -1) {
            this.setVeilLayout(this.layout);
        }
    }

    public final void setVeilLayout(@LayoutRes int layout2) {
        this.veiledAdapter = new VeiledAdapter(layout2, null, 2, null);
        this.veiledRecyclerView.setAdapter((RecyclerView.Adapter)this.veiledAdapter);
    }

    public final void setVeilLayout(@LayoutRes int layout2, @NotNull VeiledItemOnClickListener onItemClickListener) {
        Intrinsics.checkNotNullParameter((Object)onItemClickListener, (String)"onItemClickListener");
        this.veiledAdapter = new VeiledAdapter(layout2, onItemClickListener);
        this.veiledRecyclerView.setAdapter((RecyclerView.Adapter)this.veiledAdapter);
    }

    public final void setVeilLayout(@LayoutRes int layout2, int size) {
        this.setVeilLayout(layout2);
        this.addVeiledItems(size);
    }

    public final void setVeilLayout(@LayoutRes int layout2, @NotNull VeiledItemOnClickListener onItemClickListener, int size) {
        Intrinsics.checkNotNullParameter((Object)onItemClickListener, (String)"onItemClickListener");
        this.setVeilLayout(layout2, onItemClickListener);
        this.addVeiledItems(size);
    }

    /*
     * WARNING - void declaration
     */
    public final void addVeiledItems(int size) {
        block1: {
            ArrayList<VeilParams> paramList = new ArrayList<VeilParams>();
            int n = 0;
            int n2 = size;
            while (n < n2) {
                void i;
                paramList.add(new VeilParams(this.baseColor, this.highlightColor, this.drawable, this.radius, this.baseAlpha, this.highlightAlpha, this.dropOff, this.shimmerEnable, this.shimmer, this.defaultChildVisible));
                ++i;
            }
            VeiledAdapter veiledAdapter = this.veiledAdapter;
            if (veiledAdapter == null) break block1;
            veiledAdapter.updateParams((List<VeilParams>)paramList);
        }
    }

    public final void setAdapter(@Nullable RecyclerView.Adapter<?> adapter) {
        this.userRecyclerView.setAdapter(adapter);
        this.invalidate();
    }

    public final void setAdapter(@Nullable RecyclerView.Adapter<?> adapter, @NotNull RecyclerView.LayoutManager layoutManager) {
        Intrinsics.checkNotNullParameter((Object)layoutManager, (String)"layoutManager");
        this.setAdapter(adapter);
        this.setLayoutManager(layoutManager);
    }

    public final void setLayoutManager(@NotNull RecyclerView.LayoutManager layoutManager) {
        Intrinsics.checkNotNullParameter((Object)layoutManager, (String)"layoutManager");
        this.userRecyclerView.setLayoutManager(layoutManager);
        RecyclerView.LayoutManager layoutManager2 = layoutManager;
        if (layoutManager2 instanceof GridLayoutManager) {
            this.veiledRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), ((GridLayoutManager)layoutManager).getSpanCount()));
        } else if (layoutManager2 instanceof StaggeredGridLayoutManager) {
            this.veiledRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new StaggeredGridLayoutManager(((StaggeredGridLayoutManager)layoutManager).getSpanCount(), ((StaggeredGridLayoutManager)layoutManager).getOrientation()));
        } else if (layoutManager2 instanceof LinearLayoutManager) {
            this.veiledRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), ((LinearLayoutManager)layoutManager).getOrientation(), ((LinearLayoutManager)layoutManager).getReverseLayout()));
        } else {
            this.veiledRecyclerView.getLayoutManager();
        }
    }

    public final void veil() {
        block1: {
            VeiledAdapter veiledAdapter = this.veiledAdapter;
            if (veiledAdapter == null) break block1;
            VeiledAdapter veiledAdapter2 = veiledAdapter;
            boolean bl = false;
            boolean bl2 = false;
            VeiledAdapter it = veiledAdapter2;
            boolean bl3 = false;
            if (!this.isVeiled) {
                this.isVeiled = true;
                this.visibleVeilRecyclerView();
            }
        }
    }

    public final void unVeil() {
        if (this.isVeiled) {
            this.isVeiled = false;
            this.visibleUserRecyclerView();
        }
    }

    @NotNull
    public final RecyclerView getVeiledRecyclerView() {
        return this.veiledRecyclerView;
    }

    @NotNull
    public final RecyclerView getRecyclerView() {
        return this.userRecyclerView;
    }

    private final void visibleVeilRecyclerView() {
        ViewExtensionKt.visible((View)this.veiledRecyclerView);
        this.veiledRecyclerView.bringToFront();
        ViewExtensionKt.invisible((View)this.userRecyclerView);
    }

    private final void visibleUserRecyclerView() {
        ViewExtensionKt.visible((View)this.userRecyclerView);
        this.userRecyclerView.bringToFront();
        ViewExtensionKt.invisible((View)this.veiledRecyclerView);
    }

    private final void applyOverScrollMode() {
        this.veiledRecyclerView.setOverScrollMode(this.getOverScrollMode());
        this.userRecyclerView.setOverScrollMode(this.getOverScrollMode());
    }

    public VeilRecyclerFrameView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.userRecyclerView = new RecyclerView(this.getContext());
        this.veiledRecyclerView = new RecyclerView(this.getContext());
        this.baseColor = -3355444;
        this.highlightColor = -12303292;
        this.baseAlpha = 1.0f;
        this.highlightAlpha = 1.0f;
        this.dropOff = 0.5f;
        this.layout = -1;
        this.radius = ResourceExtensionKt.dp2px(8.0f, (View)this);
        this.shimmerEnable = true;
        this.threshold = 10;
        this.onCreate();
    }

    public VeilRecyclerFrameView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.userRecyclerView = new RecyclerView(this.getContext());
        this.veiledRecyclerView = new RecyclerView(this.getContext());
        this.baseColor = -3355444;
        this.highlightColor = -12303292;
        this.baseAlpha = 1.0f;
        this.highlightAlpha = 1.0f;
        this.dropOff = 0.5f;
        this.layout = -1;
        this.radius = ResourceExtensionKt.dp2px(8.0f, (View)this);
        this.shimmerEnable = true;
        this.threshold = 10;
        this.getAttrs(attrs);
        this.onCreate();
    }

    public VeilRecyclerFrameView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.userRecyclerView = new RecyclerView(this.getContext());
        this.veiledRecyclerView = new RecyclerView(this.getContext());
        this.baseColor = -3355444;
        this.highlightColor = -12303292;
        this.baseAlpha = 1.0f;
        this.highlightAlpha = 1.0f;
        this.dropOff = 0.5f;
        this.layout = -1;
        this.radius = ResourceExtensionKt.dp2px(8.0f, (View)this);
        this.shimmerEnable = true;
        this.threshold = 10;
        this.getAttrs(attrs);
        this.onCreate();
    }
}

