/*
 * Decompiled with CFR 0.152.
 */
package com.skydoves.androidveil;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.Px;
import com.facebook.shimmer.Shimmer;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.skydoves.androidveil.R;
import com.skydoves.androidveil.ResourceExtensionKt;
import com.skydoves.androidveil.ViewExtensionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\u0012\u0010D\u001a\u00020A2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010E\u001a\u00020AH\u0016J\u0012\u0010F\u001a\u00020A2\b\b\u0001\u0010\"\u001a\u00020\tH\u0002J\b\u0010G\u001a\u00020AH\u0002J\b\u0010H\u001a\u00020AH\u0014J\u0010\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020\u0011H\u0002J\u000e\u0010%\u001a\u00020A2\u0006\u0010\"\u001a\u00020)J\u0006\u0010K\u001a\u00020AJ\u0006\u0010L\u001a\u00020AJ\u0006\u0010M\u001a\u00020AJ\u0006\u0010N\u001a\u00020AR\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R&\u0010\"\u001a\u00020\t2\u0006\u0010!\u001a\u00020\t8\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001e\u0010'\u001a\u0012\u0012\u0004\u0012\u00020)0(j\b\u0012\u0004\u0012\u00020)`*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010+\u001a\n -*\u0004\u0018\u00010,0,\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001e\u00100\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R4\u00105\u001a\n -*\u0004\u0018\u00010,0,2\u000e\u0010!\u001a\n -*\u0004\u0018\u00010,0,@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010/\"\u0004\b7\u00108R\u0011\u00109\u001a\u00020:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R$\u0010=\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0013\"\u0004\b?\u0010\u0015\u00a8\u0006O"}, d2={"Lcom/skydoves/androidveil/VeilLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "baseAlpha", "", "baseColor", "defaultChildVisible", "", "getDefaultChildVisible", "()Z", "setDefaultChildVisible", "(Z)V", "drawable", "Landroid/graphics/drawable/Drawable;", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "setDrawable", "(Landroid/graphics/drawable/Drawable;)V", "dropOff", "highlightAlpha", "highlightColor", "<set-?>", "isVeiled", "value", "layout", "getLayout", "()I", "setLayout", "(I)V", "maskElements", "Ljava/util/ArrayList;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "nonShimmer", "Lcom/facebook/shimmer/Shimmer;", "kotlin.jvm.PlatformType", "getNonShimmer", "()Lcom/facebook/shimmer/Shimmer;", "radius", "getRadius", "()F", "setRadius", "(F)V", "shimmer", "getShimmer", "setShimmer", "(Lcom/facebook/shimmer/Shimmer;)V", "shimmerContainer", "Lcom/facebook/shimmer/ShimmerFrameLayout;", "getShimmerContainer", "()Lcom/facebook/shimmer/ShimmerFrameLayout;", "shimmerEnable", "getShimmerEnable", "setShimmerEnable", "addMaskElements", "", "parent", "Landroid/view/ViewGroup;", "getAttrs", "invalidate", "invalidateLayout", "onCreate", "onFinishInflate", "setChildVisibility", "visible", "startShimmer", "stopShimmer", "unVeil", "veil", "androidveil_release"})
public final class VeilLayout
extends FrameLayout {
    @ColorInt
    private int baseColor;
    @ColorInt
    private int highlightColor;
    @FloatRange(from=0.0, to=1.0)
    private float baseAlpha;
    @FloatRange(from=0.0, to=1.0)
    private float highlightAlpha;
    @FloatRange(from=0.0, to=1.0)
    private float dropOff;
    @Px
    private float radius;
    @Nullable
    private Drawable drawable;
    @LayoutRes
    private int layout;
    private boolean isVeiled;
    private final ArrayList<View> maskElements;
    @NotNull
    private final ShimmerFrameLayout shimmerContainer;
    private final Shimmer nonShimmer;
    private Shimmer shimmer;
    private boolean shimmerEnable;
    private boolean defaultChildVisible;

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float f) {
        this.radius = f;
    }

    @Nullable
    public final Drawable getDrawable() {
        return this.drawable;
    }

    public final void setDrawable(@Nullable Drawable drawable) {
        this.drawable = drawable;
    }

    public final int getLayout() {
        return this.layout;
    }

    public final void setLayout(int value) {
        this.layout = value;
        this.invalidateLayout(value);
    }

    public final boolean isVeiled() {
        return this.isVeiled;
    }

    @NotNull
    public final ShimmerFrameLayout getShimmerContainer() {
        return this.shimmerContainer;
    }

    public final Shimmer getNonShimmer() {
        return this.nonShimmer;
    }

    public final Shimmer getShimmer() {
        return this.shimmer;
    }

    public final void setShimmer(Shimmer value) {
        this.shimmer = value;
        this.shimmerContainer.setShimmer(value);
    }

    public final boolean getShimmerEnable() {
        return this.shimmerEnable;
    }

    public final void setShimmerEnable(boolean value) {
        block1: {
            boolean bl;
            block0: {
                this.shimmerEnable = value;
                bl = value;
                if (!bl) break block0;
                this.shimmerContainer.setShimmer(this.shimmer);
                break block1;
            }
            if (bl) break block1;
            this.shimmerContainer.setShimmer(this.nonShimmer);
        }
    }

    public final boolean getDefaultChildVisible() {
        return this.defaultChildVisible;
    }

    public final void setDefaultChildVisible(boolean bl) {
        this.defaultChildVisible = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.VeilLayout);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026, R.styleable.VeilLayout)");
        TypedArray a = typedArray;
        try {
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_veiled)) {
                this.isVeiled = a.getBoolean(R.styleable.VeilLayout_veilLayout_veiled, this.isVeiled);
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_layout)) {
                this.setLayout(a.getResourceId(R.styleable.VeilLayout_veilLayout_layout, -1));
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_drawable)) {
                this.drawable = a.getDrawable(R.styleable.VeilLayout_veilLayout_drawable);
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_radius)) {
                this.radius = a.getDimension(R.styleable.VeilLayout_veilLayout_radius, this.radius);
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_shimmerEnable)) {
                this.setShimmerEnable(a.getBoolean(R.styleable.VeilLayout_veilLayout_shimmerEnable, this.shimmerEnable));
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_baseColor)) {
                this.baseColor = a.getColor(R.styleable.VeilLayout_veilLayout_baseColor, this.baseColor);
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_highlightColor)) {
                this.highlightColor = a.getColor(R.styleable.VeilLayout_veilLayout_highlightColor, this.highlightColor);
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_baseAlpha)) {
                this.baseAlpha = a.getFloat(R.styleable.VeilLayout_veilLayout_baseAlpha, this.baseAlpha);
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_highlightAlpha)) {
                this.highlightAlpha = a.getFloat(R.styleable.VeilLayout_veilLayout_highlightAlpha, this.highlightAlpha);
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_dropOff)) {
                this.dropOff = a.getFloat(R.styleable.VeilLayout_veilLayout_dropOff, this.dropOff);
            }
            if (a.hasValue(R.styleable.VeilLayout_veilLayout_defaultChildVisible)) {
                this.defaultChildVisible = a.getBoolean(R.styleable.VeilLayout_veilLayout_defaultChildVisible, this.defaultChildVisible);
            }
        }
        finally {
            a.recycle();
        }
    }

    private final void onCreate() {
        ViewExtensionKt.invisible((View)this.shimmerContainer);
        Shimmer.ColorHighlightBuilder colorHighlightBuilder = new Shimmer.ColorHighlightBuilder();
        boolean bl = false;
        boolean bl2 = false;
        Shimmer.ColorHighlightBuilder $this$apply = colorHighlightBuilder;
        boolean bl3 = false;
        $this$apply.setBaseColor(this.baseColor).setHighlightColor(this.highlightColor);
        ((Shimmer.ColorHighlightBuilder)((Shimmer.ColorHighlightBuilder)$this$apply.setBaseAlpha(this.baseAlpha)).setDropoff(this.highlightAlpha)).setDropoff(this.dropOff);
        $this$apply.setAutoStart(false);
        bl = false;
        bl2 = false;
        Shimmer.ColorHighlightBuilder it = colorHighlightBuilder;
        boolean bl4 = false;
        this.setShimmer(it.build());
        this.setShimmerEnable(this.shimmerEnable);
    }

    private final void invalidateLayout(@LayoutRes int layout2) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(layout2, (ViewGroup)this, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"LayoutInflater.from(cont\u2026late(layout, this, false)");
        this.setLayout(view);
    }

    public final void setLayout(@NotNull View layout2) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        this.removeAllViews();
        this.addView(layout2);
        this.onFinishInflate();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.removeView((View)this.shimmerContainer);
        this.addView((View)this.shimmerContainer);
        this.addMaskElements((ViewGroup)this);
    }

    /*
     * WARNING - void declaration
     */
    private final void addMaskElements(ViewGroup parent) {
        block3: {
            boolean bl;
            block2: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)parent.getChildCount());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    View view = parent.getChildAt((int)it);
                    collection.add(view);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    View child = (View)element$iv;
                    boolean bl3 = false;
                    child.post(new Runnable(child, this, parent){
                        final /* synthetic */ View $child;
                        final /* synthetic */ VeilLayout this$0;
                        final /* synthetic */ ViewGroup $parent$inlined;
                        {
                            this.$child = view;
                            this.this$0 = veilLayout;
                            this.$parent$inlined = viewGroup;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void run() {
                            if (this.$child instanceof ViewGroup) {
                                VeilLayout.access$addMaskElements(this.this$0, (ViewGroup)this.$child);
                            } else {
                                float marginX = 0.0f;
                                float marginY = 0.0f;
                                ViewParent grandParent = this.$parent$inlined.getParent();
                                while (!(grandParent instanceof VeilLayout) && grandParent instanceof ViewGroup) {
                                    ViewGroup.LayoutParams params = ((ViewGroup)grandParent).getLayoutParams();
                                    if (params instanceof ViewGroup.MarginLayoutParams) {
                                        marginX += ((ViewGroup)grandParent).getX();
                                        marginY += ((ViewGroup)grandParent).getY();
                                    }
                                    grandParent = ((ViewGroup)grandParent).getParent();
                                }
                                View view = new View(this.this$0.getContext());
                                boolean bl = false;
                                boolean bl2 = false;
                                View $this$apply = view;
                                boolean bl3 = false;
                                View view2 = this.$child;
                                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"child");
                                int n = view2.getWidth();
                                View view3 = this.$child;
                                Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"child");
                                $this$apply.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, view3.getHeight()));
                                float f = marginX + this.$parent$inlined.getX();
                                View view4 = this.$child;
                                Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"child");
                                $this$apply.setX(f + view4.getX());
                                float f2 = marginY + this.$parent$inlined.getY();
                                View view5 = this.$child;
                                Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"child");
                                $this$apply.setY(f2 + view5.getY());
                                $this$apply.setBackgroundColor(VeilLayout.access$getBaseColor$p(this.this$0));
                                View view6 = $this$apply;
                                Drawable drawable = this.this$0.getDrawable();
                                if (drawable == null) {
                                    void $this$apply2;
                                    GradientDrawable gradientDrawable = new GradientDrawable();
                                    boolean bl4 = false;
                                    boolean bl5 = false;
                                    GradientDrawable gradientDrawable2 = gradientDrawable;
                                    View view7 = view6;
                                    boolean bl6 = false;
                                    $this$apply2.setColor(-12303292);
                                    $this$apply2.setCornerRadius(this.this$0.getRadius());
                                    Unit unit = Unit.INSTANCE;
                                    view6 = view7;
                                    drawable = (Drawable)gradientDrawable;
                                }
                                view6.setBackground(drawable);
                                VeilLayout.access$getMaskElements$p(this.this$0).add($this$apply);
                                this.this$0.getShimmerContainer().addView($this$apply);
                            }
                        }
                    });
                }
                this.invalidate();
                bl = this.isVeiled = !this.isVeiled;
                if (!bl) break block2;
                this.unVeil();
                break block3;
            }
            if (bl) break block3;
            this.veil();
        }
    }

    public final void veil() {
        if (!this.isVeiled) {
            this.isVeiled = true;
            this.startShimmer();
            this.invalidate();
        }
    }

    public final void unVeil() {
        if (this.isVeiled) {
            this.isVeiled = false;
            this.stopShimmer();
            this.invalidate();
        }
    }

    public final void startShimmer() {
        ViewExtensionKt.visible((View)this.shimmerContainer);
        if (this.shimmerEnable) {
            this.shimmerContainer.startShimmer();
        }
        if (!this.defaultChildVisible) {
            this.setChildVisibility(false);
        }
    }

    public final void stopShimmer() {
        ViewExtensionKt.invisible((View)this.shimmerContainer);
        this.shimmerContainer.stopShimmer();
        if (!this.defaultChildVisible) {
            this.setChildVisibility(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setChildVisibility(boolean visible) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getChildCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            View view = this.getChildAt((int)it);
            collection.add(view);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            View child = (View)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)child, (Object)this.shimmerContainer) ^ true)) continue;
            View view = child;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"child");
            ViewExtensionKt.visible(view, visible);
        }
    }

    public void invalidate() {
        super.invalidate();
        this.shimmerContainer.invalidate();
    }

    public VeilLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.baseColor = -3355444;
        this.highlightColor = -12303292;
        this.baseAlpha = 1.0f;
        this.highlightAlpha = 1.0f;
        this.dropOff = 0.5f;
        this.radius = ResourceExtensionKt.dp2px(8.0f, (View)this);
        this.layout = -1;
        this.maskElements = new ArrayList();
        this.shimmerContainer = new ShimmerFrameLayout(this.getContext());
        this.nonShimmer = ((Shimmer.AlphaHighlightBuilder)((Shimmer.AlphaHighlightBuilder)new Shimmer.AlphaHighlightBuilder().setBaseAlpha(1.0f)).setDropoff(1.0f)).build();
        this.shimmer = new Shimmer.AlphaHighlightBuilder().build();
        this.shimmerEnable = true;
        this.onCreate();
    }

    public VeilLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.baseColor = -3355444;
        this.highlightColor = -12303292;
        this.baseAlpha = 1.0f;
        this.highlightAlpha = 1.0f;
        this.dropOff = 0.5f;
        this.radius = ResourceExtensionKt.dp2px(8.0f, (View)this);
        this.layout = -1;
        this.maskElements = new ArrayList();
        this.shimmerContainer = new ShimmerFrameLayout(this.getContext());
        this.nonShimmer = ((Shimmer.AlphaHighlightBuilder)((Shimmer.AlphaHighlightBuilder)new Shimmer.AlphaHighlightBuilder().setBaseAlpha(1.0f)).setDropoff(1.0f)).build();
        this.shimmer = new Shimmer.AlphaHighlightBuilder().build();
        this.shimmerEnable = true;
        this.getAttrs(attrs);
        this.onCreate();
    }

    public VeilLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.baseColor = -3355444;
        this.highlightColor = -12303292;
        this.baseAlpha = 1.0f;
        this.highlightAlpha = 1.0f;
        this.dropOff = 0.5f;
        this.radius = ResourceExtensionKt.dp2px(8.0f, (View)this);
        this.layout = -1;
        this.maskElements = new ArrayList();
        this.shimmerContainer = new ShimmerFrameLayout(this.getContext());
        this.nonShimmer = ((Shimmer.AlphaHighlightBuilder)((Shimmer.AlphaHighlightBuilder)new Shimmer.AlphaHighlightBuilder().setBaseAlpha(1.0f)).setDropoff(1.0f)).build();
        this.shimmer = new Shimmer.AlphaHighlightBuilder().build();
        this.shimmerEnable = true;
        this.getAttrs(attrs);
        this.onCreate();
    }

    @TargetApi(value=21)
    public VeilLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.baseColor = -3355444;
        this.highlightColor = -12303292;
        this.baseAlpha = 1.0f;
        this.highlightAlpha = 1.0f;
        this.dropOff = 0.5f;
        this.radius = ResourceExtensionKt.dp2px(8.0f, (View)this);
        this.layout = -1;
        this.maskElements = new ArrayList();
        this.shimmerContainer = new ShimmerFrameLayout(this.getContext());
        this.nonShimmer = ((Shimmer.AlphaHighlightBuilder)((Shimmer.AlphaHighlightBuilder)new Shimmer.AlphaHighlightBuilder().setBaseAlpha(1.0f)).setDropoff(1.0f)).build();
        this.shimmer = new Shimmer.AlphaHighlightBuilder().build();
        this.shimmerEnable = true;
        this.getAttrs(attrs);
        this.onCreate();
    }

    public static final /* synthetic */ void access$addMaskElements(VeilLayout $this, ViewGroup parent) {
        $this.addMaskElements(parent);
    }

    public static final /* synthetic */ int access$getBaseColor$p(VeilLayout $this) {
        return $this.baseColor;
    }

    public static final /* synthetic */ void access$setBaseColor$p(VeilLayout $this, int n) {
        $this.baseColor = n;
    }

    public static final /* synthetic */ ArrayList access$getMaskElements$p(VeilLayout $this) {
        return $this.maskElements;
    }
}

