/*
 * Decompiled with CFR 0.152.
 */
package com.github.siyamed.shapeimageview.mask;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.github.siyamed.shapeimageview.R;

public abstract class PorterImageView
extends ImageView {
    private static final String TAG = PorterImageView.class.getSimpleName();
    private static final PorterDuffXfermode PORTER_DUFF_XFERMODE = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private Canvas maskCanvas;
    private Bitmap maskBitmap;
    private Paint maskPaint;
    private Canvas drawableCanvas;
    private Bitmap drawableBitmap;
    private Paint drawablePaint;
    private boolean invalidated = true;
    private boolean square = false;

    public PorterImageView(Context context) {
        super(context);
        this.setup(context, null, 0);
    }

    public PorterImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs, 0);
    }

    public PorterImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setup(context, attrs, defStyle);
    }

    public void setSquare(boolean square) {
        this.square = square;
    }

    private void setup(Context context, AttributeSet attrs, int defStyle) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShaderImageView, defStyle, 0);
            this.square = typedArray.getBoolean(R.styleable.ShaderImageView_siSquare, false);
            typedArray.recycle();
        }
        if (this.getScaleType() == ImageView.ScaleType.FIT_CENTER) {
            this.setScaleType(ImageView.ScaleType.CENTER_CROP);
        }
        this.maskPaint = new Paint(1);
        this.maskPaint.setColor(-16777216);
    }

    public void invalidate() {
        this.invalidated = true;
        super.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.createMaskCanvas(w, h, oldw, oldh);
    }

    private void createMaskCanvas(int width, int height, int oldw, int oldh) {
        boolean isValid;
        boolean sizeChanged = width != oldw || height != oldh;
        boolean bl = isValid = width > 0 && height > 0;
        if (isValid && (this.maskCanvas == null || sizeChanged)) {
            this.maskCanvas = new Canvas();
            this.maskBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.maskCanvas.setBitmap(this.maskBitmap);
            this.maskPaint.reset();
            this.paintMaskCanvas(this.maskCanvas, this.maskPaint, width, height);
            this.drawableCanvas = new Canvas();
            this.drawableBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.drawableCanvas.setBitmap(this.drawableBitmap);
            this.drawablePaint = new Paint(1);
            this.invalidated = true;
        }
    }

    protected abstract void paintMaskCanvas(Canvas var1, Paint var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onDraw(Canvas canvas) {
        if (!this.isInEditMode()) {
            int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
            try {
                Drawable drawable;
                if (this.invalidated && (drawable = this.getDrawable()) != null) {
                    this.invalidated = false;
                    Matrix imageMatrix = this.getImageMatrix();
                    if (imageMatrix == null) {
                        drawable.draw(this.drawableCanvas);
                    } else {
                        int drawableSaveCount = this.drawableCanvas.getSaveCount();
                        this.drawableCanvas.save();
                        this.drawableCanvas.concat(imageMatrix);
                        drawable.draw(this.drawableCanvas);
                        this.drawableCanvas.restoreToCount(drawableSaveCount);
                    }
                    this.drawablePaint.reset();
                    this.drawablePaint.setFilterBitmap(false);
                    this.drawablePaint.setXfermode((Xfermode)PORTER_DUFF_XFERMODE);
                    this.drawableCanvas.drawBitmap(this.maskBitmap, 0.0f, 0.0f, this.drawablePaint);
                }
                if (this.invalidated) return;
                this.drawablePaint.setXfermode(null);
                canvas.drawBitmap(this.drawableBitmap, 0.0f, 0.0f, this.drawablePaint);
                return;
            }
            catch (Exception e) {
                String log = "Exception occured while drawing " + this.getId();
                Log.e((String)TAG, (String)log, (Throwable)e);
                return;
            }
            finally {
                canvas.restoreToCount(saveCount);
            }
        } else {
            super.onDraw(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.square) {
            int width = this.getMeasuredWidth();
            int height = this.getMeasuredHeight();
            int dimen = Math.min(width, height);
            this.setMeasuredDimension(dimen, dimen);
        }
    }
}

