/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.ICoreUiSelect;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;
import java.util.Iterator;
import java.util.List;

public class TrySelect
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String SELECT_KEY = "select";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(SELECT_KEY)) {
            help = help + "  select identifier1=selectedOption1 identifier2=selectedOption2 ...;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(SELECT_KEY)) {
                Iterator iterator = dish.getElementKeySet().iterator();
                if (iterator.hasNext()) {
                    String identifier = (String)iterator.next();
                    ICoreWebElement el = (ICoreWebElement)((IWebDriverTable)this.myTable).getMyWebDriver().find(this.dynamic(identifier)).get(0);
                    String text = this.dynamic(dish.getStringElement(new String[]{identifier}));
                    if (el != null && text != null) {
                        ICoreUiSelect select = Factories.web().createUiSelect(el);
                        List options = select.getOptions();
                        for (ICoreWebElement option : options) {
                            if (option.getAttribute("value").equals(text)) {
                                select.selectByValue(text);
                                return Feedback.yami();
                            }
                            if (!option.getText().equals(text)) continue;
                            select.selectByVisibleText(text);
                            return Feedback.yami();
                        }
                        return new Feedback(Feedback.EStatus.FAIL, "No such option: " + text);
                    }
                    return new Feedback(Feedback.EStatus.FAIL, identifier + " is ambiguous or not found.");
                }
                return Feedback.yami();
            }
        }
        catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{SELECT_KEY};
    }
}

