/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.WebUtils;
import com.github.siwenyan.web.core.MyWebDriver;
import com.github.siwenyan.web.core.StaleElementException;
import java.util.Set;

public class TryInput
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String INPUT_KEY = "input";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(INPUT_KEY)) {
            help = help + "  input identifier text=inputText attributeName1=inputAttributeValue1 attributeName2=inputAttributeValue2 ...;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(INPUT_KEY)) {
                String identifier = this.dynamic(dish.getStringElement(new String[]{"main"}));
                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "identifier + not specified.");
                }
                Set keys = dish.getElementKeySet();
                if (keys.size() <= 1) {
                    return new Feedback(Feedback.EStatus.FAIL, "Nothing to be input.");
                }
                for (String key : keys) {
                    if (key.equals("main")) continue;
                    String value = this.dynamic(dish.getStringElement(new String[]{key}));
                    if (value == null) {
                        return new Feedback(Feedback.EStatus.FAIL, "Missing input value.");
                    }
                    WebUtils.doInput((MyWebDriver)((IWebDriverTable)this.myTable).getMyWebDriver(), (String)identifier, (String)key, (String)value);
                }
                return Feedback.yami();
            }
        }
        catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{INPUT_KEY};
    }
}

