/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.NGException;
import com.github.siwenyan.dish_parser.BadSmellException;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.dish_parser.ISupply;
import com.github.siwenyan.potluck.SimpleDish;
import com.github.siwenyan.potluck.SimpleTable;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.core.MyWebDriver;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SimpleWebDriverTable
extends SimpleTable
implements IWebDriverTable {
    private static final Logger log = Logger.getLogger((String)SimpleWebDriverTable.class.getName());
    private MyWebDriver myWebDriver = null;
    private Rectangle rectangle = null;

    public IDish defaultCook(ISupply oneSupply) throws BadSmellException {
        return SimpleDish.cook((ISupply)oneSupply);
    }

    @Override
    public void replaceDriver(Map<String, Object> options) throws NGException {
        if (null != this.myWebDriver) {
            this.myWebDriver.stop();
        }
        if (null == options || 0 == options.size()) {
            options = null == this.myWebDriver ? new LinkedHashMap<String, Object>() : this.myWebDriver.getOptions();
        }
        try {
            this.myWebDriver = new MyWebDriver((Map)options);
        }
        catch (MalformedURLException e) {
            throw new NGException(e.getMessage());
        }
    }

    @Override
    public MyWebDriver getMyWebDriver() {
        return this.myWebDriver;
    }

    @Override
    public void maxSize() {
        try {
            this.getMyWebDriver().getCoreWebDriver().manage().window().maximize();
        }
        catch (Exception e) {
            log.warn((Object)("Not able to max size: " + e.getMessage()));
        }
    }

    @Override
    public Rectangle getRectangle() {
        return this.rectangle;
    }

    @Override
    public void setRectangle(Rectangle rectangle) throws NGException {
        this.rectangle = rectangle;
        this.myWebDriver.setRectangle(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.supplyLock;
        synchronized (object) {
            try {
                if (null != this.myWebDriver) {
                    this.myWebDriver.stop();
                }
            }
            finally {
                this.myWebDriver = null;
                return super.stop();
            }
        }
    }
}

