/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.StringTools;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.LayoutHelper;
import com.github.siwenyan.web.LayoutOfLocatorNames;
import com.github.siwenyan.web.WebUtils;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.MyWebDriver;
import com.github.siwenyan.web.core.StaleElementException;
import java.awt.Rectangle;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShowElements
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String IDENTIFIER_KEY = "identifier";
    private static final String CHOSEN_KEY = "chosen";
    private static final String ID_VAR_KEY = "idVar";
    private static final String TEXT_VAR_KEY = "textVar";
    private static final String VALUE_VAR_KEY = "valueVar";
    private static final String ATTRIBUTE_KEY = "attribute";
    private static final String PAGE_OBJECT_KEY = "pageObject";
    private static final String CROP_KEY = "crop";
    private static final String SHOW_ELEMENTS_FLAVOR = "showElements";
    private static final String SHOW_ELEMENTS_BY_POSITION_FLAVOR = "showElementsByPosition";
    private List<ICoreWebElement> els = null;

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(SHOW_ELEMENTS_FLAVOR)) {
            help = help + "  showElements yourIdentifier chosen=chosenIndex idVar=yourIdVariable textVar=yourTextVariable valueVar=yourValueVariable;\r\n";
        } else if (flavor.equals(SHOW_ELEMENTS_BY_POSITION_FLAVOR)) {
            help = help + "  showElementsByPosition yourIdentifier attribute=yourAttribute pageObject=yourPageObjectName crop=x1:y1:x2:y2^element1^x1:y1:x2:y2^element2^...;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(SHOW_ELEMENTS_FLAVOR)) {
                String xpath = this.dynamic(dish.getStringElement(new String[]{IDENTIFIER_KEY, "main"}));
                int iChosen = StringTools.parsePositiveInteger((String)dish.getStringElement(new String[]{CHOSEN_KEY}));
                String idVar = dish.getStringElement(new String[]{ID_VAR_KEY});
                String textVar = dish.getStringElement(new String[]{TEXT_VAR_KEY});
                String valueVar = dish.getStringElement(new String[]{VALUE_VAR_KEY});
                List els = ((IWebDriverTable)this.myTable).getMyWebDriver().getCoreWebDriver().find(xpath, true);
                String tmp = "";
                int count = 0;
                Rectangle recUnion = null;
                for (ICoreWebElement el : els) {
                    Rectangle rec = WebUtils.getWebRectangle((ICoreWebElement)el);
                    recUnion = recUnion == null ? rec : recUnion.union(rec);
                    tmp = tmp + "\r\n" + StringTools.padRight((String)(++count + "."), (int)4, (char)' ');
                    String id = el.getAttribute("id");
                    tmp = tmp + StringTools.padRight((String)("id=[" + id + "]"), (int)50, (char)' ');
                    String text = el.getText();
                    tmp = tmp + StringTools.padRight((String)("text=[" + text + "]"), (int)50, (char)' ');
                    String value = el.getAttribute("value");
                    tmp = tmp + StringTools.padRight((String)("value=[" + value + "]"), (int)60, (char)' ');
                    String string = el.toString();
                    tmp = tmp + StringTools.padRight((String)("string=[" + string + "]"), (int)60, (char)' ');
                    if (iChosen != count) continue;
                    if (idVar != null && !idVar.isEmpty()) {
                        ((IWebDriverTable)this.myTable).getMyEnvironment().put(idVar, (Object)id);
                    }
                    if (textVar != null && !textVar.isEmpty()) {
                        ((IWebDriverTable)this.myTable).getMyEnvironment().put(textVar, (Object)text);
                    }
                    if (valueVar == null || valueVar.isEmpty()) continue;
                    ((IWebDriverTable)this.myTable).getMyEnvironment().put(valueVar, (Object)value);
                }
                int minX1 = recUnion.x;
                int minY1 = recUnion.y;
                int maxX2 = minX1 + recUnion.width;
                int maxY2 = minY1 + recUnion.height;
                tmp = tmp + "\r\n\r\n";
                tmp = tmp + StringTools.padRight((String)("x1=[" + minX1 + "]"), (int)15, (char)' ');
                tmp = tmp + StringTools.padRight((String)("y1=[" + minY1 + "]"), (int)15, (char)' ');
                tmp = tmp + StringTools.padRight((String)("x2=[" + maxX2 + "]"), (int)15, (char)' ');
                tmp = tmp + StringTools.padRight((String)("y2=[" + maxY2 + "]"), (int)15, (char)' ');
                ((IWebDriverTable)this.myTable).println(tmp);
                return Feedback.yami();
            }
            if (cmd.equals(SHOW_ELEMENTS_BY_POSITION_FLAVOR)) {
                String pageObject;
                String xpath = this.dynamic(dish.getStringElement(new String[]{IDENTIFIER_KEY, "main"}));
                if (xpath.isEmpty()) {
                    if (null == this.els) {
                        return Feedback.yaki((String)"Missing identifier");
                    }
                } else {
                    this.els = ((IWebDriverTable)this.myTable).getMyWebDriver().getCoreWebDriver().find(xpath, true);
                }
                LinkedHashMap<Rectangle, ICoreWebElement> elByRec = new LinkedHashMap<Rectangle, ICoreWebElement>(this.els.size());
                String sRec = this.dynamic(dish.getStringElement(new String[]{CROP_KEY}));
                Rectangle crop = sRec.isEmpty() ? null : WebUtils.toRectangle((MyWebDriver)((IWebDriverTable)this.myTable).getMyWebDriver(), (String)sRec);
                LayoutHelper layoutHelper = new LayoutHelper(crop);
                for (ICoreWebElement el : this.els) {
                    if (!el.isDisplayed()) continue;
                    Rectangle rec = WebUtils.getWebRectangle((ICoreWebElement)el);
                    elByRec.put(rec, el);
                    layoutHelper.addRectangle(rec);
                }
                Rectangle[][] layout = layoutHelper.layout();
                String att = dish.getStringElement(new String[]{ATTRIBUTE_KEY});
                if (!att.isEmpty()) {
                    String s = this.layoutString(elByRec, layout, att);
                    ((IWebDriverTable)this.myTable).print(s);
                }
                if (!(pageObject = dish.getStringElement(new String[]{PAGE_OBJECT_KEY})).isEmpty()) {
                    int lastDot = pageObject.lastIndexOf(46);
                    String packageName = pageObject.substring(0, lastDot);
                    String className = pageObject.substring(lastDot + 1);
                    LayoutOfLocatorNames layoutOfLocatorNames = new LayoutOfLocatorNames(elByRec, layout, packageName, className);
                    ((IWebDriverTable)this.myTable).println(layoutOfLocatorNames.toString());
                    ((IWebDriverTable)this.myTable).println(layoutOfLocatorNames.toPageObject());
                }
                return Feedback.yami();
            }
        }
        catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    private String layoutString(Map<Rectangle, ICoreWebElement> elByRec, Rectangle[][] layout, String att) throws StaleElementException {
        String s = "\n";
        for (int row = 0; row < layout.length; ++row) {
            s = s + "|";
            Rectangle[] oneRow = layout[row];
            for (int col = 0; col < oneRow.length; ++col) {
                String text;
                Rectangle rec = layout[row][col];
                if (null == rec) {
                    s = s + " |";
                    continue;
                }
                String attValue = null;
                attValue = "text".equals(att) ? (null == (text = elByRec.get(rec).getText()) ? "" : text.replaceAll("\n", "").trim()) : (null == (text = elByRec.get(rec).getAttribute(att)) ? "" : text.replaceAll("\n", "").trim());
                s = s + attValue + "|";
            }
            s = s + "\n";
        }
        return s;
    }

    public String[] getFlavors() {
        return new String[]{SHOW_ELEMENTS_FLAVOR, SHOW_ELEMENTS_BY_POSITION_FLAVOR};
    }
}

