/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.Sys;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.dish_parser.ISupply;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.IGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.WebUtils;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.MyWebDriver;
import com.github.siwenyan.web.core.StaleElementException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class Screenshot
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String DOT_PNG = ".png";
    private static final String DOT_HTML = ".html";
    private static final String SCREENSHOT_KEY = "screenShot";
    private static final String TO_KEY = "to";
    private static final String SAVE_HTML_KEY = "saveHtml";
    private static final String INTO_KEY = "into";
    private static final String HIGHLIGHT_KEY = "highlight";
    private static final String CROP_KEY = "crop";
    private static final String NAME_KEY = "name";
    private static final String DEBUG_KEY = "debug";
    private static String debug = "";
    private boolean saveHtml = false;
    private String to = null;
    private String into = "last_screenShot";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(SCREENSHOT_KEY)) {
            help = help + "  screenShot to=C:\\temp\\ into=screenShotFileVar;\r\n";
            help = help + "  screenShot to=C:\\temp\\ name=fielName saveHtml=[true|false] highlight=element1:element2:... highlight1=x1:y1:x2:y2^element1^x1:y1:x2:y2^element2^... highlight2=x1:y1:x2:y2^element1^x1:y1:x2:y2^element2^... crop=x1:y1:x2:y2^element1^x1:y1:x2:y2^element2^...;\r\n Parameter to is Optional if specified by above command.";
            help = help + "  screenShot debug=break;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        block23: {
            try {
                File f;
                String sPath;
                MyWebDriver myWebDriver = ((IWebDriverTable)this.myTable).getMyWebDriver();
                String cmd = dish.getFlavor().getFlavorName();
                if (this.into != null && !this.into.isEmpty()) {
                    ((IWebDriverTable)this.myTable).getMyEnvironment().put(this.into, (Object)"");
                }
                if (!cmd.equals(SCREENSHOT_KEY)) break block23;
                if (dish.containsElement(DEBUG_KEY)) {
                    debug = this.dynamic(dish.getStringElement(new String[]{DEBUG_KEY}));
                }
                if ((sPath = this.dynamic(dish.getStringElement(new String[]{TO_KEY}))) != null && !sPath.isEmpty()) {
                    this.to = sPath;
                }
                if (this.to == null || this.to.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing parameter: to");
                }
                if (!this.to.endsWith("/") && !this.to.endsWith("\\")) {
                    this.to = this.to + Sys.SEP;
                }
                if (!(f = new File(this.to)).isDirectory()) {
                    FileUtils.forceMkdir((File)new File(this.to));
                }
                ((IWebDriverTable)this.myTable).getMyEnvironment().put(this.into, (Object)"");
                String sVar = this.dynamic(dish.getStringElement(new String[]{INTO_KEY}));
                if (sVar != null && !sVar.isEmpty()) {
                    this.into = sVar;
                }
                ((IWebDriverTable)this.myTable).getMyEnvironment().put(this.into, (Object)"");
                String name = this.dynamic(dish.getStringElement(new String[]{NAME_KEY, "main"}));
                if (name == null || name.isEmpty()) {
                    name = "last_screenShot";
                }
                name = Sys.getUniqueNameWithinFolder((String)this.to, (String)name, (String)DOT_PNG, (boolean)false);
                if (dish.containsElement(SAVE_HTML_KEY)) {
                    this.saveHtml = Boolean.parseBoolean(this.dynamic(dish.getStringElement(new String[]{SAVE_HTML_KEY})));
                }
                String fullPath = this.to + name + DOT_PNG;
                File file = null;
                try {
                    myWebDriver.getCoreWebDriver().getScreenshotAsFile(this.to, name);
                    file = new File(this.to + name + DOT_PNG);
                }
                catch (Exception e) {
                    File scrFile = myWebDriver.getCoreWebDriver().getScreenshotAsFile();
                    file = new File(fullPath);
                    FileUtils.copyFile((File)scrFile, (File)file);
                }
                ((IWebDriverTable)this.myTable).getMyEnvironment().put(this.into, (Object)fullPath);
                if (this.saveHtml) {
                    String htmlFullPath = this.to + name + DOT_HTML;
                    FileUtils.writeStringToFile((File)new File(htmlFullPath), (String)((IWebDriverTable)this.myTable).getMyWebDriver().getPageSource(), (String)"utf-16");
                }
                File imageFile = new File(fullPath);
                BufferedImage img = ImageIO.read(imageFile);
                Graphics2D graph = img.createGraphics();
                graph.setColor(Color.RED);
                graph.setStroke(new BasicStroke(3.0f));
                String sElements = this.dynamic(dish.getStringElement(new String[]{HIGHLIGHT_KEY}));
                if (sElements != null && !sElements.trim().isEmpty()) {
                    String[] elements = sElements.trim().split(":");
                    this.highlight(graph, elements);
                }
                for (String key : dish.getElementKeySet()) {
                    Rectangle rect;
                    String sRec;
                    if ((key = key.trim()) == null || key.isEmpty() || key.equals(HIGHLIGHT_KEY) || !key.startsWith(HIGHLIGHT_KEY) || (sRec = this.dynamic(dish.getStringElement(new String[]{key}))) == null || sRec.trim().isEmpty() || (rect = WebUtils.toRectangle((MyWebDriver)((IWebDriverTable)this.myTable).getMyWebDriver(), (String)sRec)) == null) continue;
                    this.highlight(graph, rect);
                }
                graph.dispose();
                ImageIO.write((RenderedImage)img, "png", new File(fullPath));
                String msg = "";
                String sRec = this.dynamic(dish.getStringElement(new String[]{CROP_KEY}));
                if (sRec != null && !sRec.trim().isEmpty()) {
                    Rectangle rect = WebUtils.toRectangle((MyWebDriver)((IWebDriverTable)this.myTable).getMyWebDriver(), (String)sRec);
                    if (rect != null) {
                        try {
                            this.crop(fullPath, rect);
                        }
                        catch (Exception e) {
                            msg = msg + "Warning: " + e.getMessage();
                        }
                    } else {
                        msg = msg + "\r\nInvalid Crop Parameters: " + sRec;
                    }
                }
                if (!debug.isEmpty()) {
                    ISupply supply = ((IWebDriverTable)this.myTable).getMyHost().getTemplateSupply();
                    supply.setLines(new String[]{debug});
                    supply.addStack(dish.getSupply().getStack(0));
                    supply.addStack(SCREENSHOT_KEY);
                    ((IWebDriverTable)this.myTable).cutInSupply(supply, 0);
                }
                msg = msg + "\r\nScreenshot File: " + fullPath;
                return new Feedback(Feedback.EStatus.YAMI, msg);
            }
            catch (StaleElementException e) {
                return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
            }
            catch (Exception e) {
                return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
            }
        }
        return Feedback.yaki();
    }

    public IGuest cloneGuest() {
        Screenshot clone = new Screenshot();
        clone.into = this.into;
        clone.to = this.to;
        return clone;
    }

    private void crop(String fullpath, Rectangle rect) throws IOException {
        File imageFile = new File(fullpath);
        BufferedImage img = ImageIO.read(imageFile);
        int x = Math.max(0, rect.x);
        int y = Math.max(0, rect.y);
        int w = Math.min(rect.width, img.getWidth() - x);
        int h = Math.min(rect.height, img.getHeight() - y);
        BufferedImage crop = img.getSubimage(x, y, w, h);
        ImageIO.write((RenderedImage)crop, "png", new File(fullpath));
    }

    private void highlight(Graphics2D graph, String[] elements) throws IOException, StaleElementException {
        for (String element : elements) {
            ICoreWebElement ele = (ICoreWebElement)((IWebDriverTable)this.myTable).getMyWebDriver().find(element).get(0);
            if (ele == null) continue;
            Rectangle rect = WebUtils.getWebRectangle((ICoreWebElement)ele);
            this.highlight(graph, rect);
        }
    }

    private void highlight(Graphics2D graph, Rectangle rect) throws IOException {
        graph.draw(new Rectangle(rect.x - 3, rect.y - 3, rect.width + 6, rect.height + 6));
    }

    public String[] getFlavors() {
        return new String[]{SCREENSHOT_KEY};
    }
}

