/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.MyEscaper;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.ICoreUiSelect;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;

public class GetField
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String GET_FIELD_KEY = "getField";
    private static final String TARGET_KEY = "target";
    private static final String TARGET_TEXT_KEY = "text";
    private static final String TARGET_FIRST_SELECTION_KEY = "firstSelection";
    private static final String TARGET_RECTANGLE_KEY = "rectangle";
    private static final String INTO_KEY = "into";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(GET_FIELD_KEY)) {
            help = help + "  getField identifier target=text/firstSelection/attributeName/rectangle into=yourVariableName;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(GET_FIELD_KEY)) {
                String identifier = this.dynamic(dish.getStringElement(new String[]{"main"}));
                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing identifier.");
                }
                String target = this.dynamic(dish.getStringElement(new String[]{TARGET_KEY}));
                if (target == null || target.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing target.");
                }
                String variableName = this.dynamic(dish.getStringElement(new String[]{INTO_KEY}));
                if (variableName == null || variableName.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing into.");
                }
                if (!this.doGetField(identifier, target, variableName)) {
                    return new Feedback(Feedback.EStatus.FAIL, "Fail to get.");
                }
                return Feedback.yami();
            }
        }
        catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{GET_FIELD_KEY};
    }

    private boolean doGetField(String identifier, String target, String variableName) throws StaleElementException {
        identifier = MyEscaper.unescape((String)identifier);
        identifier = this.dynamic(identifier);
        ((IWebDriverTable)this.myTable).println("Finding the Field: " + identifier + "...");
        ICoreWebElement field = null;
        field = (ICoreWebElement)((IWebDriverTable)this.myTable).getMyWebDriver().find(identifier).get(0);
        if (field == null) {
            ((IWebDriverTable)this.myTable).println("Field " + identifier + " not found.");
            return false;
        }
        String text = null;
        if (target.equals(TARGET_TEXT_KEY)) {
            text = field.getText();
        } else if (target.equals(TARGET_FIRST_SELECTION_KEY)) {
            ICoreUiSelect select = Factories.web().createUiSelect(field);
            ICoreWebElement firstSelection = select.getFirstSelectedOption();
            text = firstSelection.getAttribute("value");
        } else {
            text = target.equals(TARGET_RECTANGLE_KEY) ? "[x=" + field.getAbsoluteLocation().getX() + ", y=" + field.getAbsoluteLocation().getY() + ", width=" + field.getSize().getWidth() + ", height=" + field.getSize().getHeight() + "]" : field.getAttribute(target);
        }
        if (text == null) {
            text = "";
        }
        ((IWebDriverTable)this.myTable).println("Field " + target + ": [" + (text == null ? "null" : text) + "]");
        ((IWebDriverTable)this.myTable).getMyEnvironment().put(variableName, (Object)text);
        return true;
    }
}

