/*
 * Decompiled with CFR 0.152.
 */
package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.ext01.IWebDriverTable;
import com.github.siwenyan.web.core.ICoreWebElement;
import java.util.List;

public class ClickAll
extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String IDENTIFIER_KEY = "identifier";
    private static final String CLICK_ALL = "clickAll";

    public String help(String flavor) {
        String help = "";
        if (flavor.equals(CLICK_ALL)) {
            help = help + "  clickAll identifier=id/name/link/partial link/tag/xpath;\r\n";
        }
        return help;
    }

    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();
            if (cmd.equals(CLICK_ALL)) {
                String identifier = this.dynamic(dish.getStringElement(new String[]{IDENTIFIER_KEY, "main"}));
                if (identifier == null || identifier.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "No identifier specified.");
                }
                List els = ((IWebDriverTable)this.myTable).getMyWebDriver().find(identifier);
                while (null != els && els.size() > 0 && (1 != els.size() || null != els.get(0))) {
                    for (ICoreWebElement el : els) {
                        try {
                            if (!el.isDisplayed()) continue;
                            try {
                                el.click();
                            }
                            catch (Exception e) {
                                ((IWebDriverTable)this.myTable).getMyWebDriver().getCoreWebDriver().executeScript("window.scrollTo(0, 0)");
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ((IWebDriverTable)this.myTable).getMyWebDriver().getCoreWebDriver().clearBuffer();
                    els = ((IWebDriverTable)this.myTable).getMyWebDriver().find(identifier);
                }
                return Feedback.yami();
            }
        }
        catch (NullPointerException e) {
            return new Feedback(Feedback.EStatus.FAIL, "Invalid identifier.");
        }
        catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }
        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{CLICK_ALL};
    }
}

