package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.Factories;
import com.github.siwenyan.web.core.ICoreUiSelect;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.StaleElementException;

import java.util.List;

public class TrySelect extends AbstractSimpleGuest<IWebDriverTable> {

    private static final String SELECT_KEY = "select";

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(SELECT_KEY)) {
            help += Constants.OUTPUT_INDENT + SELECT_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + "identifier1"
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "selectedOption1" + Constants.OUTPUT_PARAM_SEPARATOR
                    + "identifier2" + Constants.OUTPUT_PARAMNAME_SEPARATOR + "selectedOption2 ..."
                    + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            String cmd = dish.getFlavor().getFlavorName();

            if (cmd.equals(SELECT_KEY)) {

                for (String identifier : dish.getElementKeySet()) {
                    ICoreWebElement el = myTable.getMyWebDriver().find(this.dynamic(identifier)).get(0);
                    String text = this.dynamic(dish.getStringElement(identifier));
                    if (el != null && text != null) {
                        ICoreUiSelect select = Factories.web().createUiSelect(el);
                        List<ICoreWebElement> options = select.getOptions();
                        for (ICoreWebElement option : options) {
                            if (option.getAttribute("value").equals(text)) {
                                select.selectByValue(text);
                                return Feedback.yami();
                            }

                            if (option.getText().equals(text)) {
                                select.selectByVisibleText(text);
                                return Feedback.yami();
                            }
                        }

                        return new Feedback(Feedback.EStatus.FAIL, "No such option: " + text);
                        // Select select = new Select(el);
                        // select.selectByValue(text);
                    } else {
                        return new Feedback(Feedback.EStatus.FAIL, identifier + " is ambiguous or not found.");
                    }
                }

                return Feedback.yami();
            }

        } catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    public String[] getFlavors() {
        return new String[]{SELECT_KEY};
    }

}
