package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.Sys;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.dish_parser.ISupply;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.potluck.IGuest;
import com.github.siwenyan.web.WebUtils;
import com.github.siwenyan.web.core.ICoreWebElement;
import com.github.siwenyan.web.core.ITakesScreenshot;
import com.github.siwenyan.web.core.MyWebDriver;
import com.github.siwenyan.web.core.StaleElementException;
import org.apache.commons.io.FileUtils;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class Screenshot extends AbstractSimpleGuest<IWebDriverTable> {
    private static final String DOT_PNG = ".png";
    private static final String DOT_HTML = ".html";

    private static final String SCREENSHOT_KEY = "screenShot";
    private static final String TO_KEY = "to";
    private static final String SAVE_HTML_KEY = "saveHtml";
    private static final String INTO_KEY = "into";
    private static final String HIGHLIGHT_KEY = "highlight";
    private static final String CROP_KEY = "crop";
    private static final String NAME_KEY = "name";
    private static final String DEBUG_KEY = "debug";

    private static String debug = "";

    private boolean saveHtml = false;
    private String to = null;
    private String into = "last_" + SCREENSHOT_KEY;

    @Override
    public String help(String flavor) {
        String help = "";

        if (flavor.equals(SCREENSHOT_KEY)) {
            help += Constants.OUTPUT_INDENT + SCREENSHOT_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + TO_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "C:\\temp\\" + Constants.OUTPUT_PARAM_SEPARATOR
                    + INTO_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR + "screenShotFileVar"
                    + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
            help += Constants.OUTPUT_INDENT + SCREENSHOT_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + TO_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "C:\\temp\\" + Constants.OUTPUT_PARAM_SEPARATOR
                    + NAME_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR + "fielName"
                    + Constants.OUTPUT_PARAM_SEPARATOR + SAVE_HTML_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
                    + "[true|false]" + Constants.OUTPUT_PARAM_SEPARATOR + HIGHLIGHT_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "element1:element2:..."
                    + Constants.OUTPUT_PARAM_SEPARATOR + HIGHLIGHT_KEY + "1"
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "x1:y1:x2:y2^element1^x1:y1:x2:y2^element2^..."
                    + Constants.OUTPUT_PARAM_SEPARATOR + HIGHLIGHT_KEY + "2"
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "x1:y1:x2:y2^element1^x1:y1:x2:y2^element2^..."
                    + Constants.OUTPUT_PARAM_SEPARATOR + CROP_KEY + Constants.OUTPUT_PARAMNAME_SEPARATOR
                    + "x1:y1:x2:y2^element1^x1:y1:x2:y2^element2^..." + Constants.OUTPUT_LINE_SEPARATOR
                    + "\r\n Parameter " + TO_KEY + " is Optional if specified by above command.";
            help += Constants.OUTPUT_INDENT + SCREENSHOT_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + DEBUG_KEY
                    + Constants.OUTPUT_PARAMNAME_SEPARATOR + "break" + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
        }

        return help;
    }

    @Override
    public Feedback have(IDish dish) {
        try {
            MyWebDriver myWebDriver = myTable.getMyWebDriver();
            String cmd = dish.getFlavor().getFlavorName();

            if (this.into != null && !this.into.isEmpty()) {
                myTable.getMyEnvironment().put(this.into, "");
            }

            if (cmd.equals(SCREENSHOT_KEY)) {
                // accept debug
                if (dish.containsElement(DEBUG_KEY)) {
                    debug = this.dynamic(dish.getStringElement(DEBUG_KEY));
                }

                // accept path
                String sPath = this.dynamic(dish.getStringElement(TO_KEY));
                if (sPath != null && !sPath.isEmpty()) {
                    this.to = sPath;
                }

                // check path
                if (this.to == null || this.to.isEmpty()) {
                    return new Feedback(Feedback.EStatus.FAIL, "Missing parameter: " + TO_KEY);
                }
                if (!this.to.endsWith("/") && !this.to.endsWith("\\")) {
                    this.to += Sys.SEP;
                }
                File f = new File(this.to);
                if (!f.isDirectory()) {
                    FileUtils.forceMkdir(new File(this.to));
                }

                // accept into
                myTable.getMyEnvironment().put(this.into, "");
                String sVar = this.dynamic(dish.getStringElement(INTO_KEY));
                if (sVar != null && !sVar.isEmpty()) {
                    this.into = sVar;
                }
                myTable.getMyEnvironment().put(this.into, "");

                // accept name
                String name = this.dynamic(dish.getStringElement(NAME_KEY, Constants.DEFAULT_KEY));

                // check name
                if (name == null || name.isEmpty()) {
                    // default name: last_screenShot
                    name = "last_" + SCREENSHOT_KEY;
                }

                // get full path
                name = Sys.getUniqueNameWithinFolder(this.to, name, DOT_PNG, false);

                // accept saveHtml
                if (dish.containsElement(SAVE_HTML_KEY)) {
                    this.saveHtml = Boolean.parseBoolean(this.dynamic(dish.getStringElement(SAVE_HTML_KEY)));
                }

                // screenshot
                String fullPath = this.to + name + DOT_PNG;
                File file = null;
                try {
                    ((ITakesScreenshot) myWebDriver.getCoreWebDriver()).getScreenshotAsFile(this.to, name);
                    file = new File(this.to + name + DOT_PNG);
                } catch (Exception e) {
                    File scrFile = ((ITakesScreenshot) myWebDriver.getCoreWebDriver()).getScreenshotAsFile();
                    file = new File(fullPath);
                    FileUtils.copyFile(scrFile, file);
                }
                myTable.getMyEnvironment().put(this.into, fullPath);

                // do saveHtml
                if (this.saveHtml) {
                    String htmlFullPath = this.to + name + DOT_HTML;
                    FileUtils.writeStringToFile(new File(htmlFullPath), myTable.getMyWebDriver().getPageSource(),
                            "utf-16");
                }

                // highlight
                File imageFile = new File(fullPath);
                BufferedImage img = ImageIO.read(imageFile);
                Graphics2D graph = img.createGraphics();
                graph.setColor(Color.RED);
                graph.setStroke(new BasicStroke(3));

                // highlight specified elements
                String sElements = this.dynamic(dish.getStringElement(HIGHLIGHT_KEY));
                if (sElements != null && !sElements.trim().isEmpty()) {
                    String[] elements = sElements.trim().split(":");
                    highlight(graph, elements);
                }

                // highlight more rectangles
                for (String key : dish.getElementKeySet()) {
                    key = key.trim();
                    if (key != null && !key.isEmpty() && !key.equals(HIGHLIGHT_KEY) && key.startsWith(HIGHLIGHT_KEY)) {
                        String sRec = this.dynamic(dish.getStringElement(key));
                        if (sRec != null && !sRec.trim().isEmpty()) {
                            Rectangle rect = WebUtils.toRectangle(myTable.getMyWebDriver(), sRec);
                            if (rect != null) {
                                highlight(graph, rect);
                            }
                        }
                    }
                }

                graph.dispose();
                ImageIO.write(img, "png", new File(fullPath));

                // crop
                String msg = "";
                String sRec = this.dynamic(dish.getStringElement(CROP_KEY));
                if (sRec != null && !sRec.trim().isEmpty()) {
                    Rectangle rect = WebUtils.toRectangle(myTable.getMyWebDriver(), sRec);
                    if (rect != null) {
                        try {
                            crop(fullPath, rect);
                        } catch (Exception e) {
                            msg += "Warning: " + e.getMessage();
                        }
                    } else {
                        msg += "\r\nInvalid Crop Parameters: " + sRec;
                    }
                }

                if (!debug.isEmpty()) {
                    ISupply supply = myTable.getMyHost().getTemplateSupply();
                    supply.setLines(new String[]{debug});
                    supply.addStack(dish.getSupply().getStack(0));
                    supply.addStack(SCREENSHOT_KEY);
                    myTable.cutInSupply(supply, 0);
                }

                msg += "\r\nScreenshot File: " + fullPath;
                return new Feedback(Feedback.EStatus.YAMI, msg);
            }

        } catch (StaleElementException e) {
            return new Feedback(Feedback.EStatus.STALE_ELEMENT, e.getMessage());
        } catch (Exception e) {
            return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
        }

        return Feedback.yaki();
    }

    @Override
    public IGuest cloneGuest() {
        Screenshot clone = new Screenshot();
        clone.into = this.into;
        clone.to = this.to;
        return clone;
    }

    private void crop(String fullpath, Rectangle rect) throws IOException {
        File imageFile = new File(fullpath);
        BufferedImage img = ImageIO.read(imageFile);
        // ImageIO.write(img, "png",
        // new File(fullpath.substring(0, fullpath.length() - DOT_PNG.length())
        // + "_origin" + DOT_PNG));

        int x = Math.max(0, rect.x);
        int y = Math.max(0, rect.y);
        int w = Math.min(rect.width, img.getWidth() - x);
        int h = Math.min(rect.height, img.getHeight() - y);
        BufferedImage crop = img.getSubimage(x, y, w, h);

        ImageIO.write(crop, "png", new File(fullpath));
    }

    private void highlight(Graphics2D graph, String[] elements) throws IOException, StaleElementException {

        for (String element : elements) {
            ICoreWebElement ele = myTable.getMyWebDriver().find(element).get(0);
            if (ele != null) {
                Rectangle rect = WebUtils.getWebRectangle(ele);
                highlight(graph, rect);
            }
        }

    }

    private void highlight(Graphics2D graph, Rectangle rect) throws IOException {
        graph.draw(new Rectangle(rect.x - 3, rect.y - 3, rect.width + 6, rect.height + 6));
    }

    public String[] getFlavors() {
        return new String[]{SCREENSHOT_KEY};
    }

}
