package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.common.MyEscaper;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.core.MyWebDriver;

public class JavaScript extends AbstractSimpleGuest<IWebDriverTable> {

	private static final String JAVA_SCRIPT_KEY = "javascript";
	private static final String INTO = "into";

	@Override
	public String help(String flavor) {
		String help = "";

		if (flavor.equals(JAVA_SCRIPT_KEY)) {
			help += Constants.OUTPUT_INDENT + JAVA_SCRIPT_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + "yourJavaScript"
					+ Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
		}

		return help;
	}

	@Override
	public Feedback have(IDish dish) {
		try {
			MyWebDriver myWebDriver = myTable.getMyWebDriver();
			String cmd = dish.getFlavor().getFlavorName();

			if (cmd.equals(JAVA_SCRIPT_KEY)) {

				String javascript = this.dynamic(dish.getStringElement(Constants.DEFAULT_KEY));
				javascript = MyEscaper.unescape(javascript);
				if (javascript == null || javascript.trim().isEmpty()) {
					return new Feedback(Feedback.EStatus.FAIL, "JavaScript not specified.");
				}

				String javascriptReturn = "";
				try {
					Object javascriptReturnObject = myWebDriver.getCoreWebDriver().executeScript(javascript);
					javascriptReturn = javascriptReturnObject == null ? "" : javascriptReturnObject.toString();

					String varName = this.dynamic(dish.getStringElement(INTO));
					if (!varName.isEmpty()) {
						myTable.getMyEnvironment().put(varName, javascriptReturn);
					}

					this.myTable.println("Return Value: [" + javascriptReturn + "]");
				} catch (NullPointerException e) {
					this.myTable.println(e.getMessage());
				}

				return Feedback.yami();
			}

		} catch (Exception e) {
			return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
		}

		return Feedback.yaki();
	}

	public String[] getFlavors() {
		return new String[] { JAVA_SCRIPT_KEY };
	}

}
