package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;

import java.util.Map;

public class GuestReplaceDriver extends AbstractSimpleGuest<IWebDriverTable> {
	private static final String FLAVOR_REPLACE_BROWSER = "replaceBrowser";

	@Override
	public String help(String flavor) {
		String help = "";

		if (flavor.equals(FLAVOR_REPLACE_BROWSER)) {
			help += Constants.OUTPUT_INDENT + FLAVOR_REPLACE_BROWSER + Constants.OUTPUT_FLAVOR_SEPARATOR
					+ "<options>" + Constants.OUTPUT_LINE_SEPARATOR + "\r\n"
					+ Constants.OUTPUT_INDENT + Constants.OUTPUT_INDENT;
		}

		return help;
	}

	@Override
	public Feedback have(IDish dish) {
		try {
			String cmd = dish.getFlavor().getFlavorName();

			if (cmd.equals(FLAVOR_REPLACE_BROWSER)) {
				Map<String, Object> options = dish.asOptions();
				this.myTable.replaceDriver(options);
				return Feedback.yami();
			}
		} catch (Exception e) {
			return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
		}

		return Feedback.yaki();
	}

	public String[] getFlavors() {
		return new String[] { FLAVOR_REPLACE_BROWSER };
	}

}
