package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.core.ICoreAlert;
import com.github.siwenyan.web.core.MyWebDriver;

public class AlertDismiss extends AbstractSimpleGuest<IWebDriverTable> {

	private static final String DISMISS_KEY = "dismiss";

	@Override
	public String help(String flavor) {
		String help = "";

		if (flavor.equals(DISMISS_KEY)) {
			help += Constants.OUTPUT_INDENT + DISMISS_KEY + Constants.OUTPUT_LINE_SEPARATOR + "\r\n";
		}

		return help;
	}

	@Override
	public Feedback have(IDish dish) {
		try {
			MyWebDriver myWebDriver = myTable.getMyWebDriver();
			String cmd = dish.getFlavor().getFlavorName();

			if (cmd.equals(DISMISS_KEY)) {

				ICoreAlert alert = myWebDriver.getCoreWebDriver().switchTo().alert();
				alert.dismiss();
				myWebDriver.getCoreWebDriver().switchTo().defaultContent();

				return Feedback.yami();
			}

		} catch (Exception e) {
			return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
		}

		return Feedback.yaki();
	}

	public String[] getFlavors() {
		return new String[] { DISMISS_KEY };
	}

}
