package com.github.siwenyan.potluck.ext01;

import com.github.siwenyan.common.Feedback;
import com.github.siwenyan.dish_parser.Constants;
import com.github.siwenyan.dish_parser.IDish;
import com.github.siwenyan.potluck.AbstractSimpleGuest;
import com.github.siwenyan.web.core.ICoreAlert;
import com.github.siwenyan.web.core.MyWebDriver;

public class AlertAccept extends AbstractSimpleGuest<IWebDriverTable> {

	private static final String ACCEPT_KEY = "accept";
	private static final String SEND_KEY_KEY = "sendKey";

	@Override
	public String help(String flavor) {
		String help = "";

		if (flavor.equals(ACCEPT_KEY)) {
			help += Constants.OUTPUT_INDENT + ACCEPT_KEY + Constants.OUTPUT_FLAVOR_SEPARATOR + SEND_KEY_KEY
					+ Constants.OUTPUT_PARAMNAME_SEPARATOR + "keyStrokesToBeSent" + Constants.OUTPUT_LINE_SEPARATOR
					+ "\r\n";
		}

		return help;
	}

	@Override
	public Feedback have(IDish dish) {
		try {
			MyWebDriver myWebDriver = myTable.getMyWebDriver();
			String cmd = dish.getFlavor().getFlavorName();

			if (cmd.equals(ACCEPT_KEY)) {

				String sendKey = this.dynamic(dish.getStringElement(SEND_KEY_KEY, Constants.DEFAULT_KEY));
				ICoreAlert alert = myWebDriver.getCoreWebDriver().switchTo().alert();
				if (sendKey != null) {
					alert.sendKeys(sendKey);
				}
				alert.accept();
				myWebDriver.getCoreWebDriver().switchTo().defaultContent();

				return Feedback.yami();
			}

		} catch (Exception e) {
			return new Feedback(Feedback.EStatus.FAIL, e.getMessage());
		}

		return Feedback.yaki();
	}

	public String[] getFlavors() {
		return new String[] { ACCEPT_KEY };
	}

}
