/*
 * Decompiled with CFR 0.152.
 */
package com.github.sisyphsu.dateparser;

import com.github.sisyphsu.dateparser.DateBuilder;
import com.github.sisyphsu.dateparser.DateParserBuilder;
import com.github.sisyphsu.dateparser.RuleHandler;
import com.github.sisyphsu.retree.ReMatcher;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DateParser {
    private final ReMatcher matcher;
    private final DateBuilder dt = new DateBuilder();
    private final List<String> rules;
    private final Set<String> standardRules;
    private final Map<String, RuleHandler> customizedRuleMap;
    private String input;
    private boolean preferMonthFirst;
    private static final int[] NSS = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};

    DateParser(List<String> rules, Set<String> stdRules, Map<String, RuleHandler> cstRules, boolean preferMonthFirst) {
        this.rules = rules;
        this.standardRules = stdRules;
        this.customizedRuleMap = cstRules;
        this.preferMonthFirst = preferMonthFirst;
        this.matcher = new ReMatcher(this.rules.toArray(new String[0]));
    }

    public static DateParserBuilder newBuilder() {
        return new DateParserBuilder();
    }

    public void setPreferMonthFirst(boolean preferMonthFirst) {
        this.preferMonthFirst = preferMonthFirst;
    }

    public Date parseDate(String str) {
        this.dt.reset();
        this.input = str;
        this.parse(DateParser.buildInput(str));
        return this.dt.toDate();
    }

    public Calendar parseCalendar(String str) {
        this.dt.reset();
        this.input = str;
        this.parse(DateParser.buildInput(str));
        return this.dt.toCalendar();
    }

    public LocalDateTime parseDateTime(String str) {
        this.dt.reset();
        this.input = str;
        this.parse(DateParser.buildInput(str));
        return this.dt.toLocalDateTime();
    }

    public OffsetDateTime parseOffsetDateTime(String str) {
        this.dt.reset();
        this.input = str;
        this.parse(DateParser.buildInput(str));
        return this.dt.toOffsetDateTime();
    }

    private void parse(CharArray input) {
        this.matcher.reset((CharSequence)input);
        int offset = 0;
        int oldEnd = -1;
        while (this.matcher.find(offset)) {
            if (oldEnd == this.matcher.end()) {
                throw this.error(offset, "empty matching at " + offset);
            }
            if (this.standardRules.contains(this.matcher.re())) {
                this.parseStandard(input, offset);
            } else {
                RuleHandler handler = this.customizedRuleMap.get(this.matcher.re());
                handler.handle(input, this.matcher, this.dt);
            }
            oldEnd = offset = this.matcher.end();
        }
        if (offset != input.length()) {
            throw this.error(offset);
        }
    }

    void parseStandard(CharArray input, int offset) {
        block38: for (int index = 1; index <= this.matcher.groupCount(); ++index) {
            String groupName = this.matcher.groupName(index);
            int startOff = this.matcher.start(index);
            int endOff = this.matcher.end(index);
            if (groupName == null) {
                throw this.error(offset, "Hit invalid standard rule: " + this.matcher.re());
            }
            if (startOff == -1 && endOff == -1) continue;
            switch (groupName) {
                case "week": {
                    this.dt.week = this.parseWeek(input, startOff);
                    continue block38;
                }
                case "year": {
                    this.dt.year = this.parseYear(input, startOff, endOff);
                    continue block38;
                }
                case "month": {
                    this.dt.month = this.parseMonth(input, startOff, endOff);
                    if (this.dt.month > 0 && this.dt.month <= 12) continue block38;
                    throw this.error(startOff, "Invalid month at " + startOff);
                }
                case "day": {
                    this.dt.day = DateParser.parseNum(input, startOff, endOff);
                    if (this.dt.day > 0 && this.dt.day <= 31) continue block38;
                    throw this.error(startOff, "Invalid day at " + startOff);
                }
                case "hour": {
                    this.dt.hour = DateParser.parseNum(input, startOff, endOff);
                    if (this.dt.hour < 24) continue block38;
                    throw this.error(startOff, "Invalid hour at " + startOff);
                }
                case "minute": {
                    this.dt.minute = DateParser.parseNum(input, startOff, endOff);
                    if (this.dt.minute < 60) continue block38;
                    throw this.error(startOff, "Invalid minute at " + startOff);
                }
                case "second": {
                    this.dt.second = DateParser.parseNum(input, startOff, endOff);
                    if (this.dt.second < 60) continue block38;
                    throw this.error(startOff, "Invalid second at " + startOff);
                }
                case "ns": {
                    this.dt.ns = this.parseNano(input, startOff, endOff);
                    continue block38;
                }
                case "m": {
                    if (input.charAt(startOff) == 'p') {
                        this.dt.pm = true;
                        continue block38;
                    }
                    this.dt.am = true;
                    continue block38;
                }
                case "zero": {
                    this.dt.zoneOffsetSetted = true;
                    this.dt.zoneOffset = 0;
                    continue block38;
                }
                case "zoneOffset": {
                    this.dt.zoneOffsetSetted = true;
                    this.dt.zoneOffset = this.parseZoneOffset(input, startOff, endOff);
                    if (this.dt.zoneOffset >= -1080 && this.dt.zoneOffset <= 1080) continue block38;
                    throw this.error(startOff, "Invalid ZoneOffset at " + startOff);
                }
                case "zoneName": {
                    continue block38;
                }
                case "dayOrMonth": {
                    this.parseDayOrMonth(input, startOff, endOff);
                    continue block38;
                }
                case "unixsecond": {
                    this.dt.unixsecond = DateParser.parseNum(input, startOff, startOff + 10);
                    continue block38;
                }
                case "millisecond": {
                    this.dt.unixsecond = DateParser.parseNum(input, startOff, endOff - 3);
                    this.dt.ns = DateParser.parseNum(input, endOff - 3, endOff) * 1000000;
                    continue block38;
                }
                case "microsecond": {
                    this.dt.unixsecond = DateParser.parseNum(input, startOff, endOff - 6);
                    this.dt.ns = DateParser.parseNum(input, endOff - 6, endOff) * 1000;
                    continue block38;
                }
                case "nanosecond": {
                    this.dt.unixsecond = DateParser.parseNum(input, startOff, endOff - 9);
                    this.dt.ns = DateParser.parseNum(input, endOff - 9, endOff);
                    continue block38;
                }
                default: {
                    throw this.error(offset, "Hit invalid standard rule: " + this.matcher.re());
                }
            }
        }
    }

    void parseDayOrMonth(CharArray input, int from, int to) {
        int b;
        int a;
        char next = input.data[from + 1];
        if (next < '0' || next > '9') {
            a = DateParser.parseNum(input, from, from + 1);
            b = DateParser.parseNum(input, from + 2, to);
        } else {
            a = DateParser.parseNum(input, from, from + 2);
            b = DateParser.parseNum(input, from + 3, to);
        }
        if (a > 31 || b > 31 || a == 0 || b == 0 || a > 12 && b > 12) {
            throw this.error(from, "Invalid DayOrMonth at " + from);
        }
        if (b > 12 || this.preferMonthFirst) {
            this.dt.month = a;
            this.dt.day = b;
        } else {
            this.dt.day = a;
            this.dt.month = b;
        }
    }

    int parseYear(CharArray input, int from, int to) {
        switch (to - from) {
            case 4: {
                return DateParser.parseNum(input, from, to);
            }
            case 2: {
                int num = DateParser.parseNum(input, from, to);
                return (num > 50 ? 1900 : 2000) + num;
            }
            case 0: {
                return 0;
            }
        }
        throw this.error(from, "Invalid year at " + from);
    }

    int parseZoneOffset(CharArray input, int from, int to) {
        int hour;
        boolean neg;
        boolean bl = neg = input.data[from] == '-';
        if (++from + 2 <= to && Character.isDigit(input.charAt(from + 1))) {
            hour = DateParser.parseNum(input, from, from + 2);
            from += 2;
        } else {
            hour = DateParser.parseNum(input, from, from + 1);
            ++from;
        }
        if (from + 3 <= to && input.charAt(from) == ':') {
            ++from;
        }
        int minute = 0;
        if (from + 2 <= to) {
            minute = DateParser.parseNum(input, from, from + 2);
        }
        return (hour * 60 + minute) * (neg ? -1 : 1);
    }

    int parseNano(CharArray input, int from, int to) {
        int len = to - from;
        if (len < 1) {
            return 0;
        }
        int num = DateParser.parseNum(input, from, to);
        return NSS[len - 1] * num;
    }

    int parseWeek(CharArray input, int from) {
        switch (input.data[from]) {
            case 'm': {
                return 1;
            }
            case 'w': {
                return 3;
            }
            case 'f': {
                return 5;
            }
            case 't': {
                switch (input.data[from + 1]) {
                    case 'u': {
                        return 2;
                    }
                    case 'h': {
                        return 4;
                    }
                }
                break;
            }
            case 's': {
                switch (input.data[from + 1]) {
                    case 'a': {
                        return 6;
                    }
                    case 'u': {
                        return 7;
                    }
                }
            }
        }
        throw this.error(from, "Invalid week at " + from);
    }

    int parseMonth(CharArray input, int from, int to) {
        if (to - from <= 2) {
            return DateParser.parseNum(input, from, to);
        }
        switch (input.data[from]) {
            case 'a': {
                switch (input.data[from + 1]) {
                    case 'p': {
                        return 4;
                    }
                    case 'u': {
                        return 8;
                    }
                }
                break;
            }
            case 'j': {
                if (input.data[from + 1] == 'a') {
                    return 1;
                }
                switch (input.data[from + 2]) {
                    case 'n': {
                        return 6;
                    }
                    case 'l': {
                        return 7;
                    }
                }
                break;
            }
            case 'f': {
                return 2;
            }
            case 'm': {
                switch (input.data[from + 2]) {
                    case 'r': {
                        return 3;
                    }
                    case 'y': {
                        return 5;
                    }
                }
                break;
            }
            case 's': {
                return 9;
            }
            case 'o': {
                return 10;
            }
            case 'n': {
                return 11;
            }
            case 'd': {
                return 12;
            }
        }
        throw this.error(from, "Invalid month at " + from);
    }

    private DateTimeParseException error(int offset) {
        return this.error(offset, String.format("Text %s cannot parse at %d", this.input, offset));
    }

    private DateTimeParseException error(int offset, String msg) {
        return new DateTimeParseException(msg, this.input, offset);
    }

    static int parseNum(CharArray input, int from, int to) {
        int num = 0;
        for (int i = from; i < to; ++i) {
            num = num * 10 + (input.data[i] - 48);
        }
        return num;
    }

    static CharArray buildInput(String str) {
        if (str == null) {
            throw new NullPointerException("str cannot be null");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException("str cannot be empty");
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch < 'A' || ch > 'Z') continue;
            chars[i] = (char)(ch + 32);
        }
        return new CharArray(chars);
    }

    static class CharArray
    implements CharSequence {
        char[] data;

        public CharArray(char[] data) {
            this.data = data;
        }

        @Override
        public int length() {
            return this.data.length;
        }

        @Override
        public char charAt(int index) {
            return this.data[index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }
    }
}

