/*
 * Decompiled with CFR 0.152.
 */
package com.github.sinboun;

import com.github.sinboun.Emoji;
import com.github.sinboun.EmojiManager;
import com.github.sinboun.EmojiParser;
import com.github.sinboun.EmojiTrie;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class EmojiUtil {
    public static boolean isEmoji(String str) {
        return EmojiManager.isEmoji(str);
    }

    public static boolean containsEmoji(String str) {
        if (str == null) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            EmojiTrie.Matches status;
            for (int j = i + 1; j <= chars.length && !(status = EmojiManager.isEmoji(Arrays.copyOfRange(chars, i, j))).impossibleMatch(); ++j) {
                if (!status.exactMatch()) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<Emoji> getByTag(String tag) {
        return EmojiManager.getForTag(tag);
    }

    public static Emoji get(String alias) {
        return EmojiManager.getForAlias(alias);
    }

    public static String toUnicode(String str) {
        return EmojiParser.parseToUnicode(str);
    }

    public static String toAlias(String str) {
        return EmojiUtil.toAlias(str, EmojiParser.FitzpatrickAction.PARSE);
    }

    public static String toAlias(String str, EmojiParser.FitzpatrickAction fitzpatrickAction) {
        return EmojiParser.parseToAliases(str, fitzpatrickAction);
    }

    public static String toHtmlHex(String str) {
        return EmojiParser.parseToHtmlHexadecimal(str);
    }

    public static String toHtml(String str) {
        return EmojiParser.parseToHtmlHexadecimal(str);
    }

    public static String removeAllEmojis(String str) {
        return EmojiParser.removeAllEmojis(str);
    }

    public static List<String> extractEmojis(String str) {
        return EmojiParser.extractEmojis(str);
    }
}

