/*
 * Decompiled with CFR 0.152.
 */
package com.github.shootmoon.xmlconfigmapper.processor.scan;

import com.github.shootmoon.xmlconfigmapper.core.annotation.Ignore;
import com.github.shootmoon.xmlconfigmapper.core.annotation.Property;
import com.github.shootmoon.xmlconfigmapper.core.converter.TypeConverter;
import com.github.shootmoon.xmlconfigmapper.processor.field.Field;
import com.github.shootmoon.xmlconfigmapper.processor.field.ListElementField;
import com.github.shootmoon.xmlconfigmapper.processor.field.PropertyField;
import com.github.shootmoon.xmlconfigmapper.processor.util.ElementExtensionKt;
import com.github.shootmoon.xmlconfigmapper.processor.util.ProcessingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u0015J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\n\u0012\u0004\u0012\u00020\t\u0018\u0001`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/github/shootmoon/xmlconfigmapper/processor/scan/AnnotationDetector;", "", "elements", "Ljavax/lang/model/util/Elements;", "types", "Ljavax/lang/model/util/Types;", "(Ljavax/lang/model/util/Elements;Ljavax/lang/model/util/Types;)V", "converterTypeNamesSet", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getElements", "()Ljavax/lang/model/util/Elements;", "getTypes", "()Ljavax/lang/model/util/Types;", "containsTypeConverter", "", "typeString", "getGenericTypeFromList", "Ljavax/lang/model/type/TypeMirror;", "listVariableElement", "Ljavax/lang/model/element/VariableElement;", "getQualifiedConverterName", "element", "Ljavax/lang/model/element/Element;", "annotation", "Lcom/github/shootmoon/xmlconfigmapper/core/annotation/Property;", "isXmlField", "Lcom/github/shootmoon/xmlconfigmapper/processor/field/Field;", "nameFromPropertyAnnotationOrField", "property", "xmlconfigmapper-processor"})
public final class AnnotationDetector {
    private HashSet<String> converterTypeNamesSet;
    @NotNull
    private final Elements elements;
    @NotNull
    private final Types types;

    @Nullable
    public final Field isXmlField(@NotNull VariableElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element.getAnnotation(Ignore.class) != null) {
            return null;
        }
        Property propertyAnnotation = element.getAnnotation(Property.class);
        if (propertyAnnotation != null) {
            return new PropertyField(element, this.nameFromPropertyAnnotationOrField(propertyAnnotation, element), this.getQualifiedConverterName(element, propertyAnnotation));
        }
        if (this.containsTypeConverter(((Object)element.asType()).toString())) {
            return new PropertyField(element, element.getSimpleName().toString(), null, 4, null);
        }
        if (ElementExtensionKt.isList(element)) {
            TypeMirror genericListType = this.getGenericTypeFromList(element);
            Element element2 = this.types.asElement(genericListType);
            if (element2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            TypeElement genericListTypeElement = (TypeElement)element2;
            return new ListElementField(element, StringsKt.decapitalize((String)genericListTypeElement.getSimpleName().toString()), genericListType);
        }
        Element element3 = element;
        StringBuilder stringBuilder = new StringBuilder();
        Element element4 = element.getEnclosingElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element4, (String)"element.enclosingElement");
        throw (Throwable)new ProcessingException(element3, stringBuilder.append((Object)element4.getSimpleName()).append('.').append((Object)element.getSimpleName()).append(" is not supported, you can").append(" set custom type converter by @").append(Reflection.getOrCreateKotlinClass(Property.class).getSimpleName()).append(", or use @").append(Reflection.getOrCreateKotlinClass(Ignore.class).getSimpleName()).append(" to skip.").toString());
    }

    private final String nameFromPropertyAnnotationOrField(Property property, VariableElement element) {
        return StringsKt.isBlank((CharSequence)property.name()) ? element.getSimpleName().toString() : property.name();
    }

    private final String getQualifiedConverterName(Element element, Property annotation) {
        try {
            Constructor<?>[] constructors;
            Class converterClass = annotation.converter();
            if (Intrinsics.areEqual((Object)converterClass, TypeConverter.NoneTypeConverter.class)) {
            }
            if (!Modifier.isPublic(converterClass.getModifiers())) {
                throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " must be a public class!");
            }
            if (Modifier.isAbstract(converterClass.getModifiers())) {
                throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " cannot be a abstract");
            }
            if (Modifier.isInterface(converterClass.getModifiers())) {
                throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " cannot be an interface. Only classes are allowed!");
            }
            Constructor<?>[] constructorArray = constructors = converterClass.getConstructors();
            int n = constructorArray.length;
            for (int i = 0; i < n; ++i) {
                Constructor<?> c;
                Constructor<?> constructor = c = constructorArray[i];
                Intrinsics.checkExpressionValueIsNotNull(constructor, (String)"c");
                boolean isPublicConstructor = Modifier.isPublic(constructor.getModifiers());
                Class<?>[] paramTypes = c.getParameterTypes();
                Intrinsics.checkExpressionValueIsNotNull(paramTypes, (String)"paramTypes");
                Class<?>[] classArray = paramTypes;
                boolean bl = false;
                if (!(classArray.length == 0) || !isPublicConstructor) continue;
                return converterClass.getCanonicalName();
            }
            throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " must provide an empty (parameter-less) public constructor");
        }
        catch (MirroredTypeException mte) {
            Element typeConverterElement;
            TypeMirror typeMirror = mte.getTypeMirror();
            if (Intrinsics.areEqual((Object)((Object)typeMirror).toString(), (Object)Reflection.getOrCreateKotlinClass(TypeConverter.NoneTypeConverter.class).getQualifiedName())) {
                return null;
            }
            TypeMirror typeMirror2 = typeMirror;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"typeMirror");
            if (typeMirror2.getKind() != TypeKind.DECLARED) {
                throw (Throwable)new ProcessingException(element, "TypeConverter must be a class");
            }
            DeclaredType typeConverterType = (DeclaredType)typeMirror;
            Element element2 = typeConverterElement = typeConverterType.asElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"typeConverterElement");
            if (element2.getKind() != ElementKind.CLASS) {
                throw (Throwable)new ProcessingException(element, "TypeConverter " + typeConverterElement + " must be a public class!");
            }
            if (!typeConverterElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
                throw (Throwable)new ProcessingException(element, "TypeConverter " + typeConverterElement + " class is not public!");
            }
            Iterator<? extends Element> iterator = ((TypeElement)typeConverterElement).getEnclosedElements().iterator();
            while (iterator.hasNext()) {
                ExecutableElement constructor;
                Element e;
                Element element3 = e = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"e");
                if (element3.getKind() != ElementKind.CONSTRUCTOR || !(constructor = (ExecutableElement)e).getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
                return ((Object)typeMirror).toString();
            }
            throw (Throwable)new ProcessingException(element, "TypeConverter class " + typeMirror + " must provide an empty (parameter-less) public constructor");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsTypeConverter(String typeString) {
        if (this.converterTypeNamesSet == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            AnnotatedConstruct it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Package package_ = TypeConverter.class.getPackage();
            Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"TypeConverter::class.java.`package`");
            PackageElement packageElement = this.elements.getPackageElement(package_.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)packageElement, (String)"elements.getPackageEleme\u2026lass.java.`package`.name)");
            List<? extends Element> list = packageElement.getEnclosedElements();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"elements.getPackageEleme\u2026        .enclosedElements");
            Iterable iterable = list;
            AnnotationDetector annotationDetector = this;
            boolean $i$f$filterIsInstance = false;
            void var4_5 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof TypeElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<String> collection = (List)destination$iv$iv;
            $this$filterIsInstance$iv = collection;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (TypeElement)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getInterfaces();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            collection = (List)destination$iv$iv;
            $this$flatMap$iv = collection;
            $i$f$filterIsInstance = false;
            $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DeclaredType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
            $this$filterIsInstance$iv = collection;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (DeclaredType)element$iv$iv;
                boolean bl = false;
                Element element = it.asElement();
                if (element == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                }
                if (!((TypeElement)element).getQualifiedName().toString().equals(Reflection.getOrCreateKotlinClass(TypeConverter.class).getQualifiedName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
            $this$filter$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DeclaredType)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = ((Object)it.getTypeArguments().get(0)).toString();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            annotationDetector.converterTypeNamesSet = CollectionsKt.toHashSet((Iterable)collection);
        }
        HashSet<String> hashSet = this.converterTypeNamesSet;
        return hashSet != null ? hashSet.contains(typeString) : false;
    }

    private final TypeMirror getGenericTypeFromList(VariableElement listVariableElement) {
        TypeMirror typeMirror;
        TypeMirror typeMirror2 = listVariableElement.asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"listVariableElement.asType()");
        if (typeMirror2.getKind() != TypeKind.DECLARED) {
            throw (Throwable)new ProcessingException(listVariableElement, "Element must be of type java.util.List");
        }
        TypeMirror typeMirror3 = listVariableElement.asType();
        if (typeMirror3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
        }
        DeclaredType typeMirror4 = (DeclaredType)typeMirror3;
        switch (typeMirror4.getTypeArguments().size()) {
            case 0: {
                TypeMirror typeMirror5 = this.elements.getTypeElement("java.lang.Object").asType();
                typeMirror = typeMirror5;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror5, (String)"elements.getTypeElement(\u2026va.lang.Object\").asType()");
                break;
            }
            case 1: {
                TypeMirror typeMirror6;
                TypeMirror typeMirror7 = typeMirror4.getTypeArguments().get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror7, (String)"typeMirror.typeArguments[0]");
                if (typeMirror7.getKind() == TypeKind.WILDCARD) {
                    TypeMirror typeMirror8 = typeMirror4.getTypeArguments().get(0);
                    if (typeMirror8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.type.WildcardType");
                    }
                    WildcardType wildCardMirror = (WildcardType)typeMirror8;
                    typeMirror6 = wildCardMirror.getExtendsBound() != null ? wildCardMirror.getExtendsBound() : (wildCardMirror.getSuperBound() != null ? wildCardMirror.getSuperBound() : this.elements.getTypeElement("java.lang.Object").asType());
                } else {
                    typeMirror6 = typeMirror4.getTypeArguments().get(0);
                }
                typeMirror = typeMirror6;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror6, (String)"if (typeMirror.typeArgum\u2026rguments[0]\n            }");
                break;
            }
            default: {
                throw (Throwable)new ProcessingException(listVariableElement, "You have annotated a List with more than one generic argument!");
            }
        }
        return typeMirror;
    }

    @NotNull
    public final Elements getElements() {
        return this.elements;
    }

    @NotNull
    public final Types getTypes() {
        return this.types;
    }

    public AnnotationDetector(@NotNull Elements elements, @NotNull Types types) {
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        this.elements = elements;
        this.types = types;
    }
}

