/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.StringUtil;
import com.power.doc.model.ApiParam;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OpenApiSchemaUtil {
    public static Map<String, Object> primaryTypeSchema(String primaryType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", DocUtil.javaTypeToOpenApiTypeConvert(primaryType));
        return map;
    }

    public static Map<String, Object> mapTypeSchema(String primaryType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", "object");
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("type", DocUtil.javaTypeToOpenApiTypeConvert(primaryType));
        map.put("additionalProperties", items);
        return map;
    }

    public static Map<String, Object> arrayTypeSchema(String primaryType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "array");
        HashMap<String, String> items = new HashMap<String, String>();
        items.put("type", DocUtil.javaTypeToOpenApiTypeConvert(primaryType));
        map.put("items", items);
        return map;
    }

    public static Map<String, Object> returnSchema(String returnGicName) {
        if (StringUtil.isEmpty((String)returnGicName)) {
            return null;
        }
        returnGicName = returnGicName.replace(">", "");
        String[] types = returnGicName.split("<");
        StringBuilder builder = new StringBuilder();
        for (String str : types) {
            builder.append(DocClassUtil.getSimpleName(str).replace(",", ""));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("$ref", builder.toString());
        return map;
    }

    public static String getClassNameFromParams(List<ApiParam> apiParams) {
        for (ApiParam a : apiParams) {
            if (!StringUtil.isNotEmpty((String)a.getClassName())) continue;
            if (a.getClassName().contains("<") || a.getClassName().contains("[")) {
                return JavaClassUtil.getClassSimpleName(a.getClassName()) + JavaClassUtil.getClassSimpleName(a.getClassName().substring(a.getClassName().indexOf("<") + 1, a.getClassName().lastIndexOf(">")));
            }
            return JavaClassUtil.getClassSimpleName(a.getClassName());
        }
        return "NULL";
    }

    public static String get(String a) {
        if (StringUtil.isNotEmpty((String)a)) {
            if (a.contains("<") || a.contains("[")) {
                return JavaClassUtil.getClassSimpleName(a) + JavaClassUtil.getClassSimpleName(a.substring(a.indexOf("<") + 1, a.lastIndexOf(">")));
            }
            return JavaClassUtil.getClassSimpleName(a);
        }
        return null;
    }
}

