/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.constants;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.power.doc.model.ApiConfig;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TornaConstants {
    public static final String ID = "id";
    public static final String CODE = "code";
    public static final String MESSAGE = "msg";
    public static final String DATA = "data";
    public static final String SUCCESS_CODE = "0";
    public static final String DEFAULT_GROUP_CODE = "default";
    public static final String YES = "1";
    public static final String NO = "0";
    public static final String ARRAY = "array";
    public static final String CATEGORY_CREATE = "doc.category.create";
    public static final String PUSH = "doc.push";
    public static final String ENUM_PUSH = "enum.batch.push";
    public static final String PARAM_TYPE_FILE_ARRAY = "file[]";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Map<String, String> buildParams(String name, String data, ApiConfig config) {
        HashMap<String, String> param = new HashMap<String, String>(8);
        try {
            if (StringUtils.isNotBlank((CharSequence)data)) {
                data = URLEncoder.encode(data, "utf-8");
            }
            param.put("name", name);
            param.put("app_key", config.getAppKey());
            param.put(DATA, data);
            param.put("timestamp", TornaConstants.getTime());
            param.put("version", "1.0");
            param.put("access_token", config.getAppToken());
            String sign = TornaConstants.buildSign(param, config.getSecret());
            param.put("sign", sign);
            return param;
        }
        catch (IOException e) {
            e.printStackTrace();
            return param;
        }
    }

    public static String buildSign(Map<String, ?> paramsMap, String secret) {
        Set<String> keySet = paramsMap.keySet();
        ArrayList<String> paramNames = new ArrayList<String>(keySet);
        Collections.sort(paramNames);
        StringBuilder paramNameValue = new StringBuilder();
        for (String paramName : paramNames) {
            Object value = paramsMap.get(paramName);
            if (value == null) continue;
            paramNameValue.append(paramName).append(value);
        }
        String source = secret + paramNameValue.toString() + secret;
        return TornaConstants.md5(source);
    }

    public static String md5(String message) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] input = message.getBytes();
            byte[] buff = md.digest(input);
            return TornaConstants.byte2hex(buff);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static String getTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }
}

