/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.CollectionUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.common.util.ValidateUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.constants.ApiReqParamInTypeEnum;
import com.power.doc.constants.Methods;
import com.power.doc.constants.SolonRequestAnnotationsEnum;
import com.power.doc.handler.SolonRequestHeaderHandler;
import com.power.doc.handler.SolonRequestMappingHandler;
import com.power.doc.helper.FormDataBuildHelper;
import com.power.doc.helper.JsonBuildHelper;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiMethodReqParam;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.model.FormData;
import com.power.doc.model.request.ApiRequestExample;
import com.power.doc.model.request.CurlRequest;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.ApiParamTreeUtil;
import com.power.doc.utils.CurlUtil;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocPathUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JsonUtil;
import com.power.doc.utils.OpenApiSchemaUtil;
import com.power.doc.utils.TornaUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class SolonDocBuildTemplate
implements IDocBuildTemplate<ApiDoc> {
    private static Logger log = Logger.getLogger(SolonDocBuildTemplate.class.getName());
    private final AtomicInteger atomicInteger = new AtomicInteger(1);
    private List<ApiReqParam> configApiReqParams;

    @Override
    public List<ApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        this.configApiReqParams = Stream.of(apiConfig.getRequestHeaders(), apiConfig.getRequestParams()).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        int order = 0;
        Collection classes = projectBuilder.getJavaProjectBuilder().getClasses();
        boolean setCustomOrder = false;
        for (JavaClass cls : classes) {
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), cls.getCanonicalName())) continue;
            DocletTag ignoreTag = cls.getTagByName("ignore");
            if (!this.checkController(cls) || Objects.nonNull(ignoreTag)) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            ++order;
            if (ValidateUtil.isNonnegativeInteger((String)strOrder)) {
                setCustomOrder = true;
                order = Integer.parseInt(strOrder);
            }
            List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls, apiConfig, projectBuilder);
            this.handleApiDoc(cls, apiDocList, apiMethodDocs, order, apiConfig.isMd5EncryptedHtmlName());
        }
        apiDocList = this.handleTagsApiDoc(apiDocList);
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        } else if (setCustomOrder) {
            return apiDocList.stream().sorted(Comparator.comparing(ApiDoc::getOrder)).peek(p -> p.setOrder(this.atomicInteger.getAndAdd(1))).collect(Collectors.toList());
        }
        return apiDocList;
    }

    private List<ApiDoc> handleTagsApiDoc(List<ApiDoc> apiDocList) {
        if (CollectionUtil.isEmpty(apiDocList)) {
            return Collections.emptyList();
        }
        HashMap copyMap = new HashMap();
        apiDocList.forEach(doc -> {
            Object[] tags = doc.getTags();
            if (ArrayUtils.isEmpty((Object[])tags)) {
                tags = new String[]{doc.getName()};
            }
            for (Object tag : tags) {
                tag = StringUtil.trim((String)tag);
                copyMap.computeIfPresent(tag, (k, v) -> {
                    List<Object> list = CollectionUtil.isEmpty(v.getList()) ? new ArrayList() : v.getList();
                    list.addAll(doc.getList());
                    v.setList(list);
                    return v;
                });
                copyMap.putIfAbsent(tag, doc);
            }
        });
        HashMap<String, ApiDoc> allMap = new HashMap<String, ApiDoc>(copyMap);
        allMap.forEach((k, v) -> {
            List<ApiMethodDoc> methodDocList = v.getList();
            methodDocList.forEach(method -> {
                Object[] tags = method.getTags();
                if (ArrayUtils.isEmpty((Object[])tags)) {
                    return;
                }
                for (Object tag : tags) {
                    tag = StringUtil.trim((String)tag);
                    copyMap.computeIfPresent(tag, (k1, v2) -> {
                        method.setOrder(v2.getList().size() + 1);
                        v2.getList().add((ApiMethodDoc)method);
                        return v2;
                    });
                    copyMap.putIfAbsent(tag, ApiDoc.buildTagApiDoc(v, (String)tag, method));
                }
            });
        });
        ArrayList<ApiDoc> apiDocs = new ArrayList<ApiDoc>(copyMap.values());
        int index = apiDocs.size() - 1;
        for (ApiDoc apiDoc : apiDocs) {
            if (apiDoc.getOrder() != null) continue;
            apiDoc.setOrder(index++);
        }
        apiDocs.sort(Comparator.comparing(ApiDoc::getOrder));
        return apiDocs;
    }

    @Override
    public ApiDoc getSingleApiData(ProjectDocConfigBuilder projectBuilder, String apiClassName) {
        return null;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return JavaClassValidateUtil.isMvcIgnoreParams(typeName, ignoreParams);
    }

    private List<ApiMethodDoc> buildControllerMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder) {
        String clazName = cls.getCanonicalName();
        boolean paramsDataToTree = projectBuilder.getApiConfig().isParamsDataToTree();
        String group = JavaClassUtil.getClassTagsValue(cls, "group", Boolean.TRUE);
        String classAuthor = JavaClassUtil.getClassTagsValue(cls, "author", Boolean.TRUE);
        List<JavaAnnotation> classAnnotations = this.getAnnotations(cls);
        Map<String, String> constantsMap = projectBuilder.getConstantsMap();
        String baseUrl = "";
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getValue();
            if (!"Mapping".equals(annotationName) && !"org.noear.solon.annotation.Mapping".equals(annotationName)) continue;
            baseUrl = StringUtil.removeQuotes((String)DocUtil.getRequestMappingUrl(annotation));
        }
        List methods = cls.getMethods();
        ArrayList<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>(methods.size());
        for (JavaMethod method : methods) {
            if (method.isPrivate()) continue;
            docJavaMethods.add(DocJavaMethod.builder().setJavaMethod(method));
        }
        JavaClass parentClass = cls.getSuperJavaClass();
        if (Objects.nonNull(parentClass) && !"Object".equals(parentClass.getSimpleName())) {
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(parentClass);
            List parentMethodList = parentClass.getMethods();
            Iterator iterator = parentMethodList.iterator();
            while (iterator.hasNext()) {
                JavaMethod method = (JavaMethod)iterator.next();
                docJavaMethods.add(DocJavaMethod.builder().setJavaMethod(method).setActualTypesMap(actualTypesMap));
            }
        }
        List implClasses = cls.getImplements();
        for (JavaType type : implClasses) {
            JavaClass javaClass = (JavaClass)type;
            Map<String, JavaType> actualTypesMap = JavaClassUtil.getActualTypesMap(javaClass);
            for (JavaMethod method : javaClass.getMethods()) {
                if (!method.isDefault()) continue;
                docJavaMethods.add(DocJavaMethod.builder().setJavaMethod(method).setActualTypesMap(actualTypesMap));
            }
        }
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (DocJavaMethod docJavaMethod : docJavaMethods) {
            List<ApiReqParam> allApiReqHeaders;
            DocletTag docletTag;
            DocletTag pageTag;
            RequestMapping requestMapping;
            JavaMethod method = docJavaMethod.getJavaMethod();
            if (method.isPrivate() || Objects.nonNull(method.getTagByName("ignore")) || Objects.isNull(requestMapping = new SolonRequestMappingHandler().handle(projectBuilder, baseUrl, method, constantsMap))) continue;
            if (StringUtil.isEmpty((String)method.getComment()) && apiConfig.isStrict()) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            DocletTag downloadTag = method.getTagByName("download");
            if (Objects.nonNull(downloadTag)) {
                apiMethodDoc.setDownload(true);
            }
            if (Objects.nonNull(pageTag = method.getTagByName("page"))) {
                String pageUrl = projectBuilder.getServerUrl() + "/" + pageTag.getValue();
                apiMethodDoc.setPage(UrlUtil.simplifyUrl((String)pageUrl));
            }
            if (Objects.nonNull(docletTag = method.getTagByName("group"))) {
                apiMethodDoc.setGroup(docletTag.getValue());
            } else {
                apiMethodDoc.setGroup(group);
            }
            List tags = method.getTagsByName("tag");
            apiMethodDoc.setTags((String[])tags.stream().map(DocletTag::getValue).toArray(String[]::new));
            apiMethodDoc.setName(method.getName());
            apiMethodDoc.setOrder(++methodOrder);
            String comment = DocUtil.getEscapeAndCleanComment(method.getComment());
            apiMethodDoc.setDesc(comment);
            String methodUid = DocUtil.generateId(clazName + method.getName());
            apiMethodDoc.setMethodId(methodUid);
            String apiNoteValue = DocUtil.getNormalTagComments(method, "apiNote", cls.getName());
            if (StringUtil.isEmpty((String)apiNoteValue)) {
                apiNoteValue = method.getComment();
            }
            Map<String, String> authorMap = DocUtil.getParamsComments(method, "author", cls.getName());
            String authorValue = String.join((CharSequence)", ", new ArrayList<String>(authorMap.keySet()));
            if (apiConfig.isShowAuthor() && StringUtil.isNotEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(StringUtil.removeQuotes((String)authorValue));
            }
            if (apiConfig.isShowAuthor() && StringUtil.isEmpty((String)authorValue)) {
                apiMethodDoc.setAuthor(classAuthor);
            }
            apiMethodDoc.setDetail(apiNoteValue != null ? apiNoteValue : "");
            List<ApiReqParam> apiReqHeaders = new SolonRequestHeaderHandler().handle(method, projectBuilder);
            apiMethodDoc.setType(requestMapping.getMethodType());
            apiMethodDoc.setUrl(requestMapping.getUrl());
            apiMethodDoc.setServerUrl(projectBuilder.getServerUrl());
            apiMethodDoc.setPath(requestMapping.getShortUrl());
            apiMethodDoc.setDeprecated(requestMapping.isDeprecated());
            List javaParameters = method.getParameters();
            TornaUtil.setTornaArrayTags(javaParameters, apiMethodDoc, docJavaMethod.getJavaMethod().getReturns(), apiConfig);
            List<ApiReqParam> apiReqParamList = this.configApiReqParams.stream().filter(param -> this.filterPath(requestMapping, (ApiReqParam)param)).collect(Collectors.toList());
            ApiMethodReqParam apiMethodReqParam = this.requestParams(requestMapping.getMethodType(), docJavaMethod, projectBuilder, apiReqParamList);
            if (paramsDataToTree) {
                apiMethodDoc.setPathParams(ApiParamTreeUtil.apiParamToTree(apiMethodReqParam.getPathParams()));
                apiMethodDoc.setQueryParams(ApiParamTreeUtil.apiParamToTree(apiMethodReqParam.getQueryParams()));
                apiMethodDoc.setRequestParams(ApiParamTreeUtil.apiParamToTree(apiMethodReqParam.getRequestParams()));
            } else {
                apiMethodDoc.setPathParams(apiMethodReqParam.getPathParams());
                apiMethodDoc.setQueryParams(apiMethodReqParam.getQueryParams());
                apiMethodDoc.setRequestParams(apiMethodReqParam.getRequestParams());
            }
            if (this.configApiReqParams != null) {
                Map<String, List<ApiReqParam>> reqParamMap = apiReqParamList.stream().collect(Collectors.groupingBy(ApiReqParam::getParamIn));
                List headerParamList = reqParamMap.getOrDefault(ApiReqParamInTypeEnum.HEADER.getValue(), Collections.emptyList());
                allApiReqHeaders = Stream.of(apiReqHeaders, headerParamList).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            } else {
                allApiReqHeaders = apiReqHeaders.stream().filter(param -> this.filterPath(requestMapping, (ApiReqParam)param)).collect(Collectors.toList());
            }
            apiMethodDoc.setHeaders(this.createDocRenderHeaders(allApiReqHeaders, apiConfig.isAdoc()));
            apiMethodDoc.setRequestHeaders(allApiReqHeaders);
            String path = apiMethodDoc.getPath().split(";")[0];
            String pathUrl = DocUtil.formatPathUrl(path);
            List<ApiParam> pathParams = apiMethodDoc.getPathParams();
            Iterator<ApiParam> pathIterator = pathParams.iterator();
            while (pathIterator.hasNext()) {
                ApiParam next = pathIterator.next();
                String pathKey = "{" + next.getField() + "}";
                if (pathUrl.contains(pathKey)) continue;
                pathIterator.remove();
            }
            ApiRequestExample requestExample = this.buildReqJson(docJavaMethod, apiMethodDoc, requestMapping.getMethodType(), projectBuilder);
            String requestJson = requestExample.getExampleBody();
            apiMethodDoc.setRequestExample(requestExample);
            apiMethodDoc.setRequestUsage(requestJson == null ? requestExample.getUrl() : requestJson);
            String responseValue = DocUtil.getNormalTagComments(method, "response", cls.getName());
            if (StringUtil.isNotEmpty((String)responseValue)) {
                responseValue = responseValue.replaceAll("<br>", "");
                apiMethodDoc.setResponseUsage(JsonUtil.toPrettyFormat(responseValue));
            } else {
                apiMethodDoc.setResponseUsage(JsonBuildHelper.buildReturnJson(docJavaMethod, projectBuilder));
            }
            List<ApiParam> responseParams = this.buildReturnApiParams(docJavaMethod, projectBuilder);
            if (paramsDataToTree) {
                responseParams = ApiParamTreeUtil.apiParamToTree(responseParams);
            }
            apiMethodDoc.setReturnSchema(docJavaMethod.getReturnSchema());
            apiMethodDoc.setRequestSchema(docJavaMethod.getRequestSchema());
            apiMethodDoc.setResponseParams(responseParams);
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    private boolean filterPath(RequestMapping requestMapping, ApiReqParam apiReqHeader) {
        if (StringUtil.isEmpty((String)apiReqHeader.getPathPatterns()) && StringUtil.isEmpty((String)apiReqHeader.getExcludePathPatterns())) {
            return true;
        }
        return DocPathUtil.matches(requestMapping.getShortUrl(), apiReqHeader.getPathPatterns(), apiReqHeader.getExcludePathPatterns());
    }

    private ApiRequestExample buildReqJson(DocJavaMethod javaMethod, ApiMethodDoc apiMethodDoc, String methodType, ProjectDocConfigBuilder configBuilder) {
        String exampleBody;
        CurlRequest curlRequest;
        String url;
        JavaMethod method = javaMethod.getJavaMethod();
        LinkedHashMap<String, String> pathParamsMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> queryParamsMap = new LinkedHashMap<String, String>();
        apiMethodDoc.getPathParams().stream().filter(Objects::nonNull).filter(ApiParam::isConfigParam).forEach(param -> pathParamsMap.put(param.getField(), param.getValue()));
        apiMethodDoc.getQueryParams().stream().filter(Objects::nonNull).filter(ApiParam::isConfigParam).forEach(param -> queryParamsMap.put(param.getField(), param.getValue()));
        List methodAnnotations = method.getAnnotations();
        for (JavaAnnotation annotation : methodAnnotations) {
            Object paramsObjects;
            String annotationName = annotation.getType().getName();
            if (!annotationName.contains("Mapping") || Objects.isNull(paramsObjects = annotation.getNamedParameter("params"))) continue;
            String params = StringUtil.removeQuotes((String)paramsObjects.toString());
            if (!params.startsWith("[")) {
                this.mappingParamProcess(paramsObjects.toString(), queryParamsMap);
                continue;
            }
            LinkedList headers = (LinkedList)paramsObjects;
            for (String str : headers) {
                this.mappingParamProcess(str, queryParamsMap);
            }
        }
        List parameterList = method.getParameters();
        List<ApiReqParam> reqHeaderList = apiMethodDoc.getRequestHeaders();
        if (parameterList.size() < 1) {
            String path = apiMethodDoc.getPath().split(";")[0];
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String url2 = UrlUtil.urlJoin((String)path, queryParamsMap);
            url2 = StringUtil.removeQuotes((String)url2);
            url2 = apiMethodDoc.getServerUrl() + "/" + url2;
            url2 = UrlUtil.simplifyUrl((String)url2);
            CurlRequest curlRequest2 = CurlRequest.builder().setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url2);
            String format = CurlUtil.toCurl(curlRequest2);
            return ApiRequestExample.builder().setUrl(apiMethodDoc.getUrl()).setExampleBody(format);
        }
        Set<String> ignoreSets = this.ignoreParamsSets(method);
        Map<String, JavaType> actualTypesMap = javaMethod.getActualTypesMap();
        Map<String, String> constantsMap = configBuilder.getConstantsMap();
        boolean requestFieldToUnderline = configBuilder.getApiConfig().isRequestFieldToUnderline();
        Map<String, String> replacementMap = configBuilder.getReplaceClassMap();
        Map<String, String> paramsComments = DocUtil.getParamsComments(method, "param", null);
        List<String> mvcRequestAnnotations = SolonRequestAnnotationsEnum.listMvcRequestAnnotations();
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        ApiRequestExample requestExample = ApiRequestExample.builder();
        block2: for (JavaParameter parameter : parameterList) {
            FormData formData;
            String paramName;
            JavaType javaType = parameter.getType();
            if (Objects.nonNull(actualTypesMap) && Objects.nonNull(actualTypesMap.get(javaType.getCanonicalName()))) {
                javaType = actualTypesMap.get(javaType.getCanonicalName());
            }
            if (ignoreSets.contains(paramName = parameter.getName())) continue;
            String typeName = javaType.getFullyQualifiedName();
            String gicTypeName = javaType.getGenericCanonicalName();
            String commentClass = paramsComments.get(paramName);
            if (Objects.nonNull(commentClass) && commentClass.contains("ignore")) continue;
            String rewriteClassName = this.getRewriteClassName(replacementMap, typeName, commentClass);
            if (DocUtil.isClassName(rewriteClassName)) {
                gicTypeName = rewriteClassName;
                typeName = DocClassUtil.getSimpleName(rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams(typeName, configBuilder.getApiConfig().getIgnoreRequestParams())) continue;
            String simpleTypeName = javaType.getValue();
            typeName = DocClassUtil.rewriteRequestParam(typeName);
            gicTypeName = DocClassUtil.rewriteRequestParam(gicTypeName);
            if (JavaClassValidateUtil.isCollection(typeName)) {
                apiMethodDoc.setListParam(true);
            }
            JavaClass javaClass = configBuilder.getJavaProjectBuilder().getClassByName(typeName);
            String[] globGicName = DocClassUtil.getSimpleGicName(gicTypeName);
            String comment = this.paramCommentResolve(paramsComments.get(paramName));
            String mockValue = this.createMockValue(paramsComments, paramName, typeName, simpleTypeName);
            if (queryParamsMap.containsKey(paramName)) {
                mockValue = (String)queryParamsMap.get(paramName);
            }
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            List annotations = parameter.getAnnotations();
            List<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations);
            boolean paramAdded = false;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                String fullName = annotation.getType().getSimpleName();
                if (!mvcRequestAnnotations.contains(fullName) || paramAdded) continue;
                if (JavaClassValidateUtil.ignoreSolonMvcParamWithAnnotation(annotationName)) continue block2;
                AnnotationValue annotationDefaultVal = annotation.getProperty("defaultValue");
                if (null != annotationDefaultVal) {
                    mockValue = StringUtil.removeQuotes((String)annotationDefaultVal.toString());
                }
                paramName = this.getParamName(paramName, annotation);
                for (Map.Entry<String, String> entry : constantsMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (paramName.contains(key)) {
                        paramName = paramName.replace(key, value);
                    }
                    if (!mockValue.contains(key)) continue;
                    mockValue = mockValue.replace(key, value);
                }
                if ("Body".equals(annotationName) || "org.noear.solon.annotation.Body".equals(annotationName)) {
                    apiMethodDoc.setContentType("application/json; charset=utf-8");
                    if (Objects.nonNull(configBuilder.getApiConfig().getRequestBodyAdvice()) && Objects.isNull(method.getTagByName("ignoreRequestBodyAdvice"))) {
                        String requestBodyAdvice = configBuilder.getApiConfig().getRequestBodyAdvice().getClassName();
                        typeName = configBuilder.getApiConfig().getRequestBodyAdvice().getClassName();
                        gicTypeName = requestBodyAdvice + "<" + gicTypeName + ">";
                    }
                    if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                        requestExample.setJsonBody(mockValue).setJson(true);
                    } else {
                        String json = JsonBuildHelper.buildJson(typeName, gicTypeName, Boolean.FALSE, 0, new HashMap<String, String>(), groupClasses, configBuilder);
                        requestExample.setJsonBody(JsonUtil.toPrettyFormat(json)).setJson(true);
                    }
                    paramAdded = true;
                    continue;
                }
                if (!"PathVar".contains(annotationName)) continue;
                if (javaClass.isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                    mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                }
                if (pathParamsMap.containsKey(paramName)) {
                    mockValue = (String)pathParamsMap.get(paramName);
                }
                pathParamsMap.put(paramName, mockValue);
                paramAdded = true;
            }
            if (paramAdded) continue;
            if (JavaClassValidateUtil.isFile(gicTypeName)) {
                apiMethodDoc.setContentType("multipart/form-data");
                formData = new FormData();
                formData.setKey(paramName);
                formData.setType("file");
                formData.setDescription(comment);
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(typeName)) {
                formData = new FormData();
                formData.setKey(paramName);
                formData.setDescription(comment);
                formData.setType("text");
                formData.setValue(mockValue);
                formDataList.add(formData);
                continue;
            }
            if (JavaClassValidateUtil.isArray(typeName) || JavaClassValidateUtil.isCollection(typeName)) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if (!JavaClassValidateUtil.isPrimitive(gicName) && !configBuilder.getJavaProjectBuilder().getClassByName(gicName).isEnum()) {
                    throw new RuntimeException("Solon MVC can't support binding Collection on method " + method.getName() + "Check it in " + method.getDeclaringClass().getCanonicalName());
                }
                FormData formData2 = new FormData();
                formData2.setKey(paramName);
                if (!paramName.contains("[]")) {
                    formData2.setKey(paramName + "[]");
                }
                formData2.setDescription(comment);
                formData2.setType("text");
                formData2.setValue(RandomUtil.randomValueByType((String)gicName));
                formDataList.add(formData2);
                continue;
            }
            if (javaClass.isEnum()) {
                Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                String strVal = StringUtil.removeQuotes((String)String.valueOf(value));
                FormData formData3 = new FormData();
                formData3.setKey(paramName);
                formData3.setType("text");
                formData3.setDescription(comment);
                formData3.setValue(strVal);
                formDataList.add(formData3);
                continue;
            }
            formDataList.addAll(FormDataBuildHelper.getFormData(gicTypeName, new HashMap<String, String>(), 0, configBuilder, ""));
        }
        requestExample.setFormDataList(formDataList);
        String[] paths = apiMethodDoc.getPath().split(";");
        String path = paths[0];
        Map<String, String> formDataToMap = DocUtil.formDataToMap(formDataList);
        if (Methods.POST.getValue().equals(methodType) || Methods.PUT.getValue().equals(methodType)) {
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            formDataToMap.putAll(queryParamsMap);
            String body = UrlUtil.urlJoin((String)"", formDataToMap).replace("?", "");
            body = StringUtil.removeQuotes((String)body);
            url = apiMethodDoc.getServerUrl() + "/" + path;
            url = UrlUtil.simplifyUrl((String)url);
            if (requestExample.isJson()) {
                if (StringUtil.isNotEmpty((String)body)) {
                    url = url + "?" + body;
                }
                curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            } else {
                curlRequest = StringUtil.isNotEmpty((String)body) ? CurlRequest.builder().setBody(body).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url) : CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            }
            requestExample.setExampleBody(exampleBody).setUrl(url);
        } else {
            queryParamsMap.putAll(formDataToMap);
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            url = UrlUtil.urlJoin((String)path, queryParamsMap);
            url = StringUtil.removeQuotes((String)url);
            url = apiMethodDoc.getServerUrl() + "/" + url;
            url = UrlUtil.simplifyUrl((String)url);
            curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
            exampleBody = CurlUtil.toCurl(curlRequest);
            requestExample.setExampleBody(exampleBody).setJsonBody("").setUrl(url);
        }
        return requestExample;
    }

    /*
     * WARNING - void declaration
     */
    private ApiMethodReqParam requestParams(String methodType, DocJavaMethod docJavaMethod, ProjectDocConfigBuilder builder, List<ApiReqParam> configApiReqParams) {
        JavaMethod javaMethod = docJavaMethod.getJavaMethod();
        boolean isGet = "GET".equals(methodType);
        boolean isStrict = builder.getApiConfig().isStrict();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> replacementMap = builder.getReplaceClassMap();
        Map<String, String> paramTagMap = DocUtil.getParamsComments(javaMethod, "param", className);
        Map<String, String> paramsComments = DocUtil.getParamsComments(javaMethod, "param", null);
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        HashMap<String, String> mappingParams = new HashMap<String, String>();
        List methodAnnotations = javaMethod.getAnnotations();
        for (JavaAnnotation annotation : methodAnnotations) {
            Object paramsObjects;
            String annotationName = annotation.getType().getName();
            if (!annotationName.contains("Mapping") || Objects.isNull(paramsObjects = annotation.getNamedParameter("params"))) continue;
            String params = StringUtil.removeQuotes((String)paramsObjects.toString());
            if (!params.startsWith("[")) {
                this.mappingParamToApiParam(paramsObjects.toString(), paramList, mappingParams);
                continue;
            }
            LinkedList headers = (LinkedList)paramsObjects;
            for (String str : headers) {
                this.mappingParamToApiParam(str, paramList, mappingParams);
            }
        }
        Map<String, Map<String, ApiReqParam>> collect = configApiReqParams.stream().collect(Collectors.groupingBy(ApiReqParam::getParamIn, Collectors.toMap(ApiReqParam::getName, m -> m, (k1, k2) -> k1)));
        Map pathReqParamMap = collect.getOrDefault(ApiReqParamInTypeEnum.PATH.getValue(), Collections.emptyMap());
        Map queryReqParamMap = collect.getOrDefault(ApiReqParamInTypeEnum.QUERY.getValue(), Collections.emptyMap());
        List parameterList = javaMethod.getParameters();
        if (parameterList.size() < 1) {
            AtomicInteger querySize = new AtomicInteger(paramList.size() + 1);
            paramList.addAll(queryReqParamMap.values().stream().map(p -> ApiReqParam.convertToApiParam(p).setQueryParam(true).setId(querySize.getAndIncrement())).collect(Collectors.toList()));
            AtomicInteger pathSize = new AtomicInteger(1);
            return ApiMethodReqParam.builder().setPathParams(new ArrayList<ApiParam>(pathReqParamMap.values().stream().map(p -> ApiReqParam.convertToApiParam(p).setPathParam(true).setId(pathSize.getAndIncrement())).collect(Collectors.toList()))).setQueryParams(paramList).setRequestParams(new ArrayList<ApiParam>(0));
        }
        Map<String, String> constantsMap = builder.getConstantsMap();
        boolean requestFieldToUnderline = builder.getApiConfig().isRequestFieldToUnderline();
        Set<String> ignoreSets = this.ignoreParamsSets(javaMethod);
        Map<String, JavaType> actualTypesMap = docJavaMethod.getActualTypesMap();
        int requestBodyCounter = 0;
        for (JavaParameter parameter : parameterList) {
            Map<String, Object> map;
            String[] gicNameArr;
            void var28_34;
            void var28_32;
            String paramName = parameter.getName();
            if (ignoreSets.contains(paramName) || mappingParams.containsKey(paramName)) continue;
            JavaType javaType = parameter.getType();
            if (Objects.nonNull(actualTypesMap) && Objects.nonNull(actualTypesMap.get(javaType.getCanonicalName()))) {
                javaType = actualTypesMap.get(javaType.getCanonicalName());
            }
            String string = javaType.getGenericCanonicalName();
            String simpleName = javaType.getValue().toLowerCase();
            String fullTypeName = javaType.getFullyQualifiedName();
            String simpleTypeName = javaType.getValue();
            String commentClass = paramTagMap.get(paramName);
            String rewriteClassName = this.getRewriteClassName(replacementMap, fullTypeName, commentClass);
            if (DocUtil.isClassName(rewriteClassName)) {
                String string2 = rewriteClassName;
                fullTypeName = DocClassUtil.getSimpleName(rewriteClassName);
            }
            if (JavaClassValidateUtil.isMvcIgnoreParams((String)var28_32, builder.getApiConfig().getIgnoreRequestParams())) continue;
            fullTypeName = DocClassUtil.rewriteRequestParam(fullTypeName);
            String string3 = DocClassUtil.rewriteRequestParam((String)var28_32);
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            String comment = this.paramCommentResolve(paramTagMap.get(paramName));
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            if (JavaClassValidateUtil.isFile(string3)) {
                ApiParam param = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(true).setRequired(true).setVersion("-").setDesc(comment);
                if (string3.contains("[]") || string3.endsWith(">")) {
                    comment = comment + "(array of file)";
                    param.setDesc(comment);
                    param.setHasItems(true);
                }
                paramList.add(param);
                continue;
            }
            String mockValue = this.createMockValue(paramsComments, paramName, string3, simpleTypeName);
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            List annotations = parameter.getAnnotations();
            List<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations);
            String strRequired = "false";
            boolean isPathVariable = false;
            boolean isRequestBody = false;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getValue();
                if ("Param".equals(annotationName) || "PathVar".equals(annotationName)) {
                    AnnotationValue annotationDefaultVal;
                    if ("PathVar".equals(annotationName)) {
                        isPathVariable = true;
                    }
                    if (Objects.nonNull(annotationDefaultVal = annotation.getProperty("defaultValue"))) {
                        mockValue = StringUtil.removeQuotes((String)annotationDefaultVal.toString());
                    }
                    paramName = this.getParamName(paramName, annotation);
                    for (Map.Entry<String, String> entry : constantsMap.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (paramName.contains(key)) {
                            paramName = paramName.replace(key, value);
                        }
                        if (!mockValue.contains(key)) continue;
                        mockValue = mockValue.replace(key, value);
                    }
                    AnnotationValue annotationRequired = annotation.getProperty("required");
                    strRequired = Objects.nonNull(annotationRequired) ? annotationRequired.toString() : "true";
                }
                if (JavaClassValidateUtil.isJSR303Required(annotationName)) {
                    strRequired = "true";
                }
                if (!"Body".equals(annotationName)) continue;
                if (requestBodyCounter > 0) {
                    throw new RuntimeException("You have use @RequestBody Passing multiple variables  for method " + javaMethod.getName() + " in " + className + ",@RequestBody annotation could only bind one variables.");
                }
                if (Objects.nonNull(builder.getApiConfig().getRequestBodyAdvice()) && Objects.isNull(javaMethod.getTagByName("ignoreRequestBodyAdvice"))) {
                    String string4;
                    String requestBodyAdvice = builder.getApiConfig().getRequestBodyAdvice().getClassName();
                    fullTypeName = string4 = requestBodyAdvice + "<" + (String)var28_34 + ">";
                }
                ++requestBodyCounter;
                isRequestBody = true;
            }
            boolean required = Boolean.parseBoolean(strRequired);
            boolean queryParam = false;
            if (!isRequestBody && !isPathVariable && isGet) {
                queryParam = true;
            }
            if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                ApiParam param;
                JavaClass gicJavaClass;
                void var28_37;
                String gicName;
                if (JavaClassValidateUtil.isCollection((String)var28_34)) {
                    String string5 = (String)var28_34 + "<T>";
                }
                if (JavaClassValidateUtil.isArray(gicName = (gicNameArr = DocClassUtil.getSimpleGicName((String)var28_37))[0])) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if ((gicJavaClass = builder.getJavaProjectBuilder().getClassByName(gicName)).isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(gicJavaClass, Boolean.TRUE);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of enum]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setValue(String.valueOf(value));
                    paramList.add(param);
                    if (requestBodyCounter <= 0) continue;
                    Map<String, Object> map2 = OpenApiSchemaUtil.arrayTypeSchema(gicName);
                    docJavaMethod.setRequestSchema(map2);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String shortSimple = DocClassUtil.processTypeNameForParams(gicName);
                    param = ApiParam.of().setField(paramName).setDesc(comment + ",[array of " + shortSimple + "]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setValue(DocUtil.getValByTypeAndFieldName(gicName, paramName));
                    paramList.add(param);
                    if (requestBodyCounter <= 0) continue;
                    Map<String, Object> map2 = OpenApiSchemaUtil.arrayTypeSchema(gicName);
                    docJavaMethod.setRequestSchema(map2);
                    continue;
                }
                if (requestBodyCounter > 0) {
                    paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[0], "", 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.TRUE));
                    continue;
                }
                throw new RuntimeException("Solon MVC can't support binding Collection on method " + javaMethod.getName() + ",Check it in " + javaMethod.getDeclaringClass().getCanonicalName());
            }
            if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                ApiParam param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(mockValue).setDesc(comment).setRequired(required).setVersion("-");
                paramList.add(param);
                if (requestBodyCounter <= 0) continue;
                map = OpenApiSchemaUtil.primaryTypeSchema(simpleName);
                docJavaMethod.setRequestSchema(map);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullTypeName)) {
                log.warning("When using smart-doc, it is not recommended to use Map to receive parameters, Check it in " + javaMethod.getDeclaringClass().getCanonicalName() + "#" + javaMethod.getName());
                if (JavaClassValidateUtil.isMap((String)var28_34)) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    if (requestBodyCounter <= 0) continue;
                    map = OpenApiSchemaUtil.mapTypeSchema("object");
                    docJavaMethod.setRequestSchema(map);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName((String)var28_34);
                if (JavaClassValidateUtil.isPrimitive(gicNameArr[1])) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    if (requestBodyCounter <= 0) continue;
                    Map<String, Object> map3 = OpenApiSchemaUtil.mapTypeSchema(gicNameArr[1]);
                    docJavaMethod.setRequestSchema(map3);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], "", 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE));
                continue;
            }
            if (javaClass.isEnum()) {
                String o = JavaClassUtil.getEnumParams(javaClass);
                Object value = JavaClassUtil.getEnumValue(javaClass, isPathVariable || queryParam);
                ApiParam param = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(String.valueOf(value)).setType("enum").setDesc(StringUtil.removeQuotes((String)o)).setRequired(required).setVersion("-").setEnumValues(JavaClassUtil.getEnumValues(javaClass));
                paramList.add(param);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams((String)var28_34, "", 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE));
        }
        ArrayList<ApiParam> pathParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> queryParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> bodyParams = new ArrayList<ApiParam>();
        for (ApiParam apiParam : paramList) {
            apiParam.setValue(StringUtil.removeDoubleQuotes((String)apiParam.getValue()));
            if (apiParam.isPathParam()) {
                if (pathReqParamMap.containsKey(apiParam.getField())) {
                    apiParam.setConfigParam(true).setValue(((ApiReqParam)pathReqParamMap.get(apiParam.getField())).getValue());
                }
                apiParam.setId(pathParams.size() + 1);
                pathParams.add(apiParam);
                continue;
            }
            if (apiParam.isQueryParam() && isGet) {
                if (queryReqParamMap.containsKey(apiParam.getField())) {
                    apiParam.setConfigParam(true).setValue(((ApiReqParam)queryReqParamMap.get(apiParam.getField())).getValue());
                }
                apiParam.setId(queryParams.size() + 1);
                queryParams.add(apiParam);
                continue;
            }
            apiParam.setId(bodyParams.size() + 1);
            bodyParams.add(apiParam);
        }
        Set queryParamSet = queryParams.stream().map(ApiParam::getField).collect(Collectors.toSet());
        for (Object value : queryReqParamMap.values()) {
            if (queryParamSet.contains(((ApiReqParam)value).getName())) continue;
            ApiParam apiParam = ApiReqParam.convertToApiParam((ApiReqParam)value).setQueryParam(true).setId(queryParams.size());
            queryParams.add(apiParam);
        }
        Set set = pathParams.stream().map(ApiParam::getField).collect(Collectors.toSet());
        for (ApiReqParam value : pathReqParamMap.values()) {
            if (set.contains(value.getName())) continue;
            ApiParam apiParam = ApiReqParam.convertToApiParam(value).setPathParam(true).setId(pathParams.size());
            pathParams.add(apiParam);
        }
        ApiMethodReqParam apiMethodReqParam = ApiMethodReqParam.builder().setRequestParams(bodyParams).setPathParams(pathParams).setQueryParams(queryParams);
        return apiMethodReqParam;
    }

    private String getParamName(String paramName, JavaAnnotation annotation) {
        AnnotationValue annotationOfName;
        AnnotationValue annotationValue = annotation.getProperty("value");
        if (Objects.nonNull(annotationValue)) {
            paramName = StringUtil.removeQuotes((String)annotationValue.toString());
        }
        if (Objects.nonNull(annotationOfName = annotation.getProperty("name"))) {
            paramName = StringUtil.removeQuotes((String)annotationOfName.toString());
        }
        return paramName;
    }

    private boolean checkController(JavaClass cls) {
        if (cls.isAnnotation() || cls.isEnum()) {
            return false;
        }
        JavaClass superClass = cls.getSuperJavaClass();
        ArrayList classAnnotations = new ArrayList();
        if (Objects.nonNull(superClass)) {
            classAnnotations.addAll(superClass.getAnnotations());
        }
        classAnnotations.addAll(cls.getAnnotations());
        for (JavaAnnotation annotation : classAnnotations) {
            String name = annotation.getType().getValue();
            if (!"Controller".equals(name)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"restApi".equals(value)) continue;
            return true;
        }
        return false;
    }

    private String getRewriteClassName(Map<String, String> replacementMap, String fullTypeName, String commentClass) {
        String[] comments;
        String rewriteClassName;
        if (Objects.nonNull(commentClass) && !"No comments found.".equals(commentClass) && DocUtil.isClassName(rewriteClassName = (comments = commentClass.split("\\|"))[comments.length - 1])) {
            return rewriteClassName;
        }
        return replacementMap.get(fullTypeName);
    }

    private String createMockValue(Map<String, String> paramsComments, String paramName, String typeName, String simpleTypeName) {
        String mockValue = "";
        if (JavaClassValidateUtil.isPrimitive(typeName) && StringUtil.isEmpty((String)(mockValue = Objects.nonNull(mockValue = paramsComments.get(paramName)) && mockValue.contains("|") ? mockValue.substring(mockValue.lastIndexOf("|") + 1) : ""))) {
            mockValue = DocUtil.getValByTypeAndFieldName(simpleTypeName, paramName, Boolean.TRUE);
        }
        return mockValue;
    }

    private void mappingParamProcess(String str, Map<String, String> pathParamsMap) {
        String param = StringUtil.removeQuotes((String)str);
        if (param.contains("=")) {
            int index = param.indexOf("=");
            String paramName = param.substring(0, index);
            String paramValue = param.substring(index + 1);
            pathParamsMap.put(paramName, paramValue);
        } else {
            String paramName = param;
            pathParamsMap.put(paramName, DocUtil.getValByTypeAndFieldName("string", paramName, Boolean.TRUE));
        }
    }

    private void mappingParamToApiParam(String str, List<ApiParam> paramList, Map<String, String> mappingParams) {
        String paramValue;
        String paramName;
        String param = StringUtil.removeQuotes((String)str);
        if (param.contains("=")) {
            int index = param.indexOf("=");
            paramName = param.substring(0, index);
            paramValue = param.substring(index + 1);
        } else {
            paramName = param;
            paramValue = DocUtil.getValByTypeAndFieldName("string", paramName, Boolean.TRUE);
        }
        String type = ValidateUtil.isPositiveInteger((String)paramValue) ? "int32" : "string";
        ApiParam apiParam = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setQueryParam(true).setValue(paramValue).setType(type).setDesc("parameter condition").setRequired(true).setVersion("-");
        paramList.add(apiParam);
        mappingParams.put(paramName, null);
    }

    private List<JavaAnnotation> getAnnotations(JavaClass cls) {
        ArrayList<JavaAnnotation> annotationsList = new ArrayList<JavaAnnotation>();
        annotationsList.addAll(cls.getAnnotations());
        boolean flag = annotationsList.stream().anyMatch(item -> {
            String annotationName = item.getType().getValue();
            return "RequestMapping".equals(annotationName) || "org.noear.solon.annotation.Mapping".equals(annotationName);
        });
        if (flag) {
            return annotationsList;
        }
        JavaClass superJavaClass = cls.getSuperJavaClass();
        if (Objects.nonNull(superJavaClass) && !"Object".equals(superJavaClass.getSimpleName())) {
            annotationsList.addAll(this.getAnnotations(superJavaClass));
        }
        return annotationsList;
    }
}

