/*
 * Decompiled with CFR 0.152.
 */
package com.github.sett4.dataformat.xlsx.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class XlsxWriter {
    Logger log = Logger.getLogger(XlsxWriter.class.getCanonicalName());
    private final OutputStream out;
    private final SXSSFWorkbook workbook;
    private final Sheet sheet;
    private Row row = null;
    private int rowIndex = -1;
    private int _nextColumnToWrite = 0;

    public XlsxWriter(OutputStream out) {
        this.out = out;
        this.workbook = new SXSSFWorkbook();
        this.sheet = this.workbook.createSheet();
    }

    public Row getRow() {
        if (this.row == null) {
            ++this.rowIndex;
            this.row = this.sheet.createRow(this.rowIndex);
            this._nextColumnToWrite = 0;
        }
        return this.row;
    }

    public void write(int columnIndex, String text) {
        this.createCell(columnIndex, CellType.STRING).setCellValue(text);
    }

    public void write(int columnIndex, boolean state) {
        this.createCell(columnIndex, CellType.BOOLEAN).setCellValue(state);
    }

    public void endRow() {
        this.row = null;
        this._nextColumnToWrite = 0;
    }

    public void close() throws IOException {
        this.workbook.write(this.out);
    }

    public void writeColumnName(String name, int index) {
        this.getRow().createCell(index).setCellValue(name);
    }

    public void writeNull(int columnIndex) {
        if (columnIndex == this._nextColumnToWrite) {
            ++this._nextColumnToWrite;
        }
    }

    public void write(int columnIndex, float v) {
        this.createCell(columnIndex, CellType.NUMERIC).setCellValue((double)v);
    }

    public void write(int columnIndex, double v) {
        this.createCell(columnIndex, CellType.NUMERIC).setCellValue(v);
    }

    public void write(int columnIndex, int v) {
        this.createCell(columnIndex, CellType.NUMERIC).setCellValue((double)v);
    }

    public void write(int columnIndex, long v) {
        this.createCell(columnIndex, CellType.NUMERIC).setCellValue((double)v);
    }

    public Object getOutputTarget() {
        return this.out;
    }

    private Cell createCell(int columnIndex, CellType type) {
        Cell cell = this.getRow().createCell(columnIndex, type);
        if (columnIndex == this._nextColumnToWrite) {
            ++this._nextColumnToWrite;
        }
        return cell;
    }

    public int nextColumnIndex() {
        return this._nextColumnToWrite;
    }
}

