/*
 * Decompiled with CFR 0.152.
 */
package com.github.sett4.dataformat.xlsx;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.github.sett4.dataformat.xlsx.XlsxFactory;
import java.util.Collection;

public class XlsxMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    protected final LRUMap<JavaType, CsvSchema> _untypedSchemas;
    protected final LRUMap<JavaType, CsvSchema> _typedSchemas;

    public static Builder builder() {
        return new Builder(new XlsxMapper());
    }

    public static Builder builder(XlsxFactory xlsxFactory) {
        return new Builder(new XlsxMapper(xlsxFactory));
    }

    public XlsxMapper() {
        this(new XlsxFactory());
    }

    public XlsxMapper(XlsxFactory f) {
        super((JsonFactory)f);
        this.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
        this._untypedSchemas = new LRUMap(8, 32);
        this._typedSchemas = new LRUMap(8, 32);
    }

    protected XlsxMapper(XlsxMapper src) {
        super((ObjectMapper)src);
        this._untypedSchemas = new LRUMap(8, 32);
        this._typedSchemas = new LRUMap(8, 32);
    }

    public XlsxMapper copy() {
        this._checkInvalidCopy(XlsxMapper.class);
        return new XlsxMapper(this);
    }

    public XlsxMapper configure(JsonGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public XlsxMapper enable(JsonGenerator.Feature f) {
        this._jsonFactory.enable(f);
        return this;
    }

    public XlsxMapper disable(JsonGenerator.Feature f) {
        this._jsonFactory.disable(f);
        return this;
    }

    public XlsxFactory getFactory() {
        return (XlsxFactory)this._jsonFactory;
    }

    public ObjectReader readerWithSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.readerFor(type).with((FormatSchema)this.schemaFor(type));
    }

    public ObjectReader readerWithTypedSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.readerFor(type).with((FormatSchema)this.typedSchemaFor(type));
    }

    public ObjectWriter writerWithSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.writerFor(type).with((FormatSchema)this.schemaFor(type));
    }

    public ObjectWriter writerWithTypedSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.writerFor(type).with((FormatSchema)this.typedSchemaFor(type));
    }

    public CsvSchema schemaWithHeader() {
        return CsvSchema.emptySchema().withHeader();
    }

    public CsvSchema schema() {
        return CsvSchema.emptySchema();
    }

    public CsvSchema schemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._untypedSchemas, false);
    }

    public final CsvSchema schemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._untypedSchemas, false);
    }

    public final CsvSchema schemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._untypedSchemas, false);
    }

    public CsvSchema typedSchemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._typedSchemas, true);
    }

    public final CsvSchema typedSchemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._typedSchemas, true);
    }

    public final CsvSchema typedSchemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._typedSchemas, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CsvSchema _schemaFor(JavaType pojoType, LRUMap<JavaType, CsvSchema> schemas, boolean typed) {
        LRUMap<JavaType, CsvSchema> lRUMap = schemas;
        synchronized (lRUMap) {
            CsvSchema s = (CsvSchema)schemas.get((Object)pojoType);
            if (s != null) {
                return s;
            }
        }
        AnnotationIntrospector intr = this._deserializationConfig.getAnnotationIntrospector();
        CsvSchema.Builder builder = CsvSchema.builder();
        this._addSchemaProperties(builder, intr, typed, pojoType, null);
        CsvSchema result = builder.build();
        LRUMap<JavaType, CsvSchema> lRUMap2 = schemas;
        synchronized (lRUMap2) {
            schemas.put((Object)pojoType, (Object)result);
        }
        return result;
    }

    protected boolean _nonPojoType(JavaType t) {
        if (t.isPrimitive() || t.isEnumType()) {
            return true;
        }
        Class raw = t.getRawClass();
        if (Number.class.isAssignableFrom(raw) && (raw == Byte.class || raw == Short.class || raw == Character.class || raw == Integer.class || raw == Long.class || raw == Float.class || raw == Double.class)) {
            return true;
        }
        return raw == Boolean.class || raw == String.class;
    }

    protected void _addSchemaProperties(CsvSchema.Builder builder, AnnotationIntrospector intr, boolean typed, JavaType pojoType, NameTransformer unwrapper) {
        if (this._nonPojoType(pojoType)) {
            return;
        }
        BeanDescription beanDesc = this.getSerializationConfig().introspect(pojoType);
        for (BeanPropertyDefinition prop : beanDesc.findProperties()) {
            NameTransformer nextUnwrapper;
            if (!prop.couldSerialize()) continue;
            AnnotatedMember m = prop.getPrimaryMember();
            if (m != null && (nextUnwrapper = intr.findUnwrappingNameTransformer(prop.getPrimaryMember())) != null) {
                if (unwrapper != null) {
                    nextUnwrapper = NameTransformer.chainedTransformer((NameTransformer)unwrapper, (NameTransformer)nextUnwrapper);
                }
                JavaType nextType = m.getType();
                this._addSchemaProperties(builder, intr, typed, nextType, nextUnwrapper);
                continue;
            }
            String name = prop.getName();
            if (unwrapper != null) {
                name = unwrapper.transform(name);
            }
            if (typed && m != null) {
                builder.addColumn(name, this._determineType(m.getRawType()));
                continue;
            }
            builder.addColumn(name);
        }
    }

    protected CsvSchema.ColumnType _determineType(Class<?> propType) {
        if (propType.isArray()) {
            if (propType == byte[].class) {
                return CsvSchema.ColumnType.STRING;
            }
            return CsvSchema.ColumnType.ARRAY;
        }
        if (propType == String.class || propType == Character.TYPE || propType == Character.class) {
            return CsvSchema.ColumnType.STRING;
        }
        if (propType == Boolean.class || propType == Boolean.TYPE) {
            return CsvSchema.ColumnType.BOOLEAN;
        }
        if (propType.isPrimitive()) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (Number.class.isAssignableFrom(propType)) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (Collection.class.isAssignableFrom(propType)) {
            return CsvSchema.ColumnType.ARRAY;
        }
        return CsvSchema.ColumnType.NUMBER_OR_STRING;
    }

    public static class Builder
    extends MapperBuilder<XlsxMapper, Builder> {
        public Builder(XlsxMapper m) {
            super((ObjectMapper)m);
        }

        public Builder configure(JsonReadFeature f, boolean state) {
            if (state) {
                ((XlsxMapper)this._mapper).enable(new JsonParser.Feature[]{f.mappedFeature()});
            } else {
                ((XlsxMapper)this._mapper).disable(new JsonParser.Feature[]{f.mappedFeature()});
            }
            return this;
        }

        public Builder enable(JsonGenerator.Feature ... features) {
            for (JsonGenerator.Feature f : features) {
                ((XlsxMapper)this._mapper).enable(f);
            }
            return this;
        }

        public Builder disable(JsonGenerator.Feature ... features) {
            for (JsonGenerator.Feature f : features) {
                ((XlsxMapper)this._mapper).disable(f);
            }
            return this;
        }

        public Builder configure(JsonGenerator.Feature f, boolean state) {
            if (state) {
                ((XlsxMapper)this._mapper).enable(f);
            } else {
                ((XlsxMapper)this._mapper).disable(f);
            }
            return this;
        }
    }
}

