/*
 * Decompiled with CFR 0.152.
 */
package com.yuyenews.easy.netty.server;

import com.yuyenews.easy.netty.thread.RequestThread;
import com.yuyenews.easy.netty.thread.ThreadPool;
import com.yuyenews.easy.server.request.HttpResponse;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyServerHandler
extends ChannelHandlerAdapter {
    private Logger log = LoggerFactory.getLogger(EasyServerHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest httpRequest = null;
        HttpResponse response = new HttpResponse(ctx);
        try {
            if (msg instanceof FullHttpRequest) {
                httpRequest = (FullHttpRequest)msg;
                RequestThread requestThread = new RequestThread();
                requestThread.setHttpRequest(httpRequest);
                requestThread.setCtx(ctx);
                ThreadPool.execute(requestThread);
            } else {
                response.send("\u672a\u77e5\u8bf7\u6c42!", HttpResponseStatus.BAD_REQUEST);
            }
        }
        catch (Exception e) {
            this.log.error("\u5904\u7406\u8bf7\u6c42\u5931\u8d25!", (Throwable)e);
            try {
                httpRequest.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.writeAndFlush((Object)("\u5ba2\u6237\u7aef" + InetAddress.getLocalHost().getHostName() + "\u6210\u529f\u4e0e\u670d\u52a1\u7aef\u5efa\u7acb\u8fde\u63a5\uff01 "));
        super.channelActive(ctx);
    }
}

