/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.taskun.scheduler;

import com.github.seratch.taskun.scheduler.config.TaskunConfig;
import com.github.seratch.taskun.util.StringUtil;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;

public final class CurrentServer {
    public static boolean isWorkingOnNamedServerHost(TaskunConfig config, String name) {
        String expected = config.getNamedServerHostname(name);
        if (StringUtil.isEmpty(expected)) {
            return false;
        }
        return CurrentServer.getHostname().matches(expected);
    }

    public static String getServerName(TaskunConfig config) {
        if (config != null) {
            Map<String, String> servers = config.namedServers;
            Set<String> names = servers.keySet();
            for (String name : names) {
                if (!CurrentServer.getHostname().matches(servers.get(name))) continue;
                return name;
            }
        }
        return CurrentServer.getHostname();
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            return "localhost";
        }
    }
}

