/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.common.json;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class UnknownPropertyDetectionAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        if (delegate instanceof ReflectiveTypeAdapterFactory.Adapter) {
            try {
                Field f = delegate.getClass().getDeclaredField("boundFields");
                f.setAccessible(true);
                Map boundFields = (Map)f.get(delegate);
                StringBuilder sb = new StringBuilder();
                for (Object key : boundFields.keySet()) {
                    sb.append(key + ", ");
                }
                final String boundFieldsStr = sb.append("...").toString();
                boundFields = new LinkedHashMap(boundFields){

                    @Override
                    public Object get(Object key) {
                        Object value = super.get(key);
                        if (value == null) {
                            throw new JsonParseException("Unknown property detected: " + key + " in " + boundFieldsStr);
                        }
                        return value;
                    }
                };
                f.set(delegate, boundFields);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return delegate;
    }
}

