/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.shortcut.impl;

import com.github.seratch.jslack.Slack;
import com.github.seratch.jslack.api.methods.SlackApiException;
import com.github.seratch.jslack.api.methods.request.chat.ChatPostMessageRequest;
import com.github.seratch.jslack.api.methods.request.conversations.ConversationsHistoryRequest;
import com.github.seratch.jslack.api.methods.request.conversations.ConversationsListRequest;
import com.github.seratch.jslack.api.methods.request.reactions.ReactionsAddRequest;
import com.github.seratch.jslack.api.methods.request.search.SearchAllRequest;
import com.github.seratch.jslack.api.methods.response.chat.ChatPostMessageResponse;
import com.github.seratch.jslack.api.methods.response.conversations.ConversationsHistoryResponse;
import com.github.seratch.jslack.api.methods.response.conversations.ConversationsListResponse;
import com.github.seratch.jslack.api.methods.response.reactions.ReactionsAddResponse;
import com.github.seratch.jslack.api.methods.response.search.SearchAllResponse;
import com.github.seratch.jslack.api.model.Attachment;
import com.github.seratch.jslack.api.model.Conversation;
import com.github.seratch.jslack.api.model.Message;
import com.github.seratch.jslack.api.model.ResponseMetadata;
import com.github.seratch.jslack.api.model.block.LayoutBlock;
import com.github.seratch.jslack.shortcut.Shortcut;
import com.github.seratch.jslack.shortcut.model.ApiToken;
import com.github.seratch.jslack.shortcut.model.ChannelId;
import com.github.seratch.jslack.shortcut.model.ChannelName;
import com.github.seratch.jslack.shortcut.model.ReactionName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ShortcutImpl
implements Shortcut {
    private final Optional<ApiToken> apiToken;
    private final Slack slack;
    private List<Conversation> channels = new ArrayList<Conversation>();

    public Slack getSlack() {
        return this.slack;
    }

    public ShortcutImpl(Slack slack) {
        this.apiToken = Optional.empty();
        this.slack = slack;
    }

    public ShortcutImpl(Slack slack, ApiToken apiToken) {
        this.apiToken = Optional.ofNullable(apiToken);
        this.slack = slack;
    }

    @Override
    public Optional<ChannelId> findChannelIdByName(ChannelName name) throws IOException, SlackApiException {
        if (this.channels.isEmpty()) {
            this.updateChannelsCache();
        }
        return this.channels.stream().filter(c -> c.getName().equals(name.getValue())).findFirst().map(c -> new ChannelId(c.getId()));
    }

    @Override
    public Optional<ChannelName> findChannelNameById(ChannelId channelId) {
        return this.channels.stream().filter(c -> c.getId().equals(channelId.getValue())).findFirst().map(c -> new ChannelName(c.getName()));
    }

    @Override
    public List<Message> findRecentMessagesByName(ChannelName name) throws IOException, SlackApiException {
        return this.findRecentMessagesByName(name, 1000);
    }

    @Override
    public List<Message> findRecentMessagesByName(ChannelName name, int limit) throws IOException, SlackApiException {
        Optional<ChannelId> maybeChannelId = this.findChannelIdByName(name);
        if (maybeChannelId.isPresent()) {
            ChannelId channelId = maybeChannelId.get();
            ConversationsHistoryResponse response = this.slack.methods().conversationsHistory(ConversationsHistoryRequest.builder().token(this.apiToken.get().getValue()).channel(channelId.getValue()).limit(limit).build());
            if (response.isOk()) {
                response.getMessages().forEach(message -> {
                    if (message.getChannel() == null) {
                        message.setChannel(channelId.getValue());
                    }
                });
                return response.getMessages();
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public ReactionsAddResponse addReaction(Message message, ReactionName reactionName) throws IOException, SlackApiException {
        if (this.apiToken.isPresent()) {
            return this.slack.methods().reactionsAdd(ReactionsAddRequest.builder().token(this.apiToken.get().getValue()).channel(message.getChannel()).timestamp(message.getTs()).name(reactionName.getValue()).build());
        }
        throw new IllegalStateException("apiToken is absent.");
    }

    @Override
    public SearchAllResponse search(String query) throws IOException, SlackApiException {
        if (this.apiToken.isPresent()) {
            return this.slack.methods().searchAll(SearchAllRequest.builder().token(this.apiToken.get().getValue()).query(query).count(100).build());
        }
        throw new IllegalStateException("apiToken is absent.");
    }

    @Override
    public ChatPostMessageResponse post(ChannelName channel, String text) throws IOException, SlackApiException {
        return this._post(channel, text, Collections.emptyList(), true);
    }

    @Override
    public ChatPostMessageResponse postAsBot(ChannelName channel, String text) throws IOException, SlackApiException {
        return this._post(channel, text, Collections.emptyList(), false);
    }

    @Override
    public ChatPostMessageResponse post(ChannelName channel, String text, List<Attachment> attachments) throws IOException, SlackApiException {
        return this._post(channel, text, attachments, true);
    }

    @Override
    public ChatPostMessageResponse postAsBot(ChannelName channel, String text, List<Attachment> attachments) throws IOException, SlackApiException {
        return this._post(channel, text, attachments, false);
    }

    @Override
    public ChatPostMessageResponse post(ChannelName channel, List<LayoutBlock> blocks) throws IOException, SlackApiException {
        return this._post(channel, blocks, true);
    }

    @Override
    public ChatPostMessageResponse postAsBot(ChannelName channel, List<LayoutBlock> blocks) throws IOException, SlackApiException {
        return this._post(channel, blocks, false);
    }

    private ChatPostMessageResponse _post(ChannelName channel, String text, List<Attachment> attachments, boolean asUser) throws IOException, SlackApiException {
        if (this.apiToken.isPresent()) {
            Optional<ChannelId> channelId = this.findChannelIdByName(channel);
            if (channelId.isPresent()) {
                return this.slack.methods().chatPostMessage(ChatPostMessageRequest.builder().token(this.apiToken.get().getValue()).asUser(asUser).channel(channelId.get().getValue()).text(text).attachments(attachments).build());
            }
            throw new IllegalStateException("Unknown channel: " + channel.getValue());
        }
        throw new IllegalStateException("apiToken is absent.");
    }

    private ChatPostMessageResponse _post(ChannelName channel, List<LayoutBlock> blocks, boolean asUser) throws IOException, SlackApiException {
        if (this.apiToken.isPresent()) {
            Optional<ChannelId> channelId = this.findChannelIdByName(channel);
            if (channelId.isPresent()) {
                return this.slack.methods().chatPostMessage(ChatPostMessageRequest.builder().token(this.apiToken.get().getValue()).asUser(asUser).channel(channelId.get().getValue()).blocks(blocks).build());
            }
            throw new IllegalStateException("Unknown channel: " + channel.getValue());
        }
        throw new IllegalStateException("apiToken is absent.");
    }

    @Override
    public void updateChannelsCache() throws IOException, SlackApiException {
        if (this.apiToken.isPresent()) {
            if (this.channels.isEmpty()) {
                String cursor = null;
                do {
                    ConversationsListResponse response;
                    if ((response = this.slack.methods().conversationsList(ConversationsListRequest.builder().token(this.apiToken.get().getValue()).cursor(cursor).build())).isOk()) {
                        this.channels.addAll(response.getChannels());
                        cursor = Optional.ofNullable(response.getResponseMetadata()).map(ResponseMetadata::getNextCursor).orElse(null);
                        continue;
                    }
                    cursor = null;
                } while (cursor != null && !cursor.isEmpty());
            }
        } else {
            throw new IllegalStateException("apiToken is absent.");
        }
    }
}

