/*
 * Decompiled with CFR 0.152.
 */
package com.github.seratch.jslack.api.scim.impl;

import com.github.seratch.jslack.api.RequestConfigurator;
import com.github.seratch.jslack.api.scim.SCIMApiException;
import com.github.seratch.jslack.api.scim.SCIMApiRequest;
import com.github.seratch.jslack.api.scim.SCIMClient;
import com.github.seratch.jslack.api.scim.request.GroupsCreateRequest;
import com.github.seratch.jslack.api.scim.request.GroupsDeleteRequest;
import com.github.seratch.jslack.api.scim.request.GroupsPatchRequest;
import com.github.seratch.jslack.api.scim.request.GroupsReadRequest;
import com.github.seratch.jslack.api.scim.request.GroupsSearchRequest;
import com.github.seratch.jslack.api.scim.request.GroupsUpdateRequest;
import com.github.seratch.jslack.api.scim.request.ServiceProviderConfigsGetRequest;
import com.github.seratch.jslack.api.scim.request.UsersCreateRequest;
import com.github.seratch.jslack.api.scim.request.UsersDeleteRequest;
import com.github.seratch.jslack.api.scim.request.UsersPatchRequest;
import com.github.seratch.jslack.api.scim.request.UsersReadRequest;
import com.github.seratch.jslack.api.scim.request.UsersSearchRequest;
import com.github.seratch.jslack.api.scim.request.UsersUpdateRequest;
import com.github.seratch.jslack.api.scim.response.GroupsCreateResponse;
import com.github.seratch.jslack.api.scim.response.GroupsDeleteResponse;
import com.github.seratch.jslack.api.scim.response.GroupsPatchResponse;
import com.github.seratch.jslack.api.scim.response.GroupsReadResponse;
import com.github.seratch.jslack.api.scim.response.GroupsSearchResponse;
import com.github.seratch.jslack.api.scim.response.GroupsUpdateResponse;
import com.github.seratch.jslack.api.scim.response.ServiceProviderConfigsGetResponse;
import com.github.seratch.jslack.api.scim.response.UsersCreateResponse;
import com.github.seratch.jslack.api.scim.response.UsersDeleteResponse;
import com.github.seratch.jslack.api.scim.response.UsersPatchResponse;
import com.github.seratch.jslack.api.scim.response.UsersReadResponse;
import com.github.seratch.jslack.api.scim.response.UsersSearchResponse;
import com.github.seratch.jslack.api.scim.response.UsersUpdateResponse;
import com.github.seratch.jslack.common.http.SlackHttpClient;
import com.github.seratch.jslack.common.json.GsonFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Request;
import okhttp3.Response;

public class SCIMClientImpl
implements SCIMClient {
    private String endpointUrlPrefix = "https://api.slack.com/scim/v1/";
    private final SlackHttpClient slackHttpClient;
    private final String token;

    public SCIMClientImpl(SlackHttpClient slackHttpClient) {
        this(slackHttpClient, null);
    }

    public SCIMClientImpl(SlackHttpClient slackHttpClient, String token) {
        this.slackHttpClient = slackHttpClient;
        this.token = token;
    }

    @Override
    public String getEndpointUrlPrefix() {
        return this.endpointUrlPrefix;
    }

    @Override
    public void setEndpointUrlPrefix(String endpointUrlPrefix) {
        this.endpointUrlPrefix = endpointUrlPrefix;
    }

    @Override
    public ServiceProviderConfigsGetResponse getServiceProviderConfigs(ServiceProviderConfigsGetRequest req) throws IOException, SCIMApiException {
        return this.doGet(this.endpointUrlPrefix + "ServiceProviderConfigs", null, this.getToken(req), ServiceProviderConfigsGetResponse.class);
    }

    @Override
    public ServiceProviderConfigsGetResponse getServiceProviderConfigs(RequestConfigurator<ServiceProviderConfigsGetRequest.ServiceProviderConfigsGetRequestBuilder> req) throws IOException, SCIMApiException {
        return this.getServiceProviderConfigs(req.configure(ServiceProviderConfigsGetRequest.builder()).build());
    }

    @Override
    public UsersSearchResponse searchUsers(UsersSearchRequest req) throws IOException, SCIMApiException {
        HashMap<String, String> query = new HashMap<String, String>();
        if (req.getFilter() != null) {
            query.put("filter", req.getFilter());
        }
        if (req.getCount() != null) {
            query.put("count", String.valueOf(req.getCount()));
        }
        if (req.getStartIndex() != null) {
            query.put("startIndex", String.valueOf(req.getStartIndex()));
        }
        return this.doGet(this.getUsersResourceURL(), query, this.getToken(req), UsersSearchResponse.class);
    }

    @Override
    public UsersSearchResponse searchUsers(RequestConfigurator<UsersSearchRequest.UsersSearchRequestBuilder> req) throws IOException, SCIMApiException {
        return this.searchUsers(req.configure(UsersSearchRequest.builder()).build());
    }

    @Override
    public UsersReadResponse readUser(UsersReadRequest req) throws IOException, SCIMApiException {
        return this.doGet(this.getUsersResourceURL() + "/" + req.getId(), null, this.getToken(req), UsersReadResponse.class);
    }

    @Override
    public UsersReadResponse readUser(RequestConfigurator<UsersReadRequest.UsersReadRequestBuilder> req) throws IOException, SCIMApiException {
        return this.readUser(req.configure(UsersReadRequest.builder()).build());
    }

    @Override
    public UsersCreateResponse createUser(UsersCreateRequest req) throws IOException, SCIMApiException {
        return this.doPost(this.getUsersResourceURL(), req.getUser(), this.getToken(req), UsersCreateResponse.class);
    }

    @Override
    public UsersCreateResponse createUser(RequestConfigurator<UsersCreateRequest.UsersCreateRequestBuilder> req) throws IOException, SCIMApiException {
        return this.createUser(req.configure(UsersCreateRequest.builder()).build());
    }

    @Override
    public UsersPatchResponse patchUser(UsersPatchRequest req) throws IOException, SCIMApiException {
        return this.doPatch(this.getUsersResourceURL() + "/" + req.getId(), req.getUser(), this.getToken(req), UsersPatchResponse.class);
    }

    @Override
    public UsersPatchResponse patchUser(RequestConfigurator<UsersPatchRequest.UsersPatchRequestBuilder> req) throws IOException, SCIMApiException {
        return this.patchUser(req.configure(UsersPatchRequest.builder()).build());
    }

    @Override
    public UsersUpdateResponse updateUser(UsersUpdateRequest req) throws IOException, SCIMApiException {
        return this.doPut(this.getUsersResourceURL() + "/" + req.getId(), req.getUser(), this.getToken(req), UsersUpdateResponse.class);
    }

    @Override
    public UsersUpdateResponse updateUser(RequestConfigurator<UsersUpdateRequest.UsersUpdateRequestBuilder> req) throws IOException, SCIMApiException {
        return this.updateUser(req.configure(UsersUpdateRequest.builder()).build());
    }

    @Override
    public UsersDeleteResponse deleteUser(UsersDeleteRequest req) throws IOException, SCIMApiException {
        Request.Builder requestBuilder = this.withAuthorizationHeader(new Request.Builder(), this.getToken(req)).url(this.getUsersResourceURL() + "/" + req.getId());
        return this.doDelete(requestBuilder, UsersDeleteResponse.class);
    }

    @Override
    public UsersDeleteResponse deleteUser(RequestConfigurator<UsersDeleteRequest.UsersDeleteRequestBuilder> req) throws IOException, SCIMApiException {
        return this.deleteUser(req.configure(UsersDeleteRequest.builder()).build());
    }

    @Override
    @Deprecated
    public UsersDeleteResponse delete(UsersDeleteRequest req) throws IOException, SCIMApiException {
        return this.deleteUser(req);
    }

    @Override
    @Deprecated
    public UsersDeleteResponse delete(RequestConfigurator<UsersDeleteRequest.UsersDeleteRequestBuilder> req) throws IOException, SCIMApiException {
        return this.deleteUser(req);
    }

    @Override
    public GroupsSearchResponse searchGroups(GroupsSearchRequest req) throws IOException, SCIMApiException {
        HashMap<String, String> query = new HashMap<String, String>();
        if (req.getFilter() != null) {
            query.put("filter", req.getFilter());
        }
        if (req.getCount() != null) {
            query.put("count", String.valueOf(req.getCount()));
        }
        if (req.getStartIndex() != null) {
            query.put("startIndex", String.valueOf(req.getStartIndex()));
        }
        return this.doGet(this.getGroupsResourceURL(), query, this.getToken(req), GroupsSearchResponse.class);
    }

    @Override
    public GroupsSearchResponse searchGroups(RequestConfigurator<GroupsSearchRequest.GroupsSearchRequestBuilder> req) throws IOException, SCIMApiException {
        return this.searchGroups(req.configure(GroupsSearchRequest.builder()).build());
    }

    @Override
    public GroupsReadResponse readGroup(GroupsReadRequest req) throws IOException, SCIMApiException {
        return this.doGet(this.getGroupsResourceURL() + "/" + req.getId(), null, this.getToken(req), GroupsReadResponse.class);
    }

    @Override
    public GroupsReadResponse readGroup(RequestConfigurator<GroupsReadRequest.GroupsReadRequestBuilder> req) throws IOException, SCIMApiException {
        return this.readGroup(req.configure(GroupsReadRequest.builder()).build());
    }

    @Override
    public GroupsCreateResponse createGroup(GroupsCreateRequest req) throws IOException, SCIMApiException {
        return this.doPost(this.getGroupsResourceURL(), req.getGroup(), this.getToken(req), GroupsCreateResponse.class);
    }

    @Override
    public GroupsCreateResponse createGroup(RequestConfigurator<GroupsCreateRequest.GroupsCreateRequestBuilder> req) throws IOException, SCIMApiException {
        return this.createGroup(req.configure(GroupsCreateRequest.builder()).build());
    }

    @Override
    public GroupsPatchResponse patchGroup(GroupsPatchRequest req) throws IOException, SCIMApiException {
        return this.doPatch(this.getGroupsResourceURL() + "/" + req.getId(), req.getGroup(), this.getToken(req), GroupsPatchResponse.class);
    }

    @Override
    public GroupsPatchResponse patchGroup(RequestConfigurator<GroupsPatchRequest.GroupsPatchRequestBuilder> req) throws IOException, SCIMApiException {
        return this.patchGroup(req.configure(GroupsPatchRequest.builder()).build());
    }

    @Override
    public GroupsUpdateResponse updateGroup(GroupsUpdateRequest req) throws IOException, SCIMApiException {
        return this.doPut(this.getGroupsResourceURL() + "/" + req.getId(), req.getGroup(), this.getToken(req), GroupsUpdateResponse.class);
    }

    @Override
    public GroupsUpdateResponse updateGroup(RequestConfigurator<GroupsUpdateRequest.GroupsUpdateRequestBuilder> req) throws IOException, SCIMApiException {
        return this.updateGroup(req.configure(GroupsUpdateRequest.builder()).build());
    }

    @Override
    public GroupsDeleteResponse deleteGroup(GroupsDeleteRequest req) throws IOException, SCIMApiException {
        Request.Builder requestBuilder = this.withAuthorizationHeader(new Request.Builder(), this.getToken(req)).url(this.getGroupsResourceURL() + "/" + req.getId());
        return this.doDelete(requestBuilder, GroupsDeleteResponse.class);
    }

    @Override
    public GroupsDeleteResponse deleteGroup(RequestConfigurator<GroupsDeleteRequest.GroupsDeleteRequestBuilder> req) throws IOException, SCIMApiException {
        return this.deleteGroup(req.configure(GroupsDeleteRequest.builder()).build());
    }

    private String getToken(SCIMApiRequest req) {
        if (req.getToken() != null) {
            return req.getToken();
        }
        if (this.token != null) {
            return this.token;
        }
        throw new IllegalStateException("Slack OAuth token is missing! Set token in either SCIMClient or request object.");
    }

    private Request.Builder withAuthorizationHeader(Request.Builder req, String token) {
        return req.addHeader("Authorization", "Bearer " + token);
    }

    private String getUsersResourceURL() {
        return this.endpointUrlPrefix + "Users";
    }

    private String getGroupsResourceURL() {
        return this.endpointUrlPrefix + "Groups";
    }

    private <T> T doGet(String url, Map<String, String> query, String token, Class<T> clazz) throws IOException, SCIMApiException {
        Response response = this.slackHttpClient.get(url, query, token);
        return this.parseCamelCaseJsonResponseAndRunListeners(response, clazz);
    }

    private <T> T doPost(String url, Object body, String token, Class<T> clazz) throws IOException, SCIMApiException {
        Response response = this.slackHttpClient.postCamelCaseJsonBodyWithBearerHeader(url, token, body);
        return this.parseCamelCaseJsonResponseAndRunListeners(response, clazz);
    }

    private <T> T doPatch(String url, Object body, String token, Class<T> clazz) throws IOException, SCIMApiException {
        Response response = this.slackHttpClient.patchCamelCaseJsonBodyWithBearerHeader(url, token, body);
        return this.parseCamelCaseJsonResponseAndRunListeners(response, clazz);
    }

    private <T> T doPut(String url, Object body, String token, Class<T> clazz) throws IOException, SCIMApiException {
        Response response = this.slackHttpClient.putCamelCaseJsonBodyWithBearerHeader(url, token, body);
        return this.parseCamelCaseJsonResponseAndRunListeners(response, clazz);
    }

    private <T> T doDelete(Request.Builder requestBuilder, Class<T> clazz) throws IOException, SCIMApiException {
        Response response = this.slackHttpClient.delete(requestBuilder);
        return this.parseCamelCaseJsonResponseAndRunListeners(response, clazz);
    }

    private <T> T parseCamelCaseJsonResponseAndRunListeners(Response response, Class<T> clazz) throws IOException, SCIMApiException {
        String body = response.body().string();
        this.slackHttpClient.runHttpResponseListeners(response, body);
        if (response.isSuccessful()) {
            return (T)GsonFactory.createCamelCase(this.slackHttpClient.getConfig()).fromJson(body, clazz);
        }
        throw new SCIMApiException(this.slackHttpClient.getConfig(), response, body);
    }
}

