/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.models;

import com.github.segmentio.models.Context;
import com.github.segmentio.models.Options;
import com.github.segmentio.models.Props;
import java.util.UUID;
import org.joda.time.DateTime;

public class BasePayload {
    private String type;
    private Context context;
    private String anonymousId;
    private DateTime timestamp;
    private String messageId;
    private Props integrations;

    public BasePayload(String type, Options options) {
        this.type = type;
        if (options == null) {
            options = new Options();
        }
        this.timestamp = options.getTimestamp();
        this.context = options.getContext();
        this.anonymousId = options.getAnonymousId();
        this.messageId = UUID.randomUUID().toString();
        this.integrations = options.getIntegrations();
    }

    public String getType() {
        return this.type;
    }

    public String getAnonymousId() {
        return this.anonymousId;
    }

    public Context getContext() {
        return this.context;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public Props getIntegrations() {
        return this.integrations;
    }
}

