/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.flush;

import com.github.segmentio.AnalyticsClient;
import com.github.segmentio.flush.IBatchFactory;
import com.github.segmentio.models.BasePayload;
import com.github.segmentio.models.Batch;
import com.github.segmentio.models.Track;
import com.github.segmentio.request.IRequester;
import com.github.segmentio.utils.ManualResetEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flusher
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)"analytics");
    private LinkedBlockingQueue<BasePayload> queue;
    private volatile boolean go;
    private ManualResetEvent idle;
    private AnalyticsClient client;
    private IBatchFactory factory;
    private IRequester requester;
    static final int QUEUE_WARNING_PCT_THRESHHOLD = 80;

    public Flusher(AnalyticsClient client, IBatchFactory factory, IRequester requester) {
        this.client = client;
        this.factory = factory;
        this.requester = requester;
        this.queue = new LinkedBlockingQueue();
        this.go = true;
        this.idle = new ManualResetEvent(true);
    }

    @Override
    public void run() {
        while (this.go) {
            LinkedList<BasePayload> current = new LinkedList<BasePayload>();
            do {
                if (this.queue.size() == 0) {
                    this.idle.set();
                }
                BasePayload payload = null;
                try {
                    payload = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while trying to flush analytics queue.", (Throwable)e);
                }
                if (payload == null) continue;
                this.idle.reset();
                current.add(payload);
                this.client.getStatistics().updateQueued(this.queue.size());
            } while (this.go && this.queue.size() > 0 && current.size() < 20);
            this.sendBatch(current);
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while sleeping flushing thread.", (Throwable)e);
            }
        }
    }

    private void sendBatch(List<BasePayload> current) {
        boolean success = true;
        int retryCount = 0;
        do {
            try {
                if (current.size() <= 0) continue;
                logger.debug("Preparing to send batch.. [{} items]", (Object)current.size());
                Batch batch = this.factory.create(current);
                this.client.getStatistics().updateFlushAttempts(1.0);
                success = this.requester.send(batch);
                logger.debug("Initiated batch request .. [{} items]", (Object)current.size());
                current = new LinkedList<BasePayload>();
            }
            catch (RuntimeException e) {
                logger.error("Unexpected error while sending batch, catching so we don't lose records", (Throwable)e);
                ++retryCount;
                success = false;
            }
        } while (!success && retryCount < 3);
        if (!success) {
            logger.error("Unable to send batch after {} retries. Giving up on this batch.", (Object)retryCount);
        }
    }

    public void enqueue(BasePayload payload) {
        int maxQueueSize = this.client.getOptions().getMaxQueueSize();
        int currentQueueSize = this.queue.size();
        if (currentQueueSize <= maxQueueSize) {
            this.queue.add(payload);
            this.client.getStatistics().updateInserted(1.0);
            this.client.getStatistics().updateQueued(this.queue.size());
            this.logQueueDepth(payload, currentQueueSize, maxQueueSize);
        } else {
            this.client.getStatistics().updateDropped(1.0);
            logger.error("Queue has reached maxSize, dropping payload.");
        }
    }

    private void logQueueDepth(BasePayload payload, int currentQueueSize, int maxQueueSize) {
        float queueSizePct = (float)currentQueueSize / (float)maxQueueSize;
        if (queueSizePct > 80.0f) {
            String details = "";
            if (payload instanceof Track) {
                details = "Track Event: " + ((Track)payload).getEvent();
            }
            logger.warn("Queue is approaching maxSize: {}% full ({}/{}) {}", new Object[]{String.format("%f", Float.valueOf(queueSizePct)), currentQueueSize, maxQueueSize, details});
        }
    }

    public void flush() {
        try {
            this.idle.waitOne(2, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting for the thread to flush.", (Throwable)e);
        }
    }

    public void close() {
        this.go = false;
        this.queue.clear();
    }

    public int getQueueDepth() {
        return this.queue.size();
    }
}

