/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio;

import com.github.segmentio.Config;
import com.github.segmentio.flush.Flusher;
import com.github.segmentio.flush.IBatchFactory;
import com.github.segmentio.models.Alias;
import com.github.segmentio.models.BasePayload;
import com.github.segmentio.models.Batch;
import com.github.segmentio.models.Group;
import com.github.segmentio.models.Identify;
import com.github.segmentio.models.Options;
import com.github.segmentio.models.Page;
import com.github.segmentio.models.Props;
import com.github.segmentio.models.Screen;
import com.github.segmentio.models.Track;
import com.github.segmentio.models.Traits;
import com.github.segmentio.request.IRequester;
import com.github.segmentio.request.RetryingRequester;
import com.github.segmentio.stats.AnalyticsStatistics;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"analytics");
    private String writeKey;
    private Config config;
    private Flusher flusher;
    private IRequester requester;
    private AnalyticsStatistics statistics;
    Thread.UncaughtExceptionHandler flusherExceptionHandler = new Thread.UncaughtExceptionHandler(){

        public void uncaughtException(Thread t, Throwable e) {
            logger.error("Fatal exception in Flusher thread {}, events are no longer being sent to Segment", e);
        }
    };
    private IBatchFactory factory = new IBatchFactory(){

        @Override
        public Batch create(List<BasePayload> batch) {
            return new Batch(AnalyticsClient.this.writeKey, batch);
        }
    };

    public AnalyticsClient(String writeKey) {
        this(writeKey, new Config());
    }

    public AnalyticsClient(String writeKey, Config config) {
        String errorPrefix = "analytics-java client must be initialized with a valid ";
        if (StringUtils.isEmpty((CharSequence)writeKey)) {
            throw new IllegalArgumentException(errorPrefix + "writeKey.");
        }
        if (config == null) {
            throw new IllegalArgumentException(errorPrefix + "config.");
        }
        this.writeKey = writeKey;
        this.config = config;
        this.statistics = new AnalyticsStatistics();
        this.requester = new RetryingRequester(this);
        this.flusher = new Flusher(this, this.factory, this.requester);
        this.flusher.setUncaughtExceptionHandler(this.flusherExceptionHandler);
        this.flusher.start();
    }

    public void identify(String userId) {
        this.identify(userId, null, null);
    }

    public void identify(String userId, Traits traits) {
        this.identify(userId, traits, null);
    }

    public void identify(String userId, Traits traits, Options options) {
        this.flusher.enqueue(new Identify(userId, traits, options));
        this.statistics.updateIdentifies(1.0);
    }

    public void group(String userId, String groupId, Traits traits) {
        this.group(userId, groupId, traits, null);
    }

    public void group(String userId, String groupId, Traits traits, Options options) {
        this.flusher.enqueue(new Group(userId, groupId, traits, options));
        this.statistics.updateGroup(1.0);
    }

    public void track(String userId, String event) {
        this.track(userId, event, null, null);
    }

    public void track(String userId, String event, Props properties) {
        this.track(userId, event, properties, null);
    }

    public void track(String userId, String event, Props properties, Options options) {
        this.flusher.enqueue(new Track(userId, event, properties, options));
        this.statistics.updateTracks(1.0);
    }

    public void page(String userId, String name) {
        this.page(userId, name, null, null, null);
    }

    public void page(String userId, String name, Props properties) {
        this.page(userId, name, null, properties, null);
    }

    public void page(String userId, String name, Props properties, Options options) {
        this.page(userId, name, null, properties, options);
    }

    public void page(String userId, String name, String category, Props properties, Options options) {
        this.flusher.enqueue(new Page(userId, name, category, properties, options));
        this.statistics.updatePage(1.0);
    }

    public void screen(String userId, String name) {
        this.screen(userId, name, null, null, null);
    }

    public void screen(String userId, String name, Props properties) {
        this.screen(userId, name, null, properties, null);
    }

    public void screen(String userId, String name, Props properties, Options options) {
        this.screen(userId, name, null, properties, options);
    }

    public void screen(String userId, String name, String category, Props properties, Options options) {
        this.flusher.enqueue(new Screen(userId, name, category, properties, options));
        this.statistics.updateScreen(1.0);
    }

    public void alias(String previousId, String userId) {
        this.alias(previousId, userId, null);
    }

    public void alias(String previousId, String userId, Options options) {
        this.flusher.enqueue(new Alias(previousId, userId, options));
        this.statistics.updateAlias(1.0);
    }

    public void flush() {
        this.flusher.flush();
    }

    public void close() {
        this.flusher.close();
        this.requester.close();
    }

    public String getWriteKey() {
        return this.writeKey;
    }

    public void setWriteKey(String writeKey) {
        this.writeKey = writeKey;
    }

    public Config getOptions() {
        return this.config;
    }

    public AnalyticsStatistics getStatistics() {
        return this.statistics;
    }

    public int getQueueDepth() {
        return this.flusher.getQueueDepth();
    }
}

