/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.request;

import com.github.segmentio.AnalyticsClient;
import com.github.segmentio.models.BasePayload;
import com.github.segmentio.models.Batch;
import com.github.segmentio.models.Callback;
import com.github.segmentio.request.IRequester;
import com.github.segmentio.stats.AnalyticsStatistics;
import com.github.segmentio.utils.GSONUtils;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingRequester
implements IRequester {
    private static final Logger logger = LoggerFactory.getLogger((String)"analytics");
    private AnalyticsClient client;
    private Gson gson;
    private CloseableHttpClient httpClient;
    private RequestConfig defaultRequestConfig;

    public BlockingRequester(AnalyticsClient client) {
        this.client = client;
        this.httpClient = HttpClients.createDefault();
        int requestTimeout = client.getOptions().getTimeout();
        this.defaultRequestConfig = RequestConfig.custom().setCookieSpec("best-match").setExpectContinueEnabled(true).setStaleConnectionCheckEnabled(true).setSocketTimeout(requestTimeout).setConnectTimeout(requestTimeout).setConnectionRequestTimeout(requestTimeout).build();
        this.gson = GSONUtils.BUILDER.create();
    }

    public void send(Batch batch) {
        AnalyticsStatistics statistics = this.client.getStatistics();
        try {
            long start = System.currentTimeMillis();
            batch.setRequestTimestamp(DateTime.now());
            String json = this.gson.toJson((Object)batch);
            HttpResponse response = this.executeRequest(json);
            String responseBody = this.readResponseBody(response);
            int statusCode = response.getStatusLine().getStatusCode();
            long duration = System.currentTimeMillis() - start;
            statistics.updateRequestTime(duration);
            if (statusCode == 200) {
                String message = "Successful analytics request. [code = " + statusCode + "]. Response = " + responseBody;
                logger.debug(message);
                this.report(statistics, batch, true, message);
            } else {
                String message = "Failed analytics response [code = " + statusCode + "]. Response = " + responseBody;
                logger.error(message);
                this.report(statistics, batch, false, message);
            }
        }
        catch (IOException e) {
            String message = "Failed analytics response." + e.getMessage();
            logger.error(message, (Throwable)e);
            this.report(statistics, batch, false, message);
        }
    }

    public String readResponseBody(HttpResponse response) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuilder responseBuilder = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            responseBuilder.append(line);
        }
        String responseBody = responseBuilder.toString();
        return responseBody;
    }

    public HttpResponse executeRequest(String json) throws ClientProtocolException, IOException {
        HttpPost post = new HttpPost(this.client.getOptions().getHost() + "/v1/import");
        post.setConfig(this.defaultRequestConfig);
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        post.setEntity((HttpEntity)new ByteArrayEntity(json.getBytes("UTF-8")));
        if (logger.isTraceEnabled()) {
            logger.trace("Posting analytics data");
        }
        return this.httpClient.execute((HttpUriRequest)post);
    }

    private void report(AnalyticsStatistics statistics, Batch batch, boolean success, String message) {
        for (BasePayload payload : batch.getBatch()) {
            Callback callback = payload.getCallback();
            if (success) {
                statistics.updateSuccessful(1.0);
            } else {
                statistics.updateFailed(1.0);
            }
            if (callback == null) continue;
            callback.onResponse(success, message);
        }
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            logger.error("Error while closing", (Throwable)e);
        }
    }
}

